/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.html.Clock;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.util.validators.MaximumValueValidator;
import com.sas.servlet.tbeans.util.validators.MinimumValueValidator;
import com.sas.servlet.tbeans.util.validators.NumericInputValidator;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.NLInformats;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.validators.CompositeValidator;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

@SASScope
public class Time
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    private static final String RB_KEY = "Time.";
    private static final HashMap defaultStyleMap = new HashMap();
    private String parameterPrefix;
    private ResourceBundle bundle;
    public static final String TIME_HOUR_LABEL = "TIME_HOUR_LABEL";
    public static final String TIME_MINUTE_LABEL = "TIME_MINUTE_LABEL";
    public static final String TIME_SECOND_LABEL = "TIME_SECOND_LABEL";
    public static final String TIME_HOUR_COMPONENT = "TIME_HOUR_COMPONENT";
    public static final String TIME_MINUTE_COMPONENT = "TIME_MINUTE_COMPONENT";
    public static final String TIME_SECOND_COMPONENT = "TIME_SECOND_COMPONENT";
    public static final String TIME_AMPM_COMPONENT = "TIME_AMPM_COMPONENT";
    public static final String TIME_CLOCK = "TIME_CLOCK";
    public static final String TIME_LABEL = "TIME_LABEL";
    public static final String TIME_CONTAINER_STYLE = "TIME_CONTAINER_STYLE";
    public static final String TIME_CONTAINER_DISABLED_STYLE = "TIME_CONTAINER_DISABLED_STYLE";
    public static final String TIME_LABEL_STYLE = "TIME_LABEL_STYLE";
    public static final String TIME_CHOICE_COMPONENT_STYLE = "TIME_CHOICE_COMPONENT_STYLE";
    private static final ImmutableStyleInfo timeLabelStyle = new ImmutableStyleInfo("timeLabel");
    private static final ImmutableStyleInfo timeChoiceStyle = new ImmutableStyleInfo("timeChoiceBox");
    private static final ImmutableStyleInfo timeContainerStyle = new ImmutableStyleInfo("timeContainer");
    private static final ImmutableStyleInfo timeContainerDisabledStyle = new ImmutableStyleInfo("timeContainerDisabled");
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "Time.html";
    private boolean enabled = true;
    private boolean honor24HourLocale;
    private Date date = null;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    private Label hourLabel;
    private Label minuteLabel;
    private Label secondLabel;
    private ComboBoxView hourComponent;
    private ComboBoxView minuteComponent;
    private ComboBoxView secondComponent;
    private ChoiceBox ampmComponent;
    private Clock clockComponent;
    private String amString = "AM";
    private String pmString = "PM";
    public static final String AM = "AM";
    public static final String PM = "PM";

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            ImmutableStyleInfo o = defaultStyleMap.put(TIME_CONTAINER_STYLE, timeContainerStyle);
            o = defaultStyleMap.put(TIME_CONTAINER_DISABLED_STYLE, timeContainerDisabledStyle);
            o = defaultStyleMap.put(TIME_LABEL_STYLE, timeLabelStyle);
            ImmutableStyleInfo immutableStyleInfo = defaultStyleMap.put(TIME_CHOICE_COMPONENT_STYLE, timeChoiceStyle);
        }
    }

    public Time() {
        this(null);
    }

    public Time(String id) {
        if (id == null) {
            this.setId(Util.getName((String)"time"));
        } else {
            this.setId(id);
        }
        this.setTemplateKey("Time");
        this.setHours(12);
        this.addComponents();
        Time.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setHonor24HourLocale(false);
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        Label timeLabel;
        Label minuteLabel;
        Label secondLabel;
        this.bundle = ResourceBundle.getBundle("com.sas.servlet.tbeans.html.Resources", locale);
        Label hourLabel = (Label)this.getComponent(TIME_HOUR_LABEL);
        if (hourLabel != null) {
            hourLabel.setText(this.bundle.getString("Time.hour.txt"));
        }
        if ((secondLabel = (Label)this.getComponent(TIME_SECOND_LABEL)) != null) {
            secondLabel.setText(this.bundle.getString("Time.second.txt"));
        }
        if ((minuteLabel = (Label)this.getComponent(TIME_MINUTE_LABEL)) != null) {
            minuteLabel.setText(this.bundle.getString("Time.minute.txt"));
        }
        if ((timeLabel = (Label)this.getComponent(TIME_LABEL)) != null) {
            timeLabel.setText(this.bundle.getString("Time.timeLabel.txt"));
        }
        this.ampmComponent.setModel(this.getAmPmModel(locale));
        this.updateHourComponent(locale);
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.hourLabel = new Label();
            this.hourLabel.setId(this.getId() + "_hourLabel");
            this.hourLabel.setFor(this.getId() + "_hourComponent");
            this.hourLabel.setStyleInfo(timeLabelStyle);
            this.setComponent(TIME_HOUR_LABEL, this.hourLabel);
            this.minuteLabel = new Label();
            this.minuteLabel.setId(this.getId() + "_minuteLabel");
            this.minuteLabel.setFor(this.getId() + "_minuteComponent");
            this.minuteLabel.setStyleInfo(timeLabelStyle);
            this.setComponent(TIME_MINUTE_LABEL, this.minuteLabel);
            this.secondLabel = new Label();
            this.secondLabel.setId(this.getId() + "_secondLabel");
            this.secondLabel.setFor(this.getId() + "_secondComponent");
            this.secondLabel.setStyleInfo(timeLabelStyle);
            this.setComponent(TIME_SECOND_LABEL, this.secondLabel);
            NumericInputValidator hourNumValidator = new NumericInputValidator();
            MinimumValueValidator hourMinValidator = new MinimumValueValidator();
            MaximumValueValidator hourMaxValidator = new MaximumValueValidator();
            if (this.is24hrLocale(this.getLocale())) {
                hourMinValidator.setMinValue(0);
                hourMaxValidator.setMaxValue(23);
            } else {
                hourMinValidator.setMinValue(1);
                hourMaxValidator.setMaxValue(12);
            }
            CompositeValidator hourValidator = new CompositeValidator();
            hourValidator.addValidator((ValidationInterface)hourNumValidator);
            hourValidator.addValidator((ValidationInterface)hourMinValidator);
            hourValidator.addValidator((ValidationInterface)hourMaxValidator);
            this.hourComponent = new ComboBoxView();
            this.hourComponent.setId(this.getId() + "_hourComponent");
            this.hourComponent.setEditable(true);
            this.hourComponent.setRenderUsingIFrame(true);
            this.hourComponent.setDescription(RB.getStringResource(RB_KEY, "hourDescription.txt", this.getLocale()));
            this.hourComponent.setValidator((ValidationInterface)hourValidator);
            this.hourComponent.getStyleMap().put("COMBOBOXVIEW_FRAME_SELECT", timeChoiceStyle);
            this.hourComponent.setModel(this.getHourModel());
            this.hourComponent.setSelectedItem("" + this.getHours() + "", 11);
            this.setComponent(TIME_HOUR_COMPONENT, this.hourComponent);
            NumericInputValidator minuteNumValidator = new NumericInputValidator();
            MinimumValueValidator minuteMinValidator = new MinimumValueValidator();
            minuteMinValidator.setMinValue(0);
            MaximumValueValidator minuteMaxValidator = new MaximumValueValidator();
            minuteMaxValidator.setMaxValue(59);
            CompositeValidator minuteValidator = new CompositeValidator();
            minuteValidator.addValidator((ValidationInterface)minuteNumValidator);
            minuteValidator.addValidator((ValidationInterface)minuteMinValidator);
            minuteValidator.addValidator((ValidationInterface)minuteMaxValidator);
            this.minuteComponent = new ComboBoxView();
            this.minuteComponent.setId(this.getId() + "_minuteComponent");
            this.minuteComponent.setEditable(true);
            this.minuteComponent.setRenderUsingIFrame(true);
            this.minuteComponent.setDescription(RB.getStringResource(RB_KEY, "minuteDescription.txt", this.getLocale()));
            this.minuteComponent.setValidator((ValidationInterface)minuteValidator);
            this.minuteComponent.getStyleMap().put("COMBOBOXVIEW_FRAME_SELECT", timeChoiceStyle);
            this.minuteComponent.setModel(this.getMinuteSecondModel());
            this.setComponent(TIME_MINUTE_COMPONENT, this.minuteComponent);
            NumericInputValidator secondNumValidator = new NumericInputValidator();
            MinimumValueValidator secondMinValidator = new MinimumValueValidator();
            secondMinValidator.setMinValue(0);
            MaximumValueValidator secondMaxValidator = new MaximumValueValidator();
            secondMaxValidator.setMaxValue(59);
            CompositeValidator secondValidator = new CompositeValidator();
            secondValidator.addValidator((ValidationInterface)secondNumValidator);
            secondValidator.addValidator((ValidationInterface)secondMinValidator);
            secondValidator.addValidator((ValidationInterface)secondMaxValidator);
            this.secondComponent = new ComboBoxView();
            this.secondComponent.setId(this.getId() + "_secondComponent");
            this.secondComponent.setEditable(true);
            this.secondComponent.setRenderUsingIFrame(true);
            this.secondComponent.setDescription(RB.getStringResource(RB_KEY, "secondDescription.txt", this.getLocale()));
            this.secondComponent.setValidator((ValidationInterface)secondValidator);
            this.secondComponent.getStyleMap().put("COMBOBOXVIEW_FRAME_SELECT", timeChoiceStyle);
            this.secondComponent.setModel(this.getMinuteSecondModel());
            this.setComponent(TIME_SECOND_COMPONENT, this.secondComponent);
            this.ampmComponent = new ChoiceBox();
            this.ampmComponent.setId(this.getId() + "_ampmComponent");
            this.ampmComponent.setStyleInfo(new StyleInfo("timeChoiceStyle"));
            this.setComponent(TIME_AMPM_COMPONENT, this.ampmComponent);
            this.clockComponent = new Clock();
            this.clockComponent.setId(this.getId() + "_clockComponent");
            this.clockComponent.setClockXPosition(110);
            this.clockComponent.setClockYPosition(90);
            this.clockComponent.setSystemTimeDisabled(true);
            this.setComponent(TIME_CLOCK, this.clockComponent);
            this.setComponent(TIME_LABEL, new Label());
        }
    }

    private void updateHourComponent(Locale locale) {
        boolean is24Hour = this.isHonor24HourLocale() && this.is24hrLocale(locale);
        NumericInputValidator hourNumValidator = new NumericInputValidator();
        MinimumValueValidator hourMinValidator = new MinimumValueValidator();
        MaximumValueValidator hourMaxValidator = new MaximumValueValidator();
        if (is24Hour) {
            hourMinValidator.setMinValue(0);
            hourMaxValidator.setMaxValue(23);
        } else {
            hourMinValidator.setMinValue(1);
            hourMaxValidator.setMaxValue(12);
        }
        CompositeValidator hourValidator = new CompositeValidator();
        hourValidator.addValidator((ValidationInterface)hourNumValidator);
        hourValidator.addValidator((ValidationInterface)hourMinValidator);
        hourValidator.addValidator((ValidationInterface)hourMaxValidator);
        if (this.hourComponent != null) {
            this.hourComponent.setValidator((ValidationInterface)hourValidator);
            this.hourComponent.setModel(is24Hour ? this.get24HourModel() : this.getHourModel());
        }
    }

    private boolean is24hrLocale(Locale locale) {
        DateFormat instance = DateFormat.getTimeInstance(1, locale);
        String pattern = ((SimpleDateFormat)instance).toPattern();
        return pattern.indexOf("a") < 0;
    }

    public ComboBoxModel getAmPmModel(Locale locale) {
        this.bundle = ResourceBundle.getBundle("com.sas.servlet.tbeans.html.Resources", locale);
        DefaultComboBoxModel<Item> ampmComboModel = new DefaultComboBoxModel<Item>();
        Item amNode = new Item();
        amNode.setValue(AM);
        amNode.setText(this.bundle.getString("Time.am.txt"));
        Item pmNode = new Item();
        pmNode.setValue(PM);
        pmNode.setText(this.bundle.getString("Time.pm.txt"));
        ampmComboModel.addElement(amNode);
        ampmComboModel.addElement(pmNode);
        return ampmComboModel;
    }

    public ComboBoxModel get24HourModel() {
        DefaultComboBoxModel<JavaScriptNode> hourComboModel = new DefaultComboBoxModel<JavaScriptNode>();
        for (int i = 0; i < 24; ++i) {
            JavaScriptNode hourNode = new JavaScriptNode();
            hourNode.setValue("" + i + "");
            hourNode.setText("" + i + "");
            hourComboModel.addElement(hourNode);
        }
        return hourComboModel;
    }

    public ComboBoxModel getHourModel() {
        DefaultComboBoxModel<JavaScriptNode> hourComboModel = new DefaultComboBoxModel<JavaScriptNode>();
        for (int i = 1; i < 13; ++i) {
            JavaScriptNode hourNode = new JavaScriptNode();
            hourNode.setValue("" + i + "");
            hourNode.setText("" + i + "");
            hourComboModel.addElement(hourNode);
        }
        return hourComboModel;
    }

    public ComboBoxModel getMinuteSecondModel() {
        DefaultComboBoxModel<JavaScriptNode> minSecComboModel = new DefaultComboBoxModel<JavaScriptNode>();
        for (int i = 0; i < 60; ++i) {
            JavaScriptNode minSecNode = new JavaScriptNode();
            minSecNode.setValue("" + i + "");
            if (i < 10) {
                minSecNode.setText("0" + i + "");
            } else {
                minSecNode.setText("" + i + "");
            }
            minSecComboModel.addElement(minSecNode);
        }
        return minSecComboModel;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        try {
            JavaScriptIncludeHandler.writeIncludes(out, "TIME", this.getRequest());
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)Time.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("TIME_ID", this.getId());
        Locale locale = this.getLocale();
        boolean is24Hours = this.isHonor24HourLocale() && this.is24hrLocale(locale);
        String pattern = NLInformats.getPattern((String)(is24Hours ? "NLTIMENS" : "NLTIMNAP"));
        if (pattern != null && pattern.indexOf(97) == 0) {
            dictionary.put("IS_AHHMMSS_FORMAT", pattern);
        }
        if (!is24Hours && pattern != null && pattern.indexOf(97) != -1) {
            dictionary.put("SHOW_AMPM", pattern);
        }
        this.hourComponent.setOnChange("sas_getJavaScriptObject('" + this.getId() + "_clockComponent').setHours(" + this.getId() + "_hourComponent_Obj.textComponent.value); sas_getJavaScriptObject('" + this.getId() + "_clockComponent').showClock('" + this.getId() + "_clockComponent');");
        this.minuteComponent.setOnChange("sas_getJavaScriptObject('" + this.getId() + "_clockComponent').setMinutes(" + this.getId() + "_minuteComponent_Obj.textComponent.value); sas_getJavaScriptObject('" + this.getId() + "_clockComponent').showClock('" + this.getId() + "_clockComponent');");
        this.secondComponent.setOnChange("sas_getJavaScriptObject('" + this.getId() + "_clockComponent').setSeconds(" + this.getId() + "_secondComponent_Obj.textComponent.value); sas_getJavaScriptObject('" + this.getId() + "_clockComponent').showClock('" + this.getId() + "_clockComponent');");
        this.ampmComponent.setOnChange("sas_getJavaScriptObject('" + this.getId() + "_clockComponent').setAMPM(this.value); sas_getJavaScriptObject('" + this.getId() + "_clockComponent').showClock('" + this.getId() + "_clockComponent');");
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
        this.cleanUpResources();
    }

    private void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("" + this.getId() + "_Obj = new sas_Time('" + this.getId() + "');");
        out.println(this.getId() + "_Obj.setHours('" + this.getHours() + "');");
        out.println(this.getId() + "_Obj.setMinutes('" + this.getMinutes() + "');");
        out.println(this.getId() + "_Obj.setSeconds('" + this.getSeconds() + "');");
        out.println(this.getId() + "_Obj.amString = \"" + this.amString + "\";");
        out.println(this.getId() + "_Obj.pmString = \"" + this.pmString + "\";");
        out.println(this.getId() + "_Obj.clockComponent = sas_getJavaScriptObject('" + this.clockComponent.getId() + "');");
        out.println(this.getId() + "_Obj.hourComponent = sas_getJavaScriptObject('" + this.hourComponent.getId() + "');");
        out.println(this.getId() + "_Obj.minuteComponent = sas_getJavaScriptObject('" + this.minuteComponent.getId() + "');");
        out.println(this.getId() + "_Obj.secondComponent = sas_getJavaScriptObject('" + this.secondComponent.getId() + "');");
        HashMap dictionary = this.getTemplateDictionary();
        if (!this.isHonor24HourLocale() || !this.is24hrLocale(this.getLocale()) && dictionary != null && dictionary.containsKey("SHOW_AMPM")) {
            out.println(this.getId() + "_Obj.ampmComponent = document.getElementById('" + this.ampmComponent.getId() + "');");
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void writeJavaScriptClock(HashMap dictionary) {
        StringBuffer clockOutput = new StringBuffer();
        clockOutput.append(JavaScriptIncludeHandler.getStartScript());
        clockOutput.append("for(i=0;i<60;i++) //the face of the clock - circle around the clock\n");
        clockOutput.append("{\n");
        clockOutput.append("\tif ( sas_mod(i,5) == 0 )\n");
        clockOutput.append("\t\tdocument.write('<div style=\"position:absolute;z-index:100;font-family:arial;font-size:18;font-weight:bold\" id=\"f'+i+'\"><font color=\"#008080\">.</font></div>');\n");
        clockOutput.append("\telse\n");
        clockOutput.append("\t\tdocument.write('<div style=\"position:absolute;z-index:100;font-family:arial;font-size:16;font-weight:bold\" id=\"f'+i+'\"><font color=\"#D4D0C8\">.</font></div>');\n");
        clockOutput.append("}\n");
        clockOutput.append("for(i=1;i<45;i++) //the second hand\t\n");
        clockOutput.append("{\n");
        clockOutput.append("\tdocument.write('<div style=\"position:absolute;z-index:500;font-family:arial;font-size:10;font-weight:bold\" id=\"s'+i+'\"><font color=\"#000000\">.</font></div>');\n");
        clockOutput.append("}\n");
        clockOutput.append("for(i=1;i<45;i++) //the minute hand\n");
        clockOutput.append("{\n");
        clockOutput.append("\tdocument.write('<div style=\"position:absolute;z-index:400;font-family:arial;font-size:16;font-weight:bold\" id=\"m'+i+'\"><font color=\"#008080\">.</font></div>');\n");
        clockOutput.append("}\n");
        clockOutput.append("for(i=1;i<36;i++) //the hour hand\n");
        clockOutput.append("{\n");
        clockOutput.append("\tdocument.write('<div style=\"position:absolute;z-index:300;font-family:arial;font-size:16;font-weight:bold\" id=\"h'+i+'\"><font color=\"#008080\">.</font></div>');\n");
        clockOutput.append("}\n");
        clockOutput.append(JavaScriptIncludeHandler.getEndScript(null));
        dictionary.put(TIME_CLOCK, clockOutput);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getHours() {
        return this.hours;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setClock(Clock c) {
        this.clockComponent = c;
    }

    public Clock getClock() {
        return this.clockComponent;
    }

    @Override
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    public void setHonor24HourLocale(boolean honor24HourLocale) {
        this.honor24HourLocale = honor24HourLocale;
    }

    public boolean isHonor24HourLocale() {
        return this.honor24HourLocale;
    }

    static {
        JavaScriptIncludeHandler.addAlias(Time.class, "TIME");
    }
}

