/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.EnabledInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope
public class RichTextEditField
extends BaseTransformation
implements EnabledInterface,
StyleInterface {
    private boolean enabled = true;
    private StyleInfo styleInfo = null;
    private String src = null;
    private String initialHtml = "";

    public RichTextEditField() {
        this(null);
    }

    public RichTextEditField(String id) {
        if (id == null) {
            this.setId(Util.getName((String)"richTextEditField"));
        } else {
            this.setId(id);
        }
        this.setStyleInfo(new ImmutableStyleInfo("RichTextEditField"));
    }

    @SASScope
    public void setSrc(String src) {
        this.src = src;
    }

    @SASScope
    public String getSrc() {
        return this.src;
    }

    public void setInitialHtml(String html) {
        this.initialHtml = html;
    }

    public String getInitialHtml() {
        return this.initialHtml;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        super.write(out);
        JavaScriptIncludeHandler.writeIncludes(out, "RICHTEXTEDITFIELD", this.getRequest());
        StringBuffer sb = new StringBuffer();
        sb.append("<iframe src=\"");
        if (null != this.src && this.src.length() > 0) {
            sb.append(this.src).append("\"");
        } else {
            sb.append("StreamContentServlet?").append("NOOP").append("=true\" ");
        }
        sb.append(" id=\"").append(this.getId()).append("_IFrame\" ");
        StyleInfo styleInfo = this.getStyleInfo();
        if (null != styleInfo) {
            styleInfo.write(sb, null);
        }
        sb.append(" >\n");
        sb.append("</iframe>\n");
        sb.append("<input type=\"hidden\" id=\"").append(this.getId()).append("\"/>");
        out.println(sb.toString());
        this.writeJavaScript(out);
    }

    public String getJavaScriptObjectName() {
        String varName = null;
        if (null != this.getId() && this.getId().length() > 0) {
            varName = this.getId() + "_Obj";
        }
        return varName;
    }

    protected void writeJavaScript(PrintWriter out) {
        StringBuffer sb = new StringBuffer();
        sb.append(JavaScriptIncludeHandler.getStartScript());
        sb.append("var ").append(this.getJavaScriptObjectName()).append(" = new sas_RichTextEditField('").append(this.getId()).append("_IFrame").append("'");
        if (null == this.src || this.src.length() < 1) {
            sb.append(", '").append(this.getInitialHtml()).append("'");
        }
        sb.append(");\n");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public StyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    @Override
    public void setStyleInfo(StyleInfo styleInfo) {
        this.styleInfo = styleInfo;
    }

    static {
        JavaScriptIncludeHandler.addAlias(RichTextEditField.class, "RICHTEXTEDITFIELD");
    }
}

