/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.util.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

@SASScope(value="ALL")
public class Label
extends BaseLabel {
    private static final char[] xmlSpecial = new char[]{'&', '\"', '<', '>', '-'};
    private static final String[] xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&#8722;"};

    public Label() {
        this(null);
    }

    public Label(String value) {
        this.setText(value);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String s;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        boolean spanTagUsed = false;
        boolean labelTagUsed = false;
        try {
            super.write(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        if ((s = this.getURL()) != null && s.length() > 0) {
            String cName;
            String targ;
            if (this.isEncodedURL()) {
                HttpServletResponse response = this.getResponse();
                s = response.encodeURL(s);
            }
            out.print("<a href=\"" + s + "\"");
            String labelId = this.getId();
            if (labelId != null && labelId.length() > 0) {
                out.print(" id=\"" + labelId + "\"");
            }
            if ((targ = this.getTarget()) != null && targ.length() > 0) {
                out.print(" target=\"" + targ + "\"");
            }
            if ((cName = this.getStyleInfo().getClassid()) != null && cName.length() > 0) {
                out.print(" class=\"" + cName + "\"");
            }
            out.print(">");
            s = this.getText();
            if (s != null && s.length() > 0) {
                if (this.isEncodeText()) {
                    s = Label.doEncodeText(s);
                }
                if (this.isEncodeWhiteSpace()) {
                    s = Strings.replace((String)s, (int)0, (int)-1, (String)" ", (String)"&#160;");
                }
                out.print(s);
            } else if (this.getNullTextString() != null) {
                out.print(this.getNullTextString());
            }
            out.print("</a>");
        } else {
            ActionSupportFilter actionFilter;
            boolean haveCustom = false;
            boolean haveStyle = false;
            boolean haveStyleClass = false;
            boolean haveStyleClassPrefix = false;
            String custom = this.getCustomAttributes();
            String style = this.getStyleInfo().getStyle();
            String styleClass = this.getStyleInfo().getClassid();
            String scp = this.getStyleClassPrefix();
            String labelId = this.getId();
            if (custom != null && custom.length() > 0) {
                haveCustom = true;
            }
            if (style != null && style.length() > 0) {
                haveStyle = true;
            }
            if (styleClass != null && styleClass.length() > 0) {
                haveStyleClass = true;
            }
            if (scp != null && scp.length() > 0) {
                haveStyleClassPrefix = true;
            }
            ActionList actions = null;
            if (this.getActionProvider() != null && (actionFilter = new ActionSupportFilter(this.getActionSupportType(), "CUSTOM_AREA", (ActionProviderViewInterface)this, false)) != null) {
                if (labelId != null && labelId.length() > 0) {
                    actionFilter.setViewerId(labelId);
                } else {
                    actionFilter.setViewerId(com.sas.util.Util.getName((String)"label"));
                }
                actions = this.getActionProvider().getActions(actionFilter);
                if (actions != null && actions.size() <= 0) {
                    actions = null;
                }
            }
            if (actions != null) {
                HashMap argumentMap = ActionProviderMapPool.getMap();
                argumentMap.put("REQUEST", this.getRequest());
                if (haveStyleClassPrefix) {
                    argumentMap.put("STYLE_CLASS_PREFIX", scp);
                }
                Util.writeActionList(actions, out, argumentMap);
                ActionProviderMapPool.returnMap((Map)argumentMap);
            } else {
                String title;
                String labelFor = this.getFor();
                if (labelFor != null && labelFor.length() > 0) {
                    out.print("<label");
                    if (labelId != null && labelId.length() > 0) {
                        out.print(" id=\"" + labelId + "\"");
                    }
                    out.print(" for=\"" + labelFor + "\"");
                    labelTagUsed = true;
                }
                if (haveCustom || haveStyle || haveStyleClass) {
                    if (haveStyleClass && haveStyleClassPrefix) {
                        styleClass = scp.trim() + "." + styleClass;
                    }
                    if (!labelTagUsed) {
                        out.print("<span");
                        if (labelId != null && labelId.length() > 0) {
                            out.print(" id=\"" + labelId + "\"");
                        }
                        spanTagUsed = true;
                    }
                    if (haveStyle) {
                        out.print(" style=\"" + style + "\"");
                    }
                    if (haveStyleClass) {
                        out.print(" class=\"" + styleClass + "\"");
                    }
                    if (haveCustom) {
                        out.print(" " + custom);
                    }
                    if ((title = this.getTitle()) != null && title.length() > 0) {
                        out.print(" title=\"" + title + "\"");
                    }
                    if (spanTagUsed) {
                        out.print(">");
                    }
                }
                if (labelTagUsed) {
                    title = this.getTitle();
                    if (title != null && title.length() > 0) {
                        out.print(" title=\"" + title + "\"");
                    }
                    out.print(">");
                }
                if ((s = this.getText()) != null && s.length() > 0) {
                    if (this.isEncodeText()) {
                        s = Label.doEncodeText(s);
                    }
                    if (this.isEncodeWhiteSpace()) {
                        s = Strings.replace((String)s, (int)0, (int)-1, (String)" ", (String)"&#160;");
                    }
                    out.print(s);
                } else if (this.getNullTextString() != null) {
                    out.print(this.getNullTextString());
                }
                if (spanTagUsed) {
                    out.print("</span>");
                }
                if (labelTagUsed) {
                    out.print("</label>");
                }
            }
        }
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
        this.cleanUpResources();
    }

    @SASScope
    public static String doEncodeText(String string) {
        return Strings.replace((String)string, (char[])xmlSpecial, (String[])xmlReplacements);
    }
}

