/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.PalettePicker;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

@SASScope
public class ImagePicker
extends PalettePicker {
    protected String imagePlaceholderDisabled = null;
    protected String imagePlaceholder = null;
    protected String imagePlaceholderDisabledKey = null;
    protected String imagePlaceholderKey = null;
    private static final String RB_KEY = "ImagePicker.";
    private static String paletteCellTemplate = null;

    public ImagePicker() {
        super(Util.getName((String)"ip"));
        StyleInfo imageCell = new StyleInfo("ImagePickerItemCell");
        this.getStyleMap().put("PALETTE_ITEM_CELL", imageCell);
        StyleInfo selectedCell = new StyleInfo("ImagePickerSelectedItemCell");
        this.getStyleMap().put("PALETTE_SELECTED_ITEM_CELL", selectedCell);
        StyleInfo imagePreviewCell = new StyleInfo("ImagePickerPreviewCell");
        this.getStyleMap().put("PALETTE_PREVIEW_CELL", imagePreviewCell);
    }

    @Override
    protected String getJavaScript() {
        StyleInfo containerStyle = (StyleInfo)this.getStyleMap().get("PALETTE_CONTAINER");
        StyleInfo containerDisabledStyle = (StyleInfo)this.getStyleMap().get("PALETTE_CONTAINER_DISABLED");
        StringBuffer buf = new StringBuffer();
        String jsObj = this.getId() + "_Obj";
        buf.append(JavaScriptIncludeHandler.getStartScript());
        buf.append(jsObj + " = new sas_ImagePicker('" + this.getId() + "');\n");
        buf.append(jsObj + ".containerStyle = '" + containerStyle.getClassid() + "';\n");
        buf.append(jsObj + ".containerDisabledStyle = '" + containerDisabledStyle.getClassid() + "';\n");
        buf.append(jsObj + ".imagePlaceholder = '" + this.imagePlaceholder + "';\n");
        buf.append(jsObj + ".imagePlaceholderDisabled = '" + this.imagePlaceholderDisabled + "';\n");
        buf.append(JavaScriptIncludeHandler.getEndScript(null));
        buf.append(super.getJavaScript());
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(PrintWriter out) throws IOException {
        String string = RB_KEY;
        synchronized (RB_KEY) {
            String defValue;
            HashMap dictionary;
            if (paletteCellTemplate == null) {
                paletteCellTemplate = TemplateSupport.getTemplate(this.getRequest(), "ImagePaletteCell.html");
            }
            this.setPaletteCellTemplate(paletteCellTemplate);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            JavaScriptIncludeHandler.writeIncludes(out, "IMAGEPICKER", this.getRequest());
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
            if (this.imagePlaceholder == null) {
                String string2 = this.imagePlaceholder = this.imagePlaceholderKey != null ? cpm.getImageURI(this.imagePlaceholderKey) : cpm.getImageURI("Icon_Picker");
            }
            if (this.imagePlaceholderDisabled == null) {
                String string3 = this.imagePlaceholderDisabled = this.imagePlaceholderDisabledKey != null ? cpm.getImageURI(this.imagePlaceholderDisabledKey) : cpm.getImageURI("Icon_Picker_Disabled");
            }
            if ((dictionary = this.getTemplateDictionary()) == null) {
                dictionary = new HashMap();
                this.setTemplateDictionary(dictionary);
            }
            if ((defValue = this.getDefaultValue()) == null) {
                defValue = this.imagePlaceholder;
            }
            this.getTemplateDictionary().put("PALETTE_PREVIEW_CELL_CONTENTS", "<img border=\"0\" id=\"" + this.getId() + "_previewImage\" src=\"" + defValue + "\" alt=\"\" />");
            super.write(out);
            return;
        }
    }

    @Override
    public String getDefaultCellTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("<td onclick=\"%ONCLICK\" class=\"\" style=\"\">").append("<img src=\"%ITEM_VALUE\" alt=\"\" />").append("</td>");
        return template.toString();
    }

    @Override
    public String getUpdatePreviewJavascript() {
        return "";
    }

    public void setImagePlaceholder(String imagePlaceholder) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        this.imagePlaceholder = cpm.getImageLocation() + imagePlaceholder;
    }

    public void setImagePlaceholderDisabled(String imagePlaceholderDisabled) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        this.imagePlaceholderDisabled = cpm.getImageLocation() + imagePlaceholderDisabled;
    }

    @SASScope
    public void setImagePlaceholderKey(String imagePlaceholderKey) {
        this.imagePlaceholderKey = imagePlaceholderKey;
    }

    @SASScope
    public void setImagePlaceholderDisabledKey(String imagePlaceholderDisabledKey) {
        this.imagePlaceholderDisabledKey = imagePlaceholderDisabledKey;
    }

    @Override
    protected String getPaletteCell(Item paletteItem, boolean firstItem, boolean lastItem) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        String paletteItemTemplate = this.getPaletteCellTemplate();
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("ITEM_VALUE", paletteItem.getValue());
        StringBuffer onClick = new StringBuffer();
        onClick.append(this.getId()).append("_Obj.selectItem('").append(paletteItem.getValue()).append("',event);");
        if (this.getOnClick() != null) {
            onClick.append(this.getOnClick());
        }
        dictionary.put("ONCLICK", onClick.toString());
        if (this.getAutomaticCell() == null || "".equals(this.getAutomaticCell()) && lastItem) {
            dictionary.put("ONTAB", "sas_Palette_BlurringLastFocusedItemInPalette(event);");
        }
        if (firstItem) {
            dictionary.put("ONTAB", "sas_Palette_BlurringFirstFocusedItemInPalette(event);");
            dictionary.put("CELLID", this.getId() + "_swatch_firstItem");
        }
        if (lastItem) {
            dictionary.put("CELLID", this.getId() + "_swatch_lastItem");
        }
        String cellId = (this.getId() + paletteItem.getValue()).replace('#', '_');
        cellId = cellId.replace('/', '_');
        if (!firstItem && !lastItem) {
            dictionary.put("CELLID", cellId + "_swatch");
        }
        return SimpleTemplate.format((String)paletteItemTemplate, dictionary);
    }

    static {
        JavaScriptIncludeHandler.addAlias(ImagePicker.class, "IMAGEPICKER");
    }
}

