/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseImage;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope
public class Image
extends BaseImage
implements StyleInterface {
    public Image() {
        this(Util.getName((String)"Image"), null, -1, -1);
    }

    public Image(String id) {
        this(id, null, -1, -1);
    }

    public Image(String id, String image) {
        this(id, image, -1, -1);
    }

    public Image(String name, String image, int width, int height) {
        this.setName(name);
        this.setId(name);
        this.setImage(image);
        this.setWidth(width);
        this.setHeight(height);
        this.setWidthPercentage(0);
        this.setHeightPercentage(0);
        this.setBorderWidth(0);
        this.setEnabled(true);
        this.setStyleInfo(new StyleInfo("imageButton"));
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String tabindex;
        String onkeypress;
        String onkeyup;
        String onkeydown;
        String onmousemove;
        String onmouseup;
        String onmousedown;
        String onmouseover;
        String onmouseout;
        String onfocus;
        String ondblclick;
        String onclick;
        String title;
        String styleClass;
        StyleInfo imgStyles;
        String style;
        String cimage;
        String id;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "IMAGE", this.getRequest());
        StringBuffer sb = new StringBuffer();
        if (this.getTagProlog() != null) {
            sb.append(this.getTagProlog());
        }
        sb.append("<img ");
        String name = this.getName();
        if (name != null && name.length() > 0) {
            sb.append("name=\"");
            sb.append(name);
            sb.append("\"");
        }
        if ((id = this.getId()) != null && id.length() > 0) {
            sb.append(" id=\"");
            sb.append(id);
            sb.append("\"");
        }
        if ((cimage = this.getCurrentImage()) != null && cimage.length() > 0) {
            sb.append(" src=\"");
            sb.append(cimage);
            sb.append("\"");
        }
        if ((style = (imgStyles = this.getStyleInfo()).getStyle()) != null && style.length() > 0) {
            sb.append(" style=\"");
            sb.append(style);
            sb.append("\"");
        }
        if (!this.isEnabled()) {
            sb.append(" disabled=\"disabled\"");
        }
        if ((styleClass = imgStyles.getClassid()) != null && styleClass.length() > 0) {
            sb.append(" class=\"");
            sb.append(styleClass);
            sb.append("\"");
        }
        String altText = this.getAlternateText();
        char[] quote1 = new char[]{'\"'};
        String[] quote2 = new String[]{"&quot;"};
        if (altText != null && altText.length() > 0) {
            sb.append(" alt=\"");
            altText = Strings.replace((String)altText, (char[])quote1, (String[])quote2);
            sb.append(altText);
            sb.append("\"");
        } else {
            sb.append(" alt=\"\"");
        }
        String align = this.getAlignment();
        if (align != null && align.length() > 0) {
            sb.append(" align=\"");
            sb.append(align);
            sb.append("\"");
        }
        if (this.getWidth() != -1) {
            sb.append(" width=\"");
            sb.append(this.getWidth());
            sb.append("\"");
        } else if (this.getWidthPercentage() > 0) {
            sb.append(" width=\"").append(this.getWidthPercentage()).append("%\"");
        }
        if (this.getHeight() != -1) {
            sb.append(" height=\"");
            sb.append(this.getHeight());
            sb.append("\"");
        } else if (this.getHeightPercentage() > 0) {
            sb.append(" height=\"").append(this.getHeightPercentage()).append("%\"");
        }
        if (this.getVerticalSpace() != -1) {
            sb.append(" vspace=\"");
            sb.append(this.getVerticalSpace());
            sb.append("\"");
        }
        if (this.getHorizontalSpace() != -1) {
            sb.append(" hspace=\"");
            sb.append(this.getHorizontalSpace());
            sb.append("\"");
        }
        if (this.getBorderWidth() != -1) {
            sb.append(" border=\"");
            sb.append(this.getBorderWidth());
            sb.append("\"");
        }
        sb.append("/>");
        out.print("<button type=\"button\" ");
        if (this.getStyleInfo() != null) {
            if (this.getStyleInfo().getClassid() != null) {
                out.print(" class=\"" + this.getStyleInfo().getClassid() + "\"");
            }
            if (this.getStyleInfo().getStyle() != null) {
                out.print(" style=\"" + this.getStyleInfo().getStyle() + "\"");
            }
        }
        if (id != null) {
            out.println(" id=\"" + id + "_button\"");
        }
        if ((title = this.getTitle()) != null && title.length() > 0) {
            out.print(" title=\"" + title + "\"");
        } else if (altText != null && altText.length() > 0) {
            out.print(" title=\"" + altText + "\"");
        }
        String onblur = this.getOnBlur();
        if (onblur != null && onblur.length() > 0) {
            out.print(" onblur=\"" + onblur + "\"");
        }
        if ((onclick = this.getOnClick()) != null && onclick.length() > 0) {
            out.print(" onclick=\"" + onclick + "\"");
        }
        if ((ondblclick = this.getOnDblClick()) != null && ondblclick.length() > 0) {
            out.print(" ondblclick=\"" + ondblclick + "\"");
        }
        if ((onfocus = this.getOnFocus()) != null && onfocus.length() > 0) {
            out.print(" onfocus=\"" + onfocus + "\"");
        }
        if ((onmouseout = this.getOnMouseOut()) != null && onmouseout.length() > 0) {
            out.print(" onmouseout=\"" + onmouseout + "\"");
        }
        if ((onmouseover = this.getOnMouseOver()) != null && onmouseover.length() > 0) {
            out.print(" onmouseover=\"" + onmouseover + "\"");
        }
        if ((onmousedown = this.getOnMouseDown()) != null && onmousedown.length() > 0) {
            out.print(" onmousedown=\"" + onmousedown + "\"");
        }
        if ((onmouseup = this.getOnMouseUp()) != null && onmouseup.length() > 0) {
            out.print(" onmouseup=\"" + onmouseup + "\"");
        }
        if ((onmousemove = this.getOnMouseMove()) != null && onmousemove.length() > 0) {
            out.print(" onmousemove=\"" + onmousemove + "\"");
        }
        if ((onkeydown = this.getOnKeyDown()) != null && onkeydown.length() > 0) {
            out.print(" onkeydown=\"" + onkeydown + "\"");
        }
        if ((onkeyup = this.getOnKeyUp()) != null && onkeyup.length() > 0) {
            out.print(" onkeyup=\"" + onkeyup + "\"");
        }
        if ((onkeypress = this.getOnKeyPress()) != null && onkeypress.length() > 0) {
            out.print(" onkeypress=\"" + onkeypress + "\"");
        }
        if ((tabindex = this.getTabIndex()) != null && tabindex.length() > 0) {
            out.print(" tabindex=\"" + tabindex + "\"");
        }
        super.write(out);
        out.print(">");
        out.print(sb.toString());
        if (this.getTagEpilog() != null) {
            out.println(this.getTagEpilog());
        }
        out.println("</button>");
        this.writeJavaScript(out);
        this.cleanUpResources();
    }

    protected void writeJavaScript(PrintWriter out) throws IOException {
        if (this.getDisabledImage() != null || this.getDisabledImageName() != null || this.getDisabledImageKey() != null) {
            out.println(JavaScriptIncludeHandler.getStartScript());
            String jsObj = this.getId() + "_Obj";
            out.println(jsObj + " = new sas_Image('" + this.getId() + "');");
            if (this.getDisabledImage() != null) {
                out.println(jsObj + ".disabledImage = '" + this.getDisabledImage() + "';");
            } else if (this.getDisabledImageName() != null) {
                out.println(jsObj + ".disabledImageName = '" + this.getDisabledImageName() + "';");
            } else if (this.getDisabledImageKey() != null) {
                out.println(jsObj + ".image = '" + ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getDisabledImageKey(), this.imageLocation) + "';");
            }
            if (this.getImage() != null) {
                out.println(jsObj + ".image = '" + this.getImage() + "';");
            } else if (this.getImageName() != null) {
                out.println(jsObj + ".imageName = '" + this.getImageName() + "';");
            } else if (this.getImageKey() != null) {
                out.println(jsObj + ".image = '" + ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getImageKey(), this.imageLocation) + "';");
            }
            out.println(jsObj + ".imageLocation = '" + this.getImageLocation() + "';");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
    }

    private String getCurrentImage() {
        if (this.isEnabled()) {
            if (this.getImage() != null) {
                return this.getImage();
            }
            if (this.getImageName() != null) {
                return this.getImageLocation() + this.getImageName();
            }
            if (this.getImageKey() != null) {
                return ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getImageKey(), this.imageLocation);
            }
        } else {
            if (this.getDisabledImage() != null) {
                return this.getDisabledImage();
            }
            if (this.getDisabledImageName() != null) {
                return this.getImageLocation() + this.getDisabledImageName();
            }
            if (this.getDisabledImageKey() != null) {
                return ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getDisabledImageKey(), this.imageLocation);
            }
        }
        return null;
    }

    static {
        JavaScriptIncludeHandler.addAlias(Image.class, "IMAGE");
    }
}

