/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.ButtonImageKeyConfig;
import com.sas.servlet.tbeans.html.HTMLConstantsInterface;
import com.sas.servlet.tbeans.menubar.html.MenuBarStyleAreaKeysInterface;
import com.sas.servlet.tbeans.menubar.html.MenuItem;
import com.sas.servlet.tbeans.menubar.html.SelectorMenuItem;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.themeresources.cdd.images.ComponentImages;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

@SASScope
public class HtmlUtil
implements MenuBarStyleAreaKeysInterface,
HTMLConstantsInterface {
    static final String RB_KEY = "Util.";
    public static final String BUTTON_TYPE = "BUTTON_TYPE";
    public static final String STYLE_CLASS = "STYLE_CLASS";
    public static final String DIVIDER_IMAGE = "DIVIDER_IMAGE";
    public static final String STYLE_CLASS_PREFIX = "STYLE_CLASS_PREFIX";
    public static final String CLASS_ID = "CLASS_ID";
    public static final String ID = "ID";
    public static final String URL = "URL";
    public static Map defaultButtonPartialImageNames = new ConcurrentHashMap();

    public static StringBuffer generateDivider(StringBuffer inBuf, String dividerImage, String imageLocation, String styleClassPrefix, String styleClass, String classId) {
        StringBuffer outBuf = HtmlUtil.getOutBuf(inBuf);
        outBuf.append("   <td class=\"").append(styleClass).append("\">");
        if (dividerImage != null) {
            outBuf.append("<img alt=\"\" src=\"").append(imageLocation).append(dividerImage).append("\"></img>");
        } else {
            outBuf.append("<hr class=\"").append(styleClassPrefix).append(classId).append("\">");
        }
        return outBuf.append("</td>");
    }

    public static StringBuffer generateButtonProperties(StringBuffer inBuf, BaseButton baseButton, String id, boolean anchorNeeded) {
        String customAttributes;
        StringBuffer outBuf = HtmlUtil.getOutBuf(inBuf);
        boolean verifyEnabled = baseButton.isVerifyEnabled();
        if (baseButton.getOnClick() != null) {
            outBuf.append("   \n onclick=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnClick(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnKeyPress() != null) {
            outBuf.append("   \n onkeypress=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnKeyPress(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnMouseOver() != null) {
            outBuf.append("   \n onmouseover=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnMouseOver(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnMouseOut() != null) {
            outBuf.append("   \n onmouseout=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnMouseOut(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnMouseDown() != null) {
            outBuf.append("   \n onmousedown=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnMouseDown(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnMouseUp() != null) {
            outBuf.append("   \n onmouseup=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnMouseUp(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnKeyDown() != null) {
            outBuf.append("   \n onkeydown=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnKeyDown(), verifyEnabled);
            outBuf.append("\"");
        }
        if (baseButton.getOnKeyUp() != null) {
            outBuf.append("   \n onkeyup=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, baseButton.getOnKeyUp(), true);
            outBuf.append("\"");
        }
        if (baseButton.getRolloverImage() != null && baseButton.getImage() != null && baseButton.isEnabled() && baseButton.getDynamicButtonArea() == 0 && id != null) {
            outBuf.append("   \n onmouseover=\"getElementById('").append(id);
            outBuf.append("_img').src='").append(baseButton.getImageLocation()).append(baseButton.getRolloverImage()).append("'\"");
            outBuf.append("   \n onmouseout=\"getElementById('").append(id);
            outBuf.append("_img').src='").append(baseButton.getImageLocation()).append(baseButton.getImage()).append("'\"");
        } else if (baseButton.getRolloverImageKey() != null && baseButton.getImageKey() != null && baseButton.isEnabled() && baseButton.getDynamicButtonArea() == 0 && id != null) {
            outBuf.append("   \n onmouseover=\"getElementById('").append(id);
            outBuf.append("_img').src='").append(ComponentPropertyManager.getInstance(baseButton.getRequest()).getImageURI(baseButton.getRolloverImageKey()));
            outBuf.append("'\"");
            outBuf.append("   \n onmouseout=\"getElementById('").append(id);
            outBuf.append("_img').src='");
            outBuf.append(ComponentPropertyManager.getInstance(baseButton.getRequest()).getImageURI(baseButton.getImageKey()));
            outBuf.append("'\"");
        }
        if (baseButton.getDynamicRootName() != null && baseButton.getDynamicButtonArea() != 0) {
            String ilocation;
            String sroot;
            String iroot = baseButton.getDynamicRootName();
            if (iroot != null) {
                iroot = "'" + iroot + "'";
            }
            if ((sroot = baseButton.getDynamicRootName()) != null) {
                sroot = "'" + sroot + "'";
            }
            if ((ilocation = baseButton.getImageLocation()) != null) {
                ilocation = "'" + ilocation + "'";
            }
            String button_id = baseButton.getId();
            StringBuffer sb_parm = new StringBuffer();
            sb_parm.append("{name:'").append(button_id).append("'");
            sb_parm.append(",event:event").append(",id:'").append(button_id).append("'");
            sb_parm.append(",imageLocation:'").append(baseButton.getImageLocation()).append("'");
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(baseButton.getRequest());
            sb_parm.append(",dynamicRoot:'").append(baseButton.getDynamicRootName()).append("'");
            if (baseButton.getDynamicRootName() != null) {
                HtmlUtil.addDynamicRootImageNameProperties(sb_parm, baseButton, cpm);
            }
            if (baseButton.getImage() != null) {
                sb_parm.append(",\n   image:'").append(baseButton.getImage()).append("'");
            } else if (baseButton.getImageKey() != null) {
                sb_parm.append(",\n   image:'").append(cpm.getImageName(baseButton.getImageKey()) + "'");
            }
            if (baseButton.getDisabledImage() != null) {
                sb_parm.append(",disabledImage:'").append(baseButton.getDisabledImage()).append("'");
            } else if (baseButton.getDisabledImageKey() != null) {
                sb_parm.append(",disabledImage:'").append(cpm.getImageName(baseButton.getDisabledImageKey()) + "'");
            }
            if (baseButton.getRolloverImage() != null) {
                sb_parm.append(",rolloverImage:'").append(baseButton.getRolloverImage()).append("'");
            } else if (baseButton.getRolloverImageKey() != null) {
                sb_parm.append(",rolloverImage:'").append(cpm.getImageName(baseButton.getRolloverImageKey()) + "'");
            }
            outBuf.append("   \n onmouseover=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, "sas_Button_setState(" + sb_parm + ",state:sas_Button_setState.ROLLOVER})", verifyEnabled);
            outBuf.append("\"");
            outBuf.append("   \n onmouseout=\"");
            HtmlUtil.generateVerifiedFunction(outBuf, "sas_Button_setState(" + sb_parm + ",state:sas_Button_setState.ROLLOUT})", verifyEnabled);
            outBuf.append("\"");
        }
        if ((customAttributes = baseButton.getCustomAttributes()) != null && !anchorNeeded) {
            outBuf.append("   \n ").append(customAttributes);
        }
        return outBuf;
    }

    public static StringBuffer generateVerifiedFunction(StringBuffer inBuf, String functionName, boolean verifyEnabled) {
        StringBuffer outBuf = HtmlUtil.getOutBuf(inBuf);
        if (!verifyEnabled) {
            return outBuf.append(functionName);
        }
        return outBuf.append("if (!this.disabled) { ").append(functionName).append("}");
    }

    public static StringBuffer generateCenterButtonText(StringBuffer inBuf, BaseButton baseButton, String id, int buttonType, String url, boolean anchorNeeded) {
        String label;
        StringBuffer centerText = HtmlUtil.getOutBuf(inBuf);
        String currentImage = HtmlUtil.getWriteImage2(baseButton);
        if (currentImage == null && (baseButton.getLabel() == null || baseButton.getLabel().equals(""))) {
            return centerText;
        }
        StringBuffer image_string = null;
        if (currentImage != null) {
            String disabledAltText;
            image_string = new StringBuffer();
            String altText = null;
            altText = !baseButton.isEnabled() ? ((disabledAltText = baseButton.getDisabledAlternateText()) != null ? disabledAltText : baseButton.getAlternateText()) : baseButton.getAlternateText();
            image_string.append("<img id=\"").append(id).append("_img\" src=\"").append(baseButton.getImageLocation()).append(currentImage).append("\"");
            image_string.append(" alt=\"").append(altText == null ? "" : altText).append("\"");
            String title = baseButton.getTitle();
            if (title != null) {
                image_string.append(" title=\"").append(title).append("\"");
            }
            image_string.append(" border=\"0\"/>");
        }
        if (buttonType == 4 && anchorNeeded) {
            if (baseButton.isEnabled()) {
                centerText.append("<a");
                if (id != null) {
                    centerText.append(" id=\"").append(id).append("_a\"");
                }
                if (url != null) {
                    if (baseButton.isScriptActivated()) {
                        centerText.append(" href=\"").append("#").append("\"");
                        centerText.append(" onclick=\"");
                        centerText.append(HtmlUtil.removeJavaScriptProtocol(url));
                        centerText.append(HtmlUtil.getPreventDefaultCall(url));
                        centerText.append("\"");
                    } else {
                        centerText.append(" href=\"").append(url).append("\"");
                    }
                } else {
                    centerText.append(" href=\"javascript: void 0;\"");
                    centerText.append(" name=\"").append(baseButton.getId()).append("_a\"");
                }
                String target = baseButton.getTarget();
                if (target != null) {
                    centerText.append(" target=\"").append(target).append("\"");
                }
                HtmlUtil.generateCommonProperties(centerText, baseButton, anchorNeeded);
                centerText.append(">");
            }
        } else if (buttonType == 3 && baseButton instanceof Button) {
            StyleInfo buttonStyle;
            centerText.append("   <button id=\"").append(id).append("_button\" type=\"button\"");
            String styleClassPrefix = baseButton.getStyleClassPrefix();
            if (baseButton.getDynamicButtonArea() != 0) {
                buttonStyle = (StyleInfo)((Button)baseButton).getStyleMap().get("BUTTON_CENTER");
            } else {
                buttonStyle = (StyleInfo)((Button)baseButton).getStyleMap().get("BUTTON_STYLE");
                centerText.append(" class=\"").append(styleClassPrefix).append(buttonStyle.getClassid()).append("\"");
            }
            StyleInfo buttonRolloverStyle = (StyleInfo)((Button)baseButton).getStyleMap().get("BUTTON_ROLLOVER_STYLE");
            if (baseButton.getDynamicButtonArea() != 0) {
                centerText.append(" style=\"background-color: transparent;border-style: none;");
                if (buttonStyle != null && buttonStyle.getStyle() != null) {
                    centerText.append(styleClassPrefix).append(buttonStyle.getStyle());
                }
                centerText.append("\"");
            } else {
                String style = "";
                if (baseButton.getWidth() > 0) {
                    style = "width: " + baseButton.getWidth() + "px;";
                } else if (baseButton.getWidthPercentage() > 0) {
                    style = "width: " + baseButton.getWidthPercentage() + "%;";
                }
                if (baseButton.getHeight() > 0) {
                    style = "height: " + baseButton.getHeight() + "px;";
                } else if (baseButton.getHeightPercentage() > 0) {
                    style = "height: " + baseButton.getHeightPercentage() + "%;";
                }
                if (style.length() > 1) {
                    centerText.append(" style=\"" + style + "\"");
                }
                centerText.append(" onmouseover=\"this.className='").append(styleClassPrefix).append(buttonStyle.getClassid()).append(" ").append(styleClassPrefix).append(buttonRolloverStyle.getClassid()).append("'\"");
                centerText.append(" onmouseout=\"this.className='").append(styleClassPrefix).append(buttonStyle.getClassid()).append("'\"");
            }
            HtmlUtil.generateCommonProperties(centerText, baseButton, anchorNeeded);
            centerText.append(">");
        }
        if ((label = baseButton.getLabel()) == null && image_string != null) {
            centerText.append(image_string);
        } else if (image_string != null && label != null) {
            if (baseButton.getImagePosition() == 512) {
                centerText.append(image_string);
                HtmlUtil.generateSpanLabel(centerText, baseButton, anchorNeeded);
            } else {
                HtmlUtil.generateSpanLabel(centerText, baseButton, anchorNeeded);
                centerText.append(image_string);
            }
        } else if (label != null) {
            HtmlUtil.generateSpanLabel(centerText, baseButton, anchorNeeded);
        }
        if (buttonType == 4 && anchorNeeded && baseButton.isEnabled()) {
            centerText.append("</a>");
        } else if (buttonType == 3 && baseButton instanceof Button) {
            centerText.append("</button>");
        }
        return centerText;
    }

    private static String getPreventDefaultCall(String precedingScript) {
        if (precedingScript == null || precedingScript.endsWith(";")) {
            return "sas_preventDefault(event);";
        }
        return ";sas_preventDefault(event);";
    }

    private static String removeJavaScriptProtocol(String s) {
        if (s == null) {
            return null;
        }
        int jsProtocolIndex = HtmlUtil.getJavaScriptProtocolIndex(s = s.trim());
        if (jsProtocolIndex != 0) {
            return s;
        }
        return s.substring(11).trim();
    }

    private static int getJavaScriptProtocolIndex(String s) {
        if (s == null) {
            return -1;
        }
        char[] chars = s.toCharArray();
        int numChars = chars.length;
        for (int i = 0; i < numChars && i + 11 <= numChars; ++i) {
            char currentChar = chars[i];
            if (chars[i] != 'j' && chars[i] != 'J' || chars[i + 1] != 'a' && chars[i + 1] != 'A' || chars[i + 2] != 'v' && chars[i + 2] != 'V' || chars[i + 3] != 'a' && chars[i + 3] != 'A' || chars[i + 4] != 's' && chars[i + 4] != 'S' || chars[i + 5] != 'c' && chars[i + 5] != 'C' || chars[i + 6] != 'r' && chars[i + 6] != 'R' || chars[i + 7] != 'i' && chars[i + 7] != 'I' || chars[i + 8] != 'p' && chars[i + 8] != 'P' || chars[i + 9] != 't' && chars[i + 9] != 'T' || chars[i + 10] != ':') continue;
            return i;
        }
        return -1;
    }

    public static StringBuffer generateCommonProperties(StringBuffer inBuf, BaseButton baseButton, boolean anchorNeeded) {
        String title;
        String accessKey;
        String customAttributes;
        StringBuffer sb = HtmlUtil.getOutBuf(inBuf);
        boolean verifyEnabled = baseButton.isVerifyEnabled();
        int tabInt = baseButton.getTabIndex();
        if (tabInt > 0 || baseButton instanceof MenuItem || baseButton instanceof SelectorMenuItem) {
            sb.append(" tabindex=\"").append(tabInt).append("\"");
        }
        if ((customAttributes = baseButton.getCustomAttributes()) != null && customAttributes.length() > 0 && anchorNeeded) {
            sb.append(" ").append(customAttributes);
        }
        if ((accessKey = baseButton.getAccessKey()) != null) {
            sb.append(" accesskey=\"").append(accessKey).append("\"");
        }
        if ((title = baseButton.getTitle()) != null) {
            sb.append(" title=\"").append(title).append("\"");
        }
        if (baseButton.getOnFocus() != null) {
            sb.append(" onfocus=\"");
            HtmlUtil.generateVerifiedFunction(sb, baseButton.getOnFocus(), verifyEnabled);
            sb.append("\"");
        }
        if (baseButton.getOnBlur() != null) {
            sb.append(" onblur=\"");
            HtmlUtil.generateVerifiedFunction(sb, baseButton.getOnBlur(), verifyEnabled);
            sb.append("\"");
        }
        if (!baseButton.isEnabled() && !anchorNeeded) {
            sb.append(" disabled=\"disabled\"");
        }
        return sb;
    }

    private static StringBuffer getOutBuf(StringBuffer inBuf) {
        if (inBuf == null) {
            return new StringBuffer();
        }
        return inBuf;
    }

    public static StringBuffer generateSpanLabel(StringBuffer inBuf, BaseButton baseButton, boolean anchorNeeded) {
        StringBuffer sb = HtmlUtil.getOutBuf(inBuf);
        sb.append("<span id=\"").append(baseButton.getId()).append("_label\"");
        if (!anchorNeeded && baseButton.getURL() == null && baseButton.getTitle() != null) {
            sb.append(" title=\"").append(baseButton.getTitle()).append("\"");
        }
        sb.append(">");
        sb.append(baseButton.getLabel());
        sb.append("</span>");
        return sb;
    }

    public static void writeCenterButtonText(PrintWriter out, BaseButton baseButton, String itemId, int buttonType, String url, boolean anchorNeeded) {
        String label;
        String currentImage = HtmlUtil.getWriteImage2(baseButton);
        if (currentImage == null && (baseButton.getLabel() == null || baseButton.getLabel().equals(""))) {
            return;
        }
        if (buttonType == 4 && anchorNeeded) {
            if (baseButton.isEnabled()) {
                HtmlUtil.writeStartAnchorTag(out, itemId);
                HtmlUtil.writeCommonAnchorAttributes(out, url, baseButton.getTarget());
                HtmlUtil.writeCommonProperties(out, baseButton, true);
                if (baseButton instanceof MenuItem || baseButton instanceof SelectorMenuItem) {
                    HtmlUtil.writeSimpleAttribute(out, "onfocus", "sas_MenuBar_highlightMenuItem(this);");
                }
                out.print(">");
            }
        } else if (buttonType == 3 && baseButton instanceof Button) {
            StyleInfo buttonStyle;
            out.print("   <button type=\"button\"");
            String styleClassPrefix = baseButton.getStyleClassPrefix();
            if (baseButton.getDynamicButtonArea() != 0) {
                buttonStyle = (StyleInfo)((Button)baseButton).getStyleMap().get("BUTTON_CENTER");
            } else {
                buttonStyle = (StyleInfo)((Button)baseButton).getStyleMap().get("BUTTON_STYLE");
                out.print(" class=\"");
                HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
                out.print(buttonStyle.getClassid());
                out.print("\"");
            }
            StyleInfo buttonRolloverStyle = (StyleInfo)((Button)baseButton).getStyleMap().get("BUTTON_ROLLOVER_STYLE");
            if (baseButton.getDynamicButtonArea() != 0) {
                out.print(" style=\"background-color: transparent;border-style: none;");
                if (buttonStyle != null && buttonStyle.getStyle() != null) {
                    HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
                    out.print(buttonStyle.getStyle());
                }
                out.print("\"");
            } else {
                String style = "";
                if (baseButton.getWidth() > 0) {
                    style = "width: " + baseButton.getWidth() + "px;";
                } else if (baseButton.getWidthPercentage() > 0) {
                    style = "width: " + baseButton.getWidthPercentage() + "%;";
                }
                if (baseButton.getHeight() > 0) {
                    style = "height: " + baseButton.getHeight() + "px;";
                } else if (baseButton.getHeightPercentage() > 0) {
                    style = "height: " + baseButton.getHeightPercentage() + "%;";
                }
                if (style.length() > 1) {
                    out.print(" style=\"" + style + "\"");
                }
                out.print(" onmouseover=\"this.className='");
                HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
                out.print(buttonStyle.getClassid());
                out.print(" ");
                HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
                out.print(buttonRolloverStyle.getClassid());
                out.print("'\" onmouseout=\"this.className='");
                HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
                out.print(buttonStyle.getClassid());
                out.print("'\"");
            }
            HtmlUtil.writeCommonProperties(out, baseButton, anchorNeeded);
            out.print(">");
        }
        if ((label = baseButton.getLabel()) == null && currentImage != null) {
            HtmlUtil.writeImageTag(out, baseButton.getImageLocation(), currentImage, HtmlUtil.getWriteAlternateText(baseButton), baseButton.getTitle(), itemId, " border=\"0\"");
        } else if (currentImage != null && label != null) {
            if (baseButton.getImagePosition() == 512) {
                HtmlUtil.writeImageTag(out, baseButton.getImageLocation(), currentImage, HtmlUtil.getWriteAlternateText(baseButton), baseButton.getTitle(), itemId, " border=\"0\"");
                HtmlUtil.writeSpanLabel(out, baseButton.getId(), HtmlUtil.getWriteTitle(baseButton, anchorNeeded), label);
            } else {
                HtmlUtil.writeSpanLabel(out, baseButton.getId(), HtmlUtil.getWriteTitle(baseButton, anchorNeeded), label);
                HtmlUtil.writeImageTag(out, baseButton.getImageLocation(), currentImage, HtmlUtil.getWriteAlternateText(baseButton), baseButton.getTitle(), itemId, " border=\"0\"");
            }
        } else if (label != null) {
            HtmlUtil.writeSpanLabel(out, baseButton.getId(), HtmlUtil.getWriteTitle(baseButton, anchorNeeded), label);
        }
        if (buttonType == 4 && anchorNeeded && baseButton.isEnabled()) {
            out.print("</a>");
        } else if (buttonType == 3 && baseButton instanceof Button) {
            out.print("</button>");
        }
    }

    public static void writeSimpleImageTag(PrintWriter out, String image) {
        out.print("<img src=\"");
        out.print(image);
        out.print("\" alt=\"\"></img>");
    }

    public static void writeStartAnchorTag(PrintWriter out, String itemId) {
        out.print("   <a");
        HtmlUtil.writeMultiPartId(out, itemId, "_a");
    }

    public static void writeCommonAnchorAttributes(PrintWriter out, String url, String target) {
        if (url != null) {
            HtmlUtil.writeSimpleAttribute(out, "href", url);
        } else {
            HtmlUtil.writeSimpleAttribute(out, "href", "javascript: void(0)");
        }
        HtmlUtil.writeSimpleAttribute(out, "target", target);
    }

    @SASScope
    public static void writeCommonAnchorAttributes2(PrintWriter out, String url, String target, boolean scriptActivated) {
        if (url != null) {
            if (scriptActivated) {
                HtmlUtil.writeSimpleAttribute(out, "href", "#");
                HtmlUtil.writeSimpleAttribute(out, "onclick", HtmlUtil.removeJavaScriptProtocol(url) + HtmlUtil.getPreventDefaultCall(url));
            } else {
                HtmlUtil.writeSimpleAttribute(out, "href", url);
            }
        } else {
            HtmlUtil.writeSimpleAttribute(out, "href", "javascript: void(0)");
        }
        HtmlUtil.writeSimpleAttribute(out, "target", target);
    }

    public static void writeSpanLabel(PrintWriter out, String id, String title, String label) {
        HtmlUtil.writeSpanLabel(out, id, title, label, null);
    }

    public static void writeCommonSpanAttributes(PrintWriter out, String title, String label) {
        HtmlUtil.writeCommonSpanAttributes(out, title, label, null);
    }

    @SASScope
    public static void writeSpanLabel(PrintWriter out, String id, String title, String label, String tabIndex) {
        out.print("<span id=\"");
        out.print(id);
        HtmlUtil.writeCommonSpanAttributes(out, title, label, tabIndex);
        out.print("</span>");
    }

    @SASScope
    public static void writeCommonSpanAttributes(PrintWriter out, String title, String label, String tabIndex) {
        out.print("_label\"");
        HtmlUtil.writeSimpleAttribute(out, "title", title);
        if (tabIndex != null) {
            HtmlUtil.writeSimpleAttribute(out, "tabindex", tabIndex);
        }
        out.print(">");
        out.print(label);
    }

    public static void writeImageTag(PrintWriter out, String imageLocation, String image, String altText, String title, String itemId, String additionalAttrs) {
        if (image != null) {
            out.print("<img id=\"");
            out.print(itemId);
            out.print("_img\" src=\"");
            if (imageLocation != null) {
                out.print(imageLocation);
            }
            out.print(image);
            out.print("\"");
            HtmlUtil.writeSimpleAttribute(out, "alt", altText == null ? "" : altText);
            HtmlUtil.writeSimpleAttribute(out, "title", title);
            if (additionalAttrs != null) {
                out.print(additionalAttrs);
            }
            out.print("/>");
        }
    }

    public static void writeSimpleAttribute(PrintWriter out, String attrName, String attrValue) {
        if (attrValue != null) {
            out.print(" ");
            out.print(attrName);
            out.print("=\"");
            out.print(attrValue);
            out.print("\"");
        }
    }

    public static void writeAttributes(PrintWriter out, String attributes) {
        out.print(" ");
        out.print(attributes);
    }

    public static void writeCustomAttributes(PrintWriter out, String customAttributes) {
        if (customAttributes != null) {
            out.print("   \n ");
            out.println(customAttributes);
        }
    }

    public static void writeMultiPartId(PrintWriter out, String one, String two) {
        out.print(" id=\"");
        if (one != null) {
            out.print(one);
        }
        if (two != null) {
            out.print(two);
        }
        out.print("\"");
    }

    public static void writeStyleClass(PrintWriter out, String styleClassPrefix, String classId) {
        out.print(" class=\"");
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        if (classId != null) {
            out.print(classId);
        }
        out.print("\"");
    }

    public static void writeStyle(PrintWriter out, String style) {
        out.print(" style=\"");
        if (style != null) {
            out.print(style);
        }
        out.print("\"");
    }

    public static void writeOnMouseOver(PrintWriter out, String itemId, String imageLocation, String image) {
        out.print(" onmouseover=\"");
        out.print("getElementById('");
        out.print(itemId);
        if (image != null) {
            out.print("_img').src='");
            if (imageLocation != null) {
                out.print(imageLocation);
            }
            out.print(image);
            out.print("'");
        } else {
            out.print("')");
        }
        out.print("\"");
    }

    public static void writeOnMouseOut(PrintWriter out, String itemId, String imageLocation, String image) {
        out.print(" onmouseout=\"");
        out.print("getElementById('");
        out.print(itemId);
        if (image != null) {
            out.print("_img').src='");
            if (imageLocation != null) {
                out.print(imageLocation);
            }
            out.print(image);
            out.print("'");
        } else {
            out.print("')");
        }
        out.print("\"");
    }

    public static void writeStyleClassPrefix(PrintWriter out, String styleClassPrefix) {
        if (styleClassPrefix != null) {
            out.print(styleClassPrefix);
        }
    }

    public static void writeSimpleCommonProperties(PrintWriter out, String title, boolean enabled) {
        HtmlUtil.writeSimpleAttribute(out, "title", title);
        if (!enabled) {
            out.print(" disabled=\"disabled\"");
        }
    }

    public static void writeVerifiedFunction(PrintWriter out, String functionName, boolean verifyEnabled) {
        if (!verifyEnabled) {
            out.print(functionName);
        } else {
            out.print("if (!this.disabled) { ");
            out.print(functionName);
            out.print("}");
        }
    }

    public static void writeTargetScriptAttr(PrintWriter out, String target, HttpServletRequest request) {
        if (target == null) {
            out.print("opener");
            if (request != null) {
                out.print(request.getSession().getCreationTime());
            }
        } else {
            out.print(target);
        }
    }

    public static void writeTabIndex(PrintWriter out, BaseButton baseButton) {
        int tabInt = baseButton.getTabIndex();
        if (tabInt > 0 || baseButton instanceof MenuItem || baseButton instanceof SelectorMenuItem) {
            out.print(" tabindex=\"");
            out.print(tabInt);
            out.print("\"");
        }
    }

    public static void writeCommonProperties(PrintWriter out, BaseButton baseButton, boolean anchorNeeded) {
        HtmlUtil.writeTabIndex(out, baseButton);
        String customAttributes = baseButton.getCustomAttributes();
        if (customAttributes != null && customAttributes.length() > 0 && anchorNeeded) {
            HtmlUtil.writeAttributes(out, customAttributes);
        }
        HtmlUtil.writeSimpleAttribute(out, "accesskey", baseButton.getAccessKey());
        HtmlUtil.writeSimpleCommonProperties(out, baseButton.getTitle(), baseButton.isEnabled());
    }

    public static String getWriteTitle(BaseButton baseButton, boolean anchorNeeded) {
        if (!anchorNeeded && baseButton.getURL() == null) {
            return baseButton.getTitle();
        }
        return null;
    }

    public static String getWriteImage(BaseButton baseButton) {
        String disabledImage;
        String currentImage = null;
        currentImage = !baseButton.isEnabled() ? ((disabledImage = baseButton.getDisabledImage()) != null ? disabledImage : baseButton.getImage()) : baseButton.getImage();
        return currentImage;
    }

    @SASScope
    public static String getWriteImage2(BaseButton baseButton) {
        if (!baseButton.isEnabled()) {
            String disabledImageKey;
            String disabledImage;
            String string = disabledImage = baseButton.getDisabledImage() == null ? baseButton.getImage() : baseButton.getDisabledImage();
            if (disabledImage != null) {
                return disabledImage;
            }
            String string2 = disabledImageKey = baseButton.getDisabledImageKey() == null ? baseButton.getImageKey() : baseButton.getDisabledImageKey();
            if (disabledImageKey != null) {
                return ComponentPropertyManager.getInstance(baseButton.getRequest()).getImageName(disabledImageKey);
            }
        } else {
            String image = baseButton.getImage();
            if (image != null) {
                return image;
            }
            String imageKey = baseButton.getImageKey();
            if (imageKey != null) {
                return ComponentPropertyManager.getInstance(baseButton.getRequest()).getImageName(imageKey);
            }
        }
        return null;
    }

    public static String getWriteAlternateText(BaseButton baseButton) {
        String disabledAltText;
        String altText = null;
        altText = !baseButton.isEnabled() ? ((disabledAltText = baseButton.getDisabledAlternateText()) != null ? disabledAltText : baseButton.getAlternateText()) : baseButton.getAlternateText();
        return altText;
    }

    public static void writeButtonDynamicRootInfo(PrintWriter out, BaseButton baseButton) {
        if (baseButton.getDynamicRootName() != null && baseButton.getDynamicButtonArea() != 0) {
            String button_id = baseButton.getId();
            StringBuffer sb_parm = new StringBuffer();
            sb_parm.append("{name:'").append(button_id).append("'");
            sb_parm.append(",event:event").append(",id:'").append(button_id).append("'");
            sb_parm.append(",imageLocation:'").append(baseButton.getImageLocation()).append("'");
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(baseButton.getRequest());
            sb_parm.append(",dynamicRoot:'").append(baseButton.getDynamicRootName()).append("'");
            if (baseButton.getDynamicRootName() != null) {
                HtmlUtil.addDynamicRootImageNameProperties(sb_parm, baseButton, cpm);
            }
            if (baseButton.getImage() != null) {
                sb_parm.append(",\n   image:'").append(baseButton.getImage()).append("'");
            } else if (baseButton.getImageKey() != null) {
                sb_parm.append(",\n   image:'").append(cpm.getImageName(baseButton.getImageKey()) + "'");
            }
            if (baseButton.getDisabledImage() != null) {
                sb_parm.append(",disabledImage:'").append(baseButton.getDisabledImage()).append("'");
            } else if (baseButton.getDisabledImageKey() != null) {
                sb_parm.append(",disabledImage:'").append(cpm.getImageName(baseButton.getDisabledImageKey()) + "'");
            }
            if (baseButton.getRolloverImage() != null) {
                sb_parm.append(",rolloverImage:'").append(baseButton.getRolloverImage()).append("'");
            } else if (baseButton.getRolloverImageKey() != null) {
                sb_parm.append(",rolloverImage:'").append(cpm.getImageName(baseButton.getRolloverImageKey()) + "'");
            }
            out.print("   \n onmouseover=\"");
            HtmlUtil.writeVerifiedFunction(out, "sas_Button_setState(" + sb_parm + ",state:sas_Button_setState.ROLLOVER})", baseButton.isVerifyEnabled());
            out.print("\"");
            out.print("   \n onmouseout=\"");
            HtmlUtil.writeVerifiedFunction(out, "sas_Button_setState(" + sb_parm + ",state:sas_Button_setState.ROLLOUT})", baseButton.isVerifyEnabled());
            out.println("\"");
        }
    }

    public static void writeOnAttributes(PrintWriter out, BaseButton baseButton) {
        boolean verifyEnabled = baseButton.isVerifyEnabled();
        HtmlUtil.writeOnAttribute(out, baseButton.getOnClick(), " onclick=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnKeyPress(), " onkeypress=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnMouseOver(), " onmouseover=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnFocus(), " onfocus=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnMouseOut(), " onmouseout=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnBlur(), " onblur=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnMouseDown(), " onmousedown=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnMouseUp(), " onmouseup=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnKeyDown(), " onkeydown=\"", verifyEnabled);
        HtmlUtil.writeOnAttribute(out, baseButton.getOnKeyUp(), " onkeyup=\"", verifyEnabled);
    }

    public static void writeOnAttribute(PrintWriter out, String function, String onType, boolean verifyEnabled) {
        if (function != null && onType != null) {
            out.print("   \n");
            out.print(onType);
            HtmlUtil.writeVerifiedFunction(out, function, verifyEnabled);
            out.println("\"");
        }
    }

    public static void writeHiddenIFrame(PrintWriter out, String name, HttpServletRequest request) {
        HtmlUtil.writeHiddenIFrame(out, name, name, request);
    }

    public static void writeHiddenIFrame(PrintWriter out, String name, String id, HttpServletRequest request) {
        out.print("<iframe id=\"" + id);
        out.print("\" src=\"javascript:'<html></html>';");
        out.print("\" name=\"" + name);
        out.print("\" style=\"display:none; width:0px; height:0px; border: 0px;\"></iframe>");
    }

    @SASScope
    public static void addDynamicRootImageNameProperties(StringBuffer sb, ComponentPropertyManager cpm) {
        HtmlUtil.addDynamicRootImageNameProperties(sb, null, cpm);
    }

    @SASScope
    public static void addDynamicRootImageNameProperties(StringBuffer sb, BaseButton button, ComponentPropertyManager cpm) {
        sb.append(",LeftDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Left_Disabled", cpm)).append("'");
        sb.append(",RightDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Right_Disabled", cpm)).append("'");
        sb.append(",TopLeftDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Left_Disabled", cpm)).append("'");
        sb.append(",TopRightDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Right_Disabled", cpm)).append("'");
        sb.append(",BottomLeftDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Left_Disabled", cpm)).append("'");
        sb.append(",BottomRightDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Right_Disabled", cpm)).append("'");
        sb.append(",TopDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Disabled", cpm)).append("'");
        sb.append(",BottomDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Disabled", cpm)).append("'");
        sb.append(",CenterDisabledImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Center_Disabled", cpm)).append("'");
        sb.append(",LeftRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Left_Rollover", cpm)).append("'");
        sb.append(",RightRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Right_Rollover", cpm)).append("'");
        sb.append(",TopLeftRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Left_Rollover", cpm)).append("'");
        sb.append(",TopRightRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Right_Rollover", cpm)).append("'");
        sb.append(",BottomLeftRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Left_Rollover", cpm)).append("'");
        sb.append(",BottomRightRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Right_Rollover", cpm)).append("'");
        sb.append(",TopRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Rollover", cpm)).append("'");
        sb.append(",BottomRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Rollover", cpm)).append("'");
        sb.append(",CenterRolloverImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Center_Rollover", cpm)).append("'");
        sb.append(",LeftActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Left_Active", cpm)).append("'");
        sb.append(",RightActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Right_Active", cpm)).append("'");
        sb.append(",TopLeftActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "TopP_Left_Active", cpm)).append("'");
        sb.append(",TopRightActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Right_Active", cpm)).append("'");
        sb.append(",BottomLeftActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Left_Active", cpm)).append("'");
        sb.append(",BottomRightActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Right_Active", cpm)).append("'");
        sb.append(",TopActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Active", cpm)).append("'");
        sb.append(",BottomActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Active", cpm)).append("'");
        sb.append(",CenterActiveImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Center_Active", cpm)).append("'");
        sb.append(",LeftImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Left", cpm)).append("'");
        sb.append(",RightImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "RIGHT", cpm)).append("'");
        sb.append(",TopLeftImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Left", cpm)).append("'");
        sb.append(",TopRightImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Top_Right", cpm)).append("'");
        sb.append(",BottomLeftImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Left", cpm)).append("'");
        sb.append(",BottomRightImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom_Right", cpm)).append("'");
        sb.append(",TopImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "TOP", cpm)).append("'");
        sb.append(",BottomImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Bottom", cpm)).append("'");
        sb.append(",CenterImageName:'").append(HtmlUtil.getDynamicRootImageName(button, "Center", cpm)).append("'");
    }

    @SASScope
    public static String getDynamicRootImageName(BaseButton button, String key, ComponentPropertyManager cpm) {
        String dynamicRootName = button.getDynamicRootName();
        String dynamicRootKey = button.getDynamicRootKey();
        if (!dynamicRootKey.equals("Button") || dynamicRootName.equals("button")) {
            String imageKey = HtmlUtil.buildButtonImageKey(button, key);
            if (ComponentImages.getInstance().get(imageKey) != null) {
                return cpm.getImageName(imageKey);
            }
        }
        return dynamicRootName + defaultButtonPartialImageNames.get(key) + ".gif";
    }

    @SASScope
    public static String buildButtonImageKey(BaseButton button, String imageKey) {
        String rootKey;
        ButtonImageKeyConfig config = button.getImageKeyConfig();
        String partialKey = HtmlUtil.getConfigValueFromKey(button, imageKey);
        if (partialKey == null) {
            partialKey = imageKey;
        }
        return (rootKey = button.getDynamicRootKey()) == "" ? partialKey : rootKey + "_" + partialKey;
    }

    @SASScope
    public static String getConfigValueFromKey(BaseButton button, String imageKey) {
        ButtonImageKeyConfig config = button.getImageKeyConfig();
        if (imageKey == "Left") {
            return config.getLeftImageKey();
        }
        if (imageKey == "Left_Disabled") {
            return config.getLeftDisabledImageKey();
        }
        if (imageKey == "Left_Rollover") {
            return config.getLeftRolloverImageKey();
        }
        if (imageKey == "Left_Active") {
            return config.getLeftActiveImageKey();
        }
        if (imageKey == "Top_Left") {
            return config.getTopLeftImageKey();
        }
        if (imageKey == "Top_Left_Disabled") {
            return config.getTopLeftDisabledImageKey();
        }
        if (imageKey == "Top_Left_Rollover") {
            return config.getTopLeftRolloverImageKey();
        }
        if (imageKey == "TopP_Left_Active") {
            return config.getTopLeftActiveImageKey();
        }
        if (imageKey == "Bottom_Left") {
            return config.getBottomLeftImageKey();
        }
        if (imageKey == "Bottom_Left_Disabled") {
            return config.getBottomLeftDisabledImageKey();
        }
        if (imageKey == "Bottom_Left_Rollover") {
            return config.getBottomLeftRolloverImageKey();
        }
        if (imageKey == "Bottom_Left_Active") {
            return config.getBottomLeftActiveImageKey();
        }
        if (imageKey == "RIGHT") {
            return config.getRightImageKey();
        }
        if (imageKey == "Right_Disabled") {
            return config.getRightDisabledImageKey();
        }
        if (imageKey == "Right_Rollover") {
            return config.getRightRolloverImageKey();
        }
        if (imageKey == "Right_Active") {
            return config.getRightActiveImageKey();
        }
        if (imageKey == "Top_Right") {
            return config.getTopRightImageKey();
        }
        if (imageKey == "Top_Right_Disabled") {
            return config.getTopRightDisabledImageKey();
        }
        if (imageKey == "Top_Right_Rollover") {
            return config.getTopRightRolloverImageKey();
        }
        if (imageKey == "Top_Right_Active") {
            return config.getTopRightActiveImageKey();
        }
        if (imageKey == "Bottom_Right") {
            return config.getBottomRightImageKey();
        }
        if (imageKey == "Bottom_Right_Disabled") {
            return config.getBottomRightDisabledImageKey();
        }
        if (imageKey == "Bottom_Right_Rollover") {
            return config.getBottomRightRolloverImageKey();
        }
        if (imageKey == "Bottom_Right_Active") {
            return config.getBottomRightActiveImageKey();
        }
        if (imageKey == "Center") {
            return config.getCenterImageKey();
        }
        if (imageKey == "Center_Disabled") {
            return config.getCenterDisabledImageKey();
        }
        if (imageKey == "Center_Rollover") {
            return config.getCenterRolloverImageKey();
        }
        if (imageKey == "Center_Active") {
            return config.getCenterActiveImageKey();
        }
        if (imageKey == "TOP") {
            return config.getTopImageKey();
        }
        if (imageKey == "Top_Disabled") {
            return config.getTopDisabledImageKey();
        }
        if (imageKey == "Top_Rollover") {
            return config.getTopRolloverImageKey();
        }
        if (imageKey == "Top_Active") {
            return config.getTopActiveImageKey();
        }
        if (imageKey == "Bottom") {
            return config.getBottomImageKey();
        }
        if (imageKey == "Bottom_Disabled") {
            return config.getBottomDisabledImageKey();
        }
        if (imageKey == "Bottom_Rollover") {
            return config.getBottomRolloverImageKey();
        }
        if (imageKey == "Bottom_Active") {
            return config.getBottomActiveImageKey();
        }
        return null;
    }

    static {
        defaultButtonPartialImageNames.put("Left", "Left");
        defaultButtonPartialImageNames.put("Left_Rollover", "LeftRollover");
        defaultButtonPartialImageNames.put("Left_Disabled", "LeftDisabled");
        defaultButtonPartialImageNames.put("Left_Active", "LeftActive");
        defaultButtonPartialImageNames.put("Top_Left", "TopLeft");
        defaultButtonPartialImageNames.put("Top_Left_Rollover", "TopLeftRollover");
        defaultButtonPartialImageNames.put("Top_Left_Disabled", "TopLeftDisabled");
        defaultButtonPartialImageNames.put("TopP_Left_Active", "TopLeftActive");
        defaultButtonPartialImageNames.put("Bottom_Left", "BottomLeft");
        defaultButtonPartialImageNames.put("Bottom_Left_Rollover", "BottomLeftRollover");
        defaultButtonPartialImageNames.put("Bottom_Left_Disabled", "BottomLeftDisabled");
        defaultButtonPartialImageNames.put("Bottom_Left_Active", "BottomLeftActive");
        defaultButtonPartialImageNames.put("RIGHT", "Right");
        defaultButtonPartialImageNames.put("Right_Rollover", "RightRollover");
        defaultButtonPartialImageNames.put("Right_Disabled", "RightDisabled");
        defaultButtonPartialImageNames.put("Right_Active", "RightActive");
        defaultButtonPartialImageNames.put("Top_Right", "TopRight");
        defaultButtonPartialImageNames.put("Top_Right_Rollover", "TopRightRollover");
        defaultButtonPartialImageNames.put("Top_Right_Disabled", "TopRightDisabled");
        defaultButtonPartialImageNames.put("Top_Right_Active", "TopRightActive");
        defaultButtonPartialImageNames.put("Bottom_Right", "BottomRight");
        defaultButtonPartialImageNames.put("Bottom_Right_Rollover", "BottomRightRollover");
        defaultButtonPartialImageNames.put("Bottom_Right_Disabled", "BottomRightDisabled");
        defaultButtonPartialImageNames.put("Bottom_Right_Active", "BottomRightActive");
        defaultButtonPartialImageNames.put("TOP", "Top");
        defaultButtonPartialImageNames.put("Top_Rollover", "TopRollover");
        defaultButtonPartialImageNames.put("Top_Disabled", "TopDisabled");
        defaultButtonPartialImageNames.put("Top_Active", "TopActive");
        defaultButtonPartialImageNames.put("Center", "Center");
        defaultButtonPartialImageNames.put("Center_Rollover", "CenterRollover");
        defaultButtonPartialImageNames.put("Center_Disabled", "CenterDisabled");
        defaultButtonPartialImageNames.put("Center_Active", "CenterActive");
        defaultButtonPartialImageNames.put("Bottom", "Bottom");
        defaultButtonPartialImageNames.put("Bottom_Rollover", "BottomRollover");
        defaultButtonPartialImageNames.put("Bottom_Disabled", "BottomDisabled");
        defaultButtonPartialImageNames.put("Bottom_Active", "BottomActive");
    }
}

