/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseFontPicker;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.FontPickerKeysInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.ColorPicker;
import com.sas.servlet.tbeans.html.FontPickerStyleKeysInterface;
import com.sas.servlet.tbeans.html.Image;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.html.ToggleImage;
import com.sas.servlet.tbeans.models.FontPickerModel;
import com.sas.servlet.tbeans.models.FontPickerModelInterface;
import com.sas.servlet.tbeans.models.ItemInterface;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

@SASScope
public class FontPicker
extends BaseFontPicker
implements FontPickerKeysInterface,
FontPickerStyleKeysInterface {
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "FontPicker.html";
    public static final String RB_KEY = "FontPicker.";
    private static final HashMap defaultStyleMap;
    private static final String END_STRING_VALUE_SETTING = "');\n";
    private static final String END_BOOLEAN_VALUE_SETTING = ");\n";
    public static final String FONT_FAMILY = "setFontName";
    public static final String FONT_SIZE = "setFontSize";
    public static final String TEXT_DECORATION = "setTextDecoration";
    public static final String FONT_STYLE = "setFontStyle";
    public static final String FONT_WEIGHT = "setFontWeight";
    public static final String TEXT_ALIGN = "setTextAlign";
    public static final String FONT_FOREGROUND_COLOR = "setForegroundColor";
    public static final String FONT_BACKGROUND_COLOR = "setBackgroundColor";
    private boolean fontPickerEnabled;
    private boolean postConstructionSetupCompleted;
    private boolean controlSetup;
    private String id;
    private String previewTextDivId;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("FONTPICKER_CONTAINER_STYLE", new ImmutableStyleInfo("fontPickerContainer"));
            defaultStyleMap.put("FONTPICKER_TOOLBAR_STYLE", new ImmutableStyleInfo("fontPickerToolBar"));
            defaultStyleMap.put("FONTPICKER_PREVIEW_TEXT_STYLE", new ImmutableStyleInfo("fontPickerPreviewText"));
            defaultStyleMap.put("FONTPICKER_FONTNAME_STYLE", new ImmutableStyleInfo("fontPickerFontName"));
            defaultStyleMap.put("FONTPICKER_FONTSIZE_STYLE", new ImmutableStyleInfo("fontPickerFontSize"));
            defaultStyleMap.put("FONTPICKER_BOLD_STYLE", new ImmutableStyleInfo("fontPickerBoldButton"));
            defaultStyleMap.put("FONTPICKER_ITALIC_STYLE", new ImmutableStyleInfo("fontPickerItalicButton"));
            defaultStyleMap.put("FONTPICKER_UNDERLINE_STYLE", new ImmutableStyleInfo("fontPickerUnderlineButton"));
            defaultStyleMap.put("FONTPICKER_ALIGN_LEFT_STYLE", new ImmutableStyleInfo("fontPickerAlignLeftButton"));
            defaultStyleMap.put("FONTPICKER_ALIGN_CENTER_STYLE", new ImmutableStyleInfo("fontPickerAlignCenterButton"));
            defaultStyleMap.put("FONTPICKER_ALIGN_RIGHT_STYLE", new ImmutableStyleInfo("fontPickerAlignRightButton"));
            defaultStyleMap.put("FONTPICKER_FOREGROUND_COLOR_STYLE", new ImmutableStyleInfo("fontPickerForegroundColor"));
            defaultStyleMap.put("FONTPICKER_BACKGROUND_COLOR_STYLE", new ImmutableStyleInfo("fontPickerBackgroundColor"));
        }
    }

    public FontPicker() {
        this(null, null);
    }

    public FontPicker(FontPickerModelInterface model) {
        this(model, null);
    }

    public FontPicker(FontPickerModelInterface model, Locale locale) {
        if (model != null) {
            this.setModel(model);
        } else {
            model = new FontPickerModel();
            this.setModel(model);
            ((FontPickerModel)model).setTextAlign("left");
            ((FontPickerModel)model).setForegroundColor("black");
            ((FontPickerModel)model).setFontSize("12pt");
        }
        if (locale != null) {
            this.setLocale(locale);
        }
        this.setId(Util.getName((String)"FontPicker"));
        this.setVisible(true);
        this.postConstructionSetupCompleted = false;
        this.setControlJavaScriptComponentSetup(false);
        this.setFontSizeErrorMessage(RB.getStringResource(RB_KEY, "FontSizeErrorText.txt", locale));
        this.setComponent("FONTPICKER_ALIGN_CENTER_COMPONENT", this.createAlignCenterButton());
        this.setComponent("FONTPICKER_ALIGN_LEFT_COMPONENT", this.createAlignLeftButton());
        this.setComponent("FONTPICKER_ALIGN_RIGHT_COMPONENT", this.createAlignRightButton());
        this.setComponent("FONTPICKER_BOLD_COMPONENT", this.createBoldButton());
        this.setComponent("FONTPICKER_ITALIC_COMPONENT", this.createItalicButton());
        this.setComponent("FONTPICKER_UNDERLINE_COMPONENT", this.createUnderlineButton());
        this.setComponent("FONTPICKER_FONTNAME_COMPONENT", this.createFontNameComponent());
        this.setComponent("FONTPICKER_FONTSIZE_COMPONENT", this.createFontSizeComponent());
        this.setComponent("FONTPICKER_FOREGROUND_COLOR_COMPONENT", this.createForegroundColorPickerComponent());
        this.setComponent("FONTPICKER_BACKGROUND_COLOR_COMPONENT", this.createBackgroundColorPickerComponent());
        this.setComponent("FONTPICKER_PREVIEW_TEXT_COMPONENT", this.createSampleTextLabel());
        this.setComponent("FONTPICKER_FOREGROUND_COLOR_LABEL", null);
        this.setComponent("FONTPICKER_BACKGROUND_COLORPICKER_LABEL", null);
        this.setTemplateKey("Font_Picker");
        FontPicker.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
    }

    @Override
    public void setId(String value) {
        if (this.id == null && value != null || this.id != null && !this.id.equals(value)) {
            this.firePropertyChange("id", this.id, value);
        }
        this.id = value;
        String fpId = this.getId();
        Hashtable<String, String> parameterNames = new Hashtable<String, String>();
        parameterNames.put(FONT_FAMILY, "fontName_" + fpId);
        parameterNames.put(FONT_SIZE, "fontSize_" + fpId);
        parameterNames.put(TEXT_ALIGN, "textAlign_" + fpId);
        parameterNames.put(FONT_WEIGHT, "fontWeight_" + fpId);
        parameterNames.put(FONT_STYLE, "fontStyle_" + fpId);
        parameterNames.put(TEXT_DECORATION, "textDecoration_" + fpId);
        parameterNames.put(FONT_FOREGROUND_COLOR, "fontForegroundColor_" + fpId);
        parameterNames.put(FONT_BACKGROUND_COLOR, "fontBackgroundColor_" + fpId);
        this.setParameterNames(parameterNames);
        this.setReload(true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setPreviewTextId(String id) {
        this.previewTextDivId = id;
        this.removeComponent("FONTPICKER_PREVIEW_TEXT_COMPONENT");
    }

    public String getPreviewTextId() {
        return this.previewTextDivId;
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        FontPickerModelInterface model;
        super.setLocaleDependentProperties(locale);
        Image boldButton = (Image)this.getComponent("FONTPICKER_BOLD_COMPONENT");
        Image italicButton = (Image)this.getComponent("FONTPICKER_ITALIC_COMPONENT");
        Image underlineButton = (Image)this.getComponent("FONTPICKER_UNDERLINE_COMPONENT");
        Image leftAlignButton = (Image)this.getComponent("FONTPICKER_ALIGN_LEFT_COMPONENT");
        Image centerAlignButton = (Image)this.getComponent("FONTPICKER_ALIGN_CENTER_COMPONENT");
        Image rightAlignButton = (Image)this.getComponent("FONTPICKER_ALIGN_RIGHT_COMPONENT");
        BaseLabel previewTextComponent = (BaseLabel)this.getComponent("FONTPICKER_PREVIEW_TEXT_COMPONENT");
        if (boldButton != null) {
            this.updateBoldButtonLocale(locale, boldButton);
        }
        if (italicButton != null) {
            this.updateItalicButtonLocale(locale, italicButton);
        }
        if (underlineButton != null) {
            this.updateUnderlineButtonLocale(locale, underlineButton);
        }
        if (leftAlignButton != null) {
            this.updateLeftAlignButtonLocale(locale, leftAlignButton);
        }
        if (centerAlignButton != null) {
            this.updateCenterAlignButtonLocale(locale, centerAlignButton);
        }
        if (rightAlignButton != null) {
            this.updateRightAlignButtonLocale(locale, rightAlignButton);
        }
        if (previewTextComponent != null) {
            previewTextComponent.setText(RB.getStringResource(RB_KEY, "PreviewText.txt", locale));
        }
        if (this.getFontSizeErrorMessage() != null) {
            this.setFontSizeErrorMessage(RB.getStringResource(RB_KEY, "FontSizeErrorText.txt", locale));
        }
        if ((model = this.getModel()) != null && model instanceof FontPickerModel) {
            ((FontPickerModel)model).setLocale(locale);
        }
        this.setReload(true);
    }

    private void updateRightAlignButtonLocale(Locale locale, Image rightAlignButton) {
        rightAlignButton.setAlternateText(RB.getStringResource(RB_KEY, "RightAlignButton.txt", locale));
        rightAlignButton.setImageKey(RB.getStringResource(RB_KEY, "RightAlignTextImageKey.image", locale));
        rightAlignButton.setDisabledImageKey(RB.getStringResource(RB_KEY, "RightAlignTextDisabledImageKey.image", locale));
    }

    private void updateCenterAlignButtonLocale(Locale locale, Image centerAlignButton) {
        centerAlignButton.setAlternateText(RB.getStringResource(RB_KEY, "CenterAlignButton.txt", locale));
        centerAlignButton.setImageKey(RB.getStringResource(RB_KEY, "CenterAlignTextImageKey.image", locale));
        centerAlignButton.setDisabledImageKey(RB.getStringResource(RB_KEY, "CenterAlignTextDisabledImageKey.image", locale));
    }

    private void updateLeftAlignButtonLocale(Locale locale, Image leftAlignButton) {
        leftAlignButton.setAlternateText(RB.getStringResource(RB_KEY, "LeftAlignButton.txt", locale));
        leftAlignButton.setImageKey(RB.getStringResource(RB_KEY, "LeftAlignTextImageKey.image", locale));
        leftAlignButton.setDisabledImageKey(RB.getStringResource(RB_KEY, "LeftAlignTextDisabledImageKey.image", locale));
    }

    private void updateUnderlineButtonLocale(Locale locale, Image underlineButton) {
        underlineButton.setAlternateText(RB.getStringResource(RB_KEY, "UnderlineButton.txt", locale));
        underlineButton.setImageKey(RB.getStringResource(RB_KEY, "UnderlineImageKey.image", locale));
        underlineButton.setDisabledImageKey(RB.getStringResource(RB_KEY, "UnderlineDisabledImageKey.image", locale));
    }

    private void updateItalicButtonLocale(Locale locale, Image italicButton) {
        italicButton.setAlternateText(RB.getStringResource(RB_KEY, "ItalicButton.txt", locale));
        italicButton.setImageKey(RB.getStringResource(RB_KEY, "ItalicImageKey.image", locale));
        italicButton.setDisabledImageKey(RB.getStringResource(RB_KEY, "ItalicDisabledImageKey.image", locale));
    }

    private void updateBoldButtonLocale(Locale locale, Image boldButton) {
        boldButton.setAlternateText(RB.getStringResource(RB_KEY, "BoldButton.txt", locale));
        boldButton.setImageKey(RB.getStringResource(RB_KEY, "BoldImageKey.image", locale));
        boldButton.setDisabledImageKey(RB.getStringResource(RB_KEY, "BoldDisabledImageKey.image", locale));
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            JavaScriptIncludeHandler.writeIncludes(out, "FONTPICKER", this.getRequest());
            if (!this.postConstructionSetupCompleted || this.getReload()) {
                this.postConstructionSetup();
                this.setReload(false);
            }
            this.prepareToWrite();
            out.println("<div id=\"" + this.getId() + "\">");
            this.writeHiddenFields(out);
            super.write(out);
            out.println(this.applyTemplate(this));
            out.println("</div>");
            if (!this.isControlJavaScriptComponentSetup()) {
                this.writeJavaScript(out);
            }
        }
        this.cleanUpResources();
    }

    public void writeJavaScript(PrintWriter out) {
        FontPickerModelInterface fpModel = this.getModel();
        StringBuffer js = new StringBuffer();
        String fp = this.getId();
        js.append(JavaScriptIncludeHandler.getStartScript());
        js.append("var ").append(fp).append("= ").append(fp).append("_Obj = new sas_FontPicker('").append(fp).append(END_STRING_VALUE_SETTING);
        if (fpModel.getAutomaticFontChoice() && fpModel.getAutomaticFontChoiceValue() != "AUTOMATIC") {
            js.append(fp).append("_Obj.automaticFontChoiceValue='").append(fpModel.getAutomaticFontChoiceValue()).append("';\n");
        }
        BaseTransformation fontSizeComponent = (BaseTransformation)this.getComponent("FONTPICKER_FONTSIZE_COMPONENT");
        BaseTransformation fontNameComponent = (BaseTransformation)this.getComponent("FONTPICKER_FONTNAME_COMPONENT");
        BaseTransformation boldComponent = (BaseTransformation)this.getComponent("FONTPICKER_BOLD_COMPONENT");
        BaseTransformation italicComponent = (BaseTransformation)this.getComponent("FONTPICKER_ITALIC_COMPONENT");
        BaseTransformation underlineComponent = (BaseTransformation)this.getComponent("FONTPICKER_UNDERLINE_COMPONENT");
        BaseTransformation alignLeftComponent = (BaseTransformation)this.getComponent("FONTPICKER_ALIGN_LEFT_COMPONENT");
        BaseTransformation alignCenterComponent = (BaseTransformation)this.getComponent("FONTPICKER_ALIGN_CENTER_COMPONENT");
        BaseTransformation alignRightComponent = (BaseTransformation)this.getComponent("FONTPICKER_ALIGN_RIGHT_COMPONENT");
        BaseTransformation foregroundColorComponent = (BaseTransformation)this.getComponent("FONTPICKER_FOREGROUND_COLOR_COMPONENT");
        BaseTransformation backgroundColorComponent = (BaseTransformation)this.getComponent("FONTPICKER_BACKGROUND_COLOR_COMPONENT");
        BaseTransformation foregroundColorLabelComponent = (BaseTransformation)this.getComponent("FONTPICKER_FOREGROUND_COLOR_LABEL");
        BaseTransformation backgroundColorLabelComponent = (BaseTransformation)this.getComponent("FONTPICKER_BACKGROUND_COLORPICKER_LABEL");
        BaseTransformation previewTextComponent = (BaseTransformation)this.getComponent("FONTPICKER_PREVIEW_TEXT_COMPONENT");
        StringBuffer elements = new StringBuffer();
        if (fontNameComponent != null) {
            elements.append("'").append(fontNameComponent.getId()).append("'");
        } else {
            elements.append(fontNameComponent);
        }
        if (fontSizeComponent != null) {
            elements.append(",'").append(fontSizeComponent.getId()).append("'");
        } else {
            elements.append(",").append(fontSizeComponent);
        }
        if (boldComponent != null) {
            elements.append(",'").append(boldComponent.getId()).append("'");
        } else {
            elements.append(",").append(boldComponent);
        }
        if (italicComponent != null) {
            elements.append(",'").append(italicComponent.getId()).append("'");
        } else {
            elements.append(",").append(italicComponent);
        }
        if (underlineComponent != null) {
            elements.append(",'").append(underlineComponent.getId()).append("'");
        } else {
            elements.append(",").append(underlineComponent);
        }
        if (alignLeftComponent != null) {
            elements.append(",'").append(alignLeftComponent.getId()).append("'");
        } else {
            elements.append(",").append(alignLeftComponent);
        }
        if (alignCenterComponent != null) {
            elements.append(",'").append(alignCenterComponent.getId()).append("'");
        } else {
            elements.append(",").append(alignCenterComponent);
        }
        if (alignRightComponent != null) {
            elements.append(",'").append(alignRightComponent.getId()).append("'");
        } else {
            elements.append(",").append(alignRightComponent);
        }
        if (foregroundColorComponent != null) {
            elements.append(",'").append(foregroundColorComponent.getId()).append("_Obj'");
        } else {
            elements.append(",").append(foregroundColorComponent);
        }
        if (backgroundColorComponent != null) {
            elements.append(",'").append(backgroundColorComponent.getId()).append("_Obj'");
        } else {
            elements.append(",").append(backgroundColorComponent);
        }
        if (foregroundColorLabelComponent != null) {
            elements.append(",'").append(foregroundColorLabelComponent.getId()).append("'");
        } else {
            elements.append(",").append(foregroundColorLabelComponent);
        }
        if (backgroundColorLabelComponent != null) {
            elements.append(",'").append(backgroundColorLabelComponent.getId()).append("'");
        } else {
            elements.append(",").append(backgroundColorLabelComponent);
        }
        if (previewTextComponent != null) {
            elements.append(",'").append(previewTextComponent.getId()).append("'");
        } else if (this.getPreviewTextId() != null) {
            elements.append(",'").append(this.getPreviewTextId()).append("'");
        } else {
            elements.append(",").append(previewTextComponent);
        }
        js.append(fp).append("_Obj.setElements(").append(elements.toString()).append(END_BOOLEAN_VALUE_SETTING);
        js.append(fp).append("_Obj.setHiddenElements('").append(fp).append("_fontWeight','").append(fp).append("_fontStyle','").append(fp).append("_textDecoration','").append(fp).append("_textAlign');\n");
        String textAlign = fpModel.getTextAlign();
        if (textAlign != null && (textAlign.equalsIgnoreCase("left") && alignLeftComponent != null || textAlign.equalsIgnoreCase("center") && alignCenterComponent != null || textAlign.equalsIgnoreCase("right") && alignRightComponent != null)) {
            js.append(fp).append("_Obj.setTextAlign('").append(fpModel.getTextAlign()).append(END_STRING_VALUE_SETTING);
        }
        if (fpModel.getForegroundColor() != null && foregroundColorComponent != null) {
            js.append(fp).append("_Obj.setForegroundColor('").append(fpModel.getForegroundColor()).append(END_STRING_VALUE_SETTING);
        }
        if (fpModel.getBackgroundColor() != null && backgroundColorComponent != null) {
            js.append(fp).append("_Obj.setBackgroundColor('").append(fpModel.getBackgroundColor()).append(END_STRING_VALUE_SETTING);
        }
        if (fpModel.getFontSize() != null && fontSizeComponent != null) {
            js.append(fp).append("_Obj.setFontSize('").append(fpModel.getFontSize()).append(END_STRING_VALUE_SETTING);
        } else if (fontSizeComponent != null) {
            js.append(fp).append("_Obj.fontSize=").append(fp).append("_Obj.fontSizeObject.getSelectedItem();\n");
        }
        if (fpModel.getFontName() != null && fontNameComponent != null) {
            js.append(fp).append("_Obj.setFontName('").append(fpModel.getFontName()).append(END_STRING_VALUE_SETTING);
        } else if (fontNameComponent != null) {
            js.append(fp).append("_Obj.fontName=").append(fp).append("_Obj.fontNameObject.value;\n");
        }
        if (this.getOnChange() != null) {
            js.append(fp).append("_Obj.setOnChange('").append(this.getOnChange()).append(END_STRING_VALUE_SETTING);
        }
        if (boldComponent != null) {
            js.append(fp).append("_Obj.setBoldSelected(").append(fpModel.isBold()).append(END_BOOLEAN_VALUE_SETTING);
        }
        if (italicComponent != null) {
            js.append(fp).append("_Obj.setItalicSelected(").append(fpModel.isItalic()).append(END_BOOLEAN_VALUE_SETTING);
        }
        if (underlineComponent != null) {
            js.append(fp).append("_Obj.setUnderlineSelected(").append(fpModel.isUnderline()).append(END_BOOLEAN_VALUE_SETTING);
        }
        if (previewTextComponent != null || this.getPreviewTextId() != null) {
            js.append(fp).append("_Obj.setupPreviewText();\n");
        }
        if (this.getFontSizeErrorMessage() != null) {
            js.append(fp).append("_Obj.setFontSizeErrorMessage('").append(Strings.escapeForJavaScript((String)this.getFontSizeErrorMessage())).append(END_STRING_VALUE_SETTING);
        }
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(js.toString());
    }

    public void setControlJavaScriptComponentSetup(boolean controlSetup) {
        this.controlSetup = controlSetup;
    }

    public boolean isControlJavaScriptComponentSetup() {
        return this.controlSetup;
    }

    protected void writeHiddenFields(PrintWriter out) {
        Map parameterNames = this.getParameterNames();
        String fp = this.getId();
        Hidden.writeElement(out, fp + "_textAlign", (String)parameterNames.get(TEXT_ALIGN), "", false);
        Hidden.writeElement(out, fp + "_textDecoration", (String)parameterNames.get(TEXT_DECORATION), "", false);
        Hidden.writeElement(out, fp + "_fontStyle", (String)parameterNames.get(FONT_STYLE), "", false);
        Hidden.writeElement(out, fp + "_fontWeight", (String)parameterNames.get(FONT_WEIGHT), "", false);
    }

    public void postConstructionSetup() {
        int i;
        int colorLength;
        ArrayList<ItemInterface> colorList;
        ItemInterface[] colors;
        TransformationInterface fontNameComponent = this.getComponent("FONTPICKER_FONTNAME_COMPONENT");
        TransformationInterface fontSizeComponent = this.getComponent("FONTPICKER_FONTSIZE_COMPONENT");
        TransformationInterface foregroundColorPicker = this.getComponent("FONTPICKER_FOREGROUND_COLOR_COMPONENT");
        TransformationInterface backgroundColorPicker = this.getComponent("FONTPICKER_BACKGROUND_COLOR_COMPONENT");
        TransformationInterface boldButton = this.getComponent("FONTPICKER_BOLD_COMPONENT");
        TransformationInterface italicButton = this.getComponent("FONTPICKER_ITALIC_COMPONENT");
        TransformationInterface underlineButton = this.getComponent("FONTPICKER_UNDERLINE_COMPONENT");
        TransformationInterface alignLeftButton = this.getComponent("FONTPICKER_ALIGN_LEFT_COMPONENT");
        TransformationInterface alignCenterButton = this.getComponent("FONTPICKER_ALIGN_CENTER_COMPONENT");
        TransformationInterface alignRightButton = this.getComponent("FONTPICKER_ALIGN_RIGHT_COMPONENT");
        FontPickerModelInterface model = this.getModel();
        Map parameterNames = this.getParameterNames();
        if (boldButton != null) {
            boldButton.setId((String)parameterNames.get(FONT_WEIGHT) + "_button");
        }
        if (italicButton != null) {
            italicButton.setId((String)parameterNames.get(FONT_STYLE) + "_button");
        }
        if (underlineButton != null) {
            underlineButton.setId((String)parameterNames.get(TEXT_DECORATION) + "_button");
        }
        if (alignLeftButton != null) {
            alignLeftButton.setId((String)parameterNames.get(TEXT_ALIGN) + "_left");
        }
        if (alignCenterButton != null) {
            alignCenterButton.setId((String)parameterNames.get(TEXT_ALIGN) + "_center");
        }
        if (alignRightButton != null) {
            alignRightButton.setId((String)parameterNames.get(TEXT_ALIGN) + "_right");
        }
        if (foregroundColorPicker != null) {
            foregroundColorPicker.setId((String)parameterNames.get(FONT_FOREGROUND_COLOR));
            colors = model.getForegroundColors();
            if (colors != null) {
                colorList = new ArrayList<ItemInterface>();
                colorLength = colors.length;
                for (i = 0; i < colorLength; ++i) {
                    colorList.add(colors[i]);
                }
                ((ColorPicker)foregroundColorPicker).setModel(colorList);
            }
        }
        if (backgroundColorPicker != null) {
            backgroundColorPicker.setId((String)parameterNames.get(FONT_BACKGROUND_COLOR));
            colors = model.getBackgroundColors();
            if (colors != null) {
                colorList = new ArrayList();
                colorLength = colors.length;
                for (i = 0; i < colorLength; ++i) {
                    colorList.add(colors[i]);
                }
                ((ColorPicker)backgroundColorPicker).setModel(colorList);
            }
        }
        if (fontNameComponent != null) {
            fontNameComponent.setName((String)parameterNames.get(FONT_FAMILY));
            fontNameComponent.setId((String)parameterNames.get(FONT_FAMILY));
            ItemInterface[] fontNames = model.getFontNames();
            if (fontNames != null) {
                ((BaseChoiceBox)fontNameComponent).setModel(new DefaultComboBoxModel<ItemInterface>(fontNames));
            } else if (model instanceof FontPickerModel) {
                ((BaseChoiceBox)fontNameComponent).setModel(new DefaultComboBoxModel<ItemInterface>(((FontPickerModel)model).getDefaultFontNames()));
            }
        }
        if (fontSizeComponent != null) {
            fontSizeComponent.setName((String)parameterNames.get(FONT_SIZE));
            fontSizeComponent.setId((String)parameterNames.get(FONT_SIZE));
            DefaultComboBoxModel fontSizesComboModel = (DefaultComboBoxModel)((BaseChoiceBox)fontSizeComponent).getModel();
            ItemInterface[] fontSizes = model.getFontSizes();
            if (fontSizes == null && model instanceof FontPickerModel) {
                fontSizes = ((FontPickerModel)model).getDefaultFontSizes();
            }
            if (fontSizes != null) {
                int fontSizeLength = fontSizes.length;
                for (i = 0; i < fontSizeLength; ++i) {
                    JavaScriptNode fontSizeNode = new JavaScriptNode();
                    fontSizeNode.setText(fontSizes[i].getText());
                    fontSizeNode.setValue(fontSizes[i].getValue());
                    fontSizesComboModel.addElement(fontSizeNode);
                }
            }
        }
        this.postConstructionSetupCompleted = true;
    }

    protected void prepareToWrite() {
        this.prepareToWriteFontNameComponent();
        this.prepareToWriteFontSizeComponent();
        this.prepareToWriteBoldComponent();
        this.prepareToWriteItalicComponent();
        this.prepareToWriteUnderlineComponent();
        this.prepareToWriteTextAlignComponents();
        this.prepareToWriteForegroundColorComponent();
        this.prepareToWriteBackgroundColorComponent();
        this.prepareToWritePreviewText();
    }

    protected void prepareToWritePreviewText() {
    }

    protected void prepareToWriteTextAlignComponents() {
        Image alignLeftButton = (Image)this.getComponent("FONTPICKER_ALIGN_LEFT_COMPONENT");
        Image alignCenterButton = (Image)this.getComponent("FONTPICKER_ALIGN_CENTER_COMPONENT");
        Image alignRightButton = (Image)this.getComponent("FONTPICKER_ALIGN_RIGHT_COMPONENT");
        if (alignLeftButton != null) {
            alignLeftButton.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','textAlign','left');");
        }
        if (alignCenterButton != null) {
            alignCenterButton.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','textAlign','center');");
        }
        if (alignRightButton != null) {
            alignRightButton.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','textAlign','right');");
        }
    }

    protected void prepareToWriteBoldComponent() {
        Image boldButton = (Image)this.getComponent("FONTPICKER_BOLD_COMPONENT");
        if (boldButton != null) {
            boldButton.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','bold'," + null + ");");
        }
    }

    protected void prepareToWriteItalicComponent() {
        Image italicButton = (Image)this.getComponent("FONTPICKER_ITALIC_COMPONENT");
        if (italicButton != null) {
            italicButton.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','italic'," + null + ");");
        }
    }

    protected void prepareToWriteUnderlineComponent() {
        Image underlineButton = (Image)this.getComponent("FONTPICKER_UNDERLINE_COMPONENT");
        if (underlineButton != null) {
            underlineButton.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','underline'," + null + ");");
        }
    }

    protected void prepareToWriteBackgroundColorComponent() {
        ColorPicker backgroundColorPicker = (ColorPicker)this.getComponent("FONTPICKER_BACKGROUND_COLOR_COMPONENT");
        if (backgroundColorPicker != null) {
            backgroundColorPicker.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','backgroundColor', " + this.getId() + ".backgroundColorObject.getSelectedItem());");
            if (backgroundColorPicker.isAllowCustomEntry()) {
                backgroundColorPicker.setOnChange("sas_FontPicker_processSelection('" + this.getId() + "','backgroundColor', " + this.getId() + ".backgroundColorObject.getSelectedItem());");
            }
        }
    }

    protected void prepareToWriteForegroundColorComponent() {
        ColorPicker foregroundColorPicker = (ColorPicker)this.getComponent("FONTPICKER_FOREGROUND_COLOR_COMPONENT");
        if (foregroundColorPicker != null) {
            foregroundColorPicker.setOnClick("sas_FontPicker_processSelection('" + this.getId() + "','foregroundColor', " + this.getId() + ".foregroundColorObject.getSelectedItem());");
            if (foregroundColorPicker.isAllowCustomEntry()) {
                foregroundColorPicker.setOnChange("sas_FontPicker_processSelection('" + this.getId() + "','foregroundColor', " + this.getId() + ".foregroundColorObject.getSelectedItem());");
            }
        }
    }

    protected void prepareToWriteFontSizeComponent() {
        BaseChoiceBox fontSizeChoice = (BaseChoiceBox)this.getComponent("FONTPICKER_FONTSIZE_COMPONENT");
        if (fontSizeChoice != null) {
            fontSizeChoice.setOnKeyUp("sas_FontPicker_processSelection('" + this.getId() + "','fontSize'," + this.getId() + ".fontSizeObject.textComponent.value,event)");
            fontSizeChoice.setOnChange("sas_FontPicker_processSelection('" + this.getId() + "','fontSize'," + this.getId() + ".fontSizeObject.getValue(),event)");
            fontSizeChoice.setOnBlur("sas_FontPicker_checkFontSizeUnit('" + this.getId() + "',event)");
            try {
                fontSizeChoice.setSelectedItem(this.getModel().getFontSize());
            }
            catch (IOException e) {
                LoggerRepository2.getLogger((String)FontPicker.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void prepareToWriteFontNameComponent() {
        BaseChoiceBox fontNameChoice = (BaseChoiceBox)this.getComponent("FONTPICKER_FONTNAME_COMPONENT");
        if (fontNameChoice != null) {
            fontNameChoice.setOnChange("sas_FontPicker_processSelection('" + this.getId() + "','fontName', value)");
            try {
                fontNameChoice.setSelectedItem(this.getModel().getFontName());
            }
            catch (IOException e) {
                LoggerRepository2.getLogger((String)FontPicker.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setEnabled(boolean enable) {
        this.fontPickerEnabled = enable;
        Collection components = this.getComponents().values();
        for (TransformationInterface component : components) {
            if (component instanceof BaseFormElement) {
                ((BaseFormElement)component).setEnabled(enable);
                continue;
            }
            if (component instanceof Image) {
                ((Image)component).setEnabled(enable);
                continue;
            }
            if (!(component instanceof ColorPicker)) continue;
            ((ColorPicker)component).setEnabled(enable);
        }
    }

    public boolean isEnabled() {
        return this.fontPickerEnabled;
    }

    protected TransformationInterface createSampleTextLabel() {
        Label sampleTextLabel = new Label(RB.getStringResource(RB_KEY, "PreviewText.txt", this.getLocale()));
        sampleTextLabel.setId(this.getId() + "_sampleText");
        sampleTextLabel.setCustomAttributes("style=\"\"");
        return sampleTextLabel;
    }

    protected TransformationInterface createForegroundColorPickerComponent() {
        ColorPicker foregroundColorPicker = new ColorPicker();
        foregroundColorPicker.setLaunchImageKey("Foreground_Color");
        foregroundColorPicker.setLaunchImageDisabledKey("Foreground_Color_Disabled");
        return foregroundColorPicker;
    }

    protected TransformationInterface createBackgroundColorPickerComponent() {
        ColorPicker backgroundColorPicker = new ColorPicker();
        backgroundColorPicker.setLaunchImageKey("Background_Color");
        backgroundColorPicker.setLaunchImageDisabledKey("Background_Color_Disabled");
        return backgroundColorPicker;
    }

    protected TransformationInterface createFontSizeComponent() {
        ComboBoxView fs = new ComboBoxView();
        fs.setEditable(true);
        return fs;
    }

    protected TransformationInterface createFontNameComponent() {
        return new ChoiceBox();
    }

    protected TransformationInterface createUnderlineButton() {
        ToggleImage underlineButton = new ToggleImage();
        this.updateUnderlineButtonLocale(this.getLocale(), underlineButton);
        underlineButton.setSelected(false);
        underlineButton.setToggleEnabled(false);
        return underlineButton;
    }

    protected TransformationInterface createItalicButton() {
        ToggleImage italicButton = new ToggleImage();
        this.updateItalicButtonLocale(this.getLocale(), italicButton);
        italicButton.setSelected(false);
        italicButton.setToggleEnabled(false);
        return italicButton;
    }

    protected TransformationInterface createBoldButton() {
        ToggleImage boldButton = new ToggleImage();
        this.updateBoldButtonLocale(this.getLocale(), boldButton);
        boldButton.setSelected(false);
        boldButton.setToggleEnabled(false);
        return boldButton;
    }

    protected TransformationInterface createAlignRightButton() {
        ToggleImage rightAlignButton = new ToggleImage();
        this.updateRightAlignButtonLocale(this.getLocale(), rightAlignButton);
        rightAlignButton.setSelected(false);
        rightAlignButton.setToggleEnabled(false);
        return rightAlignButton;
    }

    protected TransformationInterface createAlignLeftButton() {
        ToggleImage leftAlignButton = new ToggleImage();
        this.updateLeftAlignButtonLocale(this.getLocale(), leftAlignButton);
        leftAlignButton.setSelected(false);
        leftAlignButton.setToggleEnabled(false);
        return leftAlignButton;
    }

    protected TransformationInterface createAlignCenterButton() {
        ToggleImage centerAlignButton = new ToggleImage();
        this.updateCenterAlignButtonLocale(this.getLocale(), centerAlignButton);
        centerAlignButton.setSelected(false);
        centerAlignButton.setToggleEnabled(false);
        return centerAlignButton;
    }

    static {
        JavaScriptIncludeHandler.addAlias(FontPicker.class, "FONTPICKER");
        defaultStyleMap = new HashMap();
    }
}

