/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.PalettePicker;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.util.validators.HexColorStringValidator;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

@SASScope
public class ColorPicker
extends PalettePicker {
    private static final String RB_KEY = "ColorPicker.";
    private static String paletteCellTemplate = null;
    private Object color;
    protected Label hexEntryLabel = null;
    public static final String NO_SELECTION = "NO_SELECTION";
    public static final String AUTOMATIC = "Automatic";
    private String automaticColor = null;
    private boolean allowCustomEntry;
    private boolean displayAutomaticInPreviewArea = true;
    public static final String COLOR_PICKER_AUTOMATIC_SWATCH = "COLOR_PICKER_AUTOMATIC_SWATCH";

    public ColorPicker() {
        super(Util.getName((String)"cp"));
        StyleInfo colorCell = new StyleInfo("ColorPickerItemCell");
        this.getStyleMap().put("PALETTE_ITEM_CELL", colorCell);
        StyleInfo selectedCell = new StyleInfo("ColorPickerSelectedItemCell");
        this.getStyleMap().put("PALETTE_SELECTED_ITEM_CELL", selectedCell);
        StyleInfo container = new StyleInfo("ColorPickerContainer");
        this.getStyleMap().put("PALETTE_CONTAINER", container);
        StyleInfo containerDisabled = new StyleInfo("ColorPickerContainerDisabled");
        this.getStyleMap().put("PALETTE_CONTAINER_DISABLED", containerDisabled);
        StyleInfo colorPreviewCell = new StyleInfo("ColorPickerPreviewCell");
        this.getStyleMap().put("PALETTE_PREVIEW_CELL", colorPreviewCell);
        StyleInfo colorImageCell = new StyleInfo("ColorPickerImageCell");
        this.getStyleMap().put("PALETTE_IMAGE_CELL", colorImageCell);
        StyleInfo automaticColorSwatch = new StyleInfo("ColorPickerAutomaticSwatch");
        this.getStyleMap().put(COLOR_PICKER_AUTOMATIC_SWATCH, automaticColorSwatch);
        this.setObjectDataProperty("color");
        this.setDefaultModel();
        this.hexEntryLabel = new Label();
        this.hexEntryLabel.setId(this.getId() + "_hexEntryLabel");
        this.hexEntryLabel.setVisible(false);
        this.setComponent("PALETTE_CUSTOM_LABEL", this.hexEntryLabel);
        TextEntry hexEntry = new TextEntry();
        hexEntry.setId(this.getId() + "_hexEntry");
        hexEntry.setJavaScriptObjectCreationEnabled(true);
        hexEntry.setMaximumLength(8);
        hexEntry.setSize(8);
        HexColorStringValidator validator = new HexColorStringValidator();
        validator.setSasColorsOnly(false);
        hexEntry.setValidator(validator);
        hexEntry.setVisible(false);
        hexEntry.setTabIndex("0");
        this.setComponent("PALETTE_CUSTOM_COMPONENT", hexEntry);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this.hexEntryLabel.setText(RB.getStringResource(RB_KEY, "colorValue.txt", locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(PrintWriter out) throws IOException {
        String string = RB_KEY;
        synchronized (RB_KEY) {
            HashMap<String, String> dictionary;
            if (paletteCellTemplate == null) {
                paletteCellTemplate = TemplateSupport.getTemplate(this.getRequest(), "ColorPaletteCell.html");
            }
            this.setPaletteCellTemplate(paletteCellTemplate);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            JavaScriptIncludeHandler.writeIncludes(out, "COLORPICKER", this.getRequest());
            TextEntry hexEntry = (TextEntry)this.getComponent("PALETTE_CUSTOM_COMPONENT");
            if (hexEntry != null) {
                Label hexEntryLabel = (Label)this.getComponent("PALETTE_CUSTOM_LABEL");
                if (this.isAllowCustomEntry()) {
                    hexEntry.setVisible(true);
                    if (hexEntryLabel != null) {
                        hexEntryLabel.setVisible(true);
                    }
                    hexEntry.setOnClick("event.cancelBubble=true;");
                    hexEntry.setOnKeyDown(this.getId() + "_Obj.customEntryValidate(event," + hexEntry.getId() + "_Obj); sas_Palette_BlurringLastFocusedItemInPalette(event);");
                } else {
                    hexEntryLabel.setVisible(false);
                    hexEntry.setVisible(false);
                }
            }
            if ((dictionary = this.getTemplateDictionary()) == null) {
                dictionary = new HashMap<String, String>();
                this.setTemplateDictionary(dictionary);
            }
            if (this.isAutomaticVisible()) {
                dictionary.put("PALETTE_PREVIEW_CELL_CONTENTS", "<span id=\"previewSpan_" + this.getId() + "\">" + RB.getStringResource(RB_KEY, "Automatic.txt", this.getLocale()) + "</span>");
            } else {
                dictionary.put("PALETTE_PREVIEW_CELL_CONTENTS", "&#160;");
            }
            this.writeJavaScript(out);
            super.write(out);
            return;
        }
    }

    public void setDefaultColor(String defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public String getDefaultColor() {
        return this.getDefaultValue();
    }

    @Override
    protected String getJavaScript() {
        StringBuffer buf = new StringBuffer();
        StyleInfo containerStyle = (StyleInfo)this.getStyleMap().get("PALETTE_CONTAINER");
        StyleInfo containerDisabledStyle = (StyleInfo)this.getStyleMap().get("PALETTE_CONTAINER_DISABLED");
        String jsObj = this.getId() + "_Obj";
        buf.append(JavaScriptIncludeHandler.getStartScript());
        buf.append("PALETTE_NO_SELECTION = 'NO_SELECTION';\n");
        buf.append("COLORPICKER_AUTOMATIC = 'Automatic';\n");
        buf.append(jsObj + " = new sas_ColorPicker('" + this.getId() + "');\n");
        buf.append(jsObj + ".allowCustomEntry = " + this.allowCustomEntry + ";\n");
        buf.append(jsObj + ".automaticVisible = " + this.isAutomaticVisible() + ";\n");
        buf.append(jsObj + ".displayAutomaticInPreviewArea = " + this.displayAutomaticInPreviewArea + ";\n");
        buf.append(jsObj + ".previewCellBaseContents = '" + Strings.escapeForJavaScript((String)((String)this.getTemplateDictionary().get("PALETTE_PREVIEW_CELL_CONTENTS"))) + "';\n");
        buf.append(jsObj + ".automaticColor = '" + this.getAutomaticColor() + "';\n");
        buf.append(jsObj + ".automatic = '" + Strings.escapeForJavaScript((String)RB.getStringResource(RB_KEY, "Automatic.txt", this.getLocale())) + "';\n");
        buf.append(jsObj + ".containerStyle = '" + containerStyle.getClassid() + "';\n");
        buf.append(jsObj + ".containerDisabledStyle = '" + containerDisabledStyle.getClassid() + "';\n");
        buf.append(JavaScriptIncludeHandler.getEndScript(null));
        buf.append(super.getJavaScript());
        return buf.toString();
    }

    @Override
    public String getUpdatePreviewJavascript() {
        return "";
    }

    @Override
    public String getDefaultCellTemplate() {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        String spacerImage = cpm.getImageURI("Spacer");
        StringBuffer template = new StringBuffer();
        template.append("<td onclick=\"%ONCLICK\" class=\"%ITEM_CLASS\" style=\"%ITEM_STYLE ;background-color: %ITEM_VALUE\"><img src=\"" + spacerImage + "\" class=\"%ITEM_CLASS\" alt=\"\" style=\"display: block; border: 0px;%ITEM_STYLE\" /></td>");
        return template.toString();
    }

    @Override
    protected String getAutomaticCell() {
        if (!this.isAutomaticVisible()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellpadding=\"0\" cellspacing=\"0\" style=\"width:100%\"");
        sb.append(" class=\"ColorPickerAutomatic\" onmouseover=\"this.className='ColorPickerAutomatic ColorPickerAutomaticRollover';\" onmouseout=\"this.className='ColorPickerAutomatic';\">");
        sb.append("<tr>");
        if (this.automaticColor != null) {
            String styleClass = "";
            StyleInfo automaticSwatchStyle = (StyleInfo)this.getStyleMap().get(COLOR_PICKER_AUTOMATIC_SWATCH);
            if (automaticSwatchStyle.getClassid() != null) {
                styleClass = automaticSwatchStyle.getClassid();
            }
            sb.append("<td id=\"").append(this.getId()).append("_autocolor\" class=\"").append(styleClass).append("\">");
            sb.append("<div class=\"").append(styleClass).append("\" style=\"background-color:").append(this.getAutomaticColor()).append("; font-size: 1px;\"></div>");
            sb.append("</td>");
        }
        sb.append("<td id=\"").append(this.getId()).append("_autotext\" style=\"text-align: center; white-space:nowrap\">").append(RB.getStringResource(RB_KEY, "Automatic.txt", this.getLocale())).append("</td>");
        sb.append("</tr></table>");
        StringBuffer onClick = new StringBuffer();
        onClick.append(this.getId()).append("_Obj.selectItem('Automatic',event);");
        if (this.getOnClick() != null) {
            onClick.append(this.getOnClick());
        }
        return "<tr><td colspan=\"" + this.getTemplateDictionary().get("PALETTE_CELL_COLUMN_COUNT") + "\" tabindex=\"0\" onclick=\"" + onClick.toString() + "\" onkeydown=\"if(event==null) event=window.event; if(event.keyCode==13){" + onClick.toString() + ";}" + (this.isAllowCustomEntry() ? "\"" : "sas_Palette_BlurringLastFocusedItemInPalette(event);") + "\" id=\"" + this.getId() + AUTOMATIC + "\">" + sb.toString() + "</td></tr>";
    }

    protected void setDefaultModel() {
        ArrayList<Item> colors = new ArrayList<Item>();
        Item color = new Item();
        color.setValue("#000000");
        colors.add(color);
        color = new Item();
        color.setValue("#0000FF");
        colors.add(color);
        color = new Item();
        color.setValue("#A05000");
        colors.add(color);
        color = new Item();
        color.setValue("#4F4F4F");
        colors.add(color);
        color = new Item();
        color.setValue("#E8D898");
        colors.add(color);
        color = new Item();
        color.setValue("#00FFFF");
        colors.add(color);
        color = new Item();
        color.setValue("#FF00FF");
        colors.add(color);
        color = new Item();
        color.setValue("#FFAA00");
        colors.add(color);
        color = new Item();
        color.setValue("#808080");
        colors.add(color);
        color = new Item();
        color.setValue("#00FF00");
        colors.add(color);
        color = new Item();
        color.setValue("#E06090");
        colors.add(color);
        color = new Item();
        color.setValue("#C0FF81");
        colors.add(color);
        color = new Item();
        color.setValue("#700000");
        colors.add(color);
        color = new Item();
        color.setValue("#000080");
        colors.add(color);
        color = new Item();
        color.setValue("#2A8307");
        colors.add(color);
        color = new Item();
        color.setValue("#FF8000");
        colors.add(color);
        color = new Item();
        color.setValue("#FF0080");
        colors.add(color);
        color = new Item();
        color.setValue("#703070");
        colors.add(color);
        color = new Item();
        color.setValue("#FF0000");
        colors.add(color);
        color = new Item();
        color.setValue("#FF6060");
        colors.add(color);
        color = new Item();
        color.setValue("#FF0055");
        colors.add(color);
        color = new Item();
        color.setValue("#C0C0C0");
        colors.add(color);
        color = new Item();
        color.setValue("#3883A8");
        colors.add(color);
        color = new Item();
        color.setValue("#E0A860");
        colors.add(color);
        color = new Item();
        color.setValue("#008080");
        colors.add(color);
        color = new Item();
        color.setValue("#B090D0");
        colors.add(color);
        color = new Item();
        color.setValue("#FFFFFF");
        colors.add(color);
        color = new Item();
        color.setValue("#FFFF00");
        colors.add(color);
        color = new Item();
        color.setValue("transparent");
        colors.add(color);
        this.setModel(colors);
    }

    public String getAutomaticColor() {
        return this.automaticColor;
    }

    public void setAutomaticColor(String automaticColor) {
        this.setAutomaticColor(automaticColor, true);
    }

    public void setAutomaticColor(String automaticColor, boolean displayAutomaticInPreviewArea) {
        this.automaticColor = automaticColor;
        this.displayAutomaticInPreviewArea = displayAutomaticInPreviewArea;
    }

    protected void writeJavaScript(PrintWriter out) {
    }

    @SASScope
    public Object getColor() {
        return this.color;
    }

    @SASScope
    public void setColor(Object value) {
        if (value instanceof Color) {
            Color color = (Color)value;
            String red = Integer.toHexString(color.getRed());
            String green = Integer.toHexString(color.getGreen());
            String blue = Integer.toHexString(color.getBlue());
            if (red.length() == 1) {
                red = "0" + red;
            }
            if (green.length() == 1) {
                green = "0" + green;
            }
            if (blue.length() == 1) {
                blue = "0" + blue;
            }
            this.setDefaultColor(new StringBuffer().append("#").append(red).append(green).append(blue).toString());
        } else if (value instanceof String) {
            this.setDefaultColor((String)value);
        } else if (value instanceof String[]) {
            this.setDefaultColor(((String[])value)[0]);
        } else if (value == null) {
            this.setDefaultColor(null);
        }
        this.color = value;
    }

    @SASScope
    public boolean isAllowCustomEntry() {
        return this.allowCustomEntry;
    }

    @SASScope
    public void setAllowCustomEntry(boolean allowCustomEntry) {
        this.allowCustomEntry = allowCustomEntry;
    }

    @SASScope
    public Item getColorFromModel(String color) {
        if (this.model == null) {
            return null;
        }
        try {
            for (int i = 0; i <= this.model.size(); ++i) {
                Item item = (Item)this.model.get(i);
                if (!item.getValue().equalsIgnoreCase(color)) continue;
                return item;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected String getPaletteCell(Item paletteItem, boolean firstItem, boolean lastItem) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        String paletteItemTemplate = this.getPaletteCellTemplate();
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("SPACER_IMAGE", cpm.getImageURI("Spacer"));
        dictionary.put("ITEM_VALUE", paletteItem.getValue());
        StyleInfo paletteItemStyle = (StyleInfo)this.getStyleMap().get("PALETTE_ITEM_CELL");
        if (paletteItemStyle.getClassid() != null) {
            dictionary.put("ITEM_CLASS", paletteItemStyle.getClassid());
        }
        if (paletteItemStyle.getStyle() != null) {
            dictionary.put("ITEM_STYLE", paletteItemStyle.getStyle());
        }
        StringBuffer onClick = new StringBuffer();
        onClick.append(this.getId()).append("_Obj.selectItem('").append(paletteItem.getValue()).append("',event);");
        if (this.getOnClick() != null) {
            onClick.append(this.getOnClick());
        }
        dictionary.put("ONCLICK", onClick.toString());
        if (this.getAutomaticCell() == null || "".equals(this.getAutomaticCell()) && lastItem && !this.allowCustomEntry) {
            dictionary.put("ONTAB", "sas_Palette_BlurringLastFocusedItemInPalette(event);");
        }
        if (firstItem) {
            dictionary.put("ONTAB", "sas_Palette_BlurringFirstFocusedItemInPalette(event);");
            dictionary.put("SWATCHID", this.getId() + "_swatch_firstItem");
        }
        if (lastItem) {
            dictionary.put("SWATCHID", this.getId() + "_swatch_lastItem");
        }
        String cellId = (this.getId() + paletteItem.getValue()).replace('#', '_');
        cellId = cellId.replace('/', '_');
        dictionary.put("CELLID", cellId);
        if (!firstItem && !lastItem) {
            dictionary.put("SWATCHID", cellId + "_swatch");
        }
        return SimpleTemplate.format((String)paletteItemTemplate, dictionary);
    }

    static {
        JavaScriptIncludeHandler.addAlias(ColorPicker.class, "COLORPICKER");
    }
}

