/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.ButtonImageKeyConfig;
import com.sas.servlet.tbeans.html.ButtonStyleAreaKeysInterface;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class Button
extends BaseButton
implements ButtonStyleAreaKeysInterface,
ComplexStyleInterface {
    public static final int BUTTON = 3;
    public static final int ANCHOR = 4;
    private int buttonType = 3;
    private MapWithDefaults componentStyleMap;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo ButtonContainerStyle = new ImmutableStyleInfo("buttonContainer");
    private static final ImmutableStyleInfo ButtonTopStyle = new ImmutableStyleInfo("buttonTop");
    private static final ImmutableStyleInfo ButtonTopRightStyle = new ImmutableStyleInfo("buttonTopRight");
    private static final ImmutableStyleInfo ButtonTopLeftStyle = new ImmutableStyleInfo("buttonTopLeft");
    private static final ImmutableStyleInfo ButtonBottomStyle = new ImmutableStyleInfo("buttonBottom");
    private static final ImmutableStyleInfo ButtonBottomRightStyle = new ImmutableStyleInfo("buttonBottomRight");
    private static final ImmutableStyleInfo ButtonBottomLeftStyle = new ImmutableStyleInfo("buttonBottomLeft");
    private static final ImmutableStyleInfo ButtonLeftStyle = new ImmutableStyleInfo("buttonLeft");
    private static final ImmutableStyleInfo ButtonRightStyle = new ImmutableStyleInfo("buttonRight");
    private static final ImmutableStyleInfo ButtonCenterStyle = new ImmutableStyleInfo("buttonCenter");
    private static final ImmutableStyleInfo ButtonStyle = new ImmutableStyleInfo("button");
    private static final ImmutableStyleInfo ButtonRolloverStyle = new ImmutableStyleInfo("buttonRollover");
    private static final ImmutableStyleInfo ButtonCenterDisabledStyle = new ImmutableStyleInfo("buttonCenterDisabled");
    private static final ImmutableStyleInfo ButtonCenterActiveStyle = new ImmutableStyleInfo("buttonActive");

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("BUTTON_CONTAINER", ButtonContainerStyle);
            defaultStyleMap.put("BUTTON_STYLE", ButtonStyle);
            defaultStyleMap.put("BUTTON_ROLLOVER_STYLE", ButtonRolloverStyle);
            defaultStyleMap.put("BUTTON_TOP", ButtonTopStyle);
            defaultStyleMap.put("BUTTON_TOP_RIGHT", ButtonTopRightStyle);
            defaultStyleMap.put("BUTTON_TOP_LEFT", ButtonTopLeftStyle);
            defaultStyleMap.put("BUTTON_BOTTOM", ButtonBottomStyle);
            defaultStyleMap.put("BUTTON_BOTTOM_RIGHT", ButtonBottomRightStyle);
            defaultStyleMap.put("BUTTON_BOTTOM_LEFT", ButtonBottomLeftStyle);
            defaultStyleMap.put("BUTTON_LEFT", ButtonLeftStyle);
            defaultStyleMap.put("BUTTON_RIGHT", ButtonRightStyle);
            defaultStyleMap.put("BUTTON_CENTER", ButtonCenterStyle);
            defaultStyleMap.put("BUTTON_CENTER_DISABLED", ButtonCenterDisabledStyle);
            defaultStyleMap.put("BUTTON_CENTER_ACTIVE", ButtonCenterActiveStyle);
        }
    }

    public Button() {
        this(null, null);
    }

    public Button(String label) {
        this(label, null);
    }

    public Button(String label, String image) {
        Button.setupDefaultStyleMap();
        this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
        this.setId(Util.getName((String)"button"));
        this.setTabIndex(-2);
        this.setWidthPercentage(0);
        this.setHeightPercentage(0);
        this.setWidth(0);
        this.setHeight(0);
        this.setLabel(label);
        this.setImage(image);
        this.setWrap(false);
        this.setStyleClassPrefix("");
        this.setEnabled(true);
        this.setFocus(false);
        this.setVerifyEnabled(true);
        this.setDynamicButtonArea(0);
        this.setActive(false);
        this.imageHeight = -1;
        this.imageWidth = -1;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        String button_id = this.getId();
        JavaScriptIncludeHandler.writeIncludes(out, "BUTTON", this.getRequest());
        StringBuffer sb = new StringBuffer();
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        if (!this.isSimpleButton()) {
            sb.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" id=\"");
        } else {
            sb.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" id=\"");
        }
        sb.append(button_id).append("\" class=\"");
        sb.append(this.getStyleClassPrefix()).append(((StyleInfo)this.getStyleMap().get("BUTTON_CONTAINER")).getClassid());
        sb.append("\"");
        sb.append(this.generateStyleAttribute("BUTTON_CONTAINER"));
        if (this.getWidth() > 0) {
            sb.append(" width=\"").append(this.getWidth()).append("\"");
        } else if (this.getWidthPercentage() > 0) {
            sb.append(" width=\"").append(this.getWidthPercentage()).append("%\"");
        }
        if (this.getHeight() > 0) {
            sb.append(" height=\"").append(this.getHeight()).append("\"");
        } else if (this.getHeightPercentage() > 0) {
            sb.append(" height=\"").append(this.getHeightPercentage()).append("%\"");
        }
        sb.append(this.getButtonProperties());
        sb.append(">\n<tr>\n");
        if (!this.isSimpleButton()) {
            ButtonImageKeyConfig config = this.getImageKeyConfig();
            if (this.isTopRowNeeded()) {
                String topLeftStyle = null;
                topLeftStyle = this.getDynamicButtonArea() != 0 ? this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_TOP_LEFT")).getClassid() + this.getDynamicRootName() + "TopLeft" : this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_TOP_LEFT")).getClassid();
                sb.append("  <td id=\"").append(button_id).append("_tl\" valign=\"top\"").append(this.generateStyleAttribute("BUTTON_TOP_LEFT")).append(" class=\"").append(topLeftStyle).append("\">").append(this.getImageTag(this.getTopLeftImage(), "Top_Left", "_tl_img", 64, 73)).append("</td>\n");
                String topStyle = null;
                topStyle = this.getDynamicButtonArea() != 0 ? this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_TOP")).getClassid() + this.getDynamicRootName() + "Top" : this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_TOP")).getClassid();
                sb.append("  <td id=\"" + button_id + "_t\" align=\"center\"").append(this.generateStyleAttribute("BUTTON_TOP")).append(" class=\"" + topStyle + "\">" + this.getImageTag(this.getTopImage(), "Top_Right", "_t_img", 8, 73) + "</td>\n");
                String topRightStyle = null;
                topRightStyle = this.getDynamicButtonArea() != 0 ? this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_TOP_RIGHT")).getClassid() + this.getDynamicRootName() + "TopRight" : this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_TOP_RIGHT")).getClassid();
                sb.append("  <td id=\"").append(button_id).append("_tr\" valign=\"top\"").append(this.generateStyleAttribute("BUTTON_TOP_RIGHT")).append(" class=\"").append(topRightStyle).append("\">").append(this.getImageTag(this.getTopRightImage(), "Top_Right", "_tr_img", 1, 73)).append("</td>\n");
                sb.append("</tr>\n");
                sb.append("<tr>\n");
            }
            String leftStyle = null;
            leftStyle = this.getDynamicButtonArea() != 0 ? this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_LEFT")).getClassid() + this.getDynamicRootName() + "Left" : this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_LEFT")).getClassid();
            sb.append("  <td id=\"").append(button_id).append("_l\" valign=\"top\" align=\"left\"").append(this.generateStyleAttribute("BUTTON_LEFT")).append(" class=\"").append(leftStyle).append("\">").append(this.getImageTag(this.getLeftImage(), "Left", "_l_img", 512, 4608)).append("</td>\n");
        }
        if (this.isWrapped()) {
            sb.append("  <td");
        } else {
            sb.append("  <td nowrap=\"nowrap\"");
        }
        String centerId = button_id;
        sb.append(" id=\"").append(button_id).append("_c\"");
        centerId = button_id + "_c";
        String centerStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_CENTER")).getClassid();
        String centerDisabledStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_CENTER_DISABLED")).getClassid();
        String centerActiveStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_CENTER_ACTIVE")).getClassid();
        if (this.getDynamicButtonArea() != 0) {
            centerStyle = this.getDynamicRootName() + "Center";
            centerDisabledStyle = this.getDynamicRootName() + "Disabled";
        }
        if (this.isEnabled()) {
            sb.append(" class=\"").append(centerStyle).append("\"").append(this.generateStyleAttribute("BUTTON_CENTER"));
        } else if (this.isActive()) {
            sb.append(" class=\"").append(centerActiveStyle).append("\"").append(this.generateStyleAttribute("BUTTON_CENTER_ACTIVE"));
        } else {
            sb.append(" class=\"").append(centerDisabledStyle).append("\"").append(this.generateStyleAttribute("BUTTON_CENTER_DISABLED"));
        }
        if (this.getStyle() != null) {
            sb.append(" style=\"").append(this.getStyle()).append("\"");
        }
        if ((this.getWidth() > 0 || this.getWidthPercentage() > 0) && this.getDynamicButtonArea() != 0) {
            sb.append(" width=\"100%\"");
        }
        sb.append(" align=\"center\"");
        sb.append(">");
        sb.append(this.getCenterText());
        sb.append("</td>\n");
        if (!this.isSimpleButton()) {
            ButtonImageKeyConfig config = this.getImageKeyConfig();
            String rightStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_RIGHT")).getClassid();
            if (this.getDynamicButtonArea() != 0) {
                rightStyle = this.getDynamicRootName() + "Right";
            }
            sb.append("  <td id=\"").append(button_id).append("_r\" valign=\"top\" align=\"right\"").append(this.generateStyleAttribute("BUTTON_RIGHT")).append(" class=\"").append(rightStyle).append("\">").append(this.getImageTag(this.getRightImage(), "RIGHT", "_r_img", 4096, 4608)).append("</td>\n");
            sb.append("</tr>\n");
            if (this.isBottomRowNeeded()) {
                sb.append("<tr>\n");
                String bottomLeftStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_BOTTOM_LEFT")).getClassid();
                if (this.getDynamicButtonArea() != 0) {
                    bottomLeftStyle = this.getDynamicRootName() + "BottomLeft";
                }
                sb.append("  <td id=\"").append(button_id).append("_bl\"  valign=\"bottom\"").append(this.generateStyleAttribute("BUTTON_BOTTOM_LEFT")).append(" class=\"").append(bottomLeftStyle).append("\">").append(this.getImageTag(this.getBottomLeftImage(), "Bottom_Left", "_bl_img", 32768, 2392064)).append("</td>\n");
                String bottomStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_BOTTOM")).getClassid();
                if (this.getDynamicButtonArea() != 0) {
                    bottomStyle = this.getDynamicRootName() + "Bottom";
                }
                sb.append("  <td id=\"").append(button_id).append("_b\" valign=\"top\" align=\"left\"").append(this.generateStyleAttribute("BUTTON_BOTTOM")).append(" class=\"").append(bottomStyle).append("\">").append(this.getImageTag(this.getBottomImage(), "Bottom", "_b_img", 262144, 2392064)).append("</td>\n");
                String bottomRightStyle = this.getStyleClassPrefix() + ((StyleInfo)this.getStyleMap().get("BUTTON_BOTTOM_RIGHT")).getClassid();
                if (this.getDynamicButtonArea() != 0) {
                    bottomRightStyle = this.getDynamicRootName() + "BottomRight";
                }
                sb.append("  <td id=\"").append(button_id).append("_br\" valign=\"bottom\" align=\"right\"").append(this.generateStyleAttribute("BUTTON_BOTTOM_RIGHT")).append(" class=\"").append(bottomRightStyle).append("\">" + this.getImageTag(this.getBottomRightImage(), "Bottom_Right", "_br_img", 0x200000, 2392064)).append("</td>\n");
                sb.append("</tr>");
            }
        } else {
            sb.append("</tr>");
        }
        sb.append("</table>\n");
        if (this.isFocused() || this.isVerifyEnabled()) {
            sb.append(JavaScriptIncludeHandler.getStartScript());
        }
        if (this.isFocused()) {
            sb.append(" sas_Button_focus(\"").append(button_id).append("\"); \n");
        }
        if (this.isVerifyEnabled()) {
            String enabledStatus = "sas_Button_setState.ENABLED";
            if (!this.isEnabled()) {
                enabledStatus = "sas_Button_setState.DISABLED";
            }
            boolean activeStatus = false;
            if (this.isActive()) {
                activeStatus = true;
            }
            boolean dynamic = false;
            if (this.getDynamicButtonArea() != 0) {
                dynamic = true;
            }
            sb.append(" sas_Button_setEnabledStatus(");
            sb.append("{name:'").append(button_id).append("'");
            sb.append(",id:'").append(button_id).append("'");
            sb.append(",status:").append(enabledStatus);
            sb.append(",style:'").append(this.getStyleClassPrefix()).append(((StyleInfo)this.getStyleMap().get("BUTTON_STYLE")).getClassid()).append("'");
            sb.append(",imageLocation:'").append(this.getImageLocation()).append("'");
            sb.append(",dynamicButton:").append(dynamic);
            sb.append(",centerStyle:'").append(this.getStyleClassPrefix()).append(centerStyle).append("'");
            sb.append(",centerDisabledStyle:'").append(this.getStyleClassPrefix()).append(centerDisabledStyle).append("'");
            sb.append(",centerId:'").append(centerId).append("'");
            sb.append(",dynamicRoot:'").append(this.getDynamicRootName()).append("'");
            if (this.getDynamicRootName() != null) {
                HtmlUtil.addDynamicRootImageNameProperties(sb, this, cpm);
            }
            sb.append(",active:").append(activeStatus).append("");
            if (this.getImage() != null) {
                sb.append(",image:'").append(this.getImage() + "'");
            } else if (this.getImageKey() != null) {
                sb.append(",image:'").append(cpm.getImageName(this.getImageKey()) + "'");
            }
            if (this.getDisabledImage() != null) {
                sb.append(",disabledImage:'").append(this.getDisabledImage()).append("'");
            } else if (this.getDisabledImageKey() != null) {
                sb.append(",disabledImage:'").append(cpm.getImageName(this.getDisabledImageKey()) + "'");
            }
            if (this.getRolloverImage() != null) {
                sb.append(",rolloverImage:'").append(this.getRolloverImage()).append("'");
            } else if (this.getRolloverImageKey() != null) {
                sb.append(",rolloverImage:'").append(cpm.getImageName(this.getRolloverImageKey()) + "'");
            }
            sb.append("});");
        }
        if (this.isFocused() || this.isVerifyEnabled()) {
            sb.append(JavaScriptIncludeHandler.getEndScript(null));
        }
        out.println(sb.toString());
        this.cleanUpResources();
    }

    private String generateStyleAttribute(String styleKey) {
        StyleInfo styleInfo = (StyleInfo)this.getStyleMap().get(styleKey);
        StringBuffer style = new StringBuffer();
        if (styleInfo != null && styleInfo.getStyle() != null) {
            style.append(" style=\"");
            style.append(styleInfo.getStyle());
            style.append("\" ");
        }
        return style.toString();
    }

    @SASScope
    protected StringBuffer getCommonProperties() {
        return HtmlUtil.generateCommonProperties(null, this, this.isAnchorNeeded());
    }

    private boolean isAnchorNeeded() {
        return this.getTabIndex() > -2 || this.getAccessKey() != null || this.getURL() != null || this.getOnClick() != null || this.getOnKeyDown() != null;
    }

    @SASScope
    public StringBuffer getCenterText() {
        return HtmlUtil.generateCenterButtonText(null, this, this.getId(), this.getButtonType(), this.getURL(), this.isAnchorNeeded());
    }

    public StringBuffer getButtonProperties() {
        return HtmlUtil.generateButtonProperties(null, this, this.getId(), this.isAnchorNeeded());
    }

    private String getVerifiedFunction(String functionName) {
        if (!this.isVerifyEnabled()) {
            return functionName;
        }
        return "if (!this.disabled) { " + functionName + "}";
    }

    public void setButtonType(int type) {
        this.buttonType = type;
    }

    public int getButtonType() {
        return this.buttonType;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    private boolean isSimpleButton() {
        if (this.getLeftImage() != null || this.getRightImage() != null || this.getTopImage() != null || this.getBottomImage() != null || this.getTopRightImage() != null || this.getTopLeftImage() != null || this.getBottomLeftImage() != null || this.getBottomRightImage() != null || this.getDynamicButtonArea() != 0) {
            return false;
        }
        ButtonImageKeyConfig config = this.getImageKeyConfig();
        return config.getLeftImageKey() == null && config.getRightImageKey() == null && config.getTopImageKey() == null && config.getBottomImageKey() == null && config.getTopRightImageKey() == null && config.getTopLeftImageKey() == null && config.getBottomLeftImageKey() == null && config.getBottomRightImageKey() == null;
    }

    private boolean isBottomRowNeeded() {
        return this.getBottomImage() != null || this.getBottomLeftImage() != null || this.getBottomRightImage() != null || this.getImageKeyConfig().getBottomImageKey() != null || this.getImageKeyConfig().getBottomLeftImageKey() != null || this.getImageKeyConfig().getBottomRightImageKey() != null || this.getDynamicButtonArea() == 2392064 || this.getDynamicButtonArea() == 0x200000 || this.getDynamicButtonArea() == 32768 || this.getDynamicButtonArea() == 262144;
    }

    private boolean isTopRowNeeded() {
        return this.getTopImage() != null || this.getTopRightImage() != null || this.getTopLeftImage() != null || this.getImageKeyConfig().getTopImageKey() != null || this.getImageKeyConfig().getTopRightImageKey() != null || this.getImageKeyConfig().getTopLeftImageKey() != null || this.getDynamicButtonArea() == 73 || this.getDynamicButtonArea() == 1 || this.getDynamicButtonArea() == 64 || this.getDynamicButtonArea() == 8;
    }

    private String getImageTag(String image, String imageKey, String id, int area, int areaAll) {
        String configKey = HtmlUtil.getConfigValueFromKey(this, imageKey);
        if (image == null && configKey == null && this.getDynamicButtonArea() == 0) {
            return "";
        }
        String imageName = null;
        if (image != null) {
            String location2 = this.getImageLocation();
            imageName = location2 == null ? image : location2 + image;
        } else if (this.getDynamicButtonArea() == area || this.getDynamicButtonArea() == areaAll) {
            String dynamicRootName = this.getDynamicRootName();
            imageName = dynamicRootName.equals("button") ? ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(HtmlUtil.buildButtonImageKey(this, imageKey), "".equals(this.imageLocation) ? null : this.imageLocation) : this.getImageLocation() + this.getDynamicRootName() + HtmlUtil.defaultButtonPartialImageNames.get(imageKey) + ".gif";
        } else if (configKey != null) {
            imageName = ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(configKey, "".equals(this.imageLocation) ? null : this.imageLocation);
        }
        if (imageName == null) {
            return "";
        }
        String button_id = this.getId();
        return "<img id=\"" + button_id + id + "\" alt=\"\" src=\"" + imageName + "\" border=\"0\"/>";
    }

    static {
        JavaScriptIncludeHandler.addAlias(Button.class, "BUTTON");
    }
}

