/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.framework.themes.client.Image;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.menus.menubar.html.SimpleMenuBar;
import com.sas.servlet.tbeans.menus.model.MenuBarItem;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.text.Message;
import com.sas.util.SimpleTemplateToPrintWriter;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.ComponentLogFactoryInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

@SASScope
public final class Banner
extends BaseCompositeTransformation
implements ComponentLogFactoryInterface {
    private String _title;
    private String _secondaryTitle;
    private String _userName = "";
    private String _userRole = null;
    private String _backLinkURL = null;
    private String _backLinkLabel = null;
    private String _backLinkDescription = null;
    private String _logOnURL = null;
    private String _logOffURL = null;
    private String _preferencesURL = null;
    private String _aboutTitle;
    private String _backgroundImageKey = "banner_background";
    private List _addedItems;
    private String _helpMenuItemId = null;
    private String _helpAboutURL = null;
    private String _helpDocURL;
    private String breadCrumb1;
    private String breadCrumb2;
    private boolean showDivider = true;
    private boolean calledFromABodyTag;
    public static final long serialVersionUID = 1L;
    private LoggerFactoryInterface factory;
    private CommonLoggerInterface logger = null;
    private boolean showAsMiniBanner;
    private String mainContentAreaURL;
    private String logOffTarget = "_top";

    public Banner() {
        this.setTemplateKey("genericBanner");
    }

    public Banner(boolean calledFromABodyTag) {
        this();
        this.setCalledFromABodyTag(calledFromABodyTag);
        this.setShowDivider(false);
    }

    public void setTitle(String nameInBanner) {
        this._title = nameInBanner;
    }

    public void setSecondaryTitle(String secondaryNameInBanner) {
        this._secondaryTitle = secondaryNameInBanner;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setUserRole(String userRole) {
        this._userRole = userRole;
    }

    public void setBackLinkLabel(String backLinkLabel) {
        this._backLinkLabel = backLinkLabel;
    }

    public void setBackLinkURL(String backLinkUrl) {
        this._backLinkURL = backLinkUrl;
    }

    public void setHelpMenuItemId(String helpMenuItemId) {
        this._helpMenuItemId = helpMenuItemId;
    }

    public String getHelpMenuItemId() {
        return this._helpMenuItemId;
    }

    public void setHelpAboutURL(String helpAboutURL) {
        this._helpAboutURL = helpAboutURL;
    }

    public void setHelpDocURL(String helpDocURL) {
        this._helpDocURL = helpDocURL;
    }

    public void setLogOffURL(String logOffURL) {
        this._logOffURL = logOffURL;
    }

    public void setLogOnURL(String logOnURL) {
        this._logOnURL = logOnURL;
    }

    public void setPreferencesURL(String preferencesURL) {
        this._preferencesURL = preferencesURL;
    }

    public void setAboutTitle(String aboutTitle) {
        this._aboutTitle = aboutTitle;
    }

    public void setBackgroundImageKey(String imageKey) {
        this._backgroundImageKey = imageKey;
    }

    Map createDictionary(ComponentPropertyManager cpm) throws IOException {
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        this.setupBannerTop(dictionary, cpm);
        this.setupSimpleGlobalMenu(dictionary);
        if (!this.isShowAsMiniBanner()) {
            this.setupProductTitle(dictionary);
            this.setupLogo(dictionary, cpm);
        } else {
            dictionary.put("STYLE", "style=\"display: none;\"");
        }
        if (null != this.mainContentAreaURL) {
            this.setupSkipNavigation(dictionary, cpm);
        }
        if (!this.calledFromABodyTag) {
            dictionary.put("END_DIV", "</div>");
        }
        return dictionary;
    }

    void setupBannerTop(Map dictionary, ComponentPropertyManager cpm) {
        if (this._backLinkURL != null && this._backLinkURL.trim().length() > 0) {
            this.getLogger().debug("Setting back link:", this._backLinkURL);
            if (this._backLinkLabel == null) {
                this._backLinkLabel = RB.getStringResource("action.backlink.txt", this.getLocale());
            }
            if (this._backLinkDescription == null) {
                this._backLinkDescription = this._backLinkLabel;
            }
            StringBuffer buf = new StringBuffer(100);
            buf.append("<a href=\"").append(this._backLinkURL).append("\" ");
            buf.append("title=\"").append(this._backLinkDescription).append("\" ").append(" target=\"_top\">");
            buf.append("<img src=\"");
            buf.append(cpm.getImageURI("Banner_backArrow"));
            buf.append("\" border=\"0\" alt=\"\" />");
            buf.append(" ").append(this._backLinkLabel).append("</a>");
            dictionary.put("BREADCRUMB1", buf.toString());
        } else if (null != this.breadCrumb1) {
            dictionary.put("BREADCRUMB1", this.breadCrumb1);
            this.getLogger().debug("Setting back link from breadCrumb1");
        }
        if (null != this.breadCrumb2) {
            dictionary.put("BREADCRUMB2", this.breadCrumb2);
            this.getLogger().debug("Setting breadCrumb2 into dictionary.");
        }
        if (this._userRole != null && this._userRole.trim().length() > 0) {
            String msg = MessageFormat.format(RB.getStringResource("banner.role.marker.fmt", this.getLocale()), this._userRole);
            dictionary.put("BANNER_USER_ROLE", msg);
        }
        dictionary.put("BACKGROUND", "style=\"background-image:url(" + cpm.getImageURI(this._backgroundImageKey) + "); \" ");
    }

    void setupSimpleGlobalMenu(Map dictionary) throws IOException {
        MenuBarItem helpMenu;
        StringWriter buf = new StringWriter(512);
        ArrayList<MenuBarItem> menuItems = new ArrayList<MenuBarItem>();
        if (this._logOnURL != null || this._logOffURL != null) {
            String logOnOffUrl = "";
            String logOnOffText = "";
            if (this._logOffURL != null) {
                logOnOffUrl = this._logOffURL;
                logOnOffText = MessageFormat.format(RB.getStringResource("menu.logout.fmt", this.getLocale()), this.getUserName());
            } else {
                logOnOffUrl = this._logOnURL;
                logOnOffText = RB.getStringResource("menu.logon.txt", this.getLocale());
            }
            MenuBarItem logOnOffMenu = new MenuBarItem();
            logOnOffMenu.setText(logOnOffText);
            logOnOffMenu.setUrl(logOnOffUrl);
            logOnOffMenu.setTitle(logOnOffText);
            menuItems.add(logOnOffMenu);
        }
        if (this._preferencesURL != null) {
            MenuBarItem separator = new MenuBarItem();
            separator.setSeparator(true);
            menuItems.add(separator);
            String preferencesText = RB.getStringResource("menu.preferences.txt", this.getLocale());
            MenuBarItem preferencesMenu = new MenuBarItem();
            preferencesMenu.setText(preferencesText);
            preferencesMenu.setTitle(RB.getStringResource("menu.preferences.desc.txt", this.getLocale()));
            preferencesMenu.setUrl(this._preferencesURL);
            menuItems.add(preferencesMenu);
        }
        if ((helpMenu = this.createHelpMenu()).getText() != null) {
            MenuBarItem separator = new MenuBarItem();
            separator.setSeparator(true);
            menuItems.add(separator);
            menuItems.add(helpMenu);
        }
        if (menuItems.size() > 0) {
            SimpleMenuBar menubar = new SimpleMenuBar("globalMenuBar");
            menubar.setModel(menuItems);
            menubar.setRequest(this.getRequest());
            menubar.setLook("Banner_GlobalMenu_Look");
            menubar.write(buf);
            dictionary.put("GLOBAL_MENU", buf.toString());
            String jsIncludeText = "<script type=\"text/javascript\" src=\"" + this.getRequest().getContextPath() + "/scripts/SASDoc_window.js\"></script>";
            dictionary.put("JAVASCRIPT_FILE", jsIncludeText);
        }
    }

    String getUserName() {
        String localUser = "";
        if (null == this._userName || this._userName.equals("")) {
            try {
                HttpSession session = this.getRequest().getSession(true);
                UserContextInterface uci = (UserContextInterface)session.getAttribute("sasUserContext_s");
                if (null != uci && null != uci.getPerson()) {
                    localUser = uci.getPerson().getEffectiveDisplayName();
                }
            }
            catch (RemoteException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (ServiceException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        } else {
            localUser = this._userName;
        }
        this.getLogger().debug("getUserName() is ", localUser);
        return localUser;
    }

    MenuBarItem createHelpMenu() {
        ArrayList<PopupMenuItem> helpMenuItems = new ArrayList<PopupMenuItem>();
        MenuBarItem helpMenu = new MenuBarItem();
        String helpContentsText = RB.getStringResource("menu.help.contents.txt", this.getLocale());
        helpMenu.setSubMenu(helpMenuItems);
        if (this.getHelpMenuItemId() != null) {
            helpMenu.setId(this.getHelpMenuItemId());
        } else {
            PopupMenuItem helpContents = new PopupMenuItem();
            helpContents.setText(helpContentsText);
            String helpPath = this.getHelpDocURL();
            if (helpPath.length() > 0) {
                helpContents.setJavascript("openSASDocWindow( '" + helpPath + "');");
                helpMenuItems.add(helpContents);
            }
            if (null != this._addedItems) {
                helpMenuItems.addAll(this._addedItems);
            }
            if (this._helpAboutURL != null) {
                this.getLogger().debug("Help, About URL is:", this._helpAboutURL);
                String helpAboutText = this._aboutTitle == null ? RB.getStringResource("menu.help.about.txt", this.getLocale()) : Message.format((String)RB.getStringResource("menu.help.about.fmt", this.getLocale()), (Object)this._aboutTitle);
                PopupMenuItem helpAbout = new PopupMenuItem();
                helpAbout.setText(helpAboutText);
                helpAbout.setJavascript("window.open('" + this._helpAboutURL + "', 'SAS', config='height=500,width=600'); ");
                helpMenuItems.add(helpAbout);
            }
        }
        if (!helpMenuItems.isEmpty() || this.getHelpMenuItemId() != null) {
            String helpText = RB.getStringResource("menu.help.txt", this.getLocale());
            helpMenu.setText(helpText);
            helpMenu.setTitle(RB.getStringResource("menu.help.desc.txt", this.getLocale()));
        }
        return helpMenu;
    }

    void setupProductTitle(Map dictionary) {
        String localTitle = this._title;
        String local2ndTitle = this._secondaryTitle;
        if (localTitle == null) {
            localTitle = (String)this.getRequest().getAttribute("com.sas.web.title");
        }
        if (localTitle == null || "$NAME_IN_BANNER$".equalsIgnoreCase(localTitle)) {
            localTitle = "";
            this.getLogger().warn("Banner title was not set or not substituted correctly.");
        }
        if (localTitle.indexOf("\u00ae") > 0) {
            localTitle = localTitle.replaceAll("\u00ae", "<sup style=\"font-size: smaller;\">&reg;</sup>");
        }
        this.getLogger().debug("setUpProductTitle(), title is: ", localTitle);
        dictionary.put("BANNER_TITLE", localTitle);
        if (local2ndTitle == null) {
            local2ndTitle = (String)this.getRequest().getAttribute("sas.framework.AppTitle");
        }
        if (local2ndTitle == null) {
            local2ndTitle = "";
        }
        dictionary.put("BANNER_TITLE2", local2ndTitle);
        if (localTitle != null && localTitle.trim().length() > 0 && local2ndTitle.trim().length() > 0) {
            dictionary.put("BULLET", "&#149;");
        } else {
            dictionary.remove("BULLET");
        }
        this.getLogger().debug("setUpProductTitle(), 2nd title is: ", local2ndTitle);
    }

    void setupLogo(Map dictionary, ComponentPropertyManager cpm) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("<img src=\"").append(cpm.getImageURI("logo")).append("\" ");
        if (ComponentPropertyManager.getTheme(this.getRequest()) != null) {
            Image logo = ComponentPropertyManager.getTheme(this.getRequest()).getImage("logo");
            if (null != logo) {
                buf.append("width=\"").append(logo.getWidth()).append("\" height=\"").append(logo.getHeight()).append("\"");
            } else {
                this.logger.debug("setupLogo(): no logo image obtained from the theme so no attributes available.");
            }
        }
        buf.append("\" border=\"0\" alt=\"\" />");
        dictionary.put("LOGO", buf.toString());
    }

    private String getHelpDocURL() {
        String helpPath = "";
        if (this._helpDocURL != null) {
            helpPath = this._helpDocURL;
        }
        this.getLogger().debug("The help doc URL is:", helpPath);
        return helpPath;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        ValidateArg.notNull((Object)this.getRequest(), (String)"getRequest()");
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        this.createDictionary(cpm);
        TemplateSupport.writeTemplate(this, null, out);
        if (this.isShowDivider() && !this.calledFromABodyTag) {
            this.writeContentDivider(out);
        }
    }

    public void writeContentDivider(PrintWriter out) {
        ValidateArg.notNull((Object)this.getRequest(), (String)"getRequest()");
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        String theTemplateString = TemplateSupport.getTemplateViaURI(cpm.getTemplateURI("contentDivider"), cpm);
        if (null == theTemplateString) {
            this.getLogger().warn("Could not obtain the content divider template.");
        } else {
            SimpleTemplateToPrintWriter.write((String)theTemplateString, new HashMap(), (PrintWriter)out);
        }
    }

    public void setBackLinkDescription(String linkDescription) {
        this._backLinkDescription = linkDescription;
    }

    public void setAdditionalHelpItems(List addedItems) {
        this._addedItems = addedItems;
    }

    public LoggerFactoryInterface getLoggerFactory() {
        return this.factory;
    }

    public void setLoggerFactory(LoggerFactoryInterface factory) {
        this.factory = factory;
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            this.logger = null != this.getLoggerFactory() ? LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()) : LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new Log4JFactory2());
        }
        return this.logger;
    }

    public final boolean isShowDivider() {
        return this.showDivider;
    }

    public final void setShowDivider(boolean showDivider) {
        this.showDivider = showDivider;
    }

    public void setBreadCrumb1(String breadCrumb1) {
        this.breadCrumb1 = breadCrumb1;
    }

    public void setBreadCrumb2(String breadCrumb2) {
        this.breadCrumb2 = breadCrumb2;
    }

    public void setShowAsMiniBanner(boolean showAsMiniBanner) {
        this.showAsMiniBanner = showAsMiniBanner;
    }

    public boolean isShowAsMiniBanner() {
        return this.showAsMiniBanner;
    }

    void setupSkipNavigation(Map dictionary, ComponentPropertyManager cpm) {
        if (null != this.mainContentAreaURL && ComponentPropertyManager.getTheme(this.getRequest()) != null) {
            Image skip = ComponentPropertyManager.getTheme(this.getRequest()).getImage("one_x_one");
            if (null != skip) {
                StringBuffer buf = new StringBuffer(200);
                buf.append("<a href=\" ").append(this.mainContentAreaURL).append("\" > ");
                buf.append("<img class=\"skipnav\" src=\"").append(skip.getFile()).append("\" ");
                buf.append("\" border=\"0\" alt=\"");
                buf.append(RB.getStringResource("Banner.alt.skip.txt", this.getLocale()));
                buf.append("\" /> </a>");
                dictionary.put("SKIP_NAVIGATION", buf.toString());
                this.getLogger().debug("setupSkipNavigation for ", this.mainContentAreaURL);
            } else {
                this.getLogger().info("setupSkipNavigation(): no 1x1 image obtained from the theme, so nothing written out.");
            }
        }
    }

    public void setMainContentAreaURL(String mainContentAreaURL) {
        this.mainContentAreaURL = mainContentAreaURL;
    }

    public void setLogOffTarget(String logOffTarget) {
        this.logOffTarget = logOffTarget;
    }

    public void setCalledFromABodyTag(boolean calledFromABodyTag) {
        this.calledFromABodyTag = calledFromABodyTag;
    }
}

