/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html.features;

import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.VariableList;
import com.sas.servlet.tbeans.features.DnDFeature;
import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.features.dnd.ZoneElement;
import com.sas.servlet.tbeans.features.dnd.ZoneInfo;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.olaptableview.html.features.BeanWrapper;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.olap.OLAPException;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class GraphDnDFeature
extends DnDFeature
implements Feature {
    public static final String SUBGROUPS_ZONE = "Subgroups";
    public static final String RESPONSES_ZONE = "Responses";
    public static final String RESPONSES2_ZONE = "Responses2";
    public static final String CATEGORIES_ZONE = "Categories";
    public static final String ROWS_ZONE = "Rows";
    public static final String COLUMNS_ZONE = "Columns";
    public static final String HIDDEN_ZONE = "Hidden";
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    static final int REPLACE = 2;
    protected static final int SUBGROUP = 1;
    protected static final int CATEGORY = 2;
    protected static final int RESPONSE = 3;
    protected static final int RESPONSE2 = 4;
    protected static final int COLUMN = 5;
    protected static final int ROW = 6;
    private Object imageMapInfo;
    private BaseGraph baseGraph;
    private BeanWrapper wrapper;
    private String[][] hidden = new String[][]{{"REMOVE", "Remove", "Delete_Item"}, {"ADD", "Add", "Add_Black"}};

    public GraphDnDFeature(BaseGraph baseGraph, Object imageMapInfo) {
        this.baseGraph = baseGraph;
        this.imageMapInfo = imageMapInfo;
        this.createZones();
        this.initializeTypes(baseGraph.getId());
        this.setInsertMode(0);
    }

    public GraphDnDFeature(BaseGraph baseGraph) {
        this(baseGraph, null);
        this.wrapper = BeanWrapper.create(baseGraph);
    }

    public BaseGraph getBaseGraph() {
        return this.baseGraph;
    }

    public void setBaseGraph(BaseGraph baseGraph) {
        this.baseGraph = baseGraph;
    }

    public Object getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(Object imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    private void createZones() {
        String[] zones = new String[]{COLUMNS_ZONE, ROWS_ZONE, CATEGORIES_ZONE, RESPONSES_ZONE, RESPONSES2_ZONE, SUBGROUPS_ZONE, HIDDEN_ZONE};
        this.setDragZones(this.createZoneList(zones, true));
        this.setDropZones(this.createZoneList(zones, false));
        this.setZoneInfos(this.createZoneInfoList(zones));
    }

    public void initializeTypes(String base) {
        String di = base + "_dataitem";
        String m = base + "_measure";
        String[] diZones = new String[]{COLUMNS_ZONE, ROWS_ZONE, CATEGORIES_ZONE, SUBGROUPS_ZONE};
        String[] mZones = new String[]{RESPONSES_ZONE, RESPONSES2_ZONE};
        String[] dis = new String[]{"_dataitem", di};
        String[] ms = new String[]{"_measure", m};
        this.setTypes(diZones, di, dis);
        this.setTypes(mZones, m, ms);
    }

    public void _setHidden(String[][] hidden) {
        this.hidden = hidden;
    }

    @Override
    public void write(HttpServletRequest request, Writer out) throws IOException {
        Object info = null;
        info = this.imageMapInfo != null ? this.imageMapInfo : this.wrapper.getImageMapInfo();
        if (info == null) {
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "AJAX", request);
        this.setCPM(ComponentPropertyManager.getInstance(request));
        this.fillZones(info);
        super.write(request, out, this.baseGraph.getId());
        this.setCPM(null);
    }

    private void fillZones(Object imageMapInfo) {
        ImageMapInfo info = new ImageMapInfo(imageMapInfo);
        if (info.isEmpty()) {
            return;
        }
        this.fillHiddenZone();
        LabelZoneList zoneList = info.getColumnLabelZoneList();
        this.fillLabelZone(this.getZoneInfo(COLUMNS_ZONE), zoneList, 5, 1);
        zoneList = info.getRowLabelZoneList();
        this.fillLabelZone(this.getZoneInfo(ROWS_ZONE), zoneList, 6, 0);
        zoneList = info.getSubgroupLabelZoneList();
        if (zoneList != null) {
            this.fillLabelZone(this.getZoneInfo(SUBGROUPS_ZONE), zoneList, 1, 2);
        } else {
            DataZone[] dataZones = info.getSubgroupValueZones();
            this.fillDataZone(this.getZoneInfo(SUBGROUPS_ZONE), dataZones, 1);
        }
        zoneList = info.getResponseLabelZoneList();
        this.fillLabelZone(this.getZoneInfo(RESPONSES_ZONE), zoneList, 3, 0);
        zoneList = info.getResponse2LabelZoneList();
        this.fillLabelZone(this.getZoneInfo(RESPONSES2_ZONE), zoneList, 3, 0);
        zoneList = info.getCategoryLabelZoneList();
        this.fillLabelZone(this.getZoneInfo(CATEGORIES_ZONE), zoneList, 2, 2);
    }

    private void fillHiddenZone() {
        ZoneInfo zoneInfo = this.getZoneInfo(HIDDEN_ZONE);
        for (int i = 0; i < this.hidden.length; ++i) {
            String[] hiddeni = this.hidden[i];
            this.addHidden(zoneInfo, hiddeni[0], hiddeni[1], hiddeni[2]);
        }
    }

    protected ZoneElement addHidden(ZoneInfo zone, String id, String label, String image) {
        return this.addHidden(zone, this.baseGraph.getId(), id, label, image);
    }

    private void fillLabelZone(ZoneInfo zone, LabelZoneList zoneList, int area, int layout) {
        zone.clear();
        if (zoneList == null) {
            return;
        }
        if (zoneList.getNext() == null && area != 6) {
            layout = 2;
        }
        List labelZones = this.convertToList(zoneList);
        for (int i = 0; i < labelZones.size(); ++i) {
            ZoneElement ze = this.buildLabelZoneElement(zone, labelZones, i, area, layout);
            this.addToLabelZone(ze, labelZones, i, area, layout);
        }
    }

    protected void addToLabelZone(ZoneElement ze, List labelZones, int i, int area, int layout) {
    }

    private ZoneElement buildLabelZoneElement(ZoneInfo zone, List labelZones, int i, int area, int layout) {
        LabelZoneList labelZone = (LabelZoneList)labelZones.get(i);
        ZoneElement ze = this.addLabelZoneElement(zone, labelZone, area, layout);
        if (area != 5 && area != 6) {
            return ze;
        }
        int left = this.findFirstHeader(labelZones, labelZone);
        int right = this.findLastHeader(labelZones, labelZone);
        if ((left != i || right != i) && left != -1 && right != -1) {
            labelZone = (LabelZoneList)labelZones.get(left);
            ze.addProperty("extendNodeLeft", this.convertToCoords(labelZone.getShape().getBounds()));
            labelZone = (LabelZoneList)labelZones.get(right);
            ze.addProperty("extendNodeRight", this.convertToCoords(labelZone.getShape().getBounds()));
        }
        return ze;
    }

    private List convertToList(LabelZoneList zoneList) {
        ArrayList<LabelZoneList> headers = new ArrayList<LabelZoneList>();
        while (zoneList != null) {
            headers.add(zoneList);
            zoneList = zoneList.getNext();
        }
        return headers;
    }

    private int findFirstHeader(List labelZones, LabelZoneList labelZone) {
        String header = this.getHierarchyName(labelZone.getName());
        for (int i = 0; i < labelZones.size(); ++i) {
            LabelZoneList newLabelZone = (LabelZoneList)labelZones.get(i);
            String newHeader = this.getHierarchyName(newLabelZone.getName());
            if (!newHeader.equals(header)) continue;
            return i;
        }
        return -1;
    }

    private String getHierarchyName(String name) {
        int i = name.lastIndexOf(91);
        if (i < 0) {
            return name;
        }
        return name.substring(0, i);
    }

    private int findLastHeader(List labelZones, LabelZoneList labelZone) {
        String header = this.getHierarchyName(labelZone.getName());
        for (int i = labelZones.size() - 1; i >= 0; --i) {
            LabelZoneList newLabelZone = (LabelZoneList)labelZones.get(i);
            String newHeader = this.getHierarchyName(newLabelZone.getName());
            if (!newHeader.equals(header)) continue;
            return i;
        }
        return -1;
    }

    private ZoneElement addLabelZoneElement(ZoneInfo zone, LabelZoneList zoneList, int area, int layout) {
        Rectangle rect = zoneList.getShape().getBounds();
        String coords = this.convertToCoords(rect);
        String areaName = this.convertAreaToString(area);
        String name = zoneList.getName();
        String orientation = "REPLACE";
        if (layout != 2) {
            orientation = this.calculateOrientation(layout == 0);
        }
        name = name.startsWith("[Measures]") ? "$" + name.substring("[Measures].[".length(), name.length() - 1) : (name.startsWith("[") ? name.substring(1, name.indexOf(93, 1)) : "$" + name);
        return this.createZoneElement(zone, coords, zoneList.getLabel(), areaName, name, orientation);
    }

    private ZoneElement createZoneElement(ZoneInfo zone, String coords, String label, String areaName, String name, String orientation) {
        ZoneElement element = new ZoneElement(coords, name, orientation);
        zone.addElement(element);
        element.addProperty("label", label).addProperty("area", areaName).addProperty("axis", "ROW".equals(areaName) ? "1" : "0");
        return element;
    }

    private void fillDataZone(ZoneInfo zone, DataZone[] dataZones, int area) {
        zone.clear();
        if (dataZones == null) {
            return;
        }
        for (int i = 0; i < dataZones.length; ++i) {
            if (!(dataZones[i] instanceof ChartValueZone)) continue;
            ZoneElement ze = this.addDataZoneElement(zone, (ChartValueZone)dataZones[i], area);
            this.addToDataZone(ze, dataZones, i, area);
        }
    }

    protected void addToDataZone(ZoneElement ze, DataZone[] dataZones, int i, int area) {
    }

    private ZoneElement addDataZoneElement(ZoneInfo zone, ChartValueZone dataZone, int area) {
        Rectangle rect = dataZone.getShape().getBounds();
        String coords = this.convertToCoords(rect);
        String areaName = this.convertAreaToString(area);
        ValueList subgroupValue = dataZone.getSubgroupValue();
        String name = "";
        String label = "";
        if (subgroupValue != null) {
            label = subgroupValue.getFormattedValue();
            name = "$" + label;
        } else {
            try {
                name = label = dataZone.getTupleElement().getLabel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String orientation = "HORIZONTAL";
        if (this.getInsertMode() == 2) {
            orientation = "REPLACE";
        }
        return this.createZoneElement(zone, coords, label, areaName, name, orientation);
    }

    private String convertToCoords(Rectangle rect) {
        return (int)rect.getX() + "," + (int)rect.getY() + "," + (int)(rect.getX() + rect.getWidth()) + "," + (int)(rect.getY() + rect.getHeight());
    }

    private String convertAreaToString(int area) {
        String type = "NONE";
        switch (area) {
            case 5: {
                type = "COLUMN";
                break;
            }
            case 6: {
                type = "ROW";
                break;
            }
            case 1: {
                type = "SUBGROUP";
                break;
            }
            case 2: {
                type = "CATEGORY";
                break;
            }
            case 3: {
                type = "RESPONSE";
                break;
            }
        }
        return type;
    }

    private static class ImageMapInfo {
        private ChartImageMapInfo bcimi = null;
        private PlotImageMapInfo pimi = null;

        ImageMapInfo(Object imageMapInfo) {
            if (imageMapInfo instanceof ChartImageMapInfo) {
                this.bcimi = (ChartImageMapInfo)imageMapInfo;
            } else if (imageMapInfo instanceof PlotImageMapInfo) {
                this.pimi = (PlotImageMapInfo)imageMapInfo;
            }
        }

        public boolean isEmpty() {
            return this.bcimi == null && this.pimi == null;
        }

        public LabelZoneList getColumnLabelZoneList() {
            if (this.bcimi != null) {
                return this.bcimi.getColumnLabelZoneList();
            }
            if (this.pimi != null) {
                return this.pimi.getColumnLabelZoneList();
            }
            return null;
        }

        public LabelZoneList getRowLabelZoneList() {
            if (this.bcimi != null) {
                return this.bcimi.getRowLabelZoneList();
            }
            if (this.pimi != null) {
                return this.pimi.getRowLabelZoneList();
            }
            return null;
        }

        public VariableList getResponseVariableList() {
            if (this.bcimi != null) {
                return this.bcimi.getResponseVariableList();
            }
            if (this.pimi != null) {
                return this.pimi.getYVariableList();
            }
            return null;
        }

        public LabelZoneList getResponseLabelZoneList() {
            if (this.bcimi != null) {
                return this.bcimi.getResponseLabelZoneList();
            }
            if (this.pimi != null) {
                return this.pimi.getYLabelZoneList();
            }
            return null;
        }

        public LabelZoneList getResponse2LabelZoneList() {
            if (this.bcimi != null) {
                return this.bcimi.getResponse2LabelZoneList();
            }
            if (this.pimi != null) {
                return this.pimi.getY2LabelZoneList();
            }
            return null;
        }

        public LabelZoneList getSubgroupLabelZoneList() {
            if (this.bcimi != null) {
                return this.bcimi.getSubgroupLabelZoneList();
            }
            if (this.pimi != null) {
                return this.pimi.getGroupLabelZoneList();
            }
            return null;
        }

        public DataZone[] getSubgroupValueZones() {
            if (this.bcimi != null) {
                return this.bcimi.getSubgroupValueZones();
            }
            if (this.pimi != null) {
                return this.pimi.getGroupValueZones();
            }
            return null;
        }

        public LabelZoneList getCategoryLabelZoneList() {
            if (this.bcimi != null) {
                return this.bcimi.getCategoryLabelZoneList();
            }
            if (this.pimi != null) {
                return this.pimi.getXLabelZoneList();
            }
            return null;
        }

        public String toString() {
            return "columns: " + ImageMapInfo.toString(this.getColumnLabelZoneList()) + "\nrows: " + ImageMapInfo.toString(this.getRowLabelZoneList()) + "\nresponse: " + ImageMapInfo.toString(this.getResponseLabelZoneList()) + "\nresponse2: " + ImageMapInfo.toString(this.getResponse2LabelZoneList()) + "\ncategory: " + ImageMapInfo.toString(this.getCategoryLabelZoneList()) + "\nsubgroup: " + (this.getSubgroupLabelZoneList() != null ? ImageMapInfo.toString(this.getSubgroupLabelZoneList()) : ImageMapInfo.toString(this.getSubgroupValueZones()));
        }

        public static String toString(LabelZoneList labels) {
            StringBuffer buf = new StringBuffer();
            while (labels != null) {
                buf.append(labels.getLabel()).append(" ");
                labels = labels.getNext();
            }
            return buf.toString();
        }

        public static String toString(ChartValueZone[] zones) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < zones.length; ++i) {
                ChartValueZone zone = zones[i];
                ValueList subgroupValue = zone.getSubgroupValue();
                if (subgroupValue != null) {
                    buf.append(subgroupValue.getFormattedValue());
                } else {
                    try {
                        buf.append(zone.getTupleElement().getLabel());
                    }
                    catch (OLAPException e) {
                        buf.append(zone.toString());
                        e.printStackTrace();
                    }
                }
                buf.append(" ");
            }
            return buf.toString();
        }

        public static String toString(DataZone[] dataZones) {
            if (dataZones == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < dataZones.length; ++i) {
                if (!(dataZones[i] instanceof ChartValueZone)) continue;
                ChartValueZone cvz = (ChartValueZone)dataZones[i];
                if (cvz.getResponseValue() != null) {
                    buf.append(cvz.getResponseValue().getFormattedValue());
                    continue;
                }
                try {
                    buf.append(cvz.getTupleElement().getLabel());
                    continue;
                }
                catch (Exception e) {
                    buf.append(cvz.getTupleElement());
                }
            }
            return buf.toString();
        }
    }
}

