/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.AnalysisVariableList;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariableList;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.PlotVariableList;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.VariableList;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.graphics.html.BaseGraphSupport;
import com.sas.servlet.tbeans.graphics.html.HtmlGraphUtil;
import com.sas.servlet.tbeans.graphics.html.ScatterPlot;
import com.sas.servlet.tbeans.graphics.html.TileChart;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.swing.util.ActionUtils;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;

public class GraphSupport
extends BaseGraphSupport {
    private BaseGraph baseGraph;
    boolean allActionsVisible = true;
    ActionSupportFilter analysisLabelFilter;
    ActionSupportFilter categorizationLabelFilter;
    ActionSupportFilter datavalueFilter;
    protected String[] columnLevelLabels;
    private TableModel tableModel;
    private ChartImageMapInfo bcimi;
    private PlotImageMapInfo pimi;
    private List popupMenuList = new ArrayList();
    private List columnInfo = new ArrayList();
    private List classificationPopupMenuList = new ArrayList();
    private CommonLoggerInterface log = null;

    public GraphSupport(BaseGraph baseGraph) {
        super(baseGraph);
        this.baseGraph = baseGraph;
        this.log = LoggerRepository2.getLogger((String)GraphSupport.class.getPackage().getName(), null);
        baseGraph.setActionSupportType("GRAPH_SUPPORT");
        this.analysisLabelFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "ANALYSIS_LABEL_AREA", (ActionProviderViewInterface)baseGraph, false);
        this.categorizationLabelFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "CATEGORIZATION_LABEL_AREA", (ActionProviderViewInterface)baseGraph, false);
        this.datavalueFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "DATA_VALUE_AREA", (ActionProviderViewInterface)baseGraph);
    }

    public void setModel(TableModel model) {
        this.tableModel = model;
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    private void writeActions(PrintWriter out) {
        HttpActionProvider actionProvider = this.baseGraph.getActionProvider();
        this.classificationPopupMenuList.clear();
        this.popupMenuList.clear();
        try {
            this.categorizationLabelFilter.setAttribute("model", (Object)this.getModel());
            this.analysisLabelFilter.setAttribute("model", (Object)this.getModel());
        }
        catch (AttributeSetException ase) {
            this.log.error(ase.getMessage(), (Throwable)ase);
        }
        if (this.getCategoryLabelZoneList() != null && !(this.baseGraph instanceof ScatterPlot)) {
            this.writeLabelZoneActions(out, this.getCategoryLabelZoneList(), this.categorizationLabelFilter);
        }
        if (this.getSubgroupLabelZoneList() != null) {
            this.writeLabelZoneActions(out, this.getSubgroupLabelZoneList(), this.categorizationLabelFilter);
        }
        if (this.getColumnLabelZoneList() != null) {
            this.writeLabelZoneActions(out, this.getColumnLabelZoneList(), this.categorizationLabelFilter);
        }
        if (this.getRowLabelZoneList() != null) {
            this.writeLabelZoneActions(out, this.getRowLabelZoneList(), this.categorizationLabelFilter);
        }
        if (this.getCategoryLabelZoneList() != null && this.baseGraph instanceof ScatterPlot) {
            this.writeVariableListActions(out, this.getXVariableList(), this.analysisLabelFilter, this.classificationPopupMenuList);
        }
        if (this.getResponseVariableList() != null) {
            this.writeVariableListActions(out, this.getResponseVariableList(), this.analysisLabelFilter, this.classificationPopupMenuList);
        }
        if (this.getResponse2VariableList() != null) {
            this.writeVariableListActions(out, this.getResponse2VariableList(), this.analysisLabelFilter, this.classificationPopupMenuList);
        }
    }

    private void writeLabelZoneActions(PrintWriter out, LabelZoneList labelZoneList, ActionSupportFilter filter) {
        while (labelZoneList != null) {
            String label = this.baseGraph instanceof TileChart ? labelZoneList.getName() : labelZoneList.getLabel();
            this.writeLabelActions(out, label, labelZoneList.getShape(), filter, null);
            labelZoneList = labelZoneList.getNext();
        }
    }

    private void writeVariableListActions(PrintWriter out, VariableList variableList, ActionSupportFilter filter, List pmenus) {
        while (variableList != null) {
            this.writeLabelActions(out, variableList.getLabel(), null, filter, pmenus);
            variableList = variableList.getNext();
        }
    }

    private void writeLabelActions(PrintWriter out, String label, Shape shape, ActionSupportFilter filter, List pmenus) {
        ActionList aList = this.getActions(label, filter);
        if (aList == null || pmenus == null && shape == null) {
            return;
        }
        PopupMenu popupMenu = null;
        if (pmenus == null) {
            popupMenu = new PopupMenu();
            popupMenu.setModel(new ArrayList());
            popupMenu.setRequest(this.baseGraph.getRequest());
            popupMenu.setResponse(this.baseGraph.getResponse());
        }
        String altText = (String)aList.getValue("ShortDescription");
        Iterator iter = ActionUtils.iterator((com.sas.swing.util.ActionList)aList);
        boolean addSeparator = true;
        while (iter.hasNext()) {
            PopupMenuItem menuItem;
            Object o = iter.next();
            if (o instanceof HttpAction) {
                HttpAction action = (HttpAction)((Object)o);
                menuItem = new PopupMenuItem();
                menuItem.setText((String)action.getValue("ShortDescription"));
                menuItem.setDisabled(!action.isEnabled());
                menuItem.setAlternateText((String)action.getValue("AlternateText"));
                menuItem.setUrl((String)action.getValue("URL"));
                menuItem.setImage((String)action.getValue("SmallIconName"));
                menuItem.setDisabledImage((String)action.getValue("SmallDisabledIconName"));
                String url = (String)action.getValue("URL");
                if (url != null && url.startsWith("javascript:")) {
                    menuItem.setJavascript(url.replaceFirst("javascript:", ""));
                } else {
                    menuItem.setUrl(url);
                }
                if (pmenus != null) {
                    popupMenu = null;
                    for (int i = 0; i < pmenus.size(); ++i) {
                        popupMenu = (PopupMenu)pmenus.get(i);
                        if (addSeparator) {
                            PopupMenuItem separator = new PopupMenuItem();
                            separator.setSeparator(true);
                            popupMenu.getModel().add(separator);
                        }
                        popupMenu.getModel().add(menuItem);
                    }
                    addSeparator = false;
                    continue;
                }
                popupMenu.getModel().add(menuItem);
                continue;
            }
            if (o != ActionList.SEPARATOR) continue;
            menuItem = new PopupMenuItem();
            menuItem.setSeparator(true);
            popupMenu.getModel().add(menuItem);
        }
        if (popupMenu != null && popupMenu.getModel() != null && !popupMenu.getModel().isEmpty() && pmenus == null) {
            this.popupMenuList.add(popupMenu);
            this.classificationPopupMenuList.add(popupMenu);
            this.writePopup(out, popupMenu, altText, null, shape.getBounds());
        }
    }

    public void writeClientMap(PrintWriter out, Object imageMapInfo) throws IOException {
        this.bcimi = null;
        this.pimi = null;
        if (imageMapInfo instanceof ChartImageMapInfo) {
            this.bcimi = (ChartImageMapInfo)imageMapInfo;
        } else if (imageMapInfo instanceof PlotImageMapInfo) {
            this.pimi = (PlotImageMapInfo)imageMapInfo;
        }
        out.println("<script type=\"text/javascript\">\nvar " + this.baseGraph.getId() + "_selectedArea = null;\n" + this.baseGraph.getId() + "_activate = function(element,hasFocus) {\n  " + this.baseGraph.getId() + "_selectedArea = hasFocus ? element : null;\n}\n" + this.baseGraph.getId() + "_menu = function(event) {\n  var newEventObject = document.createEventObject();\n  if (" + this.baseGraph.getId() + "_selectedArea && ((event.keyCode == 121 && event.shiftKey) || event.keyCode == 93)) {\n    event.returnValue = false;\n    newEventObject.keyCode = 221;\n    " + this.baseGraph.getId() + "_selectedArea.fireEvent('onkeyup', newEventObject);\n    return false;\n  }\n  return true;\n}\n</script>");
        out.println("<map id=\"" + this.baseGraph.getId() + "_map\" name=\"" + this.baseGraph.getId() + "\">");
        if (imageMapInfo != null) {
            boolean writeActions;
            boolean bl = writeActions = this.baseGraph.isAllActionsVisible() && this.baseGraph.getActionProvider() != null && this.getModel() != null;
            if (writeActions) {
                this.writeActions(out);
                try {
                    this.datavalueFilter.setAttribute("model", (Object)this.getModel());
                }
                catch (AttributeSetException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            HtmlGraphUtil.writeTooltip(out, this.baseGraph, imageMapInfo, this.baseGraph.isToolTipEnabled(), writeActions ? this.datavalueFilter : null, this.popupMenuList);
            out.println("</map>");
            if (writeActions) {
                for (int i = 0; i < this.popupMenuList.size(); ++i) {
                    ((PopupMenu)this.popupMenuList.get(i)).write(out);
                }
                this.popupMenuList.clear();
                this.classificationPopupMenuList.clear();
            }
        } else {
            out.println("</map>");
        }
        this.baseGraph.writeFeatures(out);
    }

    private void writePopup(PrintWriter out, PopupMenu popupMenu, String altText, String href, Rectangle rect) {
        String areaId = this.baseGraph.getId() + "_area" + Util.getNumber();
        out.print("<area id=\"" + areaId + "\" onfocus=\"" + this.baseGraph.getId() + "_activate(this,true)\" onblur=\"" + this.baseGraph.getId() + "_activate(this,false)\" shape=\"rect\" ");
        if (altText != null) {
            out.print(" alt=\"");
            out.print(altText + "\" ");
            out.print("title=\"");
            out.print(altText + "\" ");
        }
        if (href != null) {
            out.print("href=\"" + href + "\"");
        } else {
            out.print("href=\"javascript: void 0;\" ");
        }
        if (popupMenu != null) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.baseGraph.getRequest());
            String launchEvent = cpm.getContextMenuLaunchEvent();
            if (launchEvent.equalsIgnoreCase("oncontextmenu")) {
                launchEvent = "onrightclick";
            }
            popupMenu.attachTo(areaId, null, launchEvent);
        }
        out.print(" coords=\"");
        out.print((int)rect.getX() + "," + (int)rect.getY() + "," + (int)(rect.getX() + rect.getWidth()) + "," + (int)(rect.getY() + rect.getHeight()));
        out.println("\">");
    }

    private ActionList getActions(String label, ActionSupportFilter filter) {
        ActionList actions = null;
        try {
            if (this.baseGraph.getActionProvider() != null) {
                filter.setAttribute("model", (Object)this.getModel());
                filter.setAttribute("column", (Object)new Integer(this.getColumnIndex(label)));
                filter.setAttribute("modelColumn", (Object)new Integer(this.getColumnIndex(label)));
                filter.setAttribute("areaValue", (Object)label);
                filter.setViewerId(this.baseGraph.getId());
                actions = this.baseGraph.getActionProvider().getActions(filter);
            }
        }
        catch (AttributeSetException ase) {
            this.log.error(ase.getMessage(), (Throwable)ase);
        }
        return actions;
    }

    private LabelZoneList getSubgroupLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getSubgroupLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getGroupLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getCategoryLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getCategoryLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getXLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getResponseLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponseLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getYLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getResponse2LabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponse2LabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getY2LabelZoneList();
        }
        return null;
    }

    private VariableList getXVariableList() {
        if (this.bcimi != null) {
            return null;
        }
        if (this.pimi != null) {
            return this.pimi.getXVariableList();
        }
        return null;
    }

    private VariableList getResponseVariableList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponseVariableList();
        }
        if (this.pimi != null) {
            return this.pimi.getYVariableList();
        }
        return null;
    }

    private VariableList getResponse2VariableList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponse2VariableList();
        }
        if (this.pimi != null) {
            return this.pimi.getY2VariableList();
        }
        return null;
    }

    private LabelZoneList getColumnLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getColumnLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getColumnLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getRowLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getRowLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getRowLabelZoneList();
        }
        return null;
    }

    private int getColumnIndex(String label) {
        int index = -1;
        block0: for (int i = 0; i < this.columnInfo.size(); ++i) {
            ColumnInfo ci = (ColumnInfo)this.columnInfo.get(i);
            if (ci.getLabel() != null && ci.getLabel().equalsIgnoreCase(label)) {
                index = ci.getIndex();
                break;
            }
            if (ci.getIndex() != -1) continue;
            for (int j = 0; j < this.getModel().getColumnCount(); ++j) {
                if (!this.getModel().getColumnName(j).equalsIgnoreCase(label)) continue;
                index = j;
                continue block0;
            }
        }
        return index;
    }

    public List getColumnInfo() {
        return this.columnInfo;
    }

    public void setColumnInfo(Variable cv) {
        if (cv instanceof AnalysisVariableList) {
            for (AnalysisVariableList vl = (AnalysisVariableList)cv; vl != null; vl = vl.getNext()) {
                this.columnInfo.add(new ColumnInfo(vl.getColumnName(), vl.getLabel(), vl.getColumnIndex()));
            }
        } else if (cv instanceof ClassificationVariableList) {
            for (ClassificationVariableList vl = (ClassificationVariableList)cv; vl != null; vl = vl.getNext()) {
                this.columnInfo.add(new ColumnInfo(vl.getColumnName(), vl.getLabel(), vl.getColumnIndex()));
            }
        } else if (cv instanceof PlotVariableList) {
            for (PlotVariableList vl = (PlotVariableList)cv; vl != null; vl = vl.getNext()) {
                this.columnInfo.add(new ColumnInfo(vl.getColumnName(), vl.getLabel(), vl.getColumnIndex()));
            }
        } else {
            this.columnInfo.add(new ColumnInfo(cv.getColumnName(), cv.getLabel(), cv.getColumnIndex()));
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.baseGraph.getActionProvider() != null && this.baseGraph.isFlushEnabled()) {
            this.baseGraph.getActionProvider().flushViewerCommands(this.baseGraph);
        }
        super.write(out);
    }

    private static class ColumnInfo {
        private int index = -1;
        private String name;
        private String label;

        public ColumnInfo(String name, String label, int index) {
            this.setName(name);
            this.setLabel(label);
            this.setIndex(index);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

