/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics;

import com.sas.actionprovider.AbstractPool;
import com.sas.codepolicy.SASScope;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

@SASScope
public class ImagePool
extends AbstractPool {
    private static final int MAX_SIZE = 20;
    private static ImagePool _instance = new ImagePool();
    private long _itemsCleared = 0L;
    private long _newObjectsCreated = 0L;

    private ImagePool() {
        super("ImagePool");
        this.setMaxSize(20);
    }

    public static ImagePoolEntry getImage() {
        return (ImagePoolEntry)_instance.getObj();
    }

    public static void returnImage(ImagePoolEntry entry) {
        _instance.returnObj(entry);
    }

    protected void sanitize(Object obj) {
        ++this._itemsCleared;
    }

    protected Object createNewObj() {
        ++this._newObjectsCreated;
        return new ImagePoolEntry();
    }

    protected boolean isClassAcceptable(Object obj) {
        return obj != null && obj.getClass() == ImagePoolEntry.class;
    }

    public String toString() {
        return super.toString() + ",\n\t BufferedImage items cleared(" + this._itemsCleared + ").,\n\t New BufferedImages Created(" + this._newObjectsCreated + ").";
    }

    @SASScope
    public static class ImagePoolEntry {
        private BufferedImage intImage = null;
        private BufferedImage shortImage = null;
        private ByteArrayOutputStream stream = null;

        public BufferedImage getImage(int width, int height, int type) {
            BufferedImage internal;
            switch (type) {
                case 1: {
                    this.reallocIntImage(width, height);
                    internal = this.intImage;
                    break;
                }
                case 9: {
                    this.reallocShortImage(width, height);
                    internal = this.shortImage;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unkown image type: " + type);
                }
            }
            BufferedImage result = internal.getSubimage(0, 0, width, height);
            return result;
        }

        public ByteArrayOutputStream getStream() {
            if (this.stream == null) {
                this.stream = new ByteArrayOutputStream(5000);
            } else {
                this.stream.reset();
            }
            return this.stream;
        }

        private void reallocIntImage(int width, int height) {
            if (this.intImage == null || this.intImage.getWidth() < width || this.intImage.getHeight() < height) {
                this.intImage = new BufferedImage(width, height, 1);
            }
        }

        private void reallocShortImage(int width, int height) {
            if (this.shortImage == null || this.shortImage.getWidth() < width || this.shortImage.getHeight() < height) {
                this.shortImage = new BufferedImage(width, height, 9);
            }
        }
    }
}

