/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form.html;

import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.BaseTextArea;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

public class TextArea
extends BaseTextArea
implements StyleInterface {
    public TextArea() {
        this(Util.getName((String)"TextArea"));
    }

    public TextArea(String name) {
        this.setName(name);
        this.setId(name);
    }

    public TextArea(String name, String text) {
        this.setName(name);
        this.setId(name);
        this.setText(text);
    }

    public TextArea(String name, String text, int rows) {
        this.setName(name);
        this.setId(name);
        this.setText(text);
        this.setRows(rows);
    }

    public TextArea(String name, String text, int rows, int columns) {
        this.setName(name);
        this.setId(name);
        this.setText(text);
        this.setRows(rows);
        this.setColumns(columns);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String wrap;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.writeValidationScript(out);
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        out.print("<textarea id=\"");
        out.print(this.getId());
        out.print("\" name=\"");
        out.print(this.getName());
        out.print("\"");
        if (this.getColumns() > 0) {
            out.print(" cols=\"" + this.getColumns() + "\"");
        }
        if (this.getRows() > 0) {
            out.print(" rows=\"" + this.getRows() + "\"");
        }
        if ((wrap = this.getWrap()) != null && wrap.length() > 0) {
            out.print(" wrap=\"" + wrap + "\"");
        }
        super.write(out);
        String onselect = this.getOnSelect();
        if (onselect != null && onselect.length() > 0) {
            out.print(" onselect=\"" + onselect + "\"");
        }
        if (this.isReadOnly()) {
            out.print(" readonly=\"readonly\"");
        }
        if (!this.isEnabled()) {
            out.print(" disabled=\"disabled\"");
        }
        out.print(">");
        String value = this.getText();
        char[] quote1 = new char[]{'\"'};
        String[] quote2 = new String[]{"&quot;"};
        if (value != null) {
            value = Strings.replace((String)value, (char[])quote1, (String[])quote2);
            out.print(value);
        }
        out.println("</textarea>");
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
        this.writeJavaScriptObject(out);
        this.cleanUpResources();
    }
}

