/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.BaseInput;
import com.sas.servlet.tbeans.form.BaseListBox;
import com.sas.servlet.tbeans.form.BaseTextArea;
import com.sas.servlet.tbeans.form.FormElementModificationEventInterface;
import com.sas.servlet.tbeans.form.JavaScriptObjectCreationInterface;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationObjectCreationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationOnChangeInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.validators.CompositeValidator;
import com.sas.util.validators.GenericValidatorInterface;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;

@SASScope(value="ALL")
public abstract class BaseFormElement
extends BaseTransformation
implements FormElementModificationEventInterface,
GenericValidatorInterface,
JavaScriptEventHandlerInterface,
JavaScriptObjectCreationInterface {
    public static final String RB_KEY = "BaseFormElement.";
    private String name;
    private String tabindex = "";
    private String accesskey = "";
    private String modEventName = "";
    private String onBlur = "";
    private String onChange = "";
    private String onClick = "";
    private String onDblClick = "";
    private String onFocus = "";
    private String onMouseOut = "";
    private String onMouseOver = "";
    private String onMouseDown;
    private String onMouseMove = "";
    private String onMouseUp = "";
    private String onKeyDown = "";
    private String onKeyUp = "";
    private String onKeyPress = "";
    private String onSelect = "";
    private String styleClassPrefix = "";
    private String title = "";
    Boolean validationEnabled = new Boolean(false);
    Method[] setMethodCalls = null;
    Method[] getMethodCalls = null;
    private boolean enabled = true;
    private boolean javaScriptObjectCreationEnabled = false;
    private String preValidationFunction;
    private String postValidationFunction;
    private boolean validateOnBlur = true;
    private boolean validateOnChange = true;
    private boolean validateOnKeyPress = true;
    private StyleInfo componentStyle = new StyleInfo();
    private ValidationInterface validator;
    private GenericErrorHandlerInterface errorHandler;

    @Override
    public void setId(String value) {
        String oldId = this.getId();
        if (oldId == null && value != null || oldId != null && !oldId.equals(value)) {
            super.setId(value);
            String oldName = this.getName();
            if (oldName == null || oldName != null && oldId != null && oldId.equals(oldName)) {
                this.setName(this.getId());
            }
        }
    }

    @Override
    public void setName(String value) {
        if (this.name == null && value != null || this.name != null && !this.name.equals(value)) {
            this.firePropertyChange("name", this.name, value);
        }
        this.name = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setTabIndex(String value) {
        this.tabindex = value;
    }

    public String getTabIndex() {
        return this.tabindex;
    }

    public void setAccessKey(String value) {
        this.accesskey = value;
    }

    public String getAccessKey() {
        return this.accesskey;
    }

    @Override
    public void setModificationEventName(String eventName) {
        this.modEventName = eventName;
    }

    @Override
    public String getModificationEventName() {
        return this.modEventName;
    }

    @Override
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    public void setOnClick(String value) {
        this.onClick = value;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnDblClick(String value) {
        this.onDblClick = value;
    }

    public String getOnDblClick() {
        return this.onDblClick;
    }

    @Override
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    public void setOnMouseOut(String value) {
        this.onMouseOut = value;
    }

    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    public void setOnMouseOver(String value) {
        this.onMouseOver = value;
    }

    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    public void setOnMouseDown(String value) {
        this.onMouseDown = value;
    }

    public String getOnMouseDown() {
        return this.onMouseDown;
    }

    public void setOnMouseUp(String value) {
        this.onMouseUp = value;
    }

    public String getOnMouseUp() {
        return this.onMouseUp;
    }

    public void setOnMouseMove(String value) {
        this.onMouseMove = value;
    }

    public String getOnMouseMove() {
        return this.onMouseMove;
    }

    public void setOnKeyDown(String value) {
        this.onKeyDown = value;
    }

    public String getOnKeyDown() {
        return this.onKeyDown;
    }

    public void setOnKeyPress(String value) {
        this.onKeyPress = value;
    }

    public String getOnKeyPress() {
        return this.onKeyPress;
    }

    public void setOnKeyUp(String value) {
        this.onKeyUp = value;
    }

    public String getOnKeyUp() {
        return this.onKeyUp;
    }

    public void setOnSelect(String value) {
        this.onSelect = value;
    }

    public String getOnSelect() {
        return this.onSelect;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getTitle() {
        return this.title;
    }

    @SASScope
    public void setStyleClassPrefix(String styleClassPrefix) {
        this.styleClassPrefix = styleClassPrefix;
    }

    @SASScope
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    public void setValidator(ValidationInterface validator) {
        this.validator = validator;
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    public boolean isValid() {
        if (this.validator != null) {
            // empty if block
        }
        return true;
    }

    public void setErrorHandler(GenericErrorHandlerInterface errorHandler) {
        this.errorHandler = errorHandler;
    }

    public GenericErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    @SASScope
    public void setStyle(String style) {
        this.componentStyle.setStyle(style);
    }

    @Override
    @SASScope
    public void setStyleClass(String styleClass) {
        this.componentStyle.setClassid(styleClass);
    }

    @Override
    @SASScope
    public String getStyle() {
        return this.componentStyle.getStyle();
    }

    @Override
    @SASScope
    public String getStyleClass() {
        return this.componentStyle.getClassid();
    }

    public StyleInfo getStyleInfo() {
        return this.componentStyle;
    }

    public void setStyleInfo(StyleInfo styleInfo) {
        this.componentStyle = styleInfo;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @SASScope
    public void setValidateOnBlur(boolean value) {
        this.validateOnBlur = value;
    }

    @SASScope
    public boolean isValidateOnBlur() {
        return this.validateOnBlur;
    }

    @SASScope
    public void setValidateOnChange(boolean value) {
        this.validateOnChange = value;
    }

    @SASScope
    public boolean isValidateOnChange() {
        return this.validateOnChange;
    }

    @SASScope
    public void setValidateOnKeyPress(boolean value) {
        this.validateOnKeyPress = value;
    }

    @SASScope
    public boolean isValidateOnKeyPress() {
        return this.validateOnKeyPress;
    }

    protected void writeValidationScript(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
    }

    protected boolean isValidationEnabled() {
        ValidationInterface validator = this.getValidator();
        if (validator != null) {
            if (validator instanceof JavaScriptValidationOnChangeInterface) {
                return ((JavaScriptValidationOnChangeInterface)validator).isValidationOnChange();
            }
            if (validator instanceof CompositeValidator) {
                List validators = ((CompositeValidator)validator).getValidators();
                for (int i = 0; i < validators.size(); ++i) {
                    JavaScriptValidationOnChangeInterface jsvalidator = (JavaScriptValidationOnChangeInterface)validators.get(i);
                    if (!jsvalidator.isValidationOnChange()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected String getValidationFunctions(ValidationInterface validator, boolean conditional) {
        StringBuffer sb = new StringBuffer();
        if (this.getPreValidationFunction() != null) {
            sb.append(this.getPreValidationFunction()).append("; ");
        }
        if (conditional) {
            sb.append("if (");
        }
        if (validator instanceof CompositeValidator) {
            List validators = ((CompositeValidator)validator).getValidators();
            for (int i = 0; i < validators.size(); ++i) {
                JavaScriptValidationInterface val = (JavaScriptValidationInterface)validators.get(i);
                if (this instanceof ComboBoxView) {
                    sb.append(val.createValidationFunctionCall(((ComboBoxView)this).getTextEntryComponent()));
                } else {
                    sb.append(val.createValidationFunctionCall(this));
                }
                if (!conditional) {
                    sb.append("; ");
                }
                if (i >= validators.size() - 1 || !conditional) continue;
                sb.append(" && ");
            }
        } else if (validator instanceof JavaScriptValidationInterface) {
            if (this instanceof ComboBoxView) {
                sb.append(((JavaScriptValidationInterface)validator).createValidationFunctionCall(((ComboBoxView)this).getTextEntryComponent()));
            } else {
                sb.append(((JavaScriptValidationInterface)validator).createValidationFunctionCall(this));
            }
        }
        if (conditional) {
            sb.append(")");
            if (this.getPostValidationFunction() != null) {
                sb.append(this.getPostValidationFunction()).append("; ");
            }
        }
        return sb.toString();
    }

    @Override
    @SASScope
    public void setJavaScriptObjectCreationEnabled(boolean b) {
        this.javaScriptObjectCreationEnabled = b;
    }

    @Override
    @SASScope
    public boolean isJavaScriptObjectCreationEnabled() {
        return this.javaScriptObjectCreationEnabled;
    }

    protected void writeJavaScriptObject(PrintWriter out) throws IOException {
        if (this.isJavaScriptObjectCreationEnabled()) {
            JavaScriptIncludeHandler.writeIncludes(out, "FORMBEAN", this.getRequest());
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println(this.getId() + "_Obj = new sas_FormBean('" + this.getId() + "');");
            if (!this.isEnabled()) {
                out.println(this.getId() + "_Obj.enabled = false;");
            }
            out.println(this.getId() + "_Obj.element = document.getElementById('" + this.getId() + "');");
            this.writeJavaScriptValidatorObject(out);
            this.writeJavaScriptObjectValidate(out);
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
    }

    protected void writeJavaScriptValidatorObject(PrintWriter out) {
        out.println(this.getId() + "_Obj.validator = new Array();");
        BaseFormElement bean = this instanceof ComboBoxView ? ((ComboBoxView)this).getTextEntryComponent() : this;
        if (this.validator != null && this.validator instanceof CompositeValidator) {
            List validators = ((CompositeValidator)this.validator).getValidators();
            for (int i = 0; i < validators.size(); ++i) {
                if (!(validators.get(i) instanceof JavaScriptValidationObjectCreationInterface)) continue;
                JavaScriptValidationObjectCreationInterface val = (JavaScriptValidationObjectCreationInterface)validators.get(i);
                val.writeJavaScriptValidatorObject(out, bean);
                out.println(this.getId() + "_Obj.validator[" + i + "] = sas_getJavaScriptObject('" + val.getId() + "');");
            }
        } else if (this.validator != null && this.validator instanceof JavaScriptValidationObjectCreationInterface) {
            ((JavaScriptValidationObjectCreationInterface)this.validator).writeJavaScriptValidatorObject(out, bean);
            out.println(this.getId() + "_Obj.validator[0] = sas_getJavaScriptObject('" + ((JavaScriptValidationObjectCreationInterface)this.validator).getId() + "');");
        }
    }

    protected void writeJavaScriptObjectValidate(PrintWriter out) {
        out.println(this.getId() + "_Obj.valid = true;");
        BaseFormElement bean = this instanceof ComboBoxView ? ((ComboBoxView)this).getTextEntryComponent() : this;
        ValidationInterface validator = this.getValidator();
        if (validator != null && validator instanceof CompositeValidator) {
            List compValidators = ((CompositeValidator)validator).getValidators();
            int valLen = compValidators.size();
            StringBuffer validate = new StringBuffer();
            boolean validateContinuous = true;
            for (int i = 0; i < valLen; ++i) {
                ValidationInterface val = (ValidationInterface)compValidators.get(i);
                if (!(val instanceof JavaScriptValidationInterface)) continue;
                validate.append(((JavaScriptValidationInterface)val).createValidationFunctionCall(bean));
                if (i < valLen - 1) {
                    validate.append("&& ");
                }
                validateContinuous = ((JavaScriptValidator)val).isValidateContinuous();
            }
            out.println(this.getId() + "_Obj.validateContinuous = " + validateContinuous + ";");
            out.println(this.getId() + "_Obj.isComponentValid = function(){ if(!" + this.getId() + "_Obj.valid) return false; else {" + this.getId() + "_Obj.valid = false; " + this.getId() + "_Obj.valid = (" + validate.toString() + "); return " + this.getId() + "_Obj.valid}};\n");
            out.println(this.getId() + "_Obj.validate = function(){ return ((" + validate.toString() + ")? true: false);};");
            out.println(this.getId() + "_Obj.isValid = function(){ return ((" + validate.toString() + ")? true: false);};\n");
        } else if (validator != null && validator instanceof JavaScriptValidationInterface) {
            String validate = ((JavaScriptValidationInterface)validator).createValidationFunctionCall(bean);
            out.println(this.getId() + "_Obj.validateContinuous = " + ((JavaScriptValidator)validator).isValidateContinuous() + ";");
            out.println(this.getId() + "_Obj.isComponentValid = function(){if(!" + this.getId() + "_Obj.valid) return false; else {" + this.getId() + "_Obj.valid = false; " + this.getId() + "_Obj.valid = " + validate + "; return " + this.getId() + "_Obj.valid}};\n");
            out.println(this.getId() + "_Obj.validate = function(){ return " + validate + " };");
            out.println(this.getId() + "_Obj.isValid = function(){ return " + validate + "};\n");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        ValidationInterface validation = this.getValidator();
        boolean singleValidation = this.isValidationEnabled();
        this.writeAttribute(out, "title", this.getTitle());
        this.writeAttribute(out, "tabindex", this.getTabIndex());
        this.writeAttribute(out, "accessKey", this.getAccessKey());
        this.writeAttribute(out, "onclick", this.getOnClick());
        this.writeAttribute(out, "ondblclick", this.getOnDblClick());
        String onchange = this.getOnChange();
        if (this instanceof BaseInput || this instanceof BaseTextArea || this instanceof BaseChoiceBox || this instanceof BaseListBox) {
            if (singleValidation && this.isValidateOnChange()) {
                out.print(" onchange=\"");
                if (onchange != null && onchange.length() > 0) {
                    out.print(this.getValidationFunctions(validation, true) + " " + onchange);
                } else {
                    out.print(this.getValidationFunctions(validation, true) + " return true;");
                }
                out.print("\"");
            } else if (onchange != null && onchange.length() > 0) {
                out.print(" onchange=\"" + onchange + "\"");
            }
        }
        String onblur = this.getOnBlur();
        if (singleValidation && this.isValidateOnBlur()) {
            out.print(" onblur=\"");
            if (onblur != null && onblur.length() > 0) {
                out.print(this.getValidationFunctions(validation, true) + " " + onblur);
            } else {
                out.print(this.getValidationFunctions(validation, true) + " return true;");
            }
            out.print("\"");
        } else if (onblur != null && onblur.length() > 0) {
            out.print(" onblur=\"" + onblur + "\"");
        }
        this.writeAttribute(out, "onfocus", this.getOnFocus());
        this.writeAttribute(out, "onmouseout", this.getOnMouseOut());
        this.writeAttribute(out, "onmouseover", this.getOnMouseOver());
        this.writeAttribute(out, "onmousedown", this.getOnMouseDown());
        this.writeAttribute(out, "onmouseup", this.getOnMouseUp());
        this.writeAttribute(out, "onmousemove", this.getOnMouseMove());
        this.writeAttribute(out, "onkeydown", this.getOnKeyDown());
        this.writeAttribute(out, "onkeyup", this.getOnKeyUp());
        String onkeypress = this.getOnKeyPress();
        if (singleValidation && this.isValidateOnKeyPress()) {
            out.print(" onkeypress=\"");
            if (onkeypress != null && onkeypress.length() > 0) {
                out.print("if (event.keyCode == 13 && xIE ) { " + this.getValidationFunctions(validation, true) + " " + onkeypress + ";}");
            } else {
                out.print("if (event.keyCode == 13 && xIE) { " + this.getValidationFunctions(validation, true) + " return true;}");
            }
            out.print("\"");
        } else if (onkeypress != null && onkeypress.length() > 0) {
            out.print(" onkeypress=\"" + onkeypress + "\"");
        }
        super.write(out);
    }

    private void writeAttribute(PrintWriter out, String property, String value) {
        if (value != null && value.length() > 0) {
            out.print(" " + property + "=\"" + value + "\"");
        }
    }

    @SASScope
    public String getPreValidationFunction() {
        return this.preValidationFunction;
    }

    @SASScope
    public void setPreValidationFunction(String preValidationFunction) {
        this.preValidationFunction = preValidationFunction;
    }

    @SASScope
    public String getPostValidationFunction() {
        return this.postValidationFunction;
    }

    @SASScope
    public void setPostValidationFunction(String postValidationFunction) {
        this.postValidationFunction = postValidationFunction;
    }

    static {
        JavaScriptIncludeHandler.addAlias(BaseFormElement.class, "FORMBEAN");
    }
}

