/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.form;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DateType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.servlet.tbeans.form.BaseComboBoxView;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.RB;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.util.ValueItem;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;

@SASScope(value="ALL")
public abstract class BaseChoiceBox
extends BaseFormElement {
    public static final String RB_KEY = "BaseFormElement.";
    private int selected;
    private String selectedItem;
    private ComboBoxModel descModel;
    private boolean validateSelection = false;
    private boolean allowNullReturnValues = false;
    private boolean encodeWhiteSpace = false;
    private List separatorIndices;
    protected TransformInterface labelTransform;
    protected ComboBoxModel model;

    public BaseChoiceBox() {
        this.setObjectDataProperty("selectedItem");
        this.setModificationEventName("onChange");
        this.selected = -1;
        this.selectedItem = null;
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.model = comboBoxModel;
    }

    public void setSelectedIndex(int value) throws IOException {
        if (this.model != null) {
            if (value < -1 || value > this.model.getSize() - 1) {
                if (this.isValidateSelection()) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invRange.txt", this.getLocale()));
                }
                value = -1;
            }
            this.selected = value;
            if (this.selected == -1) {
                this.selectedItem = null;
            } else if (this.model.getElementAt(this.selected) instanceof JavaScriptNode) {
                JavaScriptNode item = (JavaScriptNode)this.model.getElementAt(this.selected);
                String tempItem = item.getValue();
                if (tempItem != null && tempItem.length() > 0) {
                    this.selectedItem = tempItem;
                } else {
                    tempItem = item.getText();
                    if (tempItem != null && tempItem.length() > 0) {
                        this.selectedItem = tempItem;
                    }
                }
            } else if (this.model.getElementAt(this.selected) instanceof Item) {
                Item item = (Item)this.model.getElementAt(this.selected);
                String tempItem = item.getValue();
                if (tempItem != null && tempItem.length() > 0) {
                    this.selectedItem = tempItem;
                } else {
                    tempItem = item.getText();
                    if (tempItem != null && tempItem.length() > 0) {
                        this.selectedItem = tempItem;
                    }
                }
            } else {
                this.selectedItem = this.model.getElementAt(this.selected).toString();
            }
        }
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void setSelectedItem(String value) throws IOException {
        if (this.model != null) {
            if (value == null) {
                this.selected = -1;
                this.selectedItem = null;
            } else {
                boolean found = false;
                int modSize = this.model.getSize();
                int i = 0;
                int selIndx = 0;
                while (i <= modSize - 1 && !found) {
                    String tempVal;
                    Item tempNode;
                    if (this.model.getElementAt(i) instanceof JavaScriptNode) {
                        tempNode = (JavaScriptNode)this.model.getElementAt(i);
                        if (tempNode.isUseAsSeparator()) {
                            --selIndx;
                        }
                        if ((tempVal = tempNode.getValue()) != null && tempVal.length() > 0) {
                            if (tempVal.equals(value)) {
                                this.selected = selIndx;
                                this.selectedItem = tempVal;
                                found = true;
                            } else {
                                tempVal = tempNode.getText();
                                if (tempVal != null && tempVal.length() > 0 && tempVal.equals(value)) {
                                    this.selected = selIndx;
                                    this.selectedItem = tempVal;
                                    found = true;
                                }
                            }
                        } else {
                            tempVal = tempNode.getText();
                            if (tempVal != null && tempVal.length() > 0 && tempVal.equals(value)) {
                                this.selected = selIndx;
                                this.selectedItem = tempVal;
                                found = true;
                            }
                        }
                    } else if (this.model.getElementAt(i) instanceof Item) {
                        tempNode = (Item)this.model.getElementAt(i);
                        if (tempNode.isUseAsSeparator()) {
                            --selIndx;
                        }
                        if ((tempVal = tempNode.getValue()) != null && tempVal.length() > 0) {
                            if (tempVal.equals(value)) {
                                this.selected = selIndx;
                                this.selectedItem = tempVal;
                                found = true;
                            } else {
                                tempVal = tempNode.getText();
                                if (tempVal != null && tempVal.length() > 0 && tempVal.equals(value)) {
                                    this.selected = selIndx;
                                    this.selectedItem = tempVal;
                                    found = true;
                                }
                            }
                        } else {
                            tempVal = tempNode.getText();
                            if (tempVal != null && tempVal.length() > 0 && tempVal.equals(value)) {
                                this.selected = selIndx;
                                this.selectedItem = tempVal;
                                found = true;
                            }
                        }
                    } else if (this.model.getElementAt(i) != null) {
                        Object tempVal2 = this.model.getElementAt(i);
                        if (tempVal2 instanceof ValueItem) {
                            String stringValue = "";
                            stringValue = ((ValueItem)tempVal2).getValue() instanceof Date ? ((ValueItem)tempVal2).getLabel(this.getLocale()) : ((ValueItem)tempVal2).getValueAsString(this.getLocale());
                            if ("-SEPARATOR-".equals(stringValue)) {
                                --selIndx;
                            }
                            tempVal2 = stringValue;
                        } else {
                            tempVal2 = this.model.getElementAt(i).toString();
                        }
                        if (tempVal2 != null && tempVal2.equals(value)) {
                            this.selected = selIndx;
                            this.selectedItem = value;
                            found = true;
                        }
                    }
                    ++i;
                    ++selIndx;
                }
                if ((modSize == 0 || !found) && this instanceof BaseComboBoxView && ((BaseComboBoxView)this).isEditable()) {
                    this.selected = -1;
                    this.selectedItem = value;
                    found = true;
                }
                if (!found && this.isValidateSelection()) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invSelection.txt", this.getLocale()));
                }
            }
        }
    }

    public void setSelectedItem(String value, int defaultIndex) {
        try {
            this.setSelectedItem(value);
        }
        catch (Exception ex) {
            try {
                if (defaultIndex != -1) {
                    this.setSelectedIndex(defaultIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    protected boolean isSelected(int index) {
        boolean rc = false;
        if (this.selected == index) {
            rc = true;
        }
        return rc;
    }

    protected boolean isSelected(String value) {
        boolean rc = false;
        if (value != null && this.selectedItem != null) {
            rc = value.equals(this.selectedItem);
        }
        return rc;
    }

    @SASScope
    public void setDescriptionModel(ComboBoxModel model) {
        this.descModel = model;
    }

    @SASScope
    public ComboBoxModel getDescriptionModel() {
        return this.descModel;
    }

    public void setValidateSelection(boolean value) {
        this.validateSelection = value;
    }

    public boolean isValidateSelection() {
        return this.validateSelection;
    }

    @SASScope
    public void setNullReturnValuesAllowed(boolean value) {
        this.allowNullReturnValues = value;
    }

    @SASScope
    public boolean isNullReturnValuesAllowed() {
        return this.allowNullReturnValues;
    }

    @SASScope
    public List getSeparatorIndices() {
        if (this.separatorIndices == null) {
            this.separatorIndices = new ArrayList();
        }
        return this.separatorIndices;
    }

    private int getSeparatorCount(int index) {
        if (this.separatorIndices != null) {
            int count = 0;
            Iterator itr = this.separatorIndices.iterator();
            while (itr.hasNext()) {
                int i = (Integer)itr.next();
                if (index < i) continue;
                ++count;
                ++index;
            }
            return count;
        }
        return 0;
    }

    @SASScope
    public Object getItem(int index) {
        if (index > -1) {
            return this.getModel().getElementAt(index + this.getSeparatorCount(index));
        }
        return null;
    }

    @SASScope
    public TransformInterface getLabelTransform() {
        return this.labelTransform;
    }

    @SASScope
    public void setLabelTransform(TransformInterface labelTransform) {
        this.labelTransform = labelTransform;
    }

    protected String getValueItemLabel(ValueItem item) {
        String label;
        if (this.labelTransform != null) {
            try {
                label = String.valueOf(this.labelTransform.transform(item.getValue()));
                if (item.getAttribute("QUALIFIED_LABEL") != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(item.getValue().toString());
                    sb.append(" [");
                    sb.append(label);
                    sb.append("]");
                    label = sb.toString();
                }
            }
            catch (TransformException e) {
                label = item.getLabel();
            }
        } else {
            Object input;
            label = item.getAttribute("QUALIFIED_LABEL") != null ? item.getAttribute("QUALIFIED_LABEL").toString() : ((input = item.getLabelObject()) instanceof Date ? (input instanceof Time ? TimeType.DEFAULT_INSTANCE.getDisplayString(input, this.getLocale()) : (input instanceof Timestamp ? TimeStampType.DEFAULT_INSTANCE.getDisplayString(input, this.getLocale()) : DateType.DEFAULT_INSTANCE.getDisplayString(input, this.getLocale()))) : (input instanceof MissingValues ? MissingValues.toDisplayString((MissingValues)((MissingValues)item.getValue()), (Locale)this.getLocale()) : item.getLabel()));
        }
        return label;
    }

    @SASScope
    public void setEncodeWhiteSpace(boolean value) {
        this.encodeWhiteSpace = value;
    }

    @SASScope
    public boolean isEncodeWhiteSpace() {
        return this.encodeWhiteSpace;
    }
}

