/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.features;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionListToPopupMenuModelAdapter;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.support.dataselectors.HttpRelationalPopMenuSupport;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.graphics.html.HtmlGraphUtil;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.html.TableView;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public class ActionProviderPopupMenuFeature
extends BaseActionTransformation
implements Feature {
    public static final String RB_KEY = "ActionProviderPopupMenu.";
    private BaseActionTransformation viewer;
    private ActionSupportFilter actionSupportFilter;
    protected PopupMenu popupMenu;

    public ActionProviderPopupMenuFeature(BaseActionTransformation viewer, String actionSupportType) {
        this.setViewer(viewer);
        this.setActionSupportType(actionSupportType);
        this.popupMenu = null;
    }

    public void setViewer(BaseActionTransformation viewer) {
        this.viewer = viewer;
        if (viewer != null) {
            this.setActionProvider(viewer.getActionProvider());
        }
    }

    public BaseActionTransformation getViewer() {
        return this.viewer;
    }

    public PopupMenu buildPopupMenu() {
        ActionSupportFilter filter = this.getActionSupportFilter();
        try {
            BaseActionTransformation viewer = this.getViewer();
            if (viewer instanceof TableView) {
                filter.setAttribute("model", (Object)((TableView)this.getViewer()).getModel());
            } else if (viewer instanceof OLAPTableView) {
                filter.setAttribute("model", (Object)((OLAPTableView)this.getViewer()).getModel());
            } else if (viewer instanceof BaseGraph) {
                filter.setAttribute("model", HtmlGraphUtil.getModel((BaseGraph)viewer));
                filter.setAttribute(HttpRelationalPopMenuSupport.GRAPH_COMPONENT, (Object)viewer);
            }
            filter.setAttribute("viewerComponent", (Object)this.getViewer());
        }
        catch (AttributeSetException e) {
            e.printStackTrace();
        }
        ActionList actionList = this.getViewer().getActionProvider().getActions(filter);
        if (this.getId() == null) {
            this.setId(this.getViewer().getId());
        }
        this.popupMenu = new PopupMenu(this.getId() + "_" + "pmenu");
        this.popupMenu.setModel(new ActionListToPopupMenuModelAdapter(actionList, this.getRequest()));
        if (this.getViewer() instanceof BaseGraph) {
            this.popupMenu.attachTo(this.getViewer().getId() + "_map", "onrightclick");
            this.popupMenu.attachTo(this.getViewer().getId(), "onrightclick");
        } else {
            this.popupMenu.attachTo(this.getViewer().getId(), "oncontextmenu");
        }
        return this.popupMenu;
    }

    private ActionSupportFilter getActionSupportFilter() {
        if (this.actionSupportFilter == null) {
            this.actionSupportFilter = new ActionSupportFilter(this.getActionSupportType(), "POPMENU_AREA", (ActionProviderViewInterface)this);
        }
        return this.actionSupportFilter;
    }

    @Override
    public void write(HttpServletRequest request, Writer out) throws IOException {
        this.setRequest(request);
        this.popupMenu = this.buildPopupMenu();
        if (this.popupMenu != null) {
            this.popupMenu.setRequest(request);
            this.popupMenu.setResponse(this.getResponse());
            this.popupMenu.setLocale(this.getLocale());
            this.popupMenu.write(out);
        }
    }
}

