/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dualselector.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.dualselector.html.DualSelector;
import com.sas.servlet.tbeans.dualselector.html.RB;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeNode;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

@SASScope(value="ALL")
public class TreeListSelector
extends DualSelector {
    private static final long serialVersionUID = 3258417243993092920L;
    private static String QUOTE_COMMA_QUOTE = "','";
    private static String COMMA = ",";
    private static String QUOTE_COMMA = "',";
    @SASScope
    public static final String RB_KEY = "DualSelector.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "TreeListSelector.html";
    private TreeModel model;
    private TreeModel targetModel;

    public TreeListSelector() {
        this(Util.getName((String)"tlsel"), null);
    }

    public TreeListSelector(String name, TreeModel model) {
        this.setId(name);
        this.setModel(model);
        this.setTemplateKey("Tree_List_Selector");
        this.type = "DUALTREE";
        this.setStaticSourceAllowed(false);
        this.setDefaultComponentNames();
        this.setTreeDefaults();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "DUALSELECTOR", this.getRequest());
        this.writeSelectorHeader(out);
        this.writeSelectorFooter(out);
        long n = Util.getNumber();
        out.println(JavaScriptIncludeHandler.getStartScript() + "function sas_DualSelector_moveToTarget" + n + "() {" + this.getMoveToTarget() + "\n}\n" + this.getSourceComponentName() + ".ondblclick = sas_DualSelector_moveToTarget" + n + ";\nfunction sas_DualSelector_removeFromTarget" + n + "() {" + this.getRemoveFromTarget() + "\n}\n" + this.getTargetComponentName() + ".ondblclick = sas_DualSelector_removeFromTarget" + n + ";\n" + JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    @Override
    protected void setSelectorDefaults() {
        super.setSelectorDefaults();
        TreeView sourceComponent = (TreeView)this.getSourceComponent();
        TreeModel mi = this.getModel();
        if (mi == null) {
            TreeNode node = new TreeNode("rootNode", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            TreeNode child1 = new TreeNode("child", RB.getStringResource(RB_KEY, "node.txt", this.getLocale()));
            node.add(child1);
            mi = new DefaultTreeModel(node);
        }
        sourceComponent.setModel(mi);
        if (this.getMultipleSelections() && !sourceComponent.getMultipleSelections()) {
            sourceComponent.setSelectionMode(3);
        }
        if (this.getImageLocation() != null) {
            sourceComponent.setImageLocation(this.getImageLocation());
        }
        sourceComponent.setRequest(this.getRequest());
        sourceComponent.setResponse(this.getResponse());
        sourceComponent.setLocale(this.getLocale());
        sourceComponent.setStyleClassPrefix(this.getStyleClassPrefix());
        sourceComponent.setJSType("DualList");
        sourceComponent.setModel(mi);
        TreeView targetComponent = (TreeView)this.getTargetComponent();
        TreeModel mi2 = this.getTargetModel();
        if (mi2 == null) {
            TreeNode node = new TreeNode("selection", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            mi2 = new DefaultTreeModel(node);
        }
        targetComponent.setModel(mi2);
        if (this.getMultipleSelections() && !targetComponent.getMultipleSelections()) {
            targetComponent.setSelectionMode(3);
        }
        targetComponent.setRequest(this.getRequest());
        sourceComponent.setResponse(this.getResponse());
        sourceComponent.setLocale(this.getLocale());
        if (this.getImageLocation() != null) {
            targetComponent.setImageLocation(this.getImageLocation());
        }
        targetComponent.setJSType("ListView");
        targetComponent.setStyleClassPrefix(this.getStyleClassPrefix());
        targetComponent.setRootNodeVisible(false);
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel treeModel) {
        this.model = treeModel;
    }

    public TreeModel getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(TreeModel treeModel) {
        this.targetModel = treeModel;
    }

    @Override
    protected String getMoveToTarget() {
        StringBuffer moveToTarget = new StringBuffer();
        if (this.getPreTargetTrigger() != null) {
            moveToTarget.append("if (").append(this.getPreTargetTrigger()).append(") \n");
        }
        moveToTarget.append("   moveToTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE).append(this.getTargetComponentName());
        moveToTarget.append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(COMMA).append(this.isTargetDuplicateAllowed()).append(COMMA);
        moveToTarget.append(this.getTargetMaximumCount()).append(");");
        if (this.getPostTargetTrigger() != null) {
            moveToTarget.append(this.getPostTargetTrigger()).append(";");
        }
        moveToTarget.append("return false;");
        return moveToTarget.toString();
    }

    @Override
    protected String getRemoveFromTarget() {
        StringBuffer removeFromTarget = new StringBuffer();
        if (this.getPreSourceTrigger() != null) {
            removeFromTarget.append("if (").append(this.getPreSourceTrigger()).append(")  \n");
        }
        removeFromTarget.append("   removeFromTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
        removeFromTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed());
        removeFromTarget.append(", true, true,'listview');");
        if (this.getPostSourceTrigger() != null) {
            removeFromTarget.append(this.getPostSourceTrigger()).append(";");
        }
        removeFromTarget.append("return false;");
        return removeFromTarget.toString();
    }

    @Override
    protected String getRemoveAllFromTarget() {
        StringBuffer removeAllFromTarget = new StringBuffer();
        if (this.getPreSourceTrigger() != null) {
            removeAllFromTarget.append("if (").append(this.getPreSourceTrigger()).append(") ");
        }
        removeAllFromTarget.append("   removeAllFromTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE).append(this.getTargetComponentName());
        removeAllFromTarget.append(QUOTE_COMMA).append(this.isStaticSourceAllowed() + ", false ,'listview');");
        if (this.getPostSourceTrigger() != null) {
            removeAllFromTarget.append(this.getPostSourceTrigger() + ";");
        }
        removeAllFromTarget.append("return false;");
        return removeAllFromTarget.toString();
    }

    @Override
    protected String getMoveAllToTarget() {
        StringBuffer moveAllToTarget = new StringBuffer();
        if (this.getPreTargetTrigger() != null) {
            moveAllToTarget.append("if (").append(this.getPreTargetTrigger()).append(") ");
        }
        moveAllToTarget.append("   moveAllToTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
        moveAllToTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(COMMA);
        moveAllToTarget.append(this.isTargetDuplicateAllowed()).append(COMMA).append(this.getTargetMaximumCount()).append(");");
        if (this.getPostTargetTrigger() != null) {
            moveAllToTarget.append(this.getPostTargetTrigger()).append(";");
        }
        moveAllToTarget.append("return false;");
        return moveAllToTarget.toString();
    }

    @Override
    protected String getMoveItemsUp() {
        StringBuffer moveUp = new StringBuffer();
        if (this.getPreUpTrigger() != null) {
            moveUp.append("if (").append(this.getPreUpTrigger()).append(") ");
        }
        moveUp.append("moveItemsUp('" + this.getTargetComponentName() + "', 'listview');");
        if (this.getPostUpTrigger() != null) {
            moveUp.append(this.getPostUpTrigger()).append(";");
        }
        moveUp.append("return false;");
        return moveUp.toString();
    }

    @Override
    protected String getMoveItemsDown() {
        StringBuffer moveDown = new StringBuffer();
        if (this.getPreDownTrigger() != null) {
            moveDown.append("if (").append(this.getPreDownTrigger()).append(") ");
        }
        moveDown.append("moveItemsDown('" + this.getTargetComponentName() + "', 'listview');");
        if (this.getPostDownTrigger() != null) {
            moveDown.append(this.getPostDownTrigger()).append(";");
        }
        moveDown.append("return false;");
        return moveDown.toString();
    }

    @Override
    protected String getSubmitAction() {
        StringBuffer sb = new StringBuffer();
        return sb.append("sas_TreeView_submitSelection('").append(this.getFormObject().getName()).append(QUOTE_COMMA_QUOTE).append(this.getTargetComponentName()).append("')").toString();
    }

    @Override
    public BaseTransformation getDefaultComponent() {
        return new TreeView();
    }

    private void setTreeDefaults() {
        TreeView sourceTree = (TreeView)this.getSourceComponent();
        sourceTree.setSelectionMode(1);
        sourceTree.setNodeLoading(1);
        TreeView targetTree = (TreeView)this.getTargetComponent();
        targetTree.setSelectionMode(1);
    }

    static {
        JavaScriptIncludeHandler.addAlias(TreeListSelector.class, "DUALSELECTOR");
    }
}

