/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dualselector.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dualselector.html.DualSelector;
import com.sas.servlet.tbeans.dualselector.html.RB;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeNode;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

@SASScope(value="ALL")
public class DualTreeSelector
extends DualSelector {
    private static String QUOTE_COMMA_QUOTE = "','";
    private static String COMMA = ",";
    private static String QUOTE_COMMA = "',";
    @SASScope
    public static final String RB_KEY = "DualSelector.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DualTreeSelector.html";
    private TreeModel model;
    private TreeModel targetModel;
    private String targetNode;

    public DualTreeSelector() {
        this(Util.getName((String)"dtsel"), null);
    }

    public DualTreeSelector(String name, TreeModel model) {
        this.setId(name);
        this.setModel(model);
        this.setTemplateKey("Dual_Tree_Selector");
        this.type = "DUALTREE";
        this.setDefaultComponentNames();
        this.setComponentTypes();
        this.setTreeDefaults();
    }

    private void setComponentTypes() {
        TreeView sourceComponent = (TreeView)this.getSourceComponent();
        sourceComponent.setJSType("DualList");
        sourceComponent.setNodeLoading(1);
        TreeView targetComponent = (TreeView)this.getTargetComponent();
        targetComponent.setJSType("DualList");
    }

    @Override
    protected void setSelectorDefaults() {
        super.setSelectorDefaults();
        TreeView sourceComponent = (TreeView)this.getSourceComponent();
        TreeModel mi = this.getModel();
        if (mi == null) {
            TreeNode node = new TreeNode("rootNode", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            TreeNode child1 = new TreeNode("child", RB.getStringResource(RB_KEY, "node.txt", this.getLocale()));
            node.add(child1);
            mi = new DefaultTreeModel(node);
        }
        sourceComponent.setModel(mi);
        if (this.getMultipleSelections() && !sourceComponent.getMultipleSelections()) {
            sourceComponent.setSelectionMode(3);
        }
        if (this.getImageLocation() != null) {
            sourceComponent.setImageLocation(this.getImageLocation());
        }
        sourceComponent.setRequest(this.getRequest());
        sourceComponent.setResponse(this.getResponse());
        sourceComponent.setLocale(this.getLocale());
        sourceComponent.setStyleClassPrefix(this.getStyleClassPrefix());
        sourceComponent.setModel(mi);
        TreeView targetComponent = (TreeView)this.getTargetComponent();
        TreeModel mi2 = this.getTargetModel();
        if (mi2 == null) {
            TreeNode node = new TreeNode("selection", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            mi2 = new DefaultTreeModel(node);
        }
        targetComponent.setModel(mi2);
        if (this.getMultipleSelections() && !targetComponent.getMultipleSelections()) {
            targetComponent.setSelectionMode(3);
        }
        targetComponent.setRequest(this.getRequest());
        sourceComponent.setResponse(this.getResponse());
        sourceComponent.setLocale(this.getLocale());
        if (this.getImageLocation() != null) {
            targetComponent.setImageLocation(this.getImageLocation());
        }
        targetComponent.setStyleClassPrefix(this.getStyleClassPrefix());
        if (this.getTargetNode() != null) {
            targetComponent.setRootNodeVisible(false);
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "DUALTREESELECTOR", this.getRequest());
        this.writeSelectorHeader(out);
        if (this.getTargetNode() != null) {
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println(this.getTargetComponentName() + ".targetNode = sas_TreeView_basicFindNode(\"" + this.getTargetNode() + "\");");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
        this.writeSelectorFooter(out);
        long n = Util.getNumber();
        out.println(JavaScriptIncludeHandler.getStartScript() + "function sas_DualTreeSelector_moveToTarget" + n + "() {" + this.getMoveToTarget() + "\n}\nif (typeof " + this.getSourceComponentName() + " != \"undefined\")\n\t" + this.getSourceComponentName() + ".ondblclick = sas_DualTreeSelector_moveToTarget" + n + ";\nfunction sas_DualTreeSelector_removeFromTarget" + n + "() {" + this.getRemoveFromTarget() + "\n}\nif (typeof " + this.getTargetComponentName() + " != \"undefined\")\n\t" + this.getTargetComponentName() + ".ondblclick = sas_DualTreeSelector_removeFromTarget" + n + ";\nsas_DualTreeSelectorInit('" + this.getSourceComponentName() + "','" + this.getTargetComponentName() + "');\n" + JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel treeModel) {
        this.model = treeModel;
    }

    public TreeModel getTargetModel() {
        if (this.targetModel == null) {
            TreeNode node = new TreeNode("selection", RB.getStringResource(RB_KEY, "root.txt", this.getLocale()));
            this.targetModel = new DefaultTreeModel(node);
            TreeView targetComponent = (TreeView)this.getTargetComponent();
            targetComponent.setRootNodeVisible(false);
        }
        return this.targetModel;
    }

    public void setTargetModel(TreeModel treeModel) {
        this.targetModel = treeModel;
    }

    @Override
    protected String getMoveToTarget() {
        StringBuffer moveToTarget = new StringBuffer();
        if (this.getPreTargetTrigger() != null) {
            moveToTarget.append("if (").append(this.getPreTargetTrigger()).append(") \n");
        }
        moveToTarget.append("   moveToTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
        moveToTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(COMMA);
        moveToTarget.append(this.isTargetDuplicateAllowed()).append(COMMA).append(this.getTargetMaximumCount()).append(");");
        if (this.getPostTargetTrigger() != null) {
            moveToTarget.append(this.getPostTargetTrigger()).append(";");
        }
        return moveToTarget.toString();
    }

    @Override
    protected String getRemoveFromTarget() {
        StringBuffer removeFromTarget = new StringBuffer();
        if (this.getPreSourceTrigger() != null) {
            removeFromTarget.append("if (").append(this.getPreSourceTrigger()).append(")  \n");
        }
        removeFromTarget.append("   removeFromTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
        removeFromTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(", true, true,'listview');");
        if (this.getPostSourceTrigger() != null) {
            removeFromTarget.append(this.getPostSourceTrigger()).append(";");
        }
        return removeFromTarget.toString();
    }

    @Override
    protected String getRemoveAllFromTarget() {
        StringBuffer removeAllFromTarget = new StringBuffer();
        if (this.getPreSourceTrigger() != null) {
            removeAllFromTarget.append("if (").append(this.getPreSourceTrigger()).append(") ");
        }
        removeAllFromTarget.append("   removeAllFromTarget('").append(this.getSourceComponentName());
        removeAllFromTarget.append(QUOTE_COMMA_QUOTE).append(this.getTargetComponentName()).append(QUOTE_COMMA);
        removeAllFromTarget.append(this.isStaticSourceAllowed()).append(", false ,'listview');");
        if (this.getPostSourceTrigger() != null) {
            removeAllFromTarget.append(this.getPostSourceTrigger()).append(";");
        }
        return removeAllFromTarget.toString();
    }

    @Override
    protected String getMoveAllToTarget() {
        StringBuffer moveAllToTarget = new StringBuffer();
        if (this.getPreTargetTrigger() != null) {
            moveAllToTarget.append("if (").append(this.getPreTargetTrigger()).append(") ");
        }
        moveAllToTarget.append("   moveAllToTarget('").append(this.getSourceComponentName()).append(QUOTE_COMMA_QUOTE);
        moveAllToTarget.append(this.getTargetComponentName()).append(QUOTE_COMMA).append(this.isStaticSourceAllowed()).append(COMMA);
        moveAllToTarget.append(this.isTargetDuplicateAllowed()).append(COMMA).append(this.getTargetMaximumCount()).append(");");
        if (this.getPostTargetTrigger() != null) {
            moveAllToTarget.append(this.getPostTargetTrigger()).append(";");
        }
        return moveAllToTarget.toString();
    }

    @Override
    protected String getMoveItemsUp() {
        StringBuffer moveUp = new StringBuffer();
        if (this.getPreUpTrigger() != null) {
            moveUp.append("if (").append(this.getPreUpTrigger()).append(") ");
        }
        moveUp.append("moveItemsUp('" + this.getTargetComponentName() + "', 'listview');");
        if (this.getPostUpTrigger() != null) {
            moveUp.append(this.getPostUpTrigger()).append(";");
        }
        return moveUp.toString();
    }

    @Override
    protected String getMoveItemsDown() {
        StringBuffer moveDown = new StringBuffer();
        if (this.getPreDownTrigger() != null) {
            moveDown.append("if (").append(this.getPreDownTrigger()).append(") ");
        }
        moveDown.append("moveItemsDown('" + this.getTargetComponentName() + "', 'listview');");
        if (this.getPostDownTrigger() != null) {
            moveDown.append(this.getPostDownTrigger()).append(";");
        }
        return moveDown.toString();
    }

    @Override
    protected String getSubmitAction() {
        StringBuffer sb = new StringBuffer();
        return sb.append("sas_DualTreeSelector_submitSelection('").append(this.getFormObject().getName()).append(QUOTE_COMMA_QUOTE).append(this.getTargetComponentName()).append("')").toString();
    }

    @Override
    public BaseTransformation getDefaultComponent() {
        return new TreeView();
    }

    public String getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(String targetNode) {
        this.targetNode = targetNode;
    }

    @Override
    protected void setDefaultComponentNames() {
        TransformationInterface targetLabel;
        super.setDefaultComponentNames();
        String name = this.getId();
        TransformationInterface sourceLabel = this.getComponent("DUALSELECTOR_SOURCE_LABEL");
        if (sourceLabel instanceof Label) {
            ((Label)sourceLabel).setFor(name + "_source" + "_Div");
        }
        if ((targetLabel = this.getComponent("DUALSELECTOR_TARGET_LABEL")) instanceof Label) {
            ((Label)targetLabel).setFor(name + "_Div");
        }
    }

    private void setTreeDefaults() {
        TreeView sourceTree = (TreeView)this.getSourceComponent();
        sourceTree.setSelectionMode(1);
        TreeView targetTree = (TreeView)this.getTargetComponent();
        targetTree.setSelectionMode(1);
    }

    static {
        JavaScriptIncludeHandler.addAlias(DualTreeSelector.class, "DUALTREESELECTOR");
    }
}

