/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dualselector.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dualselector.BaseDualSelector;
import com.sas.servlet.tbeans.dualselector.html.DualSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dualselector.html.RB;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope(value="ALL")
public abstract class DualSelector
extends BaseDualSelector
implements FormViewInterface,
DualSelectorStyleKeysInterface {
    private String postSourceTrigger;
    private String preSourceTrigger;
    private String postTargetTrigger;
    private String preTargetTrigger;
    private String postUpTrigger;
    private String preUpTrigger;
    private String postDownTrigger;
    private String preDownTrigger;
    private HashMap additionalParameters;
    private boolean formEnabled;
    private boolean initialized;
    private Form formObject;
    @SASScope
    protected String type = "DUALLIST";
    public static final String RB_KEY = "DualSelector.";
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo DualSelectorContainerStyle = new ImmutableStyleInfo("dualSelectorContainer");
    private static final ImmutableStyleInfo DualSelectorSourceContainerStyle = new ImmutableStyleInfo("dualSelectorSourceContainer");
    private static final ImmutableStyleInfo DualSelectorTargetContainerStyle = new ImmutableStyleInfo("dualSelectorTargetContainer");
    private static final ImmutableStyleInfo DualSelectorSourceStyle = new ImmutableStyleInfo("dualSelectorSource");
    private static final ImmutableStyleInfo DualSelectorTargetStyle = new ImmutableStyleInfo("dualSelectorTarget");
    private static final ImmutableStyleInfo DualSelectorSourceLabelStyle = new ImmutableStyleInfo("dualSelectorSourceLabel");
    private static final ImmutableStyleInfo DualSelectorTargetLabelStyle = new ImmutableStyleInfo("dualSelectorTargetLabel");
    private static final ImmutableStyleInfo DualSelectorButtonStyle = new ImmutableStyleInfo("button dualSelectorButton");

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("DUALSELECTOR_CONTAINER", DualSelectorContainerStyle);
            defaultStyleMap.put("DUALSELECTOR_SOURCE_CONTAINER", DualSelectorSourceContainerStyle);
            defaultStyleMap.put("DUALSELECTOR_TARGET_CONTAINER", DualSelectorTargetContainerStyle);
            defaultStyleMap.put("DUALSELECTOR_SOURCE_LISTBOX", DualSelectorSourceStyle);
            defaultStyleMap.put("DUALSELECTOR_TARGET_LISTBOX", DualSelectorTargetStyle);
            defaultStyleMap.put("DUALSELECTOR_SOURCE_LABEL_AREA", DualSelectorSourceLabelStyle);
            defaultStyleMap.put("DUALSELECTOR_TARGET_LABEL_AREA", DualSelectorTargetLabelStyle);
            defaultStyleMap.put("DUALSELECTOR_BUTTON", DualSelectorButtonStyle);
        }
    }

    public DualSelector() {
        this(Util.getName((String)"dsel"));
    }

    public DualSelector(String name) {
        BaseButton downButton;
        BaseButton upButton;
        BaseButton leftAllButton;
        Button leftButton;
        BaseButton rightAllButton;
        this.setId(name);
        this.setTargetButtonsVisible(true);
        this.setTransferAllButtonVisible(true);
        this.setSubmitButtonVisible(true);
        this.setFormEnabled(true);
        this.setStyleClassPrefix("");
        this.setStaticSourceAllowed(false);
        this.setSourceAlphabetized(false);
        this.setTargetAlphabetized(false);
        this.setTargetDuplicateAllowed(false);
        this.setTargetMaximumCount(-1);
        this.setSize(12);
        DualSelector.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponent("DUALSELECTOR_SOURCE", this.getSourceComponent());
        this.setComponent("DUALSELECTOR_TARGET", this.getTargetComponent());
        this.setComponent("DUALSELECTOR_SOURCE_LABEL", this.getSourceLabel());
        this.setComponent("DUALSELECTOR_TARGET_LABEL", this.getTargetLabel());
        HashMap<String, ImmutableStyleInfo> defaultMap = new HashMap<String, ImmutableStyleInfo>();
        defaultMap.put("BUTTON_STYLE", DualSelectorButtonStyle);
        BaseButton rightButton = this.getMoveRightButton();
        if (rightButton instanceof ComplexStyleInterface) {
            ((Button)rightButton).getStyleMap().putAll(defaultMap);
        }
        if ((rightAllButton = this.getMoveAllRightButton()) instanceof ComplexStyleInterface) {
            ((Button)rightAllButton).getStyleMap().putAll(defaultMap);
        }
        if ((leftButton = (Button)this.getMoveLeftButton()) instanceof ComplexStyleInterface) {
            leftButton.getStyleMap().putAll(defaultMap);
        }
        if ((leftAllButton = this.getMoveAllLeftButton()) instanceof ComplexStyleInterface) {
            ((Button)leftAllButton).getStyleMap().putAll(defaultMap);
        }
        if ((upButton = this.getMoveUpButton()) instanceof ComplexStyleInterface) {
            ((Button)upButton).getStyleMap().putAll(defaultMap);
        }
        if ((downButton = this.getMoveDownButton()) instanceof ComplexStyleInterface) {
            ((Button)downButton).getStyleMap().putAll(defaultMap);
        }
        BaseButton submitButton = this.getSubmitButton();
        this.setComponent("DUALSELECTOR_RIGHT_BUTTON", rightButton);
        this.setComponent("DUALSELECTOR_LEFT_BUTTON", leftButton);
        this.setComponent("DUALSELECTOR_RIGHT_ALL_BUTTON", rightAllButton);
        this.setComponent("DUALSELECTOR_LEFT_ALL_BUTTON", leftAllButton);
        this.setComponent("DUALSELECTOR_UP_BUTTON", upButton);
        this.setComponent("DUALSELECTOR_DOWN_BUTTON", downButton);
        this.setComponent("DUALSELECTOR_SUBMIT_BUTTON", submitButton);
        ((Button)this.getSubmitButton()).setButtonType(3);
        this.initialized = false;
    }

    protected abstract String getRemoveFromTarget();

    protected abstract String getRemoveAllFromTarget();

    protected abstract String getMoveToTarget();

    protected abstract String getMoveItemsUp();

    protected abstract String getMoveItemsDown();

    protected abstract String getMoveAllToTarget();

    protected abstract String getSubmitAction();

    protected void setSelectorDefaults() {
        if (!this.initialized) {
            BaseButton submitButton;
            BaseLabel targetLabel;
            BaseLabel sourceLabel;
            BaseButton rightButton = this.getMoveRightButton();
            rightButton.setOnClick(this.getMoveToTarget());
            if (rightButton.getImage() == null && rightButton.getLabel() == null) {
                rightButton.setImageKey("Arrow_Right_Add");
            }
            if (rightButton.getAlternateText() == null) {
                rightButton.setAlternateText(RB.getStringResource(RB_KEY, "moveRightButtonAlt.txt", this.getLocale()));
            }
            if (rightButton.getTitle() == null) {
                rightButton.setTitle(RB.getStringResource(RB_KEY, "moveRightButtonAlt.txt", this.getLocale()));
            }
            BaseButton rightAllButton = this.getMoveAllRightButton();
            rightAllButton.setOnClick(this.getMoveAllToTarget());
            if (rightAllButton.getImage() == null && rightAllButton.getLabel() == null) {
                rightAllButton.setImageKey("Arrow_Right_Add_All");
            }
            if (rightAllButton.getAlternateText() == null) {
                rightAllButton.setAlternateText(RB.getStringResource(RB_KEY, "moveRightAllButtonAlt.txt", this.getLocale()));
            }
            if (rightAllButton.getTitle() == null) {
                rightAllButton.setTitle(RB.getStringResource(RB_KEY, "moveRightAllButtonAlt.txt", this.getLocale()));
            }
            BaseButton leftButton = this.getMoveLeftButton();
            leftButton.setOnClick(this.getRemoveFromTarget());
            if (leftButton.getImage() == null && leftButton.getLabel() == null) {
                leftButton.setImageKey("Arrow_Left_Remove");
            }
            if (leftButton.getAlternateText() == null) {
                leftButton.setAlternateText(RB.getStringResource(RB_KEY, "moveLeftButtonAlt.txt", this.getLocale()));
            }
            if (leftButton.getTitle() == null) {
                leftButton.setTitle(RB.getStringResource(RB_KEY, "moveLeftButtonAlt.txt", this.getLocale()));
            }
            BaseButton leftAllButton = this.getMoveAllLeftButton();
            leftAllButton.setOnClick(this.getRemoveAllFromTarget());
            if (leftAllButton.getImage() == null && leftAllButton.getLabel() == null) {
                leftAllButton.setImageKey("Arrow_Left_Remove_All");
            }
            if (leftAllButton.getAlternateText() == null) {
                leftAllButton.setAlternateText(RB.getStringResource(RB_KEY, "moveLeftAllButtonAlt.txt", this.getLocale()));
            }
            if (leftAllButton.getTitle() == null) {
                leftAllButton.setTitle(RB.getStringResource(RB_KEY, "moveLeftAllButtonAlt.txt", this.getLocale()));
            }
            BaseButton upButton = this.getMoveUpButton();
            upButton.setOnClick(this.getMoveItemsUp());
            if (upButton.getImage() == null && upButton.getLabel() == null) {
                upButton.setImageKey("Arrow_Up_Default");
            }
            if (upButton.getAlternateText() == null) {
                upButton.setAlternateText(RB.getStringResource(RB_KEY, "moveUpButtonAlt.txt", this.getLocale()));
            }
            if (upButton.getTitle() == null) {
                upButton.setTitle(RB.getStringResource(RB_KEY, "moveUpButtonAlt.txt", this.getLocale()));
            }
            BaseButton downButton = this.getMoveDownButton();
            downButton.setOnClick(this.getMoveItemsDown());
            if (downButton.getImage() == null && downButton.getLabel() == null) {
                downButton.setImageKey("Arrow_Down_Default");
            }
            if (downButton.getAlternateText() == null) {
                downButton.setAlternateText(RB.getStringResource(RB_KEY, "moveDownButtonAlt.txt", this.getLocale()));
            }
            if (downButton.getTitle() == null) {
                downButton.setTitle(RB.getStringResource(RB_KEY, "moveDownButtonAlt.txt", this.getLocale()));
            }
            if ((sourceLabel = this.getSourceLabel()).getText() == null) {
                sourceLabel.setText(RB.getStringResource(RB_KEY, "source.txt", this.getLocale()));
            }
            if ((targetLabel = this.getTargetLabel()).getText() == null) {
                targetLabel.setText(RB.getStringResource(RB_KEY, "target.txt", this.getLocale()));
            }
            if ((submitButton = this.getSubmitButton()).getLabel() == null && submitButton.getImage() == null) {
                submitButton.setLabel(RB.getStringResource(RB_KEY, "submit.txt", this.getLocale()));
            }
            submitButton.setOnClick(this.getSubmitAction());
            if (!this.isSubmitButtonVisible()) {
                this.getSubmitButton().setVisible(false);
            }
            if (!this.isTargetButtonsVisible()) {
                this.getMoveUpButton().setVisible(false);
                this.getMoveDownButton().setVisible(false);
            }
            if (!this.isTransferAllButtonVisible()) {
                this.getMoveAllRightButton().setVisible(false);
                this.getMoveAllLeftButton().setVisible(false);
            }
        }
    }

    private String getImageURI(String imageKey) {
        return ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(imageKey, this.imageLocation);
    }

    protected void setDefaultComponentNames() {
        String name = this.getId();
        this.getComponent("DUALSELECTOR_SOURCE").setName(name + "_source");
        ((BaseTransformation)this.getComponent("DUALSELECTOR_SOURCE")).setId(name + "_source");
        this.getComponent("DUALSELECTOR_TARGET").setName(name);
        ((BaseTransformation)this.getComponent("DUALSELECTOR_TARGET")).setId(name);
        ((Label)this.getComponent("DUALSELECTOR_SOURCE_LABEL")).setFor(name + "_source");
        this.getComponent("DUALSELECTOR_SOURCE_LABEL").setName(name + "_sourceLabel");
        ((Label)this.getComponent("DUALSELECTOR_TARGET_LABEL")).setFor(name);
        this.getComponent("DUALSELECTOR_TARGET_LABEL").setName(name + "_targetLabel");
        this.getComponent("DUALSELECTOR_RIGHT_BUTTON").setName(name + "_rightButton");
        this.getComponent("DUALSELECTOR_RIGHT_ALL_BUTTON").setName(name + "_rightAllButton");
        this.getComponent("DUALSELECTOR_LEFT_BUTTON").setName(name + "_leftButton");
        this.getComponent("DUALSELECTOR_LEFT_ALL_BUTTON").setName(name + "_leftAllButton");
        this.getComponent("DUALSELECTOR_UP_BUTTON").setName(name + "_upButton");
        this.getComponent("DUALSELECTOR_DOWN_BUTTON").setName(name + "_downButton");
        this.getComponent("DUALSELECTOR_SUBMIT_BUTTON").setName(name + "_submitButton");
    }

    @SASScope
    public void writeFormHeader(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormHeader(o);
        o.flush();
    }

    @SASScope
    public void writeFormHeader(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormHeader(o);
        o.flush();
    }

    @SASScope
    public void writeFormFooter(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormFooter(o);
        o.flush();
    }

    @SASScope
    public void writeFormFooter(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeFormFooter(o);
        o.flush();
    }

    @SASScope
    public void writeFormHeader(PrintWriter out) throws IOException {
        this.getFormObject().writeHeader(out);
    }

    @SASScope
    public void writeFormFooter(PrintWriter out) throws IOException {
        this.getFormObject().writeFooter(out);
    }

    @SASScope
    protected void writeSelectorHeader(PrintWriter out) throws IOException {
        this.setSelectorDefaults();
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        if (this.isFormEnabled()) {
            this.getFormObject().writeHeader(out);
        }
        BaseUtil.writeAdditionalParameters(this.getAdditionalParameters(), out);
        this.writeTemplate(this, null, out);
    }

    @SASScope
    protected void writeSelectorFooter(PrintWriter out) throws IOException {
        String epilog;
        if (this.isFormEnabled()) {
            this.getFormObject().writeFooter(out);
        }
        if ((epilog = this.getTagEpilog()) != null) {
            out.write(epilog);
        }
    }

    public void setPostSourceTrigger(String value) {
        this.postSourceTrigger = value;
    }

    public String getPostSourceTrigger() {
        return this.postSourceTrigger;
    }

    public void setPreSourceTrigger(String value) {
        this.preSourceTrigger = value;
    }

    public String getPreSourceTrigger() {
        return this.preSourceTrigger;
    }

    public String getPostTargetTrigger() {
        return this.postTargetTrigger;
    }

    public void setPostTargetTrigger(String value) {
        this.postTargetTrigger = value;
    }

    public String getPreTargetTrigger() {
        return this.preTargetTrigger;
    }

    public void setPreTargetTrigger(String value) {
        this.preTargetTrigger = value;
    }

    public String getPostUpTrigger() {
        return this.postUpTrigger;
    }

    public void setPostUpTrigger(String value) {
        this.postUpTrigger = value;
    }

    public String getPreUpTrigger() {
        return this.preUpTrigger;
    }

    public void setPreUpTrigger(String value) {
        this.preUpTrigger = value;
    }

    public String getPostDownTrigger() {
        return this.postDownTrigger;
    }

    public void setPostDownTrigger(String value) {
        this.postDownTrigger = value;
    }

    public String getPreDownTrigger() {
        return this.preDownTrigger;
    }

    public void setPreDownTrigger(String value) {
        this.preDownTrigger = value;
    }

    @Override
    public void setFormObject(Form form) {
        this.formObject = form;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    @Override
    public Form getDefaultFormObject() {
        HttpServletResponse response;
        Form f = new Form(this.getId() + "_Form");
        String action = "";
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            action = request.getRequestURI();
        }
        if ((response = this.getResponse()) != null) {
            action = response.encodeURL(action);
        }
        f.setAction(action);
        return f;
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    @Override
    public void setFormEnabled(boolean value) {
        this.formEnabled = value;
    }

    @Override
    protected BaseButton getDefaultButton() {
        Button button = new Button();
        button.setRequest(this.getRequest());
        button.setResponse(this.getResponse());
        button.setLocale(this.getLocale());
        button.setButtonType(4);
        return button;
    }

    @Override
    protected BaseLabel getDefaultLabel() {
        Label label = new Label();
        label.setRequest(this.getRequest());
        label.setResponse(this.getResponse());
        label.setLocale(this.getLocale());
        return label;
    }

    @SASScope
    public void writeSelector(PrintWriter out) throws IOException {
        this.setSelectorDefaults();
        if (this.getTargetMaximumCount() > -1) {
            Hidden.writeElement(out, null, this.getName() + "_list1_srcselected", "", false);
            Hidden.writeElement(out, null, this.getName() + "_list1_numsrcselected", "", false);
        }
        this.writeTemplate(this, this.getDefaultSelectorTemplate(), out);
    }

    @SASScope
    public void writeSelector(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeSelector(o);
        o.flush();
    }

    @SASScope
    public void writeSelector(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeSelector(o);
        o.flush();
    }

    @SASScope
    public void writeButton(PrintWriter out) throws IOException {
        this.setSelectorDefaults();
        this.writeTemplate(this, this.getDefaultButtonTemplate(), out);
    }

    @SASScope
    public void writeButton(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeButton(o);
        o.flush();
    }

    @SASScope
    public void writeButton(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeButton(o);
        o.flush();
    }

    @SASScope
    public void writeMoveUpDownButtons(PrintWriter out) throws IOException {
        this.setSelectorDefaults();
        this.writeTemplate(this, this.getDefaultMoveUpDownButtonTemplate(), out);
    }

    @SASScope
    public void writeMoveButtons(PrintWriter out) throws IOException {
        this.setSelectorDefaults();
        this.writeTemplate(this, this.getDefaultMoveButtonTemplate(), out);
    }

    protected String getDefaultMoveButtonTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("%DUALSELECTOR_RIGHT_BUTTON %DUALSELECTOR_LEFT_BUTTON <br><br>%DUALSELECTOR_RIGHT_ALL_BUTTON %DUALSELECTOR_LEFT_ALL_BUTTON");
        return template.toString();
    }

    protected String getDefaultMoveUpDownButtonTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("<table><tr>");
        template.append("  <td>%DUALSELECTOR_UP_BUTTON</td><td>%DUALSELECTOR_DOWN_BUTTON</td>");
        template.append("</tr></table>\n");
        return template.toString();
    }

    protected String getDefaultButtonTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("%DUALSELECTOR_SUBMIT_BUTTON");
        return template.toString();
    }

    protected String getDefaultSelectorTemplate() {
        return "";
    }

    @Override
    public String getDefaultTemplate() {
        return "";
    }

    protected String getSourceComponentName() {
        return this.getComponent("DUALSELECTOR_SOURCE").getName();
    }

    protected String getTargetComponentName() {
        return this.getComponent("DUALSELECTOR_TARGET").getName();
    }

    @Override
    public void setName(String value) {
        this.setId(value);
    }

    @Override
    public void setId(String value) {
        String sourceName;
        TransformationInterface source;
        String previousName = this.getId();
        if (previousName != null && this.getComponent("DUALSELECTOR_TARGET").getName().equals(previousName)) {
            this.getComponent("DUALSELECTOR_TARGET").setName(value);
        }
        if ((source = this.getComponent("DUALSELECTOR_SOURCE")) != null && (sourceName = source.getName()).startsWith(previousName)) {
            source.setName(value + "_source");
        }
        super.setId(value);
    }

    public void initializeSelector() {
        this.setSelectorDefaults();
        this.initialized = true;
    }
}

