/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource.directoryfile;

import com.sas.iom.SAS.IWorkspace;
import com.sas.models.FileLocation;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourcePicker;
import com.sas.servlet.tbeans.datasource.DataSourceValidationException;
import com.sas.servlet.tbeans.datasource.DataSourceValidationInterface;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.datasource.directoryfile.DirectoryFileDialog;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.text.Message;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DirectoryFilePicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface,
DataSourceValidationInterface {
    protected TextEntry textEntry;
    protected Button rfsButton;
    private DirectoryFileDialog dialog;
    private IWorkspace iworkspace;
    private List fileTypes;
    private String logicalServerName;
    private FileLocation fileLocation;
    private String type = "OUTPUT_TYPE";
    private UserContextInterface userContext;
    private boolean directoriesOnly = false;
    private boolean directoriesOnlyCheckBoxVisible = true;
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "DirectoryFilePicker.html";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=" + DirectoryFilePicker.class.getName() + "&" + "METHOD" + "=openDirectoryFileViewer&id=%id";

    public DirectoryFilePicker(IWorkspace iworkspace, List fileTypes) {
        this.iworkspace = iworkspace;
        this.fileTypes = fileTypes;
        this.fileLocation = new FileLocation(null, null);
        this.initialize();
    }

    public DirectoryFilePicker(UserContextInterface userContext, String logicalServerName, List fileTypes) {
        this.userContext = userContext;
        this.fileTypes = fileTypes;
        this.logicalServerName = logicalServerName;
        this.fileLocation = new FileLocation(null, null);
        this.initialize();
    }

    private void initialize() {
        this.setObjectDataProperty("text");
        this.setId(Util.getName((String)"fp"));
        this.setTemplateKey("Directory_File_Picker");
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.addComponents();
    }

    public void setText(String value) {
        if (value != null) {
            this.fileLocation.parseString(value);
            this.textEntry.setText(this.fileLocation.getFileLocation());
        } else {
            this.textEntry.setText("");
        }
    }

    public IWorkspace getIWorkspace() {
        return this.iworkspace;
    }

    public List getFileTypes() {
        return this.fileTypes;
    }

    protected void addComponents() {
        this.textEntry = new TextEntry();
        this.textEntry.setSize(50);
        this.textEntry.setId(this.getId() + "_textEntry");
        this.setComponent(DataSourcePicker.DATASOURCE_TEXT, this.textEntry);
        this.rfsButton = new Button();
        this.rfsButton.setId(this.getId() + "_button");
        this.setComponent(DataSourcePicker.DATASOURCE_BUTTON, this.rfsButton);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.rfsButton != null) {
            this.rfsButton.setLabel(RB.getStringResource("DataPicker.", "browse.txt", currentLocale));
        }
    }

    protected void setup() {
        if (this.rfsButton != null) {
            this.rfsButton.setOnClick(this.getId() + "_Obj.openDirectoryFileDialog()");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "DIRECTORYFILEPICKER", this.getRequest());
        this.setup();
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    protected void writeJavaScript(PrintWriter out) throws IOException {
        this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        StringBuffer sb = new StringBuffer().append(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        sb.append(jsObj).append(" = new sas_DirectoryFilePicker('").append(this.getId()).append("');\n");
        sb.append(jsObj).append(".url= \"").append(this.getURLTemplate().format()).append("\";");
        sb.append(jsObj + ".servername = \"" + this.getLogicalServerName() + "\";");
        sb.append(jsObj + ".separator = \" " + "@@" + " \";");
        if (this.isDirectoriesOnly()) {
            sb.append(jsObj + ".dirOnly = \"true\";");
        } else {
            sb.append(jsObj + ".dirOnly = \"false\";");
        }
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    public static void openDirectoryFileViewer(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof DirectoryFilePicker) {
            DirectoryFileDialog selectorPanel;
            PrintWriter out = response.getWriter();
            DirectoryFilePicker picker = (DirectoryFilePicker)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                picker.getActionProvider().executeCommand(request, response, out);
            }
            if ((selectorPanel = picker.getDialog()) == null) {
                picker.initializeDirectoryFileDialog();
                selectorPanel = picker.getDialog();
                selectorPanel.setRequest(request);
                selectorPanel.setResponse(response);
                selectorPanel.setActionProvider(picker.getActionProvider());
                ComponentSessionManager.getSessionManager(request).put(selectorPanel.getId(), selectorPanel);
            } else {
                selectorPanel.resetWorkspace();
                selectorPanel.setRequest(request);
                selectorPanel.setResponse(response);
            }
            BaseUtil.writeDialog(out, request, selectorPanel, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public DirectoryFileDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(DirectoryFileDialog fileSelectorPanel) {
        this.dialog = fileSelectorPanel;
    }

    public void initializeDirectoryFileDialog() {
        if (this.dialog == null) {
            DirectoryFileDialog filedialog;
            try {
                filedialog = new DirectoryFileDialog(this.getId() + "_directoryFileDialog", this.userContext, this.logicalServerName, this.fileTypes, this.isDirectoriesOnly());
            }
            catch (ServerConnectionException e) {
                filedialog = new DirectoryFileDialog(this.getId() + "_directoryFileDialog", this.getIWorkspace(), this.fileTypes, this.isDirectoriesOnly());
            }
            filedialog.setOnChange(this.getOnChange());
            filedialog.setCallerId(this.getId());
            filedialog.setDirectoriesOnlyCheckBoxVisible(this.isDirectoriesOnlyCheckBoxVisible());
            this.setDialog(filedialog);
        }
    }

    @Override
    public void setOnChange(String eventHandler) {
        this.textEntry.setOnChange(eventHandler);
    }

    @Override
    public String getOnChange() {
        return this.textEntry.getOnChange();
    }

    @Override
    public void setOnFocus(String value) {
        this.textEntry.setOnFocus(value);
    }

    @Override
    public String getOnFocus() {
        return this.textEntry.getOnFocus();
    }

    @Override
    public void setOnBlur(String value) {
        this.textEntry.setOnBlur(value);
    }

    @Override
    public String getOnBlur() {
        return this.textEntry.getOnBlur();
    }

    public String getLogicalServerName() {
        return this.logicalServerName;
    }

    public void setLogicalServerName(String logicalServerName) {
        this.logicalServerName = logicalServerName;
    }

    public boolean isDirectoriesOnly() {
        return this.directoriesOnly;
    }

    public void setDirectoriesOnly(boolean directoriesOnly) {
        this.directoriesOnly = directoriesOnly;
    }

    public boolean isDirectoriesOnlyCheckBoxVisible() {
        return this.directoriesOnlyCheckBoxVisible;
    }

    public void setDirectoriesOnlyCheckBoxVisible(boolean directoriesOnlyCheckBoxVisible) {
        this.directoriesOnlyCheckBoxVisible = directoriesOnlyCheckBoxVisible;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        if (this.getDialog() != null) {
            this.getDialog().cleanup(session);
        }
    }

    public String getType() {
        if (this.type.equals("INPUT_TYPE")) {
            return "INPUT_TYPE";
        }
        return "OUTPUT_TYPE";
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate(Object value, Locale locale) throws Exception {
        if (this.getType().equals("INPUT_TYPE") && value instanceof String) {
            String fullValue = (String)value;
            String fileName = fullValue.substring(fullValue.indexOf("@@") + "@@".length(), fullValue.lastIndexOf("@@"));
            fileName = fileName.trim();
            IWorkspace _iworkspace = this.getIWorkspace();
            DataProvider dataProvider = null;
            if (_iworkspace == null && this.logicalServerName != null) {
                dataProvider = new DataProvider(this.userContext);
                _iworkspace = dataProvider.getIWorkspace(this.logicalServerName);
            }
            String type = IFileServiceAdapterSupport.getFileType((IWorkspace)_iworkspace, null, null, (String)fileName);
            if (this.isDirectoriesOnly()) {
                if (type == null) {
                    String error = new Message(com.sas.swing.visuals.RB.getStringResource((String)"IFilePicker.", (String)"directoryDoesNotExist.ex.txt", (Locale)locale), (Object)fileName).toString();
                    throw new DataSourceValidationException(error);
                }
                if (!type.equals("FOLDER")) {
                    String error = new Message(com.sas.swing.visuals.RB.getStringResource((String)"IFilePicker.", (String)"notADirectory.ex.txt", (Locale)locale), (Object)fileName).toString();
                    throw new DataSourceValidationException(error);
                }
            } else if (type == null) {
                String error = new Message(com.sas.swing.visuals.RB.getStringResource((String)"IFilePicker.", (String)"doesNotExists.ex.txt", (Locale)locale), (Object)fileName).toString();
                throw new DataSourceValidationException(error);
            }
            if (dataProvider != null) {
                dataProvider.close();
            }
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(DirectoryFilePicker.class, "DIRECTORYFILEPICKER");
    }
}

