/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource.directoryfile;

import com.sas.iom.SAS.IWorkspace;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation2;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.dataselectors.SelectorContainerKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.SelectorContainerStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.directoryfile.DirectoryFileDialogKeysInterface;
import com.sas.servlet.tbeans.datasource.directoryfile.DirectoryFileDialogStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.directoryfile.RB;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.remotefileselector2.directoryfile.DirectoryFileViewer;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.BaseIFileServiceTreeModel;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.IFileServiceTreeNavigationModel;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DirectoryFileDialog
extends BaseCompositeTransformation2
implements DirectoryFileDialogStyleKeysInterface,
DirectoryFileDialogKeysInterface,
SelectorContainerStyleKeysInterface,
SelectorContainerKeysInterface {
    private static final long serialVersionUID = -8190384233826042100L;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DirectoryFileDialog.html";
    private static Map defaultStyleMap = null;
    private CommonLoggerInterface log = null;
    private IWorkspace iworkspace = null;
    private String callerId;
    private String onChange;
    private UserContextInterface userContext;
    private String logicalServerName;
    private DataProvider dataProvider;
    private boolean directoriesOnlyCheckBoxVisible = true;
    private SimpleTemplate ajaxURLTemplate;
    public static final String RB_KEY = "DirectoryFileDialog.";

    public DirectoryFileDialog(String id, IWorkspace iworkspace, List fileTypes) {
        this(id, iworkspace, fileTypes, false);
    }

    public DirectoryFileDialog(String id) {
        this.initialize(id, null, null, false);
    }

    public DirectoryFileDialog(String id, IWorkspace iworkspace, List fileTypes, boolean directoriesOnly) {
        this.initialize(id, iworkspace, fileTypes, directoriesOnly);
    }

    public DirectoryFileDialog(String id, UserContextInterface userContext, String logicalServerName, List fileTypes, boolean directoriesOnly) throws ServerConnectionException {
        this.userContext = userContext;
        this.logicalServerName = logicalServerName;
        this.dataProvider = new DataProvider(userContext);
        this.initialize(id, this.dataProvider.getIWorkspace(logicalServerName), fileTypes, directoriesOnly);
    }

    private void initialize(String id, IWorkspace iworkspace, List fileTypes, boolean directoriesOnly) {
        this.iworkspace = iworkspace;
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        this.setId(id);
        this.setTemplateKey("Directory_File_Dialog");
        this.addComponents(directoriesOnly);
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this._setLocaleDependentProperties(this.getLocale());
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(BaseUtil.AJAX_BASEUTIL_URL_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
    }

    public void resetWorkspace() {
        DirectoryFileViewer dfv = (DirectoryFileViewer)this.getComponent("DIRECTORY_FILE_VIEWER");
        if (dfv != null & this.iworkspace != null) {
            this.dataProvider = new DataProvider(this.userContext);
            try {
                dfv.getTreeNavigationModel().setWorkspace(this.dataProvider.getIWorkspace(this.logicalServerName));
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addComponents(boolean directoriesOnly) {
        IFileServiceTreeNavigationModel ifstnm = null;
        ifstnm = this.iworkspace != null ? new IFileServiceTreeNavigationModel(this.iworkspace) : new IFileServiceTreeNavigationModel();
        this.setComponent("DIRECTORY_FILE_VIEWER", new DirectoryFileViewer(this.getId() + "_DirectoryFileViewer", (BaseIFileServiceTreeModel)ifstnm));
        ifstnm.setDirectoriesOnly(directoriesOnly);
        Button okButton = new Button();
        okButton.setOnClick(this.getId() + "_Obj.OKAction();");
        this.setComponent("SELECTORCONTAINER_OK_BUTTON", okButton);
        Button cancelButton = new Button();
        cancelButton.setOnClick(this.getId() + "_Obj.CancelAction();");
        this.setComponent("SELECTORCONTAINER_CANCEL_BUTTON", cancelButton);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        Button cancelButton;
        Button okButton = (Button)this.getComponent("SELECTORCONTAINER_OK_BUTTON");
        if (okButton != null) {
            okButton.setLabel(RB.getStringResource(RB_KEY, "ok.txt", locale));
        }
        if ((cancelButton = (Button)this.getComponent("SELECTORCONTAINER_CANCEL_BUTTON")) != null) {
            cancelButton.setLabel(RB.getStringResource(RB_KEY, "cancel.txt", locale));
        }
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "DIRECTORYFILEDIALOG", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        DirectoryFileViewer dfv = (DirectoryFileViewer)this.getComponent("DIRECTORY_FILE_VIEWER");
        CheckBox cb = (CheckBox)dfv.getComponent("DFV_FILE_CHECKBOX");
        if (cb != null) {
            cb.setVisible(this.isDirectoriesOnlyCheckBoxVisible());
        }
        this.setupTemplateDictionary();
        this.writeTemplate(this, null, out);
        this.writeScript(out);
    }

    protected void setupTemplateDictionary() {
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("SELECTORCONTAINER_BUTTON_ROW_ID", this.getId() + "_ButtonRow");
    }

    private void writeScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        out.println(jsObj + " = new sas_DirectoryFileDialog('" + this.getId() + "');");
        out.println(jsObj + ".callerId = \"" + this.getCallerId() + "\";");
        out.println(jsObj + ".onChangeEvent = \"" + this.getOnChange() + "\";");
        Map map = this.ajaxURLTemplate.getValueDictionary();
        map.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            map.put("AJAX_URL_SUFFIX", "?");
        } else {
            map.put("AJAX_URL_SUFFIX", "&");
        }
        out.println(jsObj + ".urlCombine = \"" + this.ajaxURLTemplate.format() + "\";");
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager();");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    public void setOnChange(String eventHandler) {
        this.onChange = eventHandler;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public boolean isDirectoriesOnlyCheckBoxVisible() {
        return this.directoriesOnlyCheckBoxVisible;
    }

    public void setDirectoriesOnlyCheckBoxVisible(boolean directoriesOnlyCheckBoxVisible) {
        this.directoriesOnlyCheckBoxVisible = directoriesOnlyCheckBoxVisible;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        this.closeResources();
    }

    public void closeResources() {
        if (this.dataProvider != null) {
            try {
                this.dataProvider.close();
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        defaultStyleMap = new HashMap();
        defaultStyleMap.put("DFD_CONTAINER", new ImmutableStyleInfo("dfd_Container"));
        defaultStyleMap.put("DFD_DFV_CONTAINER", new ImmutableStyleInfo("dfd_dfvContainer"));
        defaultStyleMap.put("SELECTOR_CONTAINER_OK_BUTTON", new ImmutableStyleInfo("SelectorContainerOKButton"));
        defaultStyleMap.put("SELECTOR_CONTAINER_CANCEL_BUTTON", new ImmutableStyleInfo("SelectorContainerCancelButton"));
        JavaScriptIncludeHandler.addAlias(DirectoryFileDialog.class, "DIRECTORYFILEDIALOG");
    }
}

