/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.actionprovider.Area;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.util.ISUtility;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.remotefileselector2.html.InformationServicesSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.DefaultComboBoxModel;

public class SASLibraryDialog
extends BaseCompositeTransformation
implements DataSourceDialogStyleKeysInterface,
DataSourceDialogKeysInterface {
    private static final long serialVersionUID = -8190384233826042100L;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DataSourceDialog.html";
    private static final String DEFAULT_RFS_TEMPLATE = "FileSelectorRemoteFileSelector.html";
    public static final String DATASOURCESELECTOR_CANCEL_BUTTON = "DATASOURCESELECTOR_CANCEL_BUTTON";
    private InformationServicesNavigationModel selectorModel = null;
    private InformationServicesSelector remoteFileSelector;
    private UserContextInterface userContext;
    private String callerId;
    private String onChange;
    private String onFocus;
    private String onBlur;
    protected DefaultComboBoxModel fileTypeModel;
    protected Label fileTypeLabel;
    protected ChoiceBox fileTypeChoiceBox;
    protected Button cancelButton;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo containerStyle = new ImmutableStyleInfo("dataSelectorPanelContainer");
    private static final ImmutableStyleInfo labelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo valueTextEntryStyle = new ImmutableStyleInfo("selectorTextEntry fileSelectorInput");
    private static final ImmutableStyleInfo fileTypeChoiceBoxStyle = new ImmutableStyleInfo("selectorChoice fileSelectorChoice");
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=%CLASS_PARAMETER&METHOD=%METHOD&id=%id";
    public static final String RB_KEY = "IFileDialog.";

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("FILE_PANEL_CONTAINER", containerStyle);
            defaultStyleMap.put("FILE_FILE_NAME_LABEL", labelStyle);
            defaultStyleMap.put("FILE_FILE_NAME_TEXTENTRY", valueTextEntryStyle);
            defaultStyleMap.put("FILE_FILE_TYPE_LABEL", labelStyle);
            defaultStyleMap.put("FILE_FILE_TYPE_CHOICEBOX", fileTypeChoiceBoxStyle);
        }
    }

    public SASLibraryDialog(UserContextInterface userContext) {
        this.userContext = userContext;
        this.setId(Util.getName((String)"ds_panel"));
        SASLibraryDialog.setupDefaultStyleMap();
        MapWithDefaults stylemap = (MapWithDefaults)this.getStyleMap();
        stylemap.setDefaultMap((Map)defaultStyleMap);
        this.setTemplateKey("Data_Source_Dialog");
        this.fileTypeLabel = new Label();
        this.fileTypeLabel.setId(this.getId() + "_fileTypeLabel");
        this.fileTypeLabel.setStyleInfo(labelStyle);
        this.setComponent("FILE_TYPE_LABEL", this.fileTypeLabel);
        this.fileTypeChoiceBox = new ChoiceBox();
        this.fileTypeChoiceBox.setName(this.getId() + "_fileTypeChoice");
        this.fileTypeChoiceBox.setId(this.getId() + "_fileTypeChoice");
        this.fileTypeChoiceBox.setStyleInfo(fileTypeChoiceBoxStyle);
        this.setComponent("FILE_TYPE_CHOICEBOX", this.fileTypeChoiceBox);
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.fileTypeModel = new DefaultComboBoxModel();
        this.fileTypeChoiceBox.setModel(this.fileTypeModel);
        this.cancelButton = new Button();
        this.setComponent(DATASOURCESELECTOR_CANCEL_BUTTON, this.cancelButton);
        this.fileTypeLabel = (Label)this.getComponent("FILE_TYPE_LABEL");
        ArrayList<String> types = new ArrayList<String>();
        types.add("Library");
        ServerInterface server = null;
        try {
            server = this.getUserContext().getAuthServer();
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)SASLibraryDialog.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)SASLibraryDialog.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.remoteFileSelector = new InformationServicesSelector(server, null, null);
        this.selectorModel = (InformationServicesNavigationModel)this.remoteFileSelector.getModel();
        this.selectorModel.setIncludeSystemFolders(false);
        this.selectorModel.setFilterValues(types);
        this.selectorModel.setRefreshNeeded(true);
        this.remoteFileSelector.setId(this.getId() + "_rfs");
        this.remoteFileSelector.removeComponent("RFS_SEARCH");
        this.remoteFileSelector.setTemplateKey("File_Selector_Remote_File_Selector");
        this.remoteFileSelector.setPartialRefreshActionsEnabled(true);
        ((TableView)this.remoteFileSelector.getComponent("RFS_FILE_DETAILVIEW")).getFormObject().setVisible(false);
        this.setComponent("FILE_REMOTE_FILE_SELECTOR", this.remoteFileSelector);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.cancelButton.setLabel(RB.getStringResource(RB_KEY, "cancel.txt", locale));
        if (this.fileTypeModel != null) {
            this.fileTypeModel.addElement(new Item(ISUtility.getLocalizedTypeName((String)"SASLibrary", (Locale)locale), "SASLibrary"));
        }
    }

    public static void performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof SASLibraryDialog) {
            PrintWriter out = response.getWriter();
            SASLibraryDialog dsp = (SASLibraryDialog)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                dsp.getActionProvider().executeCommand(request, response, out);
                dsp.setRequest(request);
                dsp.setResponse(response);
            } else {
                String selectedLibrary = request.getParameter("sas_library");
                try {
                    SASLibraryLocationInterface path = DataSourceUtil.getSASLibrary((UserContextInterface)dsp.getUserContext(), (String)selectedLibrary);
                    String callerId = dsp.getCallerId();
                    out.println("with (window.opener) {");
                    out.println("   var obj = window[\"" + callerId + "_Obj\"];");
                    out.println("   obj.setLibref(\"" + path.getLibref() + "\");");
                    out.println("   obj.setValue(\"" + path.getSASLibraryLocation() + "\");");
                    out.println("}");
                    return;
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            InformationServicesSelector iss = (InformationServicesSelector)dsp.getComponent("FILE_REMOTE_FILE_SELECTOR");
            iss.setRequest(request);
            iss.setResponse(response);
            dsp.setRequest(request);
            dsp.setResponse(response);
            BaseUtil.writeDialog(out, request, dsp, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        if (ap != null) {
            this.remoteFileSelector.setActionProvider(ap);
            TableView tv = (TableView)this.remoteFileSelector.getComponent("RFS_FILE_DETAILVIEW");
            HttpAction selectFileAction = (HttpAction)this.remoteFileSelector.getActionProvider().getDefaultAction("REMOTE_FILE_SELECTOR2_COMPOSITE_SUPPORT", "DATA_CELL_AREA", "SELECT_FILE_ACTION");
            this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
            selectFileAction.setURLTemplate(new SimpleTemplate("javaScript:void(" + this.getId() + "_Obj.fileSelected('%fullyQualifiedLocation'))"));
            ArrayList<TableView> viewers = new ArrayList<TableView>();
            viewers.add(tv);
            this.remoteFileSelector.getActionProvider().setAction(selectFileAction, viewers, new Area("DATA_CELL_AREA"));
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        if (this.getActionProvider() == null) {
            out.println("ActionProvider is null " + this.getId());
            return;
        }
        this.setActionProvider(this.getActionProvider());
        this.remoteFileSelector.setRequest(this.getRequest());
        this.remoteFileSelector.setResponse(this.getResponse());
        JavaScriptIncludeHandler.writeIncludes(out, "SASLIBRARYDIALOG", this.getRequest());
        this.cancelButton.setOnClick("window.close()");
        this.writeTemplate(this, null, out);
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        out.println(jsObj + " = new sas_SASLibraryDialog(\"" + this.getId() + "\");");
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        this.getURLTemplate().getValueDictionary().put("METHOD", "performAction");
        this.getURLTemplate().getValueDictionary().put("CLASS_PARAMETER", SASLibraryDialog.class.getName());
        out.println(jsObj + ".url = \"" + this.getURLTemplate().format() + "\";");
        out.println(jsObj + ".callerId = \"" + this.getCallerId() + "\";");
        out.println(jsObj + ".onChangeEvent = \"" + this.getOnChange() + "\";");
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager();");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    public InformationServicesNavigationModel getSelectorModel() {
        return this.selectorModel;
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    public void setUserContext(UserContextInterface userContext) {
        this.userContext = userContext;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public String getOnBlur() {
        return this.onBlur;
    }

    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public String getOnFocus() {
        return this.onFocus;
    }

    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    static {
        JavaScriptIncludeHandler.addAlias(SASLibraryDialog.class, "SASLIBRARYDIALOG");
    }
}

