/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialog;
import com.sas.servlet.tbeans.datasource.DataSourceValidationException;
import com.sas.servlet.tbeans.datasource.DataSourceValidationInterface;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.text.Message;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DataSourcePicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface,
AJAXControllerURLInterface,
DataSourceValidationInterface {
    public static final String RB_KEY = "DataPicker.";
    private static final long serialVersionUID = 1L;
    protected TextEntry textEntry;
    protected Button rfsButton;
    private String onChange;
    private String onFocus;
    private String onBlur;
    private UserContextInterface userContext;
    private long allowedDataSources;
    public static String DATASOURCE_TEXT = "DATASOURCE_TEXT";
    public static String DATASOURCE_BUTTON = "DATASOURCE_BUTTON";
    private DataSourceDialog dataSourcePanel;
    private Object initialValue;
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "DataSourcePicker.html";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=" + DataSourcePicker.class.getName() + "&" + "METHOD" + "=openRemoteFileSelector&id=%id";
    private boolean isEditing;

    public DataSourcePicker(UserContextInterface userContext) {
        this(userContext, -1L);
    }

    public DataSourcePicker(UserContextInterface userContext, long allowedDataSources) {
        this.setId(Util.getName((String)"dsp"));
        this.userContext = userContext;
        this.allowedDataSources = allowedDataSources;
        this.isEditing = false;
        this.setTemplateKey("Data_Source_Picker");
        this.setObjectDataProperty("initialValue");
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.setTemplateDictionary(new HashMap());
        this.addComponents();
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    protected void addComponents() {
        this.textEntry = new TextEntry();
        this.textEntry.setSize(50);
        this.textEntry.setId(this.getId() + "_textEntry");
        this.setComponent(DATASOURCE_TEXT, this.textEntry);
        this.rfsButton = new Button();
        this.rfsButton.setId(this.getId() + "_button");
        this.setComponent(DATASOURCE_BUTTON, this.rfsButton);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.rfsButton != null) {
            this.rfsButton.setLabel(RB.getStringResource(RB_KEY, "browse.txt", currentLocale));
        }
    }

    protected void setup() {
        if (this.rfsButton != null) {
            this.rfsButton.setOnClick(this.getId() + "_Obj.openRFS()");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.textEntry = (TextEntry)this.getComponent(DATASOURCE_TEXT);
        if (this.getOnChange() != null && this.textEntry != null) {
            this.textEntry.setOnChange(this.getOnChange());
        }
        this.getTemplateDictionary().put("ID", this.getId());
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "DATASOURCEPICKER", this.getRequest());
        this.setup();
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    protected void writeJavaScript(PrintWriter out) throws IOException {
        this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        StringBuffer sb = new StringBuffer().append(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        sb.append(jsObj).append(" = new sas_DataSourcePicker('").append(this.getId()).append("');\n");
        sb.append(jsObj).append(".url= \"").append(this.getURLTemplate().format()).append("\";");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    public static void openRemoteFileSelector(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof DataSourcePicker) {
            DataSourceDialog dssp;
            PrintWriter out = response.getWriter();
            DataSourcePicker dsp = (DataSourcePicker)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                dsp.getActionProvider().executeCommand(request, response, out);
            }
            if ((dssp = dsp.getDataSourcePanel()) == null) {
                dsp.setRequest(request);
                dsp.setResponse(response);
                dsp.initializeRFS(request, response);
                dssp = dsp.getDataSourcePanel();
                RemoteFileSelector rfs = (RemoteFileSelector)dssp.getComponent("FILE_REMOTE_FILE_SELECTOR");
                if (rfs != null) {
                    TableView tv = (TableView)rfs.getComponent("RFS_FILE_DETAILVIEW");
                    if (tv != null) {
                        tv.setLockColumnHeaders(true);
                    }
                } else {
                    dssp.setRequest(request);
                    dssp.setResponse(response);
                }
                dssp.setActionProvider(dsp.getActionProvider());
                ComponentSessionManager.getSessionManager(request).put(dssp.getId(), dssp);
            } else {
                dssp.setRequest(request);
                dssp.setResponse(response);
            }
            dssp.setAllowedDataSources(dsp.getAllowedDataSources());
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put("TITLE", RB.getStringResource(RB_KEY, "selectDataSource.txt", dssp.getLocale()));
            BaseUtil.writeDialog(out, request, dssp, dictionary, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public long getAllowedDataSources() {
        return this.allowedDataSources;
    }

    public void setAllowedDataSources(long allowedDataSources) {
        if (this.allowedDataSources != allowedDataSources) {
            this.allowedDataSources = allowedDataSources;
        }
    }

    public DataSourceDialog getDataSourcePanel() {
        return this.dataSourcePanel;
    }

    public void setDataSourcePanel(DataSourceDialog dataSource) {
        this.dataSourcePanel = dataSource;
    }

    public void initializeRFS(HttpServletRequest request, HttpServletResponse response) {
        if (this.dataSourcePanel == null) {
            DataSourceDialog panel = new DataSourceDialog(this.getUserContext(), this.getAllowedDataSources());
            panel.setRequest(request);
            panel.setResponse(response);
            panel.setOnChange(this.getOnChange());
            panel.setOnBlur(this.getOnBlur());
            panel.setOnFocus(this.getOnFocus());
            panel.setCallerId(this.getId());
            panel.setAJAXControllerURL(this.getAJAXControllerURL());
            this.setDataSourcePanel(panel);
        }
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Object initialValue) {
        TextEntry dataSourceText = (TextEntry)this.getComponent(DATASOURCE_TEXT);
        if (initialValue instanceof BaseDataSource) {
            if (dataSourceText != null) {
                dataSourceText.setText(((BaseDataSource)initialValue).getDataSourceLocation());
            }
        } else if (initialValue instanceof String) {
            dataSourceText.setText(initialValue.toString());
        } else if (initialValue == null || initialValue.toString().length() == 0) {
            dataSourceText.setText("");
        }
        this.initialValue = initialValue;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        if (this.getDataSourcePanel() != null) {
            this.getDataSourcePanel().cleanup(session);
        }
    }

    public DataSourceInterface getDataSource(String path) {
        if (path != null) {
            try {
                return DataSourceUtil.getDataSource((UserContextInterface)this.userContext, (String)path);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void validate(Object value, Locale locale) throws Exception {
        if (value instanceof String) {
            String dataSourceValue = (String)value;
            DataSourceInterface ds = DataSourceUtil.getDataSource((UserContextInterface)this.getUserContext(), (String)dataSourceValue);
            String error = null;
            if (ds != null) {
                if (!DataSourceUtil.isDataSourceTypeAllowed((long)ds.getDataSourceType(), (long)this.getAllowedDataSources())) {
                    error = new Message(com.sas.swing.visuals.RB.getStringResource((String)"DataSourcePicker.", (String)"illegalType.ex.fmt.txt", (Locale)locale), (Object)dataSourceValue).toString();
                }
            } else {
                error = new Message(com.sas.swing.visuals.RB.getStringResource((String)"DataSourcePicker.", (String)"invalidPath.ex.txt", (Locale)locale)).toString();
            }
            if (error != null) {
                throw new DataSourceValidationException(error);
            }
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(DataSourcePicker.class, "DATASOURCEPICKER");
    }
}

