/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.actionprovider.ActionAttributeDescriptor;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.util.ISUtility;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.remotefileselector2.html.InformationServicesSelector;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationTypesModel;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.DefaultComboBoxModel;

public class DataSourceDialog
extends BaseCompositeTransformation
implements DataSourceDialogStyleKeysInterface,
DataSourceDialogKeysInterface {
    private static final long serialVersionUID = -8190384233826042100L;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DataSourceDialog.html";
    private static final String DEFAULT_RFS_TEMPLATE = "FileSelectorRemoteFileSelector.html";
    public static final String DATASOURCESELECTOR_CANCEL_BUTTON = "DATASOURCESELECTOR_CANCEL_BUTTON";
    private InformationServicesNavigationModel selectorModel = null;
    private InformationServicesSelector remoteFileSelector;
    private long allowedDataSources;
    private UserContextInterface userContext;
    private String callerId;
    private String onChange;
    private String onFocus;
    private String onBlur;
    private List types;
    protected DefaultComboBoxModel fileTypeModel;
    protected Label fileTypeLabel;
    protected ChoiceBox fileTypeChoiceBox;
    protected Button cancelButton;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo containerStyle = new ImmutableStyleInfo("dataSelectorPanelContainer");
    private static final ImmutableStyleInfo labelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo valueTextEntryStyle = new ImmutableStyleInfo("selectorTextEntry fileSelectorInput");
    private static final ImmutableStyleInfo fileTypeChoiceBoxStyle = new ImmutableStyleInfo("selectorChoice fileSelectorChoice");
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=%CLASS_PARAMETER&METHOD=%METHOD&id=%id";
    public static final String RB_KEY = "IFileDialog.";

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("FILE_PANEL_CONTAINER", containerStyle);
            defaultStyleMap.put("FILE_FILE_NAME_LABEL", labelStyle);
            defaultStyleMap.put("FILE_FILE_NAME_TEXTENTRY", valueTextEntryStyle);
            defaultStyleMap.put("FILE_FILE_TYPE_LABEL", labelStyle);
            defaultStyleMap.put("FILE_FILE_TYPE_CHOICEBOX", fileTypeChoiceBoxStyle);
        }
    }

    public DataSourceDialog(UserContextInterface userContext, long allowedDataSources) {
        this.allowedDataSources = allowedDataSources;
        this.userContext = userContext;
        this.setId(Util.getName((String)"ds_panel"));
        DataSourceDialog.setupDefaultStyleMap();
        MapWithDefaults stylemap = (MapWithDefaults)this.getStyleMap();
        stylemap.setDefaultMap((Map)defaultStyleMap);
        this.setTemplateKey("Data_Source_Dialog");
        this.fileTypeLabel = new Label();
        this.fileTypeLabel.setId(this.getId() + "_fileTypeLabel");
        this.fileTypeLabel.setStyleInfo(labelStyle);
        this.setComponent("FILE_TYPE_LABEL", this.fileTypeLabel);
        this.fileTypeChoiceBox = new ChoiceBox();
        this.fileTypeChoiceBox.setName(this.getId() + "_fileTypeChoice");
        this.fileTypeChoiceBox.setId(this.getId() + "_fileTypeChoice");
        this.fileTypeChoiceBox.setStyleInfo(fileTypeChoiceBoxStyle);
        this.setComponent("FILE_TYPE_CHOICEBOX", this.fileTypeChoiceBox);
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setURLTemplate(ajaxURLTemplate);
        this.fileTypeModel = new DefaultComboBoxModel();
        this.fileTypeChoiceBox.setModel(this.fileTypeModel);
        this.cancelButton = new Button();
        this.setComponent(DATASOURCESELECTOR_CANCEL_BUTTON, this.cancelButton);
        this.fileTypeLabel = (Label)this.getComponent("FILE_TYPE_LABEL");
        this.types = new ArrayList();
        if (this.isDataSourceTypeAllowed(2L)) {
            this.types.add("Cube");
        }
        if (this.isDataSourceTypeAllowed(1L)) {
            this.types.add("Table");
        }
        if (this.isDataSourceTypeAllowed(8L)) {
            this.types.add("InformationMap.OLAP");
        }
        if (this.isDataSourceTypeAllowed(4L)) {
            this.types.add("InformationMap.Relational");
        }
        ServerInterface server = null;
        try {
            server = this.getUserContext().getAuthServer();
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)DataSourceDialog.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)DataSourceDialog.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.remoteFileSelector = new InformationServicesSelector(server, null, null);
        this.selectorModel = (InformationServicesNavigationModel)this.remoteFileSelector.getModel();
        this.selectorModel.setIncludeSystemFolders(false);
        this.selectorModel.setFilterValues(this.types);
        this.remoteFileSelector.setId(this.getId() + "_rfs");
        this.remoteFileSelector.removeComponent("RFS_SEARCH");
        this.remoteFileSelector.setTemplateKey("File_Selector_Remote_File_Selector");
        this.remoteFileSelector.setPartialRefreshActionsEnabled(true);
        this.remoteFileSelector.getModel().setRefreshNeeded(true);
        ((TableView)this.remoteFileSelector.getComponent("RFS_FILE_DETAILVIEW")).getFormObject().setVisible(false);
        this.setComponent("FILE_REMOTE_FILE_SELECTOR", this.remoteFileSelector);
        this.setTemplateDictionary(new HashMap());
    }

    private void convertMapToComboModel(DefaultComboBoxModel cmodel, List fileTypes, Locale locale) {
        StringBuffer allTypes = new StringBuffer();
        int size = fileTypes.size();
        for (int i = 0; i < fileTypes.size(); ++i) {
            Object type = fileTypes.get(i);
            allTypes.append(type);
            if (i < size - 1) {
                allTypes.append(",");
            }
            if (type == "Cube") {
                cmodel.addElement(new Item(ISUtility.getLocalizedTypeName((String)"Cube", (Locale)locale), "Cube"));
                continue;
            }
            if (type == "Table") {
                cmodel.addElement(new Item(ISUtility.getLocalizedTypeName((String)"Table", (Locale)locale), "Table"));
                continue;
            }
            if (type == "InformationMap.OLAP") {
                cmodel.addElement(new Item(ISUtility.getLocalizedTypeName((String)"InformationMap.OLAP", (Locale)locale), "InformationMap.OLAP"));
                continue;
            }
            if (type != "InformationMap.Relational") continue;
            cmodel.addElement(new Item(ISUtility.getLocalizedTypeName((String)"InformationMap.Relational", (Locale)locale), "InformationMap.Relational"));
        }
        if (cmodel.getSize() > 1) {
            cmodel.insertElementAt(new Item(com.sas.swing.visuals.RB.getStringResource((String)"", (String)"allApplicableSASTypes.txt", (Locale)locale), allTypes.toString()), 0);
        }
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.cancelButton.setLabel(RB.getStringResource(RB_KEY, "cancel.txt", locale));
        this.convertMapToComboModel(this.fileTypeModel, this.types, locale);
    }

    protected boolean isDataSourceTypeAllowed(long dataSourceType) {
        if (this.allowedDataSources == -1L) {
            return true;
        }
        return (this.allowedDataSources & dataSourceType) == dataSourceType;
    }

    public void setSelectorModel(InformationServicesNavigationTypesModel selectormodel) {
        this.selectorModel = selectormodel;
        Locale locale = this.getLocale();
        this.remoteFileSelector.setId(this.getId() + "_rfs");
        this.remoteFileSelector.setActionProvider(this.getActionProvider());
        this.remoteFileSelector.setLocale(locale);
        this.remoteFileSelector.getModel().setRefreshNeeded(true);
        this.remoteFileSelector.removeComponent("RFS_SEARCH");
        this.remoteFileSelector.setTemplateKey("File_Selector_Remote_File_Selector");
        ((TableView)this.remoteFileSelector.getComponent("RFS_FILE_DETAILVIEW")).getFormObject().setVisible(false);
    }

    public static void performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String id = request.getParameter("id");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof DataSourceDialog) {
            PrintWriter out = response.getWriter();
            DataSourceDialog dsp = (DataSourceDialog)ti;
            String cmdid = request.getParameter("CMDID");
            if (cmdid != null) {
                dsp.getActionProvider().executeCommand(request, response, out);
                dsp.setRequest(request);
                dsp.setResponse(response);
            } else {
                String fileType = request.getParameter("fileType");
                if (fileType != null) {
                    InformationServicesNavigationModel model = dsp.getSelectorModel();
                    ChoiceBox cb = (ChoiceBox)dsp.getComponent("FILE_TYPE_CHOICEBOX");
                    cb.setSelectedItem(fileType);
                    ArrayList<String> types = new ArrayList<String>();
                    if (fileType.indexOf(",") > 0) {
                        if (dsp.isDataSourceTypeAllowed(2L)) {
                            types.add("Cube");
                        }
                        if (dsp.isDataSourceTypeAllowed(1L)) {
                            types.add("Table");
                        }
                        if (dsp.isDataSourceTypeAllowed(8L)) {
                            types.add("InformationMap.OLAP");
                        }
                        if (dsp.isDataSourceTypeAllowed(4L)) {
                            types.add("InformationMap.Relational");
                        }
                    } else {
                        types.add(fileType);
                    }
                    model.setFilterValues(types);
                    model.setRefreshNeeded(true);
                    InformationServicesSelector iss = (InformationServicesSelector)dsp.getComponent("FILE_REMOTE_FILE_SELECTOR");
                    iss.setModel((RemoteFileNavigationModelInterface)model);
                    iss.setRequest(request);
                    iss.setResponse(response);
                    iss.write(out);
                    return;
                }
            }
            dsp.setRequest(request);
            dsp.setResponse(response);
            BaseUtil.writeDialog(out, request, dsp, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        if (ap != null) {
            this.remoteFileSelector.setActionProvider(ap);
            TableView tv = (TableView)this.remoteFileSelector.getComponent("RFS_FILE_DETAILVIEW");
            HttpAction selectFileAction = (HttpAction)this.remoteFileSelector.getActionProvider().getDefaultAction("REMOTE_FILE_SELECTOR2_COMPOSITE_SUPPORT", "DATA_CELL_AREA", "SELECT_FILE_ACTION");
            this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
            selectFileAction.setURLTemplate(new SimpleTemplate("javaScript:void(" + this.getId() + "_Obj.fileSelected('%fullyQualifiedLocation'))"));
            ActionAttributeDescriptor descriptor = (ActionAttributeDescriptor)selectFileAction.getAttributeDescriptor("fullyQualifiedLocation");
            if (descriptor != null) {
                descriptor.setEncode(false);
            }
            ArrayList<TableView> viewers = new ArrayList<TableView>();
            viewers.add(tv);
            this.remoteFileSelector.getActionProvider().setAction(selectFileAction, viewers, new Area("DATA_CELL_AREA"));
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        if (this.getActionProvider() == null) {
            out.println("ActionProvider is null " + this.getId());
            return;
        }
        this.setActionProvider(this.getActionProvider());
        this.getTemplateDictionary().put("CONTAINER_ID", this.getId() + "_container");
        this.remoteFileSelector.setRequest(this.getRequest());
        this.remoteFileSelector.setResponse(this.getResponse());
        JavaScriptIncludeHandler.writeIncludes(out, "DATASOURCEDIALOG", this.getRequest());
        this.fileTypeChoiceBox.setOnChange(this.getId() + "_Obj.fileTypeChanged()");
        this.cancelButton.setOnClick("window.close()");
        this.writeTemplate(this, null, out);
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        out.println(jsObj + " = new sas_DataSourceDialog('" + this.getId() + "', '" + this.getActionProvider().getParameterPrefix() + "', '" + this.getId() + "');");
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        this.getURLTemplate().getValueDictionary().put("METHOD", "performAction");
        this.getURLTemplate().getValueDictionary().put("CLASS_PARAMETER", DataSourceDialog.class.getName());
        out.println(jsObj + ".url = \"" + this.getURLTemplate().format() + "\";");
        out.println(jsObj + ".callerId = \"" + this.getCallerId() + "\";");
        out.println(jsObj + ".onChangeEvent = \"" + this.getOnChange() + "\";");
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager();");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    public InformationServicesNavigationModel getSelectorModel() {
        return this.selectorModel;
    }

    public long getAllowedDataSources() {
        return this.allowedDataSources;
    }

    public void setAllowedDataSources(long allowedDataSources) {
        if (this.allowedDataSources != allowedDataSources) {
            this.allowedDataSources = allowedDataSources;
        }
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    public void setUserContext(UserContextInterface userContext) {
        this.userContext = userContext;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public String getOnBlur() {
        return this.onBlur;
    }

    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public String getOnFocus() {
        return this.onFocus;
    }

    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    static {
        JavaScriptIncludeHandler.addAlias(DataSourceDialog.class, "DATASOURCEDIALOG");
    }
}

