/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.datasource;

import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.SelectorContainerKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.SelectorContainerStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourceColumnPicker;
import com.sas.servlet.tbeans.datasource.DataSourceDialog;
import com.sas.servlet.tbeans.datasource.DataSourceDialogKeysInterface;
import com.sas.servlet.tbeans.datasource.DataSourceDialogStyleKeysInterface;
import com.sas.servlet.tbeans.datasource.RB;
import com.sas.servlet.tbeans.datasource.ValueProviderAdapter;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.ValueListEditor;
import com.sas.servlet.tbeans.itemlistmanager.TableItemListManager;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.ValueItemsToComboBoxModelAdapter;
import com.sas.servlet.tbeans.remotefileselector2.html.InformationServicesSelector;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.TableModel;

public class DataSourceColumnDialog
extends DataSourceDialog
implements DataSourceDialogStyleKeysInterface,
DataSourceDialogKeysInterface,
SelectorContainerStyleKeysInterface,
SelectorContainerKeysInterface,
JavaScriptEventHandlerInterface {
    private static final long serialVersionUID = 1L;
    private boolean allowMultipleDataSource;
    private DataProviderInterface dataProvider;
    private ColumnNamesValueProvider columnNameValueProvider;
    private InfoMapItemsValueProvider infoMapItemsValueProvider;
    public static final String DATASOURCECOLUMN_OK_BUTTON = "DATASOURCECOLUMN_OK_BUTTON";
    public static final String DATASOURCECOLUMN_CANCEL_BUTTON = "DATASOURCECOLUMN_CANCEL_BUTTON";
    public static final String DATASOURCECOLUMN_DATASOURCES = "DATASOURCECOLUMN_DATASOURCES";
    public static final String DATASOURCE_ITEMS_LABEL = "DATASOURCE_ITEMS_LABEL";
    public static final String SELECT_DATASOURCE_LABEL = "SELECT_DATASOURCE_LABEL";
    private long allowedColumnTypes;
    private DataSourceInterface dataSource;
    private int selectionType = 300;
    private ValuePicker valuePicker;
    private DataSourceValueProviderAdapter vpAdapter;
    private ChoiceBox choiceBox;
    private Button okButton;
    private Button cancelButton;
    private String onChange;
    private String onFocus;
    private String onBlur;
    private List dataSources;
    private Object initialValue;
    private DataSourceColumnPicker picker;
    private String warningMessage;
    private int maxValues;
    public static final int SINGLE_SELECTION = 300;
    public static final int MULTIPLE_SELECTION = 301;
    public static final int ORDERED_MULTIPLE_SELECTION = 302;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DataSourceColumnDialog.html";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%CONTEXTPATH/MethodInvocationServlet?CLASS_PARAMETER=%CLASS_PARAMETER&METHOD=%METHOD&id=%id";
    public static final String RB_KEY = "DataSourceColumnPicker.";
    public static final String RB_KEY2 = "DataPicker.";
    public static final String RB_KEY3 = "IFileDialog.";

    public DataSourceColumnDialog(UserContextInterface userContext, long allowedDataSources, long allowedColumnTypes, List dataSources) {
        this(userContext, allowedDataSources, allowedColumnTypes, dataSources, null);
    }

    public DataSourceColumnDialog(UserContextInterface userContext, long allowedDataSources, long allowedColumnTypes, List dataSources, DataSourceColumnPicker picker) {
        super(userContext, allowedDataSources);
        this.picker = picker;
        this.dataSources = dataSources;
        this.setTemplateKey("Data_Source_Column_Dialog");
        this.setId(Util.getName((String)"dataSourceColumnDialog"));
        this.allowedColumnTypes = allowedColumnTypes;
        this.allowMultipleDataSource = true;
        this.maxValues = -1;
        if (dataSources != null) {
            this.choiceBox = new ChoiceBox();
            DefaultComboBoxModel<Item> choiceModel = new DefaultComboBoxModel<Item>();
            int index = 0;
            for (DataSourceInterface dataSource : dataSources) {
                try {
                    if (DataSourceUtil.getDataSource((UserContextInterface)this.getUserContext(), (String)dataSource.getDataSourceLocation()) == null) continue;
                    choiceModel.addElement(new Item(dataSource.getDataSourceLocation(), Integer.toString(index)));
                    ++index;
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.choiceBox.setModel(choiceModel);
            this.setComponent(DATASOURCECOLUMN_DATASOURCES, this.choiceBox);
        }
        SimpleTemplate ajaxURLTemplate = new SimpleTemplate();
        ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        ajaxURLTemplate.setValueDictionary(new HashMap());
        this.okButton = new Button();
        this.okButton.setId(this.getId() + "_okButton");
        this.setComponent(DATASOURCECOLUMN_OK_BUTTON, this.okButton);
        this.cancelButton = new Button();
        this.cancelButton.setId(this.getId() + "_cancelButton");
        this.cancelButton.setOnClick("window.close()");
        this.setComponent(DATASOURCECOLUMN_CANCEL_BUTTON, this.cancelButton);
        this.setObjectDataProperty("initialValue");
        this.setComponent(DATASOURCE_ITEMS_LABEL, new Label(this.getId() + "_dataSourceItemsLabel"));
        Label selectDataSourceLabel = new Label(this.getId() + "_selectDataSourceLabel");
        selectDataSourceLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FILE_FILE_TYPE_LABEL"));
        this.setComponent(SELECT_DATASOURCE_LABEL, selectDataSourceLabel);
        this.setTemplateDictionary(new HashMap());
        this.warningMessage = null;
    }

    public DataSourceColumnDialog(UserContextInterface userContext, DataSourceInterface dataSource) {
        this(userContext, 5L, -1L, null);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        Label selectDataSourceLabel;
        this.cancelButton.setLabel(RB.getStringResource(RB_KEY3, "cancel.txt", locale));
        this.okButton.setLabel(RB.getStringResource(RB_KEY3, "ok.txt", locale));
        Label dataSourceItemsLabel = (Label)this.getComponent(DATASOURCE_ITEMS_LABEL);
        if (dataSourceItemsLabel != null) {
            dataSourceItemsLabel.setText(RB.getStringResource(RB_KEY, "selectDataSourceItems.txt", locale));
        }
        if ((selectDataSourceLabel = (Label)this.getComponent(SELECT_DATASOURCE_LABEL)) != null) {
            selectDataSourceLabel.setText(RB.getStringResource(RB_KEY, "selectDataSource.txt", locale));
        }
    }

    public DataSourceValueProviderAdapter getValueProvider() {
        DataSourceValueProviderAdapter vpAdapter = new DataSourceValueProviderAdapter(this.getAllowedDataSources(), this.getAllowedColumnTypes(), this.dataSources);
        ArrayList<ColumnNamesValueProvider> providers = new ArrayList<ColumnNamesValueProvider>();
        for (DataSourceInterface dataSource : this.dataSources) {
            ColumnNamesValueProvider valueProvider = null;
            if (dataSource.getDataSourceType() == 1L) {
                ColumnNamesValueProvider columnNameValueProvider = new ColumnNamesValueProvider(dataSource.getDataSourceLocation());
                columnNameValueProvider.setDataProvider(this.getDataProvider());
                valueProvider = columnNameValueProvider;
            } else if (dataSource.getDataSourceType() == 4L) {
                InfoMapItemsValueProvider infoMapItemsValueProvider = new InfoMapItemsValueProvider();
                infoMapItemsValueProvider.setIsOLAP(false);
                infoMapItemsValueProvider.setInfoMapUrl(dataSource.getDataSourceLocation());
                infoMapItemsValueProvider.setDataProvider(this.getDataProvider());
                valueProvider = infoMapItemsValueProvider;
            }
            providers.add(valueProvider);
        }
        vpAdapter.setValueProviders(providers);
        return vpAdapter;
    }

    public DataSourceValueProviderAdapter getDataSourceValueProviderAdapter() {
        return new DataSourceValueProviderAdapter(this.getAllowedDataSources(), this.getAllowedColumnTypes(), this.getDataSources());
    }

    public static void performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String id = request.getParameter("id");
        try {
            TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
            if (ti instanceof DataSourceColumnDialog) {
                PrintWriter out = response.getWriter();
                DataSourceColumnDialog dsp = (DataSourceColumnDialog)ti;
                String cmdid = request.getParameter("CMDID");
                String path = request.getParameter("fullyQualifiedPath");
                String callerId = request.getParameter("callerId");
                String selectedDataSource = request.getParameter("selectedDataSource");
                if (cmdid != null) {
                    dsp.getActionProvider().executeCommand(request, response, out);
                    dsp.setRequest(request);
                    dsp.setResponse(response);
                } else if (selectedDataSource != null) {
                    List datasources = dsp.getDataSources();
                    int selectedIndex = Integer.parseInt(selectedDataSource);
                    DataSourceInterface dataSource = (DataSourceInterface)datasources.get(selectedIndex);
                    path = dataSource.getDataSourceLocation();
                }
                if (path != null) {
                    long type = DataSourceUtil.getDataSourceType((UserContextInterface)dsp.getUserContext(), (String)path);
                    DataSourceValueProviderAdapter vpAdapter = dsp.getDataSourceValueProviderAdapter();
                    if (type != -1L) {
                        if (type == 1L) {
                            ColumnNamesValueProvider columnNameValueProvider = dsp.getColumnNameValueProvider();
                            dsp.setInfoMapItemsValueProvider(null);
                            if (columnNameValueProvider == null) {
                                columnNameValueProvider = new ColumnNamesValueProvider(path);
                                columnNameValueProvider.setDataProvider(dsp.getDataProvider());
                                dsp.setColumnNameValueProvider(columnNameValueProvider);
                                vpAdapter.setValueProvider((ValueProviderInterface)columnNameValueProvider);
                            } else {
                                columnNameValueProvider.setSbipUrl(path);
                                columnNameValueProvider.setDataProvider(dsp.getDataProvider());
                                dsp.setColumnNameValueProvider(columnNameValueProvider);
                                vpAdapter.setValueProvider((ValueProviderInterface)columnNameValueProvider);
                            }
                        } else if (type == 4L) {
                            InfoMapItemsValueProvider infoMapItemsValueProvider = dsp.getInfoMapItemsValueProvider();
                            if (infoMapItemsValueProvider == null) {
                                dsp.setColumnNameValueProvider(null);
                                infoMapItemsValueProvider = new InfoMapItemsValueProvider();
                                infoMapItemsValueProvider.setIsOLAP(false);
                                infoMapItemsValueProvider.setInfoMapUrl(path);
                                infoMapItemsValueProvider.setDataProvider(dsp.getDataProvider());
                                vpAdapter.setValueProvider((ValueProviderInterface)infoMapItemsValueProvider);
                            } else {
                                infoMapItemsValueProvider.setInfoMapUrl(path);
                                infoMapItemsValueProvider.setDataProvider(dsp.getDataProvider());
                                vpAdapter.setValueProvider((ValueProviderInterface)infoMapItemsValueProvider);
                            }
                        }
                        ValuePicker valuePicker = dsp.getValuePicker();
                        if (valuePicker == null) {
                            int selection = dsp.getSelectionType() == 300 ? 303 : dsp.getSelectionType();
                            valuePicker = new ValuePicker(vpAdapter, 403, selection, dsp.getLocale());
                            valuePicker.setTemplateKey("Data_Source_Column_Value_Picker");
                            valuePicker.setComponent(DATASOURCE_ITEMS_LABEL, dsp.getComponent(DATASOURCE_ITEMS_LABEL));
                            valuePicker.setColumnName(RB.getStringResource(RB_KEY2, "dataSource.txt", dsp.getLocale()), 0);
                            valuePicker.setColumnName(RB.getStringResource(RB_KEY2, "column.txt", dsp.getLocale()), 1);
                            valuePicker.setId(dsp.getId() + "_vp");
                            valuePicker.setActionProvider(dsp.getActionProvider());
                            valuePicker.setAJAXControllerURL(dsp.getAJAXControllerURL());
                            dsp.setValuePicker(valuePicker);
                        } else {
                            valuePicker.setValueProvider(vpAdapter);
                        }
                        if (!dsp.isAllowMultipleDataSource()) {
                            valuePicker.setSelectedValue(null);
                        }
                        valuePicker.setRequest(request);
                        valuePicker.setResponse(response);
                        valuePicker.write(out);
                    }
                } else if (callerId != null) {
                    TransformationInterface dsc = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(callerId);
                    ValuePicker vp = dsp.getValuePicker();
                    if (vp != null) {
                        ValueListEditor valueListEditor;
                        if (vp.getSelectionMode() == 303) {
                            valueListEditor = (ValueListEditor)vp.getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
                            int[] rows = valueListEditor.getSelectedRowIndices();
                            if (rows.length > 0) {
                                int row = rows[0];
                                TableModel m = (TableModel)valueListEditor.getModel();
                                Object obj = m.getValueAt(row, 1);
                                String selectedItem = null;
                                selectedItem = obj instanceof ValueItem ? ((ValueItem)obj).getValueAsString(dsp.getLocale()) : obj.toString();
                                if (dsc instanceof DataSourceColumnPicker) {
                                    DataSourceColumnPicker dscp = (DataSourceColumnPicker)dsc;
                                    TransformationInterface dsColumnComponent = dscp.getComponent("DATASOURCECOLUMN_CHOICEBOX");
                                    ChoiceBox cb = null;
                                    if (dsColumnComponent instanceof ValuePicker) {
                                        ValuePicker valuePicker = (ValuePicker)dscp.getComponent("DATASOURCECOLUMN_CHOICEBOX");
                                        cb = (ChoiceBox)valuePicker.getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
                                        if (cb != null) {
                                            cb.setSelectedIndex(row + 1);
                                            out.println("eval(window.opener." + callerId + ").setSelectedItem('" + selectedItem + "');");
                                        }
                                    } else if (dsColumnComponent instanceof ChoiceBox) {
                                        valueListEditor = (ValueListEditor)vp.getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
                                        TableModel model = (TableModel)valueListEditor.getModel();
                                        cb = (ChoiceBox)dsColumnComponent;
                                        ArrayList<Object> c = new ArrayList<Object>();
                                        c.add(new ValueItem((Object)"", (Object)""));
                                        if (model.getValueAt(row, 0) instanceof ValueItem) {
                                            c.add(model.getValueAt(row, 0));
                                        } else if (model.getColumnCount() > 1) {
                                            c.add(model.getValueAt(row, 1));
                                        } else {
                                            c.add(model.getValueAt(row, 0));
                                        }
                                        cb.setStyleInfo(new StyleInfo(null, null));
                                        cb.setModel((ComboBoxModel)((Object)new ValueItemsToComboBoxModelAdapter(c)));
                                        cb.setSelectedIndex(1);
                                        dscp.setRequest(request);
                                        dscp.setResponse(response);
                                        dscp.writeContent(out);
                                    }
                                }
                            }
                        } else {
                            valueListEditor = (ValueListEditor)vp.getComponent(ValuePicker.VALUEPICKER_TARGET_COMPONENT);
                            Object model = valueListEditor.getModel();
                            if (model instanceof ValueItemsToTableModelAdapter) {
                                ArrayList<String> columns = new ArrayList<String>();
                                columns.add("LABEL");
                                columns.add("VALUE");
                                ((ValueItemsToTableModelAdapter)model).setColumnName(com.sas.swing.visuals.RB.getStringResource((String)RB_KEY, (String)"column.txt", (Locale)vp.getLocale()), 0);
                                ((ValueItemsToTableModelAdapter)model).setColumnName(com.sas.swing.visuals.RB.getStringResource((String)RB_KEY, (String)"dataSource.txt", (Locale)vp.getLocale()), 1);
                                if (dsc instanceof DataSourceColumnPicker) {
                                    DataSourceColumnPicker dscp = (DataSourceColumnPicker)dsc;
                                    TableItemListManager ilm = (TableItemListManager)dscp.getComponent("DATASOURCECOLUMN_ITEMLISTMANAGER");
                                    ilm.setModel((TableModel)((ValueItemsToTableModelAdapter)model));
                                }
                            }
                        }
                    }
                }
                if (cmdid != null) {
                    InformationServicesSelector iss = (InformationServicesSelector)dsp.getComponent("FILE_REMOTE_FILE_SELECTOR");
                    iss.setRequest(request);
                    iss.setResponse(response);
                    dsp.setRequest(request);
                    dsp.setResponse(response);
                    if (dsp.getValuePicker() != null) {
                        ValuePicker vp = dsp.getValuePicker();
                        vp.setRequest(request);
                        vp.setResponse(response);
                        dsp.setComponent("COLUMNS_VALUE_PICKER", vp);
                    }
                    BaseUtil.writeDialog(out, request, dsp, TemplateSupport.getTemplate(request, ValuePicker.DEFAULT_DIALOGTEMPLATE));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DataSourceColumnPicker getPicker() {
        return this.picker;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        if (this.warningMessage != null) {
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println("alert(\"" + Strings.escapeForJavaScript((String)this.warningMessage) + "\");");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
        this.warningMessage = null;
        JavaScriptIncludeHandler.writeIncludes(out, "DATASOURCECOLUMNDIALOG", this.getRequest());
        if (this.getActionProvider() == null) {
            out.println("ActionProvider is null " + this.getId());
            return;
        }
        this.getTemplateDictionary().put("CONTAINER_ID", this.getId() + "_container");
        this.valuePicker = this.getValuePicker();
        List dataSources = this.dataSources;
        if (dataSources != null) {
            this.choiceBox = (ChoiceBox)this.getComponent(DATASOURCECOLUMN_DATASOURCES);
            if (this.choiceBox != null) {
                this.choiceBox.setOnChange(this.getId() + "_Obj.changeDataSource(this)");
            }
            this.removeComponent("FILE_REMOTE_FILE_SELECTOR");
            int dataSourceIndex = 0;
            if (this.getPicker() != null && this.picker.getDisplayedDataSource() != null) {
                int i = 0;
                for (DataSourceInterface obj : dataSources) {
                    if (obj.getDataSourceLocation().equals(this.getPicker().getDisplayedDataSource().getDataSourceLocation())) {
                        dataSourceIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            if (this.choiceBox != null) {
                this.choiceBox.setSelectedIndex(dataSourceIndex);
            }
            this.vpAdapter = this.updateValueProvider((DataSourceInterface)dataSources.get(dataSourceIndex));
            if (this.valuePicker == null) {
                int selection = this.getSelectionType() == 300 ? 303 : this.getSelectionType();
                this.valuePicker = new ValuePicker(this.vpAdapter, 403, selection, this.getLocale());
                this.valuePicker.setTemplateKey("Data_Source_Column_Value_Picker");
                this.valuePicker.setComponent(DATASOURCE_ITEMS_LABEL, this.getComponent(DATASOURCE_ITEMS_LABEL));
                this.valuePicker.setActionProvider(this.getActionProvider());
                this.valuePicker.setId(this.getId() + "_vp");
                this.valuePicker.setAJAXControllerURL(this.getAJAXControllerURL());
                this.valuePicker.setColumnName(RB.getStringResource(RB_KEY2, "dataSource.txt", this.getLocale()), 0);
                this.valuePicker.setColumnName(RB.getStringResource(RB_KEY2, "column.txt", this.getLocale()), 1);
                this.setValuePicker(this.valuePicker);
            } else {
                this.valuePicker.setValueProvider(this.vpAdapter);
            }
        }
        if (this.valuePicker != null) {
            this.valuePicker.setRequest(this.getRequest());
            this.valuePicker.setResponse(this.getResponse());
            this.getURLTemplate().getValueDictionary().put("DATASOURCECOLUMN_VALUEPICKER_CONTAINER_STYLE", "display:block");
            this.setComponent("COLUMNS_VALUE_PICKER", this.valuePicker);
            this.valuePicker.setObjectData(this.initialValue);
        } else {
            this.getURLTemplate().getValueDictionary().put("DATASOURCECOLUMN_VALUEPICKER_CONTAINER_STYLE", "display:none");
        }
        this.okButton.setOnClick(this.getId() + "_Obj.submitSelection()");
        this.writeTemplate(this, null, out);
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        this.okButton.setOnClick(jsObj + ".submitSelection()");
        out.println(jsObj + " = new sas_DataSourceColumnDialog('" + this.getId() + "', '" + this.getActionProvider().getParameterPrefix() + "', '" + this.getId() + "');");
        out.println(jsObj + ".onChangeEvent = \"" + this.getOnChange() + "\";");
        this.getURLTemplate().getValueDictionary().put("id", this.getId());
        this.getURLTemplate().getValueDictionary().put("METHOD", "performAction");
        this.getURLTemplate().getValueDictionary().put("CLASS_PARAMETER", DataSourceColumnDialog.class.getName());
        this.getURLTemplate().getValueDictionary().put("CONTEXTPATH", this.getRequest().getContextPath());
        out.println(jsObj + ".url = \"" + this.getURLTemplate().format() + "\";");
        if (this.getCallerId() != null) {
            out.println(jsObj + ".callerId = \"" + this.getCallerId() + "\";");
        }
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager();");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    private DataSourceValueProviderAdapter updateValueProvider(DataSourceInterface dataSource) {
        this.vpAdapter = new DataSourceValueProviderAdapter(this.getAllowedDataSources(), this.getAllowedColumnTypes(), this.getDataSources());
        if (this.vpAdapter != null) {
            if (dataSource != null) {
                if (dataSource.getDataSourceType() == 1L) {
                    this.infoMapItemsValueProvider = null;
                    if (this.columnNameValueProvider == null) {
                        this.columnNameValueProvider = new ColumnNamesValueProvider(dataSource.getDataSourceLocation());
                        this.columnNameValueProvider.setDataProvider(this.getDataProvider());
                    } else {
                        this.columnNameValueProvider.setSbipUrl(dataSource.getDataSourceLocation());
                    }
                    this.vpAdapter.setValueProvider((ValueProviderInterface)this.columnNameValueProvider);
                } else if (dataSource.getDataSourceType() == 4L) {
                    this.columnNameValueProvider = null;
                    if (this.infoMapItemsValueProvider == null) {
                        this.infoMapItemsValueProvider = new InfoMapItemsValueProvider();
                        this.infoMapItemsValueProvider.setIsOLAP(false);
                        this.infoMapItemsValueProvider.setInfoMapUrl(dataSource.getDataSourceLocation());
                        this.infoMapItemsValueProvider.setDataProvider(this.getDataProvider());
                    } else {
                        this.infoMapItemsValueProvider.setInfoMapUrl(dataSource.getDataSourceLocation());
                    }
                    this.vpAdapter.setValueProvider((ValueProviderInterface)this.infoMapItemsValueProvider);
                }
            } else {
                this.vpAdapter.setValueProvider(null);
            }
        }
        return this.vpAdapter;
    }

    private DataProviderInterface getDataProvider() {
        if (this.dataProvider == null) {
            this.dataProvider = new DataProvider(this.getUserContext());
        }
        return this.dataProvider;
    }

    public ValuePicker getValuePicker() {
        return this.valuePicker;
    }

    public void setValuePicker(ValuePicker valuePicker) {
        if (this.valuePicker != valuePicker) {
            ValuePicker oldValue = this.valuePicker;
            this.valuePicker = valuePicker;
            if (this.valuePicker != null) {
                this.valuePicker.setMaximumValueCount(this.getMaximumValueCount());
            }
            this.firePropertyChange("valuePicker", oldValue, valuePicker);
        }
    }

    public ColumnNamesValueProvider getColumnNameValueProvider() {
        return this.columnNameValueProvider;
    }

    public void setColumnNameValueProvider(ColumnNamesValueProvider columnNameValueProvider) {
        this.columnNameValueProvider = columnNameValueProvider;
    }

    public InfoMapItemsValueProvider getInfoMapItemsValueProvider() {
        return this.infoMapItemsValueProvider;
    }

    public void setInfoMapItemsValueProvider(InfoMapItemsValueProvider infoMapItemsValueProvider) {
        this.infoMapItemsValueProvider = infoMapItemsValueProvider;
    }

    public boolean isAllowMultipleDataSource() {
        return this.allowMultipleDataSource;
    }

    public void setAllowMultipleDataSource(boolean allowMultipleDataSource) {
        this.allowMultipleDataSource = allowMultipleDataSource;
    }

    private boolean isColumnTypeAllowed(long columnType) {
        if (this.allowedColumnTypes == -1L) {
            return true;
        }
        return (this.allowedColumnTypes & columnType) == columnType;
    }

    public boolean isValueItemAllowed(ValueItem vi) {
        if (vi.getValue() instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface dataSourceColumn = (DataSourceColumnInterface)vi.getValue();
            if (this.dataSource == null) {
                return this.isDataSourceTypeAllowed(dataSourceColumn.getDataSource().getDataSourceType()) && this.isColumnTypeAllowed(dataSourceColumn.getColumnType());
            }
            return this.dataSource.equals(dataSourceColumn.getDataSource()) && this.isColumnTypeAllowed(dataSourceColumn.getColumnType());
        }
        return false;
    }

    public int getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(int selectionType) {
        this.selectionType = selectionType;
    }

    public List getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List dataSources) {
        this.dataSources = dataSources;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    public long getAllowedColumnTypes() {
        return this.allowedColumnTypes;
    }

    @Override
    protected boolean isDataSourceTypeAllowed(long dataSourceType) {
        long allowedDataSources = this.getAllowedDataSources();
        if (dataSourceType == 8L || dataSourceType == 2L) {
            return false;
        }
        if (allowedDataSources == -1L) {
            return true;
        }
        return (allowedDataSources & dataSourceType) == dataSourceType;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Object initialValue) {
        this.initialValue = initialValue;
    }

    public void setMaximumValueCount(int max) {
        if (max < -1) {
            max = -1;
        }
        if (this.maxValues != max) {
            int oldValue = this.maxValues;
            this.maxValues = max;
            if (this.getValuePicker() != null) {
                this.getValuePicker().setMaximumValueCount(max);
            }
            this.firePropertyChange("maxValues", oldValue, this.maxValues);
        }
    }

    public int getMaximumValueCount() {
        return this.maxValues;
    }

    static {
        JavaScriptIncludeHandler.addAlias(DataSourceColumnDialog.class, "DATASOURCECOLUMNDIALOG");
    }

    private class DataSourceValueProviderAdapter
    extends ValueProviderAdapter {
        public DataSourceValueProviderAdapter(long allowedDataSources, long allowedColumnTypes, List dataSources) {
            super(allowedDataSources, allowedColumnTypes, dataSources);
        }

        @Override
        public Object getValues(Locale locale) throws ValueProviderException {
            if (this.valueProviders != null) {
                if (this.valueProviders.size() == 1) {
                    List values = null;
                    try {
                        values = (List)((ValueProviderInterface)this.valueProviders.get(0)).getValues(locale);
                        values = (List)this.filterColumns(values);
                    }
                    catch (Exception ex) {
                        DataSourceColumnDialog.this.warningMessage = ex.getLocalizedMessage();
                        return Collections.EMPTY_LIST;
                    }
                    this.values = values;
                    return values;
                }
                ArrayList allValues = new ArrayList();
                for (ValueProviderInterface provider : this.valueProviders) {
                    Collection values = null;
                    try {
                        values = (Collection)provider.getValues(locale);
                    }
                    catch (Exception ex) {
                        DataSourceColumnDialog.this.warningMessage = ex.getLocalizedMessage();
                    }
                    if (values == null) continue;
                    values = this.filterColumns(values);
                    allValues.addAll(values);
                }
                this.values = allValues;
                return allValues;
            }
            return Collections.EMPTY_LIST;
        }
    }
}

