/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.sort.html;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CancelInterface;
import com.sas.dataselectors.sort.SortSelectorInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.dataselectors.sort.html.SortSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.sort.html.SortSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.Radio;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.awt.ComponentOrientation;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class SortSelectorPanel
extends SelectorPanel
implements CancelInterface,
SortSelectorKeysInterface,
SortSelectorStyleKeysInterface {
    private Form form;
    private Object selectorModel;
    private String parameterPrefix;
    private boolean isOLAP;
    private boolean isRawDataAvailable;
    private boolean isStyleSheets;
    private ResourceBundle bundle;
    private String RB_KEY;
    private boolean isLeftToRight;
    private boolean isHorizontal;
    private boolean isSortFromSelItems = false;
    private boolean isThenBy1FromSelItems = false;
    private boolean isThenBy2FromSelItems = false;
    private int maxSortableColumns = -1;
    private DefaultComboBoxModel sortByComboModel;
    private DefaultComboBoxModel sortedItems;
    private static final String LINE_BREAK = "<br>";
    private static final String TABLE_BEGIN = "<table border='0' cellpadding='0' cellspacing='0'>";
    private static final String TABLE_END = "</table>";
    private static final String ROW_BEGIN = "<tr>";
    private static final String ROW_BEGIN_VALIGN_TOP = "<tr valign='top'>";
    private static final String ROW_SPACER = "<tr> <!-- selector row spacer --> <td><span class='selectorRowSpacer'>&#160;</span></td></tr>";
    private static final String ROW_END = "</tr>";
    private static final String CELL_BEGIN = "<td>";
    private static final String CELL_END = "</td>";
    private static final String CELL_COMPONENT_SPACER = "<td><span class='selectorComponentSpacer'>&#160;</span></td>";
    private static final String DIV_BEGIN = "<div>";
    private static final String DIV_CLASS_BEGIN = "<div class='";
    private static final String DIV_CLASS_END = "'>";
    private static final String COMPONENT_KEY = "SORT_COMPONENT";
    private static final String DIV_END = "</div>";
    private static final String CENTER_BEGIN = "<center>";
    private static final String CENTER_END = "</center>";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "SortSelectorPanel.html";
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo SSLabelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo SSChoiceStyle = new ImmutableStyleInfo("sortSelectorChoiceBox");
    private static final ImmutableStyleInfo SSRadioStyle = new ImmutableStyleInfo("selectorRadio");
    private static final ImmutableStyleInfo SSDivStyle = new ImmutableStyleInfo("selectorComponentDiv");

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("SORTSELECTOR_LABEL", SSLabelStyle);
            defaultStyleMap.put("SORTSELECTOR_CHOICE", SSChoiceStyle);
            defaultStyleMap.put("SORTSELECTOR_RADIO", SSRadioStyle);
            defaultStyleMap.put("SORTSELECTOR_DIV", SSDivStyle);
        }
    }

    public SortSelectorPanel() {
        this(Util.getName((String)"sSel_panel"));
    }

    public SortSelectorPanel(String name) {
        this.setId(name);
        this.RB_KEY = "SortSelector.";
        this.parameterPrefix = "";
        this.isStyleSheets = true;
        this.setTemplateKey("Sort_Selector_Panel");
        this.addComponents();
        SortSelectorPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        Radio thenByRadio;
        Label thenByLabel;
        Radio sortByRadio;
        this.bundle = ResourceBundle.getBundle("com.sas.servlet.tbeans.dataselectors.sort.html.Resources", locale);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        this.isLeftToRight = orientation.isLeftToRight();
        this.isHorizontal = orientation.isHorizontal();
        Label sortByLabel = (Label)this.getComponent("SORTSELECTOR_SORT_BY_LABEL");
        if (sortByLabel != null) {
            sortByLabel.setText(this.bundle.getString(this.RB_KEY + "sortBy.txt"));
        }
        if ((sortByRadio = (Radio)this.getComponent("SORTSELECTOR_SORT_BY_RADIO")) != null) {
            sortByRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
        if ((thenByLabel = (Label)this.getComponent("SORTSELECTOR_THEN_BY_LABEL")) != null) {
            thenByLabel.setText(this.bundle.getString(this.RB_KEY + "thenBy.txt"));
        }
        if ((thenByRadio = (Radio)this.getComponent("SORTSELECTOR_THEN_BY_RADIO1")) != null) {
            thenByRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        }
    }

    @Override
    public void write(PrintWriter out) {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        try {
            JavaScriptIncludeHandler.writeIncludes(out, "SORTSELECTOR", this.getRequest());
            JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)SortSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.form = this.getFormObject();
        this.form.setRequest(this.getRequest());
        this.form.setResponse(this.getResponse());
        this.form.setLocale(this.getLocale());
        try {
            this.writeSelectorPanelHeader(out);
            if (this.getActionProvider() != null) {
                String name = this.getActionProvider().getName();
                name = Strings.escapeForJavaScript((String)name);
                Hidden.writeElement(out, "APNAME", "APNAME", name, true);
                Hidden.writeElement(out, "CMDID", "CMDID", Strings.escapeForJavaScript((String)this.getCommandId()), true);
                name = this.getActionProvider().getParameterPrefix();
                name = Strings.escapeForJavaScript((String)name);
                Hidden.writeElement(out, name + "mode", name + "mode", "COMMIT", true);
            }
            this.createAdditionalComponents();
            this.setComponentValues();
            String layoutTemplate = this.getLayoutTemplate().toString();
            this.writeTemplate(this, layoutTemplate, out);
            int size = this.getSortModel().getSize();
            for (int i = 1; i < size - 1; ++i) {
                Radio thenByRadio = (Radio)this.getComponent("SORTSELECTOR_THEN_BY_RADIO" + i);
                Hidden.writeElement(out, thenByRadio.getId() + "_h", new StringBuffer().append(this.parameterPrefix).append("thenByRadioBox").toString(), thenByRadio.getSelectedIndex() == 0 ? "ASCENDING" : "DESCENDING", false);
            }
            this.writeSelectorPanelFooter(out);
            this.initJsVars(out);
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)SortSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.cleanUpResources();
    }

    protected StringBuffer getLayoutTemplate() {
        StringBuffer sb = new StringBuffer();
        ImmutableStyleInfo divStyle = (ImmutableStyleInfo)this.getStyleMap().get("SORTSELECTOR_DIV");
        sb.append(DIV_CLASS_BEGIN);
        sb.append(divStyle.getClassid());
        sb.append(DIV_CLASS_END);
        sb.append(TABLE_BEGIN);
        sb.append(ROW_BEGIN);
        sb.append("<td>%SORTSELECTOR_SORT_BY_LABEL</td>");
        sb.append(CELL_COMPONENT_SPACER);
        sb.append(CELL_COMPONENT_SPACER);
        sb.append(ROW_END);
        sb.append(ROW_BEGIN_VALIGN_TOP);
        sb.append("<td>%SORTSELECTOR_SORT_BY_CHOICEBOX</td>");
        sb.append(CELL_COMPONENT_SPACER);
        sb.append("<td>%SORTSELECTOR_SORT_BY_RADIO</td>");
        sb.append(ROW_END);
        int numCols = 0;
        int maxSortCols = this.getMaxSortableColumns();
        numCols = maxSortCols > -1 ? maxSortCols : this.getSortModel().getSize() - 1;
        for (int i = 1; i < numCols; ++i) {
            sb.append(ROW_BEGIN);
            sb.append("<td>%SORTSELECTOR_THEN_BY_LABEL</td>");
            sb.append(CELL_COMPONENT_SPACER);
            sb.append(CELL_COMPONENT_SPACER);
            sb.append(ROW_END);
            sb.append(ROW_BEGIN_VALIGN_TOP);
            sb.append("<td>%SORTSELECTOR_THEN_BY_CHOICEBOX" + i + CELL_END);
            sb.append(CELL_COMPONENT_SPACER);
            sb.append("<td>%SORTSELECTOR_THEN_BY_RADIO" + i + CELL_END);
            sb.append(ROW_END);
        }
        sb.append(TABLE_END);
        sb.append(DIV_END);
        sb.append(LINE_BREAK);
        sb.append(LINE_BREAK);
        return sb;
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            Label sortByLabel = this.createSortSelectorLabel();
            this.setComponent("SORTSELECTOR_SORT_BY_LABEL", sortByLabel);
            Label thenByLabel = this.createSortSelectorLabel();
            this.setComponent("SORTSELECTOR_THEN_BY_LABEL", thenByLabel);
            ChoiceBox sortByChoiceBox = this.createSortSelectorChoiceBox();
            this.setComponent("SORTSELECTOR_SORT_BY_CHOICEBOX", sortByChoiceBox);
            ChoiceBox thenByChoiceBox = this.createSortSelectorChoiceBox();
            this.setComponent("SORTSELECTOR_THEN_BY_CHOICEBOX1", thenByChoiceBox);
            Radio sortByRadio = this.createSortSelectorRadioBox();
            this.setComponent("SORTSELECTOR_SORT_BY_RADIO", sortByRadio);
            Radio thenByRadio = this.createSortSelectorRadioBox();
            this.setComponent("SORTSELECTOR_THEN_BY_RADIO1", thenByRadio);
        }
    }

    protected void createAdditionalComponents() {
        ComboBoxModel sortByTypes = this.getSortModel();
        int size = sortByTypes.getSize();
        Label sortByLabel = (Label)this.getComponent("SORTSELECTOR_SORT_BY_LABEL");
        sortByLabel.setId(new StringBuffer().append(this.getId()).append("_").append("sortByLabel").toString());
        ChoiceBox sortByChoiceBox = (ChoiceBox)this.getComponent("SORTSELECTOR_SORT_BY_CHOICEBOX");
        sortByChoiceBox.setId(new StringBuffer().append(this.getId()).append("_").append("sortByChoiceBox").toString());
        Radio sortByRadio = (Radio)this.getComponent("SORTSELECTOR_SORT_BY_RADIO");
        sortByRadio.setId(new StringBuffer().append(this.getId()).append("_").append("sortByRadioBox").toString());
        Label thenByLabel = (Label)this.getComponent("SORTSELECTOR_THEN_BY_LABEL");
        thenByLabel.setId(new StringBuffer().append(this.getId()).append("_").append("thenByLabel").toString());
        ChoiceBox thenByChoiceBox = (ChoiceBox)this.getComponent("SORTSELECTOR_THEN_BY_CHOICEBOX1");
        thenByChoiceBox.setId(new StringBuffer().append(this.getId()).append("_").append("thenByChoiceBox1").toString());
        Radio thenByRadio = (Radio)this.getComponent("SORTSELECTOR_THEN_BY_RADIO1");
        thenByRadio.setId(new StringBuffer().append(this.getId()).append("_").append("thenByRadioBox1").toString());
        thenByRadio.setOnChange("sas_sortSelector_createHiddenDirectionElement('" + thenByRadio.getId() + "');");
        for (int i = 2; i < size - 1; ++i) {
            ImmutableStyleInfo cbRadioBoxStyleInfo;
            ChoiceBox _thenByChoiceBox = this.createSortSelectorChoiceBox();
            _thenByChoiceBox.setStyleInfo(thenByChoiceBox.getStyleInfo());
            _thenByChoiceBox.setId(new StringBuffer().append(this.getId()).append("_").append("thenByChoiceBox").append(i).toString());
            this.setComponent("SORTSELECTOR_THEN_BY_CHOICEBOX" + i, _thenByChoiceBox);
            Radio _thenByRadio = this.createSortSelectorRadioBox();
            _thenByRadio.setStyleInfo(thenByRadio.getStyleInfo());
            ImmutableStyleInfo cbRadioLabelStyleInfo = (ImmutableStyleInfo)thenByRadio.getStyleMap().get("RADIO_LABEL");
            if (cbRadioLabelStyleInfo != null) {
                _thenByRadio.getStyleMap().put("RADIO_LABEL", cbRadioLabelStyleInfo);
            }
            if ((cbRadioBoxStyleInfo = (ImmutableStyleInfo)thenByRadio.getStyleMap().get("RADIO_BOX")) != null) {
                _thenByRadio.getStyleMap().put("RADIO_BOX", cbRadioBoxStyleInfo);
            }
            _thenByRadio.setId(new StringBuffer().append(this.getId()).append("_").append("thenByRadioBox").append(i).toString());
            _thenByRadio.setOnChange("sas_sortSelector_createHiddenDirectionElement('" + _thenByRadio.getId() + "');");
            this.setComponent("SORTSELECTOR_THEN_BY_RADIO" + i, _thenByRadio);
        }
    }

    protected Label createSortSelectorLabel() {
        Label sortByLabel = new Label();
        sortByLabel.setStyleInfo(SSLabelStyle);
        return sortByLabel;
    }

    protected ChoiceBox createSortSelectorChoiceBox() {
        ChoiceBox sortByChoiceBox = new ChoiceBox();
        sortByChoiceBox.setStyleInfo(SSChoiceStyle);
        return sortByChoiceBox;
    }

    protected Radio createSortSelectorRadioBox() {
        Radio sortByRadio = new Radio();
        sortByRadio.setStyleInfo(SSRadioStyle);
        return sortByRadio;
    }

    private void setComponentValues() {
        ChoiceBox sortByChoiceBox = (ChoiceBox)this.getComponent("SORTSELECTOR_SORT_BY_CHOICEBOX");
        ComboBoxModel sortByTypes = this.getSortModel();
        if (sortByTypes != null) {
            Radio sortByRadio;
            int[] itemsAlreadySortedDirections = ((SortSelectorInterface)this.selectorModel).getSortedDirections();
            if (sortByChoiceBox != null) {
                sortByChoiceBox.setName(new StringBuffer().append(this.parameterPrefix).append("sortByChoiceBox").toString());
                if (sortByTypes != null && sortByTypes.getSize() > 0) {
                    sortByChoiceBox.setModel(sortByTypes);
                    try {
                        if (this.sortedItems != null && this.sortedItems.getSize() > 0) {
                            sortByChoiceBox.setSelectedItem(this.sortedItems.getElementAt(0).toString());
                            this.isSortFromSelItems = true;
                        } else {
                            sortByChoiceBox.setSelectedIndex(-1);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if ((sortByRadio = (Radio)this.getComponent("SORTSELECTOR_SORT_BY_RADIO")) != null) {
                sortByRadio.setName(new StringBuffer().append(this.parameterPrefix).append("sortByRadioBox").toString());
                sortByRadio.setModel(this.getLocalizedRadioModel());
                try {
                    if (this.sortedItems != null && this.sortedItems.getSize() > 0) {
                        if (itemsAlreadySortedDirections[0] == 0) {
                            sortByRadio.setSelectedIndex(0);
                        } else if (itemsAlreadySortedDirections[0] == 1) {
                            sortByRadio.setSelectedIndex(1);
                        }
                    } else {
                        sortByRadio.setSelectedIndex(0);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (int i = 1; i < sortByTypes.getSize(); ++i) {
                Radio thenByRadio;
                ChoiceBox thenByChoiceBox = (ChoiceBox)this.getComponent("SORTSELECTOR_THEN_BY_CHOICEBOX" + i);
                if (thenByChoiceBox != null) {
                    thenByChoiceBox.setName(new StringBuffer().append(this.parameterPrefix).append("thenByChoiceBox").toString());
                    if (sortByTypes != null && sortByTypes.getSize() > 0) {
                        thenByChoiceBox.setModel(sortByTypes);
                        try {
                            if (this.sortedItems != null && this.sortedItems.getSize() > i) {
                                thenByChoiceBox.setSelectedItem(this.sortedItems.getElementAt(i).toString());
                                this.isThenBy1FromSelItems = true;
                            } else {
                                thenByChoiceBox.setSelectedIndex(-1);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if ((thenByRadio = (Radio)this.getComponent("SORTSELECTOR_THEN_BY_RADIO" + i)) == null) continue;
                thenByRadio.setName(new StringBuffer().append(this.parameterPrefix).append("thenByRadioBox").append(i).toString());
                thenByRadio.setModel(this.getLocalizedRadioModel());
                try {
                    if (this.sortedItems != null && this.sortedItems.getSize() > i) {
                        if (itemsAlreadySortedDirections[i] == 0) {
                            thenByRadio.setSelectedIndex(0);
                        } else if (itemsAlreadySortedDirections[i] == 1) {
                            thenByRadio.setSelectedIndex(1);
                        }
                    } else {
                        thenByRadio.setSelectedIndex(0);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                thenByRadio.setOnClick("sas_sortSelector_createHiddenDirectionElement('" + thenByRadio.getId() + "');");
            }
        }
    }

    private ListModel getLocalizedRadioModel() {
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "ascending.txt"), "ASCENDING"));
        listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "descending.txt"), "DESCENDING"));
        return listModel;
    }

    private ComboBoxModel getSortModel() {
        this.sortByComboModel = new DefaultComboBoxModel();
        this.sortedItems = new DefaultComboBoxModel();
        DefaultComboBoxModel<Item> hiddenItems = new DefaultComboBoxModel<Item>();
        if (this.selectorModel == null && super.getSelectorModel() instanceof SortSelectorInterface) {
            this.selectorModel = (SortSelectorInterface)super.getSelectorModel();
        }
        Object[] allCols = ((SortSelectorInterface)this.selectorModel).getAllItems();
        Object[] availCols = ((SortSelectorInterface)this.selectorModel).getAvailableItems();
        Object[] hiddenAvailCols = ((SortSelectorInterface)this.selectorModel).getHiddenAvailableItems();
        Object[] sortedCols = ((SortSelectorInterface)this.selectorModel).getSortedItems();
        for (int v = 0; sortedCols != null && v < sortedCols.length; ++v) {
            this.sortedItems.addElement("" + sortedCols[v].toString() + "");
        }
        this.sortByComboModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "none.txt"), "None"));
        for (int i = 0; allCols != null && i < allCols.length; ++i) {
            boolean addedToModel = false;
            for (int k = 0; availCols != null && k < availCols.length; ++k) {
                if (!allCols[i].toString().equals(availCols[k].toString())) continue;
                this.sortByComboModel.addElement(new Item(allCols[i].toString(), "" + i + ""));
                addedToModel = true;
            }
            for (int m = 0; sortedCols != null && m < sortedCols.length; ++m) {
                if (!allCols[i].toString().equals(sortedCols[m].toString())) continue;
                boolean found = false;
                for (int n = 0; hiddenAvailCols != null && n < hiddenAvailCols.length; ++n) {
                    if (!sortedCols[m].toString().equals(hiddenAvailCols[n].toString())) continue;
                    found = true;
                    break;
                }
                if (found || addedToModel) continue;
                this.sortByComboModel.addElement(new Item(allCols[i].toString(), "" + i + ""));
                addedToModel = true;
            }
            for (int t = 0; hiddenAvailCols != null && t < hiddenAvailCols.length; ++t) {
                if (!allCols[i].toString().equals(hiddenAvailCols[t].toString()) || addedToModel) continue;
                hiddenItems.addElement(new Item(allCols[i].toString() + this.bundle.getString(this.RB_KEY + "notShown.txt"), "" + i + ""));
            }
        }
        if (hiddenItems.getSize() > 0) {
            for (int n = 0; n < hiddenItems.getSize(); ++n) {
                this.sortByComboModel.addElement(hiddenItems.getElementAt(n));
            }
        }
        return this.sortByComboModel;
    }

    private void initJsVars(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        String name = this.parameterPrefix;
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("apPrefix = '").append(name).append("';").toString());
        name = this.getFormObject().getName();
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("formName = '").append(name).append("';").toString());
        out.println(new StringBuffer().append("isStyleSheets = ").append(this.isStyleSheets).append(";").toString());
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    public void cancel() {
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        this.parameterPrefix = this.getActionProvider().getParameterPrefix();
    }

    @Override
    public void setSelectorModel(Object selectorModel) {
        super.setSelectorModel(selectorModel);
        if (selectorModel instanceof SortSelectorInterface && this.selectorModel != selectorModel) {
            super.setSelectorModel(selectorModel);
            Object old = this.selectorModel;
            this.selectorModel = (SortSelectorInterface)selectorModel;
        }
    }

    @Override
    public Object getSelectorModel() {
        return this.selectorModel;
    }

    public void setMaxSortableColumns(int value) {
        this.maxSortableColumns = value;
    }

    public int getMaxSortableColumns() {
        return this.maxSortableColumns;
    }
}

