/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.ranking.html;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.dataselectors.qualifiers.QualifiersSelectorAdapter;
import com.sas.dataselectors.qualifiers.QualifiersSelectorInterface;
import com.sas.dataselectors.ranking.BaseRankingSelectorAdapter;
import com.sas.dataselectors.ranking.OLAPRankingSelectorInterface;
import com.sas.dataselectors.ranking.RankingSelectorInterface;
import com.sas.dataselectors.ranking.RelationalRankingSelectorInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.dataselectors.html.DataItemNode;
import com.sas.servlet.tbeans.dataselectors.html.DataSelectorListBoxView;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.dataselectors.qualifiers.html.QualifiersSelector;
import com.sas.servlet.tbeans.dataselectors.ranking.html.RankingSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.ranking.html.RankingSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.Radio;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.util.validators.MinimumValueValidator;
import com.sas.servlet.tbeans.util.validators.NumericInputValidator;
import com.sas.servlet.tbeans.util.validators.RequiredStringValidator;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.Message;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.awt.ComponentOrientation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class RankingSelectorPanel
extends SelectorPanel
implements RankingSelectorKeysInterface,
RankingSelectorStyleKeysInterface {
    private Form form;
    private Form remoteScriptForm;
    private String remoteScriptURL;
    private DefaultListModel listModel;
    private ResourceBundle bundle;
    private String RB_KEY;
    private boolean isLeftToRight;
    private boolean isHorizontal;
    private String editButtonAccessKey;
    private String clearButtonAccessKey;
    private boolean topRanking;
    private boolean percentageRanking;
    private boolean isOLAP;
    private String infoText;
    private String remoteAction;
    private String srvRankingInfoLabelID;
    private String[][] measures;
    private String selectedBasedOnMeasureId;
    private String remoteButtonRowId;
    private String[][] measuresWhereClauses;
    private Object selectorModel;
    private String parameterPrefix;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "RankingSelectorPanel.html";
    @SASScope
    protected Label cdiRanksLabel;
    @SASScope
    protected DataSelectorListBoxView cdiRanksListBoxView;
    @SASScope
    protected Label cdiHintLabel;
    @SASScope
    protected Button cdiEditButton;
    @SASScope
    protected Button cdiClearButton;
    @SASScope
    protected Label srvRanksLabel;
    @SASScope
    protected Radio srvRadio;
    @SASScope
    protected TextEntry srvCountTextEntry;
    @SASScope
    protected BaseChoiceBox srvRankTypeChoiceBox;
    @SASScope
    protected CheckBox srvIncludeTiesCheckBox;
    @SASScope
    protected Label srvBasedOnLabel;
    @SASScope
    protected BaseChoiceBox srvBasedOnChoiceBox;
    @SASScope
    protected Button srvEditButton;
    @SASScope
    protected Label srvRankingInfoLabel;
    @SASScope
    protected QualifiersSelector srqRanksQualifier;
    @SASScope
    protected String isRankingCountNonBlankErrorMessage = null;
    @SASScope
    protected String isRankingCountNonNumericErrorMessage = null;
    @SASScope
    protected String isRankingCountMinValueValidErrorMessage = null;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo RSLabelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo RSRadioStyle = new ImmutableStyleInfo("selectorRadio");
    private static final ImmutableStyleInfo RSCheckStyle = new ImmutableStyleInfo("selectorCheckBox");
    private static final ImmutableStyleInfo RSTextEntryStyle = new ImmutableStyleInfo("selectorTextEntry");
    private static final ImmutableStyleInfo RSChoiceStyle = new ImmutableStyleInfo("selectorChoice");
    private static final ImmutableStyleInfo RSChoiceWidthStyle = new ImmutableStyleInfo("selectorChoice", "width:250px;");
    private static final ImmutableStyleInfo RSHintStyle = new ImmutableStyleInfo("selectorText");
    private static final ImmutableStyleInfo RSRadioLabelStyle = new ImmutableStyleInfo("selectorRadioLabel");
    private static final ImmutableStyleInfo RSCheckLabelStyle = new ImmutableStyleInfo("selectorCheckBoxLabel");

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            ImmutableStyleInfo o = defaultStyleMap.put("RANKINGSELECTOR_LABEL", RSLabelStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_RADIO", RSRadioStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_CHECK", RSCheckStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_TEXT_ENTRY", RSTextEntryStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_CHOICE", RSChoiceStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_HINT", RSHintStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_RADIO_LABEL", RSRadioLabelStyle);
            o = defaultStyleMap.put("RANKINGSELECTOR_CHECK_LABEL", RSCheckLabelStyle);
            ImmutableStyleInfo immutableStyleInfo = defaultStyleMap.put("RANKINGSELECTOR_RANKING_INFO_LABEL", RSLabelStyle);
        }
    }

    public RankingSelectorPanel() {
        this(true, true);
    }

    public RankingSelectorPanel(boolean topRanking, boolean percentageRanking) {
        this.setId(Util.getName((String)"rSel_panel"));
        this.RB_KEY = "RankingSelector.";
        this.topRanking = topRanking;
        this.percentageRanking = percentageRanking;
        this.addComponents();
        this.setTemplateKey("Ranking_Selector_Panel");
        RankingSelectorPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.remoteScriptForm = new Form();
        this.remoteScriptURL = null;
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    @SASScope
    protected void setLocaleDependentProperties(Locale locale) {
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        RankingSelectorInterface selectorModel = (RankingSelectorInterface)this.getSelectorModel();
        if (selectorModel != null) {
            selectorModel.setLocale(locale);
        }
        this.bundle = ResourceBundle.getBundle("com.sas.swing.visuals.dataselectors.ranking.Resources", locale);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        this.isLeftToRight = orientation.isLeftToRight();
        this.isHorizontal = orientation.isHorizontal();
        this.editButtonAccessKey = this.bundle.getString(this.RB_KEY + "editButtonAccessKey.txt");
        this.clearButtonAccessKey = this.bundle.getString(this.RB_KEY + "clearButtonAccessKey.txt");
        this.cdiEditButton = (Button)this.getComponent("RANKINGSELECTOR_CDI_EDIT_BUTTON");
        if (this.cdiEditButton != null) {
            this.cdiEditButton.setLabel(this.bundle.getString(this.RB_KEY + "editButton.txt"));
        }
        this.cdiClearButton = (Button)this.getComponent("RANKINGSELECTOR_CDI_CLEAR_BUTTON");
        if (this.cdiClearButton != null) {
            this.cdiClearButton.setLabel(this.bundle.getString(this.RB_KEY + "clearButton.txt"));
        }
        this.srvEditButton = (Button)this.getComponent("RANKINGSELECTOR_SRV_EDIT_BUTTON");
        if (this.srvEditButton != null) {
            this.srvEditButton.setLabel(this.bundle.getString(this.RB_KEY + "editButton.txt"));
        }
        this.cdiRanksLabel = (Label)this.getComponent("RANKINGSELECTOR_CDI_RANKS_LABEL");
        if (this.cdiRanksLabel != null) {
            this.cdiRanksLabel.setText(this.bundle.getString(this.RB_KEY + "cdiRanksLabel.txt"));
        }
        this.cdiHintLabel = (Label)this.getComponent("RANKINGSELECTOR_CDI_HINT_LABEL");
        if (this.cdiHintLabel != null) {
            this.cdiHintLabel.setText(this.bundle.getString(this.RB_KEY + "cdiHintLabel.txt"));
            this.cdiHintLabel.setStyleInfo(RSHintStyle);
        }
        this.srvRanksLabel = (Label)this.getComponent("RANKINGSELECTOR_SRV_RANKS_LABEL");
        if (this.srvRanksLabel != null) {
            this.srvRanksLabel.setText(this.bundle.getString(this.RB_KEY + "srvRanksLabel.txt"));
        }
        this.cdiRanksListBoxView = (DataSelectorListBoxView)this.getComponent("RANKINGSELECTOR_CDI_RANKS_LIST_BOX_VIEW");
        if (this.cdiRanksListBoxView != null) {
            this.cdiRanksListBoxView.setItemLabel(new Label(this.bundle.getString(this.RB_KEY + "dataitem.txt")));
            this.cdiRanksListBoxView.setItemDescription(new Label(this.bundle.getString(this.RB_KEY + "currentrank.txt")));
        }
        this.srvIncludeTiesCheckBox = (CheckBox)this.getComponent("RANKINGSELECTOR_SRV_INCLUDE_TIES_CHECK_BOX");
        if (this.srvIncludeTiesCheckBox != null) {
            this.srvIncludeTiesCheckBox.setText(this.bundle.getString(this.RB_KEY + "srvIncludeTiesCheckBox.txt"));
        }
        this.srvBasedOnLabel = (Label)this.getComponent("RANKINGSELECTOR_SRV_BASED_ON_LABEL");
        if (this.srvBasedOnLabel != null) {
            this.srvBasedOnLabel.setText(this.bundle.getString(this.RB_KEY + "basedOnLabel.txt"));
        }
        this.srqRanksQualifier = (QualifiersSelector)this.getComponent("RANKINGSELECTOR_QUALIFIER");
        if (this.srqRanksQualifier != null) {
            this.srqRanksQualifier.setNoSelection(this.bundle.getString(this.RB_KEY + "noFilter.txt"));
            Label label = (Label)this.srqRanksQualifier.getComponent("QUALIFIERSELECTOR_WHERE_LABEL");
            label.setText(this.bundle.getString(this.RB_KEY + "basedOnLabel.txt"));
        }
        this.isRankingCountNonBlankErrorMessage = this.bundle.getString(this.RB_KEY + "noRankValueSet.txt");
        this.isRankingCountNonNumericErrorMessage = this.bundle.getString(this.RB_KEY + "rankValueNotNumeric.txt");
        this.isRankingCountMinValueValidErrorMessage = Message.format((ResourceBundle)this.bundle, (String)(this.RB_KEY + "rankValueBelowMinimum.fmt.txt"), (Object)new Integer(1));
    }

    @Override
    public void write(PrintWriter out) {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        try {
            this.writeRemoteScriptForm(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isOLAP) {
            this.removeComponent("RANKINGSELECTOR_CDI_HINT_LABEL");
        } else {
            this.removeComponent("RANKINGSELECTOR_SRV_BASED_ON_LABEL");
            this.removeComponent("RANKINGSELECTOR_SRV_BASED_ON_CHOICE_BOX");
            this.removeComponent("RANKINGSELECTOR_SRV_EDIT_BUTTON");
            this.removeComponent("RANKINGSELECTOR_QUALIFIER");
        }
        try {
            JavaScriptIncludeHandler.writeIncludes(out, "RANKINGSELECTOR", this.getRequest());
            JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.form = this.getFormObject();
        this.form.setRequest(this.getRequest());
        this.form.setResponse(this.getResponse());
        this.form.setLocale(this.getLocale());
        try {
            this.writeSelectorPanelHeader(out);
            Hidden.writeElement(out, null, "APNAME", Strings.escapeForJavaScript((String)this.getActionProvider().getName()), true);
            Hidden.writeElement(out, null, "CMDID", Strings.escapeForJavaScript((String)this.getCommandId()), true);
            Hidden.writeElement(out, null, Strings.escapeForJavaScript((String)this.getActionProvider().getParameterPrefix()) + "mode", "COMMIT", true);
            this.writeSelectorPanelFooter(out);
            this.setComponentValues();
            this.setRequest(this.getRequest());
            String formattedSelector = this.applyTemplate(this);
            out.println(formattedSelector);
            this.initJsVars(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cleanUpResources();
    }

    private void writeRemoteScriptForm(PrintWriter out) throws IOException {
        this.remoteScriptForm.setAction(this.getRemoteScriptURL());
        this.remoteScriptForm.setName(this.getId() + "_RSForm");
        this.remoteScriptForm.setId(this.getId() + "_RSForm");
        this.remoteScriptForm.setTarget(this.getIframeName());
        this.remoteScriptForm.setRequest(this.getRequest());
        this.remoteScriptForm.setResponse(this.getResponse());
        this.remoteScriptForm.setLocale(this.getLocale());
        this.remoteScriptForm.writeHeader(out);
        Hidden.writeElement(out, null, "APNAME", Strings.escapeForJavaScript((String)this.getActionProvider().getName()), true);
        Hidden.writeElement(out, null, "CMDID", Strings.escapeForJavaScript((String)this.getCommandId()), true);
        String token = this.getActionProvider().getParameterPrefix();
        token = Strings.escapeForJavaScript((String)token);
        Hidden.writeElement(out, null, token + "mode", "PROCESS", true);
        Hidden.writeElement(out, null, token + "remoteRankOrder", "", true);
        Hidden.writeElement(out, null, token + "remoteRankValue", "", true);
        Hidden.writeElement(out, null, token + "remoteRankType", "", true);
        Hidden.writeElement(out, null, token + "remoteIncludeTies", "", true);
        Hidden.writeElement(out, null, token + "remoteAction", "", true);
        Hidden.writeElement(out, null, "sas_charEncoding", BaseUtil.getOutputCharacterEncoding(this.getRequest()), true);
        if (this.isOLAP) {
            Hidden.writeElement(out, null, token + "remoteBasedOn", "", true);
            Hidden.writeElement(out, null, token + "remoteBasedOnDesc", "", true);
            Hidden.writeElement(out, null, token + "remoteDataItemId", "", true);
            Hidden.writeElement(out, null, token + "remoteWhereClause", "", true);
            Hidden.writeElement(out, null, token + "remoteWhereValue", "", true);
            Hidden.writeElement(out, null, token + "remoteButtonRowId", "", true);
        }
        this.remoteScriptForm.writeFooter(out);
    }

    private String getRemoteScriptURL() {
        String value = this.remoteScriptURL;
        if (this.remoteScriptURL == null) {
            String contextPath;
            value = "/SelectorServlet";
            if (this.getRequest() != null && (contextPath = this.getRequest().getContextPath()) != null) {
                value = contextPath + "/SelectorServlet";
            }
        }
        return value;
    }

    @Override
    public void writeRemoteScriptCommands(PrintWriter out) throws IOException {
        super.writeRemoteScriptCommands(out);
        StringWriter sw = new StringWriter();
        PrintWriter myOut = new PrintWriter(sw);
        String escapedInfoText = null;
        myOut.println(JavaScriptIncludeHandler.getStartScript());
        if (this.remoteAction.equalsIgnoreCase("COMMIT")) {
            escapedInfoText = Strings.escapeForJavaScript((String)this.infoText);
            myOut.println(new StringBuffer().append("parent.sas_rankingSelector_updateInfoText('").append(escapedInfoText).append("');").toString());
        } else if (this.remoteAction.equalsIgnoreCase("CLEAR")) {
            escapedInfoText = Strings.escapeForJavaScript((String)this.infoText);
            myOut.println(new StringBuffer().append("parent.sas_rankingSelector_updateRankInfo('").append(escapedInfoText).append("');").toString());
        } else if (this.remoteAction.equalsIgnoreCase("POPULATEBASEDON")) {
            myOut.println("parent.sas_rankingSelector_emptyMeasuresArray();");
            int nMeasures = this.measures.length;
            for (int i = 0; i < nMeasures; ++i) {
                this.createJsBasedOnMeasure(myOut, "measures", i, this.measures[i][1], this.measures[i][0], this.measures[i][2]);
            }
            myOut.println("parent.sas_rankingSelector_emptyMeasuresWhereClausesArray();");
            int nMeasuresWhereClauses = this.measuresWhereClauses.length;
            for (int i = 0; i < nMeasuresWhereClauses; ++i) {
                this.createJsMeasureWhereClause(myOut, "measuresWhereClauses", i, this.measuresWhereClauses[i][0], this.measuresWhereClauses[i][1], this.measuresWhereClauses[i][2], this.measuresWhereClauses[i][3]);
            }
            String token = this.selectedBasedOnMeasureId;
            token = Strings.escapeForJavaScript((String)token);
            myOut.println(new StringBuffer().append("parent.sas_rankingSelector_updateBasedOn('").append(token).append("');").toString());
        } else if (this.remoteAction.equalsIgnoreCase("UPDATEBASEDON")) {
            myOut.println("parent.sas_rankingSelector_emptyMeasuresArray();");
            int nMeasures = this.measures.length;
            for (int i = 0; i < nMeasures; ++i) {
                this.createJsBasedOnMeasure(myOut, "measures", i, this.measures[i][1], this.measures[i][0], this.measures[i][2]);
            }
            myOut.println("parent.sas_rankingSelector_emptyMeasuresWhereClausesArray();");
            int nMeasuresWhereClauses = this.measuresWhereClauses.length;
            for (int i = 0; i < nMeasuresWhereClauses; ++i) {
                this.createJsMeasureWhereClause(myOut, "measuresWhereClauses", i, this.measuresWhereClauses[i][0], this.measuresWhereClauses[i][1], this.measuresWhereClauses[i][2], this.measuresWhereClauses[i][3]);
            }
            String token = this.selectedBasedOnMeasureId;
            token = Strings.escapeForJavaScript((String)token);
            myOut.println(new StringBuffer().append("parent.sas_rankingSelector_updateBasedOn('").append(token).append("');").toString());
            escapedInfoText = Strings.escapeForJavaScript((String)this.infoText);
            myOut.println(new StringBuffer().append("parent.sas_rankingSelector_updateInfoText('").append(escapedInfoText).append("');").toString());
            token = this.remoteButtonRowId;
            token = Strings.escapeForJavaScript((String)token);
            myOut.println(new StringBuffer().append("parent.sas_QS_hideContainerButtons(false,'").append(token).append("');").toString());
            myOut.println(new StringBuffer().append("parent.sas_rankingSelector_commitAction();").toString());
        }
        myOut.println(JavaScriptIncludeHandler.getEndScript(null));
        out.print(sw.toString());
    }

    private void createJsBasedOnMeasure(PrintWriter out, String jsMeasuresWhereClausesArrayName, int index, String text, String value, String measureLabel) {
        String escapedText = null;
        escapedText = Strings.escapeForJavaScript((String)text);
        String escapedMeasureLabel = null;
        escapedMeasureLabel = Strings.escapeForJavaScript((String)measureLabel);
        String escapedValue = null;
        escapedValue = Strings.escapeForJavaScript((String)value);
        out.println(new StringBuffer().append("parent.").append(jsMeasuresWhereClausesArrayName).append("[").append(index).append("] = new parent.sas_rankingSelector_basedOnMeasure('").append(escapedText).append("','").append(escapedValue).append("','").append(escapedMeasureLabel).append("');").toString());
    }

    private void createJsMeasureWhereClause(PrintWriter out, String jsMeasuresArrayName, int index, String measureID, String whereClause, String whereValue, String whereID) {
        String escapedMeasureID = null;
        escapedMeasureID = Strings.escapeForJavaScript((String)measureID);
        String escapedWhereClause = null;
        escapedWhereClause = Strings.escapeForJavaScript((String)whereClause);
        String escapedWhereValue = null;
        escapedWhereValue = Strings.escapeForJavaScript((String)whereValue);
        String escapedWhereID = null;
        escapedWhereID = Strings.escapeForJavaScript((String)whereID);
        out.println(new StringBuffer().append("parent.").append(jsMeasuresArrayName).append("[").append(index).append("] = new parent.sas_rankingSelector_MeasureWhereClause('").append(escapedMeasureID).append("','").append(escapedWhereClause).append("','").append(escapedWhereValue).append("','").append(escapedWhereID).append("');").toString());
    }

    @Override
    public void contentsChanged(ContentsChangedEvent event) {
        if (event instanceof ActionProviderEvent) {
            Map info = ((ActionProviderEvent)event).getEventInfo();
            this.infoText = (String)info.get("infoText");
            this.remoteAction = (String)info.get("remoteAction");
            this.measures = (String[][])info.get("measures");
            this.selectedBasedOnMeasureId = (String)info.get("selectedBasedOnMeasureId");
            this.remoteButtonRowId = (String)info.get("remoteButtonRowId");
            this.measuresWhereClauses = (String[][])info.get("measuresWhereClauses");
        }
    }

    private void initJsVars(PrintWriter out) {
        Object selectorModel = this.getSelectorModel();
        out.println(JavaScriptIncludeHandler.getStartScript());
        String token = this.parameterPrefix;
        token = Strings.escapeForJavaScript((String)token);
        out.println(new StringBuffer().append("apPrefix = '").append(token).append("';").toString());
        out.println(new StringBuffer().append("isOLAP = ").append(this.isOLAP).append(";").toString());
        token = this.getFormObject().getName();
        token = Strings.escapeForJavaScript((String)token);
        out.println(new StringBuffer().append("formName = '").append(token).append("';").toString());
        int countRankTypeValue = ((RankingSelectorInterface)selectorModel).countRankTypeValue();
        out.println(new StringBuffer().append("countRankTypeValue = '").append(countRankTypeValue).append("';").toString());
        out.println(new StringBuffer().append("defaultNoRankValue = ").append(-9999).append(";").toString());
        int defaultRankCountValue = 10;
        out.println(new StringBuffer().append("defaultRankCountValue = ").append(defaultRankCountValue).append(";").toString());
        token = ".";
        token = Strings.escapeForJavaScript((String)token);
        out.println(new StringBuffer().append("missingValue = '").append(token).append("';").toString());
        token = this.getSelector().getId();
        token = Strings.escapeForJavaScript((String)token);
        out.println("buttonRowId = '" + token + "_ButtonRow';");
        String name = "cdiEditButton";
        this.cdiEditButton = (Button)this.getComponent("RANKINGSELECTOR_CDI_EDIT_BUTTON");
        if (this.cdiEditButton != null) {
            name = this.cdiEditButton.getId();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("cdiEditButtonName = '").append(name).append("';").toString());
        name = "cdiClearButton";
        this.cdiClearButton = (Button)this.getComponent("RANKINGSELECTOR_CDI_CLEAR_BUTTON");
        if (this.cdiClearButton != null) {
            name = this.cdiClearButton.getId();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("cdiClearButtonName = '").append(name).append("';").toString());
        name = "show";
        this.srvRadio = (Radio)this.getComponent("RANKINGSELECTOR_SRV_TOP_BOTTOM_RADIO");
        if (this.srvRadio != null) {
            name = this.srvRadio.getName();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("srvRadioName = '").append(name).append("';").toString());
        name = "rankingCount";
        this.srvCountTextEntry = (TextEntry)this.getComponent("RANKINGSELECTOR_SRV_COUNT_TEXT_ENTRY");
        if (this.srvCountTextEntry != null) {
            name = this.srvCountTextEntry.getName();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("srvCountTextEntryName = '").append(name).append("';").toString());
        name = "rankingType";
        this.srvRankTypeChoiceBox = (ChoiceBox)this.getComponent("RANKINGSELECTOR_SRV_TYPE_CHOICE_BOX");
        if (this.srvRankTypeChoiceBox != null) {
            name = this.srvRankTypeChoiceBox.getName();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("srvRankTypeChoiceBoxName = '").append(name).append("';").toString());
        name = "includeTies";
        this.srvIncludeTiesCheckBox = (CheckBox)this.getComponent("RANKINGSELECTOR_SRV_INCLUDE_TIES_CHECK_BOX");
        if (this.srvIncludeTiesCheckBox != null) {
            name = this.srvIncludeTiesCheckBox.getName();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("srvIncludeTiesCheckBoxName = '").append(name).append("';").toString());
        name = "basedOn";
        this.srvBasedOnChoiceBox = (ChoiceBox)this.getComponent("RANKINGSELECTOR_SRV_BASED_ON_CHOICE_BOX");
        if (this.srvBasedOnChoiceBox != null) {
            name = this.srvBasedOnChoiceBox.getName();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("srvBasedOnChoiceBoxName = '").append(name).append("';").toString());
        this.cdiRanksListBoxView = (DataSelectorListBoxView)this.getComponent("RANKINGSELECTOR_CDI_RANKS_LIST_BOX_VIEW");
        if (this.cdiRanksListBoxView != null) {
            name = this.cdiRanksListBoxView.getId();
        }
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("cdiRanksListBoxView = eval('").append(name).append("');").toString());
        this.srvCountTextEntry = (TextEntry)this.getComponent("RANKINGSELECTOR_SRV_COUNT_TEXT_ENTRY");
        if (this.srvCountTextEntry != null) {
            RequiredStringValidator requiredStringValidator = new RequiredStringValidator();
            String isRankingCountNonBlankFunction = requiredStringValidator.createValidationFunctionCall(this.srvCountTextEntry);
            name = Strings.escapeForJavaScript((String)isRankingCountNonBlankFunction);
            out.println(new StringBuffer().append("isRankingCountNonBlankFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isRankingCountNonBlankErrorMessage);
            out.println(new StringBuffer().append("isRankingCountNonBlankErrorMessage = '").append(name).append("';").toString());
            NumericInputValidator numericInputValidator = new NumericInputValidator();
            String isRankingCountNonNumericFunction = numericInputValidator.createValidationFunctionCall(this.srvCountTextEntry);
            name = Strings.escapeForJavaScript((String)isRankingCountNonNumericFunction);
            out.println(new StringBuffer().append("isRankingCountNonNumericFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isRankingCountNonNumericErrorMessage);
            out.println(new StringBuffer().append("isRankingCountNonNumericErrorMessage = '").append(name).append("';").toString());
            MinimumValueValidator minimumValueValidator = new MinimumValueValidator(1);
            String isRankingCountMinValueValidFunction = minimumValueValidator.createValidationFunctionCall(this.srvCountTextEntry);
            name = Strings.escapeForJavaScript((String)isRankingCountMinValueValidFunction);
            out.println(new StringBuffer().append("isRankingCountMinValueValidFunction = '").append(name).append("';").toString());
            name = Strings.escapeForJavaScript((String)this.isRankingCountMinValueValidErrorMessage);
            out.println(new StringBuffer().append("isRankingCountMinValueValidErrorMessage = '").append(name).append("';").toString());
        }
        Map map = null;
        boolean valuesFromDataModel = ((RankingSelectorInterface)selectorModel).valuesFromDataModel();
        ((RankingSelectorInterface)selectorModel).valuesFromDataModel(false);
        String jsDataItemsRankValuesArrayName = "dataItems";
        String jsDataItemsWhereClausesArrayName = "whereClauses";
        String dataItemID2 = null;
        String rankOrder = null;
        int rankValue = 0;
        int rankType = 0;
        String includeTies = "0";
        String measureDataItemID = ".";
        String[] wheres = null;
        String[] whereClauses = null;
        String[] ids = null;
        String[] whereValues = null;
        int index = 0;
        if (this.isOLAP) {
            map = ((OLAPRankingSelectorInterface)selectorModel).rankableLevelNames();
            for (String dataItemID2 : map.values()) {
                rankOrder = ((RankingSelectorInterface)selectorModel).rankOrder(dataItemID2);
                rankValue = ((RankingSelectorInterface)selectorModel).rankValue(dataItemID2);
                rankType = ((RankingSelectorInterface)selectorModel).rankType(dataItemID2);
                includeTies = ((RankingSelectorInterface)selectorModel).getIncludeTies(dataItemID2);
                measureDataItemID = ((OLAPRankingSelectorInterface)selectorModel).getSelectedBasedOnMeasureId(dataItemID2);
                wheres = ((OLAPRankingSelectorInterface)selectorModel).whereClauses(dataItemID2);
                if (wheres != null) {
                    int nWheres = wheres.length;
                    if (nWheres > 0) {
                        whereClauses = new String[nWheres];
                        ids = new String[nWheres];
                        whereValues = new String[nWheres];
                        String[] splitted = null;
                        for (int i = 0; i < nWheres; ++i) {
                            splitted = wheres[i].split("\t");
                            ids[i] = splitted[0];
                            whereClauses[i] = splitted[1];
                            whereValues[i] = splitted[2];
                        }
                    } else {
                        whereClauses = new String[]{};
                        ids = new String[]{};
                        whereValues = new String[]{};
                    }
                }
                if (whereClauses != null) {
                    this.createJsWhereClauses(out, jsDataItemsWhereClausesArrayName, index, ".", dataItemID2, whereClauses, ids, whereValues);
                }
                this.createJsDataItem(out, jsDataItemsRankValuesArrayName, index, dataItemID2, rankOrder, rankValue, rankType, includeTies, measureDataItemID);
                ++index;
            }
            this.srqRanksQualifier = (QualifiersSelector)this.getComponent("RANKINGSELECTOR_QUALIFIER");
            if (this.srqRanksQualifier != null) {
                name = this.srqRanksQualifier.getId();
            }
            name = Strings.escapeForJavaScript((String)name);
            out.println(new StringBuffer().append("srqRanksQualifierSelector = eval('").append(name).append("');").toString());
        } else {
            map = ((RelationalRankingSelectorInterface)selectorModel).rankableColumnNames();
            for (String dataItemID2 : map.values()) {
                rankOrder = ((RankingSelectorInterface)selectorModel).rankOrder(dataItemID2);
                rankValue = ((RankingSelectorInterface)selectorModel).rankValue(dataItemID2);
                rankType = ((RankingSelectorInterface)selectorModel).rankType(dataItemID2);
                includeTies = ((RankingSelectorInterface)selectorModel).getIncludeTies(dataItemID2);
                this.createJsDataItem(out, jsDataItemsRankValuesArrayName, index, dataItemID2, rankOrder, rankValue, rankType, includeTies, measureDataItemID);
                ++index;
            }
        }
        ((RankingSelectorInterface)selectorModel).valuesFromDataModel(valuesFromDataModel);
        out.println(new StringBuffer().append("includeTiesValue = '").append("1").append("';").toString());
        out.println(new StringBuffer().append("notIncludeTiesValue = '").append("0").append("';").toString());
        out.println(new StringBuffer().append("tiesNotApplicableValue = '").append("2").append("';").toString());
        out.println(new StringBuffer().append("includeTiesValueBackup = '").append("1").append("';").toString());
        name = this.remoteScriptForm.getName();
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("remoteScriptFormName = '").append(name).append("';").toString());
        name = this.srvRankingInfoLabel.getId();
        name = Strings.escapeForJavaScript((String)name);
        out.println(new StringBuffer().append("srvRankingInfoLabelID = '").append(name).append("';").toString());
        out.println("sas_registerEventHandler(window,'load', function(evt){ sas_rankingSelector_sizeButtons('" + this.getId() + "');}, false);");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void createJsDataItem(PrintWriter out, String jsDataItemsRankValuesArrayName, int index, String dataItemID, String rankOrder, int rankValue, int rankType, String includeTies, String measureDataItemID) {
        StringBuffer line = new StringBuffer();
        line.append(jsDataItemsRankValuesArrayName);
        line.append("[");
        line.append(index);
        line.append("] = new sas_rankingSelector_dataItem('");
        String escapedDataItemID = null;
        escapedDataItemID = Strings.escapeForJavaScript((String)dataItemID);
        line.append(escapedDataItemID);
        line.append("','");
        line.append(rankOrder);
        line.append("','");
        line.append(rankValue);
        line.append("','");
        line.append(rankType);
        line.append("','");
        line.append(includeTies);
        line.append("','");
        String escapedMeasureDataItemID = null;
        escapedMeasureDataItemID = Strings.escapeForJavaScript((String)measureDataItemID);
        line.append(escapedMeasureDataItemID);
        line.append("');");
        out.println(line.toString());
    }

    private void createJsWhereClauses(PrintWriter out, String jsDataItemsWhereClausesArrayName, int index, String missingValue, String dataItemID, String[] whereClauses, String[] ids, String[] whereValues) {
        String whereClause = "";
        String id = "";
        String whereValue = "";
        int nw = whereClauses.length;
        if (nw <= 0) {
            whereClause = missingValue;
        } else {
            for (int i = 0; i < nw; ++i) {
                whereClause = whereClause + "\t" + whereClauses[i];
            }
        }
        int ni = ids.length;
        if (ni <= 0) {
            id = missingValue;
        } else {
            for (int i = 0; i < ni; ++i) {
                id = id + "\t" + ids[i];
            }
        }
        int nv = whereValues.length;
        if (nv <= 0) {
            whereValue = missingValue;
        } else {
            for (int i = 0; i < nv; ++i) {
                whereValue = whereValue + "\t" + whereValues[i];
            }
        }
        StringBuffer line = new StringBuffer();
        line.append(jsDataItemsWhereClausesArrayName);
        line.append("[");
        line.append(index);
        line.append("] = new sas_rankingSelector_whereClause('");
        String escapedDataItemId = null;
        escapedDataItemId = Strings.escapeForJavaScript((String)dataItemID);
        line.append(escapedDataItemId);
        line.append("','");
        String escapedWhereClause = null;
        escapedWhereClause = Strings.escapeForJavaScript((String)whereClause);
        line.append(escapedWhereClause);
        line.append("','");
        String escapedId = null;
        escapedId = Strings.escapeForJavaScript((String)id);
        line.append(escapedId);
        line.append("','");
        String escapedWhereValue = null;
        escapedWhereValue = Strings.escapeForJavaScript((String)whereValue);
        line.append(escapedWhereValue);
        line.append("');");
        out.println(line.toString());
    }

    @SASScope
    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.createCdiRanksLabel();
            this.setComponent("RANKINGSELECTOR_CDI_RANKS_LABEL", this.cdiRanksLabel);
            this.createCdiRanksListBoxView();
            this.setComponent("RANKINGSELECTOR_CDI_RANKS_LIST_BOX_VIEW", this.cdiRanksListBoxView);
            this.createCdiHintLabel();
            this.setComponent("RANKINGSELECTOR_CDI_HINT_LABEL", this.cdiHintLabel);
            this.createCdiEditButton();
            this.setComponent("RANKINGSELECTOR_CDI_EDIT_BUTTON", this.cdiEditButton);
            this.createCdiClearButton();
            this.setComponent("RANKINGSELECTOR_CDI_CLEAR_BUTTON", this.cdiClearButton);
            this.createSrvRanksLabel();
            this.setComponent("RANKINGSELECTOR_SRV_RANKS_LABEL", this.srvRanksLabel);
            this.createSrvTopBottomRadioBox();
            this.setComponent("RANKINGSELECTOR_SRV_TOP_BOTTOM_RADIO", this.srvRadio);
            this.createSrvCountTextEntry();
            this.setComponent("RANKINGSELECTOR_SRV_COUNT_TEXT_ENTRY", this.srvCountTextEntry);
            this.createSrvRankTypeChoiceBox();
            this.setComponent("RANKINGSELECTOR_SRV_TYPE_CHOICE_BOX", this.srvRankTypeChoiceBox);
            this.createSrvIncludeTiesCheckBox();
            this.setComponent("RANKINGSELECTOR_SRV_INCLUDE_TIES_CHECK_BOX", this.srvIncludeTiesCheckBox);
            this.createSrvBasedOnLabel();
            this.setComponent("RANKINGSELECTOR_SRV_BASED_ON_LABEL", this.srvBasedOnLabel);
            this.createSrvBasedOnChoiceBox();
            this.setComponent("RANKINGSELECTOR_SRV_BASED_ON_CHOICE_BOX", this.srvBasedOnChoiceBox);
            this.createSrvEditButton();
            this.setComponent("RANKINGSELECTOR_SRV_EDIT_BUTTON", this.srvEditButton);
            this.createSrvRankingInfoLabel();
            this.setComponent("RANKINGSELECTOR_SRV_RANKING_INFO_LABEL", this.srvRankingInfoLabel);
            this.createSrqRanksQualifier();
            this.setComponent("RANKINGSELECTOR_QUALIFIER", this.srqRanksQualifier);
        }
    }

    private void setComponentValues() {
        Map map2;
        Object selectorModel = this.getSelectorModel();
        String token = null;
        this.cdiRanksListBoxView = (DataSelectorListBoxView)this.getComponent("RANKINGSELECTOR_CDI_RANKS_LIST_BOX_VIEW");
        if (this.cdiRanksListBoxView != null) {
            map2 = null;
            map2 = this.isOLAP ? ((OLAPRankingSelectorInterface)selectorModel).rankableLevelNames() : ((RelationalRankingSelectorInterface)selectorModel).rankableColumnNames();
            this.cdiRanksListBoxView.setModel((DefaultListModel)this.getDataItemNodeList(map2));
            this.cdiRanksListBoxView.setRequest(this.getRequest());
            this.cdiRanksListBoxView.setResponse(this.getResponse());
            this.cdiRanksListBoxView.setLocale(this.getLocale());
        }
        this.cdiEditButton = (Button)this.getComponent("RANKINGSELECTOR_CDI_EDIT_BUTTON");
        if (this.cdiEditButton != null) {
            this.cdiEditButton.setEnabled(false);
            this.cdiEditButton.setOnClick("sas_rankingSelector_editRank(); return false;");
            this.cdiEditButton.setAccessKey(this.editButtonAccessKey);
        }
        this.cdiClearButton = (Button)this.getComponent("RANKINGSELECTOR_CDI_CLEAR_BUTTON");
        if (this.cdiClearButton != null) {
            this.cdiClearButton.setEnabled(false);
            this.cdiClearButton.setOnClick("sas_rankingSelector_clearRank(); return false;");
            this.cdiClearButton.setAccessKey(this.clearButtonAccessKey);
        }
        this.srvRadio = (Radio)this.getComponent("RANKINGSELECTOR_SRV_TOP_BOTTOM_RADIO");
        if (this.srvRadio != null) {
            this.listModel = new DefaultListModel();
            this.listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "topRadio.txt"), "T"));
            this.listModel.addElement(new Item(this.bundle.getString(this.RB_KEY + "bottomRadio.txt"), "B"));
            this.srvRadio.setModel(this.listModel);
            try {
                this.srvRadio.setSelectedIndex(0);
            }
            catch (IOException map2) {
                // empty catch block
            }
        }
        this.srvIncludeTiesCheckBox = (CheckBox)this.getComponent("RANKINGSELECTOR_SRV_INCLUDE_TIES_CHECK_BOX");
        if (this.srvIncludeTiesCheckBox != null) {
            this.srvIncludeTiesCheckBox.setValue("1");
        }
        this.srvBasedOnChoiceBox = (ChoiceBox)this.getComponent("RANKINGSELECTOR_SRV_BASED_ON_CHOICE_BOX");
        if (this.srvBasedOnChoiceBox != null) {
            ComboBoxModel model1 = null;
            if (selectorModel instanceof OLAPRankingSelectorInterface) {
                model1 = new DefaultComboBoxModel();
            } else if (selectorModel instanceof RelationalRankingSelectorInterface) {
                model1 = this.getComboModel(((RelationalRankingSelectorInterface)selectorModel).rankableColumnNames());
            }
            this.srvBasedOnChoiceBox.setModel(model1);
        }
        this.srvEditButton = (Button)this.getComponent("RANKINGSELECTOR_SRV_EDIT_BUTTON");
        if (this.srvEditButton != null) {
            this.srvEditButton.setEnabled(true);
            token = this.srvBasedOnChoiceBox.getName();
            token = Strings.escapeForJavaScript((String)token);
            this.srvEditButton.setOnClick(new StringBuffer().append("sas_rankingSelector_srvEdit('").append(token).append("'); return false;").toString());
            this.srvEditButton.setAccessKey(this.editButtonAccessKey);
        }
        this.srqRanksQualifier = (QualifiersSelector)this.getComponent("RANKINGSELECTOR_QUALIFIER");
        if (this.srqRanksQualifier != null) {
            map2 = ((OLAPRankingSelectorInterface)selectorModel).rankableLevelNames();
            this.srqRanksQualifier.setSelectorModel((QualifiersSelectorInterface)new QualifiersSelectorAdapter(((BaseRankingSelectorAdapter)selectorModel).dataModel(), map2));
            this.srqRanksQualifier.setOkFunction("sas_rankingSelector_qualOK");
            this.srqRanksQualifier.setCancelFunction("sas_rankingSelector_qualCancel");
            this.srqRanksQualifier.setRequest(this.getRequest());
            this.srqRanksQualifier.setResponse(this.getResponse());
            this.srqRanksQualifier.setLocale(this.getLocale());
        }
        this.srvRankTypeChoiceBox = (ChoiceBox)this.getComponent("RANKINGSELECTOR_SRV_TYPE_CHOICE_BOX");
        if (this.srvRankTypeChoiceBox != null) {
            Map rankTypes = ((RankingSelectorInterface)selectorModel).rankTypes();
            ComboBoxModel cModel = this.getComboModel(rankTypes);
            this.srvRankTypeChoiceBox.setModel(cModel);
            this.srvRankTypeChoiceBox.setOnChange("sas_rankingSelector_respondToRankTypeChange( );");
        }
    }

    @SASScope
    protected void createCdiRanksLabel() {
        this.cdiRanksLabel = new Label();
        this.cdiRanksLabel.setId(new StringBuffer().append(this.getId()).append("_").append("cdiRanksLabel").toString());
        this.cdiRanksLabel.setStyleInfo(RSLabelStyle);
    }

    @SASScope
    protected void createCdiHintLabel() {
        this.cdiHintLabel = new Label();
        this.cdiHintLabel.setId(new StringBuffer().append(this.getId()).append("_").append("cdiHintLabel").toString());
    }

    @SASScope
    protected void createSrvRanksLabel() {
        this.srvRanksLabel = new Label();
        this.srvRanksLabel.setStyleInfo(RSLabelStyle);
        this.srvRanksLabel.setId(new StringBuffer().append(this.getId()).append("_").append("srvRanksLabel").toString());
    }

    @SASScope
    protected void createCdiRanksListBoxView() {
        this.cdiRanksListBoxView = new DataSelectorListBoxView();
        this.cdiRanksListBoxView.setSelector(this);
        this.cdiRanksListBoxView.setId(new StringBuffer().append(this.getId()).append("_").append("dataItem").toString());
        this.cdiRanksListBoxView.setSize(4);
    }

    @SASScope
    protected void createCdiEditButton() {
        this.cdiEditButton = new Button();
        this.cdiEditButton.setId(new StringBuffer().append(this.getId()).append("_").append("cdiEditButton").toString());
    }

    @SASScope
    protected void createCdiClearButton() {
        this.cdiClearButton = new Button();
        this.cdiClearButton.setId(new StringBuffer().append(this.getId()).append("_").append("cdiClearButton").toString());
    }

    @SASScope
    protected void createSrvTopBottomRadioBox() {
        this.srvRadio = new Radio();
        this.srvRadio.setName(new StringBuffer().append(this.getId()).append("_").append("show").toString());
        this.srvRadio.setId(new StringBuffer().append(this.getId()).append("_").append("show").toString());
        this.srvRadio.setHorizontalAlignment(true);
        this.srvRadio.setLabelOrientation(this.isLeftToRight ? 4 : 2);
        this.srvRadio.setStyleInfo(RSRadioStyle);
        Map srvRadioStyleMap = this.srvRadio.getStyleMap();
        if (srvRadioStyleMap != null) {
            srvRadioStyleMap.put("RADIO_LABEL", new ImmutableStyleInfo("selectorRadioLabel"));
        }
        this.srvRadio.setOnClick("sas_rankingSelector_respondToGenericRankingValueChange();");
    }

    @SASScope
    protected void createSrvCountTextEntry() {
        this.srvCountTextEntry = new TextEntry();
        this.srvCountTextEntry.setName(new StringBuffer().append(this.getId()).append("_").append("rankingCount").toString());
        this.srvCountTextEntry.setId(new StringBuffer().append(this.getId()).append("_").append("rankingCount").toString());
        this.srvCountTextEntry.setSize(8);
        this.srvCountTextEntry.setStyleInfo(RSTextEntryStyle);
        this.srvCountTextEntry.setOnKeyUp("sas_rankingSelector_respondToCountKeyUp( event );");
    }

    @SASScope
    protected void createSrvRankTypeChoiceBox() {
        this.srvRankTypeChoiceBox = new ChoiceBox();
        this.srvRankTypeChoiceBox.setName(new StringBuffer().append(this.getId()).append("_").append("rankingType").toString());
        this.srvRankTypeChoiceBox.setId(new StringBuffer().append(this.getId()).append("_").append("rankingType").toString());
        this.srvRankTypeChoiceBox.setStyleInfo(RSChoiceStyle);
    }

    @SASScope
    protected void createSrvIncludeTiesCheckBox() {
        this.srvIncludeTiesCheckBox = new CheckBox();
        this.srvIncludeTiesCheckBox.setName(new StringBuffer().append(this.getId()).append("_").append("includeTies").toString());
        this.srvIncludeTiesCheckBox.setId(new StringBuffer().append(this.getId()).append("_").append("includeTies").toString());
        this.srvIncludeTiesCheckBox.setStyleInfo(RSCheckStyle);
        Map srvIncludeTiesCheckBoxMap = this.srvIncludeTiesCheckBox.getStyleMap();
        if (srvIncludeTiesCheckBoxMap != null) {
            srvIncludeTiesCheckBoxMap.put("CHECKBOX_LABEL", new ImmutableStyleInfo("selectorCheckBoxLabel"));
        }
        this.srvIncludeTiesCheckBox.setOnClick("sas_rankingSelector_respondToTiesChange( );");
    }

    @SASScope
    protected void createSrvBasedOnLabel() {
        this.srvBasedOnLabel = new Label();
        this.srvBasedOnLabel.setId(new StringBuffer().append(this.getId()).append("_").append("srvBasedOnLabel").toString());
        this.srvBasedOnLabel.setStyleInfo(RSLabelStyle);
    }

    @SASScope
    protected void createSrvBasedOnChoiceBox() {
        this.srvBasedOnChoiceBox = new ChoiceBox();
        this.srvBasedOnChoiceBox.setName(new StringBuffer().append(this.getId()).append("_").append("basedOn").toString());
        this.srvBasedOnChoiceBox.setId(new StringBuffer().append(this.getId()).append("_").append("basedOn").toString());
        this.srvBasedOnChoiceBox.setStyleInfo(RSChoiceWidthStyle);
        this.srvBasedOnChoiceBox.setOnChange("sas_rankingSelector_respondToBasedOnChange( );");
    }

    @SASScope
    protected void createSrvEditButton() {
        this.srvEditButton = new Button();
        this.srvEditButton.setId(new StringBuffer().append(this.getId()).append("_").append("srvEditButton").toString());
        this.srvEditButton.setWidthPercentage(100);
    }

    @SASScope
    protected void createSrvRankingInfoLabel() {
        this.srvRankingInfoLabel = new Label();
        this.srvRankingInfoLabel.setId(new StringBuffer().append(this.getId()).append("_").append("srvRankingInfoLabel").toString());
        this.srvRankingInfoLabelID = this.srvRankingInfoLabel.getId();
        this.srvRankingInfoLabel.setCustomAttributes(new StringBuffer().append("id=\"").append(this.srvRankingInfoLabelID).append("\"").toString());
        this.srvRankingInfoLabel.setStyleInfo(RSLabelStyle);
    }

    @SASScope
    protected void createSrqRanksQualifier() {
        this.srqRanksQualifier = new QualifiersSelector();
        this.srqRanksQualifier.setId(new StringBuffer().append(this.getId()).append("_").append("srqRanksQualifier").toString());
        this.srqRanksQualifier.setComponents();
    }

    private ListModel getDataItemNodeList(Map map2) {
        DefaultListModel<DataItemNode> model2 = null;
        if (map2 != null) {
            model2 = new DefaultListModel<DataItemNode>();
            Iterator iterator = map2.keySet().iterator();
            Object selectorModel = this.getSelectorModel();
            while (iterator.hasNext()) {
                String description = (String)iterator.next();
                String name = (String)map2.get(description);
                String javaName = Util.createJavaIdentifier((String)name);
                String rankStatus = ((RankingSelectorInterface)selectorModel).dataItemRankStatus(name);
                model2.addElement(this.getDataItemNode(javaName, name, description, rankStatus));
            }
        }
        return model2;
    }

    private DataItemNode getDataItemNode(String name, String value, String text, String description) {
        DataItemNode node = new DataItemNode();
        node.setName(name);
        node.setValue(value);
        node.setText(text);
        node.setDescription(description);
        node.setSelectNodeFunctionName("sas_rankingSelector_dataItemSelected");
        return node;
    }

    private ComboBoxModel getComboModel(Map map3) {
        DefaultComboBoxModel<Item> model3 = null;
        if (map3 != null) {
            model3 = new DefaultComboBoxModel<Item>();
            Item item = null;
            String key2 = null;
            String value = null;
            for (String key2 : map3.keySet()) {
                value = map3.get(key2).toString();
                item = new Item();
                item.setText(key2);
                item.setValue(value);
                model3.addElement(item);
            }
        }
        return model3;
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        this.parameterPrefix = this.getActionProvider().getParameterPrefix();
    }

    @Override
    public void setSelectorModel(Object selectorModel) {
        super.setSelectorModel(selectorModel);
        if (selectorModel instanceof RelationalRankingSelectorInterface || selectorModel instanceof OLAPRankingSelectorInterface) {
            if (this.selectorModel != selectorModel) {
                super.setSelectorModel(selectorModel);
                this.selectorModel = selectorModel;
                this.isOLAP = selectorModel instanceof OLAPRankingSelectorInterface;
            }
            ((RankingSelectorInterface)selectorModel).setLocale(this.getLocale());
        }
    }

    @Override
    public Object getSelectorModel() {
        return this.selectorModel;
    }
}

