/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.qualifiers.html;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.LabeledStringValueInterface;
import com.sas.dataselectors.qualifiers.QualifiersSelectorAdapter;
import com.sas.dataselectors.qualifiers.QualifiersSelectorInterface;
import com.sas.dataselectors.qualifiers.RB;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.DataItemNode;
import com.sas.servlet.tbeans.dataselectors.html.DataSelectorListBoxView;
import com.sas.servlet.tbeans.dataselectors.qualifiers.html.QualifiersSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.qualifiers.html.QualifiersSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.ListBoxView;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.html.TreeViewFull;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.DefaultListModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class QualifiersSelector
extends BaseCompositeTransformation
implements QualifiersSelectorStyleKeysInterface,
QualifiersSelectorKeysInterface {
    private static final boolean DEBUG = false;
    private String cancelFunction;
    private String okFunction;
    private String iframeName;
    private String noSelection;
    private String defaultNoSelection;
    private Form form;
    @SASScope
    protected Form _remoteScriptForm = null;
    @SASScope
    protected String _remoteScriptURL = null;
    ArrayList treeViewList = new ArrayList();
    @SASScope
    public final String DEFAULT_TEMPLATE_FILE_NAME = "QualifierSelector.html";
    private QualifiersSelectorInterface selectorModel;
    @SASScope
    public static final String RB_KEY = "QualifiersEditorBQ.";
    @SASScope
    public static final String RB_KEY2 = "QualifierSelector.";
    private static final HashMap defaultStyleMap;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("QUALIFIERSELECTOR_CONTAINER", new ImmutableStyleInfo("selectorBackground"));
            defaultStyleMap.put("QUALIFIERSELECTOR_WHERE_LABEL_AREA", new ImmutableStyleInfo("selectorLabel"));
            defaultStyleMap.put("QUALIFIERSELECTOR_FOR_LABEL_AREA", new ImmutableStyleInfo("selectorLabelTop"));
            defaultStyleMap.put("QUALIFIERSELECTOR_FOR_TEXT_AREA", new ImmutableStyleInfo("dataItemNodeText"));
            defaultStyleMap.put("QUALIFIERSELECTOR_FOR_DESCRIPTION_AREA", new ImmutableStyleInfo("dataItemNodeDescription"));
            defaultStyleMap.put("QUALIFIERSELECTOR_WHERE_AREA", new ImmutableStyleInfo("selectorText"));
            defaultStyleMap.put("QUALIFIERSELECTOR_TREE_AREA", new ImmutableStyleInfo("qualifierSelectorTreeArea"));
            defaultStyleMap.put("QUALIFIERSELECTOR_BUTTON_CONTAINER", new ImmutableStyleInfo("SelectorButtonContainer"));
            defaultStyleMap.put("QUALIFIERSELECTOR_BUTTON_TABLE", new ImmutableStyleInfo("SelectorButtonTable"));
        }
    }

    public QualifiersSelector() {
        this(null);
    }

    public QualifiersSelector(String name) {
        this.setId(name == null ? Util.getName((String)"qlSel") : name);
        this.setTemplateKey("Qualifier_Selector");
        QualifiersSelector.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponents();
        this._setLocaleDependentProperties(this.getLocale());
    }

    @SASScope
    public void setComponents() {
        if (this.getComponents().isEmpty()) {
            this.setComponent("QUALIFIERSELECTOR_WHERE_LABEL", this.getWhereLabel());
            this.setComponent("QUALIFIERSELECTOR_WHERE", this.getWhere());
            this.setComponent("QUALIFIERSELECTOR_FOR_LABEL", this.getForLabel());
            this.setComponent("QUALIFIERSELECTOR_FOR_TABLE", this.getForTable());
            this.setComponent("QUALIFIERSELECTOR_TREE", this.getTree());
            this.setComponent("QUALIFIERSELECTOR_OK", this.getOkButton());
            this.setComponent("QUALIFIERSELECTOR_CANCEL", this.getCancelButton());
            this.setComponent("QUALIFIERSELECTOR_CLEAR", this.getClearButton());
        }
    }

    @Override
    @SASScope
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        ((Label)this.getComponent("QUALIFIERSELECTOR_WHERE_LABEL")).setText(this._rbstr("itemLabel.txt", currentLocale));
        ((Label)this.getComponent("QUALIFIERSELECTOR_FOR_LABEL")).setText(this._rbstr("itemsLabel.txt", currentLocale));
        DataSelectorListBoxView view = (DataSelectorListBoxView)this.getComponent("QUALIFIERSELECTOR_FOR_TABLE");
        view.getItemLabel().setText(this._rbstr("itemsNameColumnLabel.txt", currentLocale));
        view.getItemDescription().setText(this._rbstr("itemsValueColumnLabel.txt", currentLocale));
        ((Button)this.getComponent("QUALIFIERSELECTOR_OK")).setLabel(this._rbstr2("OK.txt", currentLocale));
        ((Button)this.getComponent("QUALIFIERSELECTOR_CANCEL")).setLabel(this._rbstr2("cancel.txt", currentLocale));
        ((Button)this.getComponent("QUALIFIERSELECTOR_CLEAR")).setLabel(this._rbstr("clear.txt", currentLocale));
        this.defaultNoSelection = this._rbstr("noSelection.txt", currentLocale);
    }

    private String _rbstr(String id, Locale loc) {
        return RB.getStringResource((String)RB_KEY, (String)id, (Locale)loc);
    }

    private String _rbstr2(String id, Locale loc) {
        return com.sas.servlet.tbeans.dataselectors.html.RB.getStringResource(RB_KEY2, id, loc);
    }

    @Override
    public TransformationInterface setComponent(String componentKey, TransformationInterface tbean) {
        if (tbean instanceof ComplexStyleInterface) {
            ((ComplexStyleInterface)((Object)tbean)).getStyleMap().putAll(this.getStyleMap());
        }
        return super.setComponent(componentKey, tbean);
    }

    void writeJS(PrintWriter out) throws IOException {
        out.println(JavaScriptIncludeHandler.getStartScript());
        TreeView tv = (TreeView)this.getComponent("QUALIFIERSELECTOR_TREE");
        DataSelectorListBoxView dlv = (DataSelectorListBoxView)this.getComponent("QUALIFIERSELECTOR_FOR_TABLE");
        ListBoxView lv = dlv.getListBox();
        out.println(this.getId() + " = new sas_QS(" + lv.getId() + ", " + tv.getId() + ");");
        out.println(this.getId() + ".rsForm = \"" + this._remoteScriptForm.getName() + "\";");
        out.println(this.getId() + ".session = \"" + this.getId() + "\";");
        out.println(this.getId() + ".okFunction = " + this.getOkFunction() + ";");
        out.println(this.getId() + ".cancelFunction = " + this.getCancelFunction() + ";");
        if (this.getNoSelection() != null) {
            out.println(this.getId() + ".noSelectionDescription= " + Strings.quote((String)this.getNoSelection()) + ";");
        }
        String textStyle = ((StyleInfo)this.getStyleMap().get("QUALIFIERSELECTOR_FOR_TEXT_AREA")).getClassid();
        out.println(lv.getId() + ".nodeTextStyle = \"" + textStyle + "\";");
        String descStyle = ((StyleInfo)this.getStyleMap().get("QUALIFIERSELECTOR_FOR_DESCRIPTION_AREA")).getClassid();
        out.println(lv.getId() + ".nodeDescriptionStyle = \"" + descStyle + "\";");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.getRequest().getSession().setAttribute(this.getId(), (Object)this);
        this.setComponents();
        this.hookUp();
        this.getComponents().putAll(this.getStyleMap());
        this.setRequest(this.getRequest());
        super.write(out);
        JavaScriptIncludeHandler.writeIncludes(out, "QUALIFIER", this.getRequest());
        String formattedSelector = this.applyTemplate(this);
        out.println(formattedSelector);
        if (this.form == null) {
            this.writeRemoteScriptForm(out);
            this.writeRemoteScriptFrame(out);
        } else {
            this._remoteScriptForm = this.form;
        }
        this.writeJS(out);
        TreeView tv = (TreeView)this.getComponent("QUALIFIERSELECTOR_TREE");
        this.getRequest().getSession().setAttribute(tv.getId(), (Object)tv);
        this.cleanUpResources();
    }

    @SASScope
    public QualifiersSelectorInterface getSelectorModel() {
        return this.selectorModel;
    }

    @SASScope
    public void setSelectorModel(QualifiersSelectorInterface dataModel) {
        this.selectorModel = dataModel;
    }

    @SASScope
    public static HashMap getDefaultStyleMap() {
        return defaultStyleMap;
    }

    @SASScope
    protected Label getForLabel() {
        Label l = new Label();
        l.setId(this.getId() + "_ForLabel");
        return l;
    }

    @SASScope
    protected DataSelectorListBoxView getForTable() {
        DataSelectorListBoxView view = new DataSelectorListBoxView();
        view.setId(this.getId() + "_Table");
        view.setItemLabel(new Label());
        view.setItemDescription(new Label());
        view.setSize(4);
        view.getListBox().getStyleMap().put("LISTBOXVIEW_TEXT", new StyleInfo("dataItemNodeText"));
        return view;
    }

    @SASScope
    protected DefaultListModel createListModel() {
        if (this.selectorModel == null) {
            return new DefaultListModel();
        }
        DefaultListModel<DataItemNode> model = new DefaultListModel<DataItemNode>();
        for (int i = 0; i < this.selectorModel.getNumberOfItems(); ++i) {
            DataItemNode newnode = new DataItemNode();
            newnode.setText(this.selectorModel.getName(i));
            String desc = this.selectorModel.getDescription(i);
            if (desc == null || desc.length() == 0) {
                desc = this.getNoSelection();
            }
            if (desc == null) {
                desc = "[no selection]";
            }
            newnode.setDescription(desc);
            newnode.setValue(this.selectorModel.getValue(i));
            model.addElement(newnode);
        }
        return model;
    }

    @SASScope
    public void hookUp() {
        DataSelectorListBoxView view = (DataSelectorListBoxView)this.getComponent("QUALIFIERSELECTOR_FOR_TABLE");
        DefaultListModel model = this.createListModel();
        view.setModel(model);
        TreeView tv = (TreeView)this.getComponent("QUALIFIERSELECTOR_TREE");
        tv.setSelectNodeFunctionName("sas_QS_selectTreeNode");
        Button button = (Button)this.getComponent("QUALIFIERSELECTOR_CANCEL");
        button.setOnClick(this.getId() + ".clickCancel()");
        button = (Button)this.getComponent("QUALIFIERSELECTOR_CLEAR");
        button.setOnClick(this.getId() + ".clickClear()");
        button = (Button)this.getComponent("QUALIFIERSELECTOR_OK");
        button.setOnClick(this.getId() + ".clickOK()");
    }

    @SASScope
    protected TreeView getTree() {
        TreeView tv = new TreeView(this.getId() + "_TreeView");
        tv.setModel(new DefaultTreeModel(new com.sas.servlet.tbeans.models.TreeNode(null, "ROOT")));
        tv.setRootNodeVisible(false);
        tv.setUsingURLLinks(false);
        tv.setImageVisible(false);
        tv.setSelectionMode(1);
        tv.setNodeLoading(2);
        tv.setTransform(new TreeNodeTransform());
        return tv;
    }

    @SASScope
    protected TransformationInterface getWhere() {
        Label label = new Label();
        label.setId(this.getId() + "_Where");
        return label;
    }

    @SASScope
    protected Button getCancelButton() {
        Button button = new Button();
        button.setId(this.getId() + "_CancelButton");
        return button;
    }

    @SASScope
    protected Button getClearButton() {
        Button button = new Button();
        button.setId(this.getId() + "_ClearButton");
        return button;
    }

    @SASScope
    protected Button getOkButton() {
        Button button = new Button();
        button.setId(this.getId() + "_OKButton");
        return button;
    }

    @SASScope
    public Label getWhereLabel() {
        Label label = new Label();
        label.setId(this.getId() + "_WhereLabel");
        return label;
    }

    public String getCancelFunction() {
        return this.cancelFunction;
    }

    public String getOkFunction() {
        return this.okFunction;
    }

    public void setCancelFunction(String cancelFunction) {
        this.cancelFunction = cancelFunction;
    }

    public void setOkFunction(String okFunction) {
        this.okFunction = okFunction;
    }

    public void setNoSelection(String noSelection) {
        this.noSelection = noSelection;
    }

    private String getNoSelection() {
        if (this.noSelection != null) {
            return this.noSelection;
        }
        return this.defaultNoSelection;
    }

    public void writeRemoteScriptFrame(PrintWriter out) throws IOException {
        HtmlUtil.writeHiddenIFrame(out, this.getIframeName(), this.getRequest());
    }

    @SASScope
    public void setForm(Form form) {
        this.form = form;
    }

    public void writeRemoteScriptForm(PrintWriter out) throws IOException {
        if (this._remoteScriptForm == null) {
            this._remoteScriptForm = new Form();
            this._remoteScriptForm.setName(this.getId() + "_RSForm");
            this._remoteScriptForm.setTarget(this.getIframeName());
            this._remoteScriptForm.setId(this.getId() + "_RSForm");
            this._remoteScriptURL = null;
        }
        this._remoteScriptForm.setRequest(this.getRequest());
        this._remoteScriptForm.setAction(this.getRemoteScriptURL());
        if (this._remoteScriptForm.isVisible()) {
            this._remoteScriptForm.writeHeader(out);
            Hidden.writeElement(out, null, "CLASS_PARAMETER", QualifiersSelector.class.getName(), true);
            Hidden.writeElement(out, null, "METHOD_PARAMETER", "", true);
            Hidden.writeElement(out, null, "sas_charEncoding", BaseUtil.getOutputCharacterEncoding(this.getRequest()), true);
            this._remoteScriptForm.writeFooter(out);
        }
    }

    @SASScope
    public String getRemoteScriptURL() {
        return "MethodInvocationServlet";
    }

    @SASScope
    public String getIframeName() {
        if (this.iframeName == null) {
            this.iframeName = this.getId() + "_RSIFrame";
        }
        return this.iframeName;
    }

    @SASScope
    public void setIframeName(String iframeName) {
        this.iframeName = iframeName;
    }

    @SASScope
    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("qs");
        QualifiersSelector qs = (QualifiersSelector)request.getSession().getAttribute(name);
        String cmd = request.getParameter("METHOD_PARAMETER");
        ServletOutputStream out = response.getOutputStream();
        PrintWriter writer = new PrintWriter((OutputStream)out);
        writer.println(JavaScriptIncludeHandler.getStartScript());
        if ("qsTreeCommand".equals(cmd)) {
            qs.writeTreeRemoteScriptCommands(writer, request);
        } else if ("qsForCommand".equals(cmd)) {
            qs.writeListRemoteScriptCommands(writer);
        } else if ("qsOKCommand".equals(cmd)) {
            qs.writeOKRemoteScriptCommands(writer, request);
        }
        writer.println(JavaScriptIncludeHandler.getEndScript(null));
        writer.flush();
    }

    @SASScope
    public void writeListRemoteScriptCommands(PrintWriter out) throws IOException {
        QualifiersSelectorInterface data = this.getSelectorModel();
        StringBuffer sb = new StringBuffer();
        this.handleListBox(sb, data);
        this.handleItemName(sb, data);
        int skipIndex = this.handleSkipItem(sb, data);
        this.handleInitialValues(sb, data, skipIndex);
        sb.append("parent.").append(this.getId()).append(".setDivToTree(null);\n");
        out.println(sb);
    }

    private void handleListBox(StringBuffer sb, QualifiersSelectorInterface data) {
        sb.append("parent.").append(this.getId()).append(".clearListBox();\n");
        for (int i = 0; i < data.getNumberOfItems(); ++i) {
            String desc = data.getDescription(i);
            if (desc == null) {
                desc = this.getNoSelection();
            }
            sb.append("parent.").append(this.getId()).append(".addNode(").append(Strings.quote((String)data.getName(i))).append(", ").append(Strings.quote((String)desc)).append(");\n");
        }
    }

    private void handleItemName(StringBuffer sb, QualifiersSelectorInterface data) {
        if (data.getItemName() != null) {
            sb.append("parent.").append(this.getId()).append(".setWhere(\"").append(data.getItemName()).append("\");\n");
        }
    }

    private int handleSkipItem(StringBuffer sb, QualifiersSelectorInterface data) {
        int skipIndex = -1;
        if (data.getSkipItem() != null) {
            for (int i = 0; i < data.getNumberOfItems(); ++i) {
                if (!data.getValue(i).equals(data.getSkipItem())) continue;
                skipIndex = i;
                break;
            }
            sb.append("parent.").append(this.getId()).append(".setSkip(").append(skipIndex).append(");\n");
        }
        return skipIndex;
    }

    private void handleInitialValues(StringBuffer sb, QualifiersSelectorInterface data, int skipIndex) {
        for (int i = 0; i < data.getNumberOfItems(); ++i) {
            if (data.getSelectedValue(i) == null) continue;
            this.handleInitialValue(sb, data, skipIndex, i);
        }
    }

    private void handleInitialValue(StringBuffer sb, QualifiersSelectorInterface data, int skipIndex, int index) {
        String desc = data.getDescription(index);
        String value = data.getSelectedValue(index);
        if (index > skipIndex && skipIndex >= 0) {
            --index;
        }
        sb.append("parent.").append(this.getId()).append(".setSelected(").append(index).append(", ").append(Strings.quote((String)desc)).append(", ").append(Strings.quote((String)value)).append(");\n");
    }

    @SASScope
    public void writeOKRemoteScriptCommands(PrintWriter out, HttpServletRequest request) throws IOException {
        String path = request.getParameter("path");
    }

    @SASScope
    public static void qsTreeCommand(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("qs");
        QualifiersSelector qs = (QualifiersSelector)request.getSession().getAttribute(name);
        ServletOutputStream out = response.getOutputStream();
        PrintWriter writer = new PrintWriter((OutputStream)out);
        out.println(JavaScriptIncludeHandler.getStartScript());
        qs.writeTreeRemoteScriptCommands(writer, request);
        writer.flush();
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @SASScope
    public void writeTreeRemoteScriptCommands(PrintWriter out, HttpServletRequest request) throws IOException {
        String treenum = request.getParameter("treenum");
        if (treenum == null) {
            return;
        }
        int treenumint = Integer.parseInt(treenum);
        for (int i = this.treeViewList.size(); i < this.getSelectorModel().getNumberOfItems(); ++i) {
            this.treeViewList.add(null);
        }
        TreeView tv = (TreeView)this.treeViewList.get(treenumint);
        if (tv == null) {
            tv = this.buildNewTree(treenumint, request);
        } else {
            tv.setRequest(request);
        }
        TreeViewFull tvf = new TreeViewFull(tv);
        out.println("with (parent) {");
        out.println(" if (parent." + this.getId() + ".trees[" + treenum + "] == null) { ");
        out.println("  parent.sas_QS_addDiv( parent." + this.getId() + ", \"" + tv.getId() + "\", " + treenum + ");");
        StringBuffer sb = new StringBuffer();
        tvf.createNodesAndTree(sb);
        String selected = request.getParameter("selected");
        out.println(sb);
        out.println(tv.getId() + ".QS = parent." + this.getId() + ";");
        out.println("  parent." + this.getId() + ".trees[" + treenum + "] = " + tv.getId() + ";");
        out.println("  parent." + this.getId() + ".treeView = " + tv.getId() + ";");
        out.println("}");
        out.println("else " + tv.getId() + " = " + this.getId() + ".trees[" + treenum + "];");
        if (selected != null && selected.length() > 0) {
            this.handleSelectedItem(out, treenumint, selected, tv, tvf);
        }
        out.println("}");
    }

    private TreeView buildNewTree(int treenumint, HttpServletRequest request) {
        TreeView tv = this.getTree();
        tv.setSelectNodeFunctionName("sas_QS_selectTreeNode");
        TreeView otv = (TreeView)this.getComponent("QUALIFIERSELECTOR_TREE");
        tv.setRemoteScriptForm(otv.getRemoteScriptForm());
        this.treeViewList.set(treenumint, tv);
        tv.setId(tv.getId() + treenumint);
        tv.setRequest(request);
        TreeModel model = this.getSelectorModel().getTreeModel(treenumint);
        tv.setModel(model);
        return tv;
    }

    private void handleSelectedItem(PrintWriter out, int treenumint, String selected, TreeView tv, TreeViewFull tvf) {
        QualifiersSelectorAdapter qsa = (QualifiersSelectorAdapter)this.getSelectorModel();
        try {
            if (!selected.equals(qsa.getValue(treenumint))) {
                qsa.getIndexForTreeValue(selected);
            }
            StringBuffer sb = new StringBuffer();
            TreeNode selnode = (TreeNode)qsa.getSelectedNodeFor(treenumint, tv.getModel());
            sb.append("sas_TreeView_tree = " + tv.getId() + ";\n");
            tvf.expandToNode(sb, selnode);
            sb.append("parent.sas_TreeView_selectNode(sas_TreeView_node);\n");
            out.println(sb);
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)QualifiersSelector.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(QualifiersSelector.class, "QUALIFIER");
        defaultStyleMap = new HashMap();
    }

    @SASScope
    static class TreeNodeTransform
    implements TreeView.TreeNodeTransform {
        TreeNodeTransform() {
        }

        @Override
        public void transform(TreeNodeInterface node, Object obj) {
            if (obj instanceof LabeledStringValueInterface) {
                LabeledStringValueInterface tn = (LabeledStringValueInterface)obj;
                node.setName(tn.getValue());
                node.setURL(tn.getValue());
                node.setText(tn.getLabel());
            } else {
                node.setText(obj.toString());
            }
        }
    }
}

