/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.html;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.SelectorCloseInterface;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.SelectorContainerKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.DataSelector;
import com.sas.servlet.tbeans.dataselectors.html.RB;
import com.sas.servlet.tbeans.dataselectors.html.SelectorContainerStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope(value="ALL")
public abstract class AbstractSelectorContainer
extends DataSelector
implements SelectorContainerStyleKeysInterface,
SelectorContainerKeysInterface,
SelectorCloseInterface {
    @SASScope
    public static final String RB_KEY = "AbstractSelectorContainer.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "SelectorContainer.html";
    @SASScope
    protected SelectorPanel dataSelectorPanel;
    private Object selectorModel = null;
    @SASScope
    protected BaseButton okButton;
    @SASScope
    protected BaseButton cancelButton;
    @SASScope
    protected BaseButton helpButton;
    @SASScope
    protected boolean okButtonVisible;
    @SASScope
    protected boolean cancelButtonVisible;
    @SASScope
    protected boolean helpButtonVisible;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            ImmutableStyleInfo SelectorContainerStyle = new ImmutableStyleInfo("SelectorContainer");
            defaultStyleMap.put("SELECTOR_CONTAINER", SelectorContainerStyle);
            SelectorContainerStyle = new ImmutableStyleInfo("SelectorButtonContainer");
            defaultStyleMap.put("SELECTOR_BUTTON_CONTAINER", SelectorContainerStyle);
            SelectorContainerStyle = new ImmutableStyleInfo("SelectorButtonTable");
            defaultStyleMap.put("SELECTOR_BUTTON_TABLE", SelectorContainerStyle);
            SelectorContainerStyle = new ImmutableStyleInfo("SelectorContainerOKButton");
            defaultStyleMap.put("SELECTOR_CONTAINER_OK_BUTTON", SelectorContainerStyle);
            SelectorContainerStyle = new ImmutableStyleInfo("SelectorContainerCancelButton");
            defaultStyleMap.put("SELECTOR_CONTAINER_CANCEL_BUTTON", SelectorContainerStyle);
            SelectorContainerStyle = new ImmutableStyleInfo("SelectorContainerHelpButton");
            defaultStyleMap.put("SELECTOR_CONTAINER_HELP_BUTTON", SelectorContainerStyle);
        }
    }

    public AbstractSelectorContainer(String id) {
        this.setId(id);
        AbstractSelectorContainer.setupDefaultStyleMap();
        MapWithDefaults stylemap = (MapWithDefaults)this.getStyleMap();
        stylemap.setDefaultMap((Map)defaultStyleMap);
        this.setTemplateKey("Selector_Container");
        this.setFormEnabled(false);
        this.okButtonVisible = true;
        this.cancelButtonVisible = true;
        this.helpButtonVisible = false;
        this.setComponents();
        this._setLocaleDependentProperties(Locale.getDefault());
    }

    public AbstractSelectorContainer() {
        this(null);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        BaseButton _helpButton;
        BaseButton _cancelButton;
        BaseButton _okButton = (BaseButton)this.getComponent("SELECTORCONTAINER_OK_BUTTON");
        if (_okButton != null) {
            _okButton.setLabel(RB.getStringResource(RB_KEY, "ok.txt", locale));
        }
        if ((_cancelButton = (BaseButton)this.getComponent("SELECTORCONTAINER_CANCEL_BUTTON")) != null) {
            _cancelButton.setLabel(RB.getStringResource(RB_KEY, "cancel.txt", locale));
        }
        if ((_helpButton = (BaseButton)this.getComponent("SELECTORCONTAINER_HELP_BUTTON")) != null) {
            _helpButton.setLabel(RB.getStringResource(RB_KEY, "help.txt", locale));
        }
    }

    @Override
    @SASScope
    protected void setLocaleDependentProperties(Locale loc) {
        super.setLocaleDependentProperties(loc);
        this._setLocaleDependentProperties(loc);
    }

    @SASScope
    protected void setComponents() {
        Button _okButton = new Button();
        _okButton.setRequest(this.getRequest());
        _okButton.setOnClick("document.forms['" + this.getFormObject().getName() + "'].submit();");
        this.setComponent("SELECTORCONTAINER_OK_BUTTON", _okButton);
        Button _cancelButton = new Button();
        _cancelButton.setRequest(this.getRequest());
        _cancelButton.setOnClick("window.close();");
        this.setComponent("SELECTORCONTAINER_CANCEL_BUTTON", _cancelButton);
        Button _helpButton = new Button();
        _helpButton.setRequest(this.getRequest());
        _helpButton.setVisible(false);
        this.setComponent("SELECTORCONTAINER_HELP_BUTTON", _helpButton);
    }

    public void setSelectorButtonIds(String id) {
        BaseButton _helpButton;
        BaseButton _cancelButton;
        BaseButton _okButton = (BaseButton)this.getComponent("SELECTORCONTAINER_OK_BUTTON");
        if (_okButton != null) {
            _okButton.setId(id + "_selButtonOk");
        }
        if ((_cancelButton = (BaseButton)this.getComponent("SELECTORCONTAINER_CANCEL_BUTTON")) != null) {
            _cancelButton.setId(id + "_selButtonCancel");
        }
        if ((_helpButton = (BaseButton)this.getComponent("SELECTORCONTAINER_HELP_BUTTON")) != null) {
            _helpButton.setId(id + "_selButtonHelp");
        }
    }

    @SASScope
    public void setDataSelectorPanel(SelectorPanel selectorpanel) {
        this.setComponent("SELECTORCONTAINER_PANEL", selectorpanel);
    }

    @SASScope
    public SelectorPanel getDataSelectorPanel() {
        if (this.getComponent("SELECTORCONTAINER_PANEL") != null) {
            return (SelectorPanel)this.getComponent("SELECTORCONTAINER_PANEL");
        }
        return null;
    }

    @Override
    @SASScope
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        SelectorPanel selector = this.getDataSelectorPanel();
        if (selector != null) {
            selector.setRequest(request);
        }
    }

    @Override
    @SASScope
    public void setResponse(HttpServletResponse response) {
        super.setResponse(response);
        SelectorPanel selector = this.getDataSelectorPanel();
        if (selector != null) {
            selector.setResponse(response);
        }
    }

    @Override
    public void setSelectorModel(Object selectormodel) {
        this.selectorModel = selectormodel;
        SelectorPanel selector = this.getDataSelectorPanel();
        if (selector != null) {
            selector.setSelectorModel(selectormodel);
        }
    }

    @Override
    public Object getSelectorModel() {
        return this.selectorModel;
    }

    public void writeRemoteScriptCommands(PrintWriter out) throws IOException {
    }

    public void writeRemoteScriptFrame(PrintWriter out) throws IOException {
        HtmlUtil.writeHiddenIFrame(out, this.getId() + "_RSIFrame", this.getRequest());
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        SelectorPanel selector = this.getDataSelectorPanel();
        selector.setActionProvider(this.getActionProvider());
        selector.setCommandId(this.getCommandId());
        selector.setFormEnabled(true);
        selector.setSelector(this);
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>(2);
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("SELECTORCONTAINER_BUTTON_ROW_ID", this.getId() + "_ButtonRow");
        this.writeRemoteScriptFrame(out);
        Form containerform = this.getFormObject();
        if (this.isFormEnabled()) {
            containerform.writeHeader(out);
        }
        selector.setIframeName(this.getId() + "_RSIFrame");
        TemplateSupport.writeTemplate(this, null, out);
        if (this.isFormEnabled()) {
            containerform.writeFooter(out);
        }
        this.cleanUpResources();
    }

    @SASScope
    protected int initializeBaseFormElementTabIndex(int index, BaseCompositeTransformation composite, String componentKey) {
        int result = index;
        BaseFormElement component = (BaseFormElement)composite.getComponent(componentKey);
        if (component != null && component.isVisible() && component.getTabIndex().equalsIgnoreCase("")) {
            component.setTabIndex(Integer.toString(index));
            ++result;
        }
        return result;
    }

    @SASScope
    protected int initializeBaseButtonTabIndex(int index, BaseCompositeTransformation composite, String componentKey) {
        int result = index;
        BaseButton component = (BaseButton)composite.getComponent(componentKey);
        if (component != null && component.isVisible() && component.getTabIndex() <= 0) {
            component.setTabIndex(index);
            ++result;
        }
        return result;
    }

    public void close() {
        TransformationInterface panel = this.getComponent("SELECTORCONTAINER_PANEL");
        if (panel != null && panel instanceof SelectorPanel) {
            ((SelectorPanel)panel).close();
        } else if (this.dataSelectorPanel != null) {
            this.dataSelectorPanel.close();
        }
    }
}

