/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.format.html;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.collection.ContentsChangedEvent;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionUtil;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.models.formats.FormatDescription;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.format.html.FormatSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.format.html.FormatSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.format.html.RB;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.ListBox;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.util.validators.MaximumValueValidator;
import com.sas.servlet.tbeans.util.validators.MinimumValueValidator;
import com.sas.servlet.tbeans.util.validators.NumericInputValidator;
import com.sas.servlet.tbeans.util.validators.RequiredStringValidator;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import com.sas.swing.visuals.dataselectors.format.FormatTypeAdapterInterface;
import com.sas.text.Message;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.swing.DefaultComboBoxModel;

public class FormatSelectorPanel
extends SelectorPanel
implements FormatSelectorKeysInterface,
FormatSelectorStyleKeysInterface {
    private Form form;
    private String parameterPrefix;
    private String RB_KEY = "FormatSelectorPanel.";
    private FormatAdapterInterface formatAdapter;
    private Map formatTypes;
    private List formatTypesList;
    private Map formatDescriptors;
    private List formatsList;
    private Object errorMessage;
    private Object formatTypeSelected;
    private Object formatSelected;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "FormatSelectorPanel.html";
    protected Label dataItemLabel;
    protected Label dataItemValueLabel;
    protected Label formatTypeLabel;
    protected ChoiceBox formatTypeChoice;
    protected ListBox formatList;
    protected Label widthLabel;
    protected TextEntry widthEntry;
    protected Label decimalLabel;
    protected TextEntry decimalEntry;
    protected Label exampleLabel;
    protected Label formatExample;
    protected Label formatDescription;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo labelStyle = new ImmutableStyleInfo("selectorLabel fullWidth");
    private static final ImmutableStyleInfo descriptionLabelStyle = new ImmutableStyleInfo("selectorLabel formatSelectorDescriptionLabel");
    private static final ImmutableStyleInfo textEntryStyle = new ImmutableStyleInfo("selectorTextEntry");
    private static final ImmutableStyleInfo listBoxStyle = new ImmutableStyleInfo("selectorListBox formatSelectorListBox fullWidth");
    private static final ImmutableStyleInfo choiceBoxStyle = new ImmutableStyleInfo("selectorChoiceBox fullWidth");
    protected int minWidth = -1;
    protected int maxWidth = 0;
    protected int minDecimalWidth = -1;
    protected int maxDecimalWidth = 0;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("FORMATSELECTOR_LABEL", labelStyle);
            defaultStyleMap.put("FORMATSELECTOR_DESCRIPTION_LABEL", descriptionLabelStyle);
            defaultStyleMap.put("FORMATSELECTOR_CHOICE", choiceBoxStyle);
            defaultStyleMap.put("FORMATSELECTOR_LIST", listBoxStyle);
            defaultStyleMap.put("FORMATSELECTOR_TEXT_ENTRY", textEntryStyle);
        }
    }

    public FormatSelectorPanel() {
        this(Util.getName((String)"forSel_panel"));
    }

    public FormatSelectorPanel(String name) {
        this.setId(name);
        this.setTemplateKey("Format_Selector_Panel");
        FormatSelectorPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.formatTypesList = new ArrayList();
        this.formatTypes = new HashMap();
        this.formatDescriptors = new HashMap();
        this.formatsList = new ArrayList();
        this.addComponents();
        super.setLocaleDependentProperties(this.getLocale());
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.dataItemLabel = (Label)this.getComponent("FORMATSELECTOR_DATA_ITEM_LABEL");
        if (this.dataItemLabel != null) {
            this.dataItemLabel.setText(RB.getStringResource(this.RB_KEY, "dataItemLabel.txt", locale));
        }
        this.formatTypeLabel = (Label)this.getComponent("FORMATSELECTOR_FORMAT_TYPE_LABEL");
        if (this.formatTypeLabel != null) {
            this.formatTypeLabel.setText(RB.getStringResource(this.RB_KEY, "formatTypeLabel.txt", locale));
        }
        this.widthLabel = (Label)this.getComponent("FORMATSELECTOR_WIDTH_LABEL");
        if (this.widthLabel != null) {
            this.widthLabel.setText(RB.getStringResource(this.RB_KEY, "widthLabel.txt", locale));
        }
        this.decimalLabel = (Label)this.getComponent("FORMATSELECTOR_DECIMAL_LABEL");
        if (this.decimalLabel != null) {
            this.decimalLabel.setText(RB.getStringResource(this.RB_KEY, "decimalLabel.txt", locale));
        }
        this.exampleLabel = (Label)this.getComponent("FORMATSELECTOR_EXAMPLE_LABEL");
        if (this.exampleLabel != null) {
            this.exampleLabel.setText(RB.getStringResource(this.RB_KEY, "exampleLabel.txt", locale));
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "FORMATSELECTORPANEL", this.getRequest());
        this.form = this.getFormObject();
        this.form.setRequest(this.getRequest());
        this.form.setResponse(this.getResponse());
        this.form.setLocale(this.getLocale());
        this.form.setValidationEnabled(true);
        this.form.setTarget(this.getIframeName());
        TransformationInterface validationComponent = this.getComponent("FORMATSELECTOR_WIDTH_ENTRY");
        if (!this.form.getComponents().contains(validationComponent)) {
            this.form.addComponent(validationComponent);
        }
        validationComponent = this.getComponent("FORMATSELECTOR_DECIMAL_ENTRY");
        if (!this.form.getComponents().contains(validationComponent)) {
            this.form.addComponent(validationComponent);
        }
        this.writeSelectorPanelHeader(out);
        StringBuffer sb = new StringBuffer();
        if (this.getActionProvider() != null) {
            Hidden.writeElement(out, null, "APNAME", this.getActionProvider().getName(), true);
            String cmdId = this.getCommandId();
            Hidden.writeElement(out, null, "CMDID", cmdId == null ? "" : cmdId, true);
            Hidden.writeElement(out, null, this.parameterPrefix + "mode", "PROCESS", true);
            Hidden.writeElement(out, null, this.parameterPrefix + "action", "", true);
            Hidden.writeElement(out, null, this.parameterPrefix + "format", "", true);
            Hidden.writeElement(out, null, this.parameterPrefix + "userDefinedFormat", "", true);
        }
        out.println(sb.toString());
        this.setComponentValues();
        out.println(this.getConstructionJavaScript());
        if (this.getActionProvider() != null) {
            String title = this.getRequest().getParameter("title");
            if (title == null || title.trim().length() == 0) {
                title = this.getDescription();
            }
            String dynamicProperties = "?CMDID=" + this.getCommandId() + "&amp;" + "APNAME=" + this.getActionProvider().getName() + "&amp;" + "selectorInstance=" + this.getSelector().getId() + "&amp;" + "selector=Y" + "&amp;" + "title=" + Strings.escapeForJavaScript((String)title);
            String mode = "&amp;" + this.parameterPrefix + "mode=PROCESS";
            String formatTypeChangedString = this.getId() + ".formatTypeChanged('" + this.getFormObject().getName() + "', '" + dynamicProperties + mode + "', '" + this.parameterPrefix + "');";
            String formatSelectedString = this.getId() + ".formatSelected('" + this.getFormObject().getName() + "', '" + dynamicProperties + mode + "', '" + this.parameterPrefix + "');";
            this.formatTypeChoice.setOnChange(formatTypeChangedString);
            this.formatList.setOnChange(formatSelectedString);
        }
        String formattedSelector = this.applyTemplate(this);
        out.println(formattedSelector);
        if (this.formatAdapter != null && this.formatAdapter instanceof FormatTypeAdapterInterface) {
            String format = ((FormatTypeAdapterInterface)this.formatAdapter).getFormat();
            SASFormatAttributes atts = null;
            if (format != null) {
                try {
                    atts = SASFormatDescriptionUtil.getFormatAttributes((String)format);
                }
                catch (SASFormatException formatTypeChangedString) {
                    // empty catch block
                }
            }
            if (atts != null) {
                this.formatTypeSelected = atts.getType().toString();
                this.formatSelected = atts.getBaseFormatName();
            } else {
                this.formatTypeSelected = RB.getStringResource(this.RB_KEY, "defaultFormat.txt", this.getLocale());
            }
            this.writeRemoteScriptCommands(out);
            if (atts != null) {
                StringBuffer stb = new StringBuffer();
                stb.append(JavaScriptIncludeHandler.getStartScript());
                String remoteObjectName = "   parent." + this.getId();
                stb.append(remoteObjectName).append(".setWidth(\"").append(atts.getWidth()).append("\")\n");
                if (atts.isDecimalWidthSupported()) {
                    stb.append(remoteObjectName).append(".setDecimalWidth(\"").append(atts.getDecimalWidth()).append("\")\n");
                } else {
                    stb.append(remoteObjectName).append(".setDecimalWidth(\"").append(-1).append("\")\n");
                }
                stb.append(JavaScriptIncludeHandler.getEndScript(null));
                out.println(stb.toString());
            }
        } else {
            this.formatTypeSelected = RB.getStringResource(this.RB_KEY, "defaultFormat.txt", this.getLocale());
            this.writeRemoteScriptCommands(out);
        }
        this.writeSelectorPanelFooter(out);
        this.cleanUpResources();
    }

    protected String getConstructionJavaScript() {
        String name = this.getId();
        StringBuffer js = new StringBuffer(JavaScriptIncludeHandler.getStartScript());
        js.append(name).append(" = new sas_FormatSelectorPanel('").append(name).append("', '").append(this.parameterPrefix).append("');\n");
        js.append("selector=\"" + name + "\";");
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        return js.toString();
    }

    @Override
    public void contentsChanged(ContentsChangedEvent event) {
        if (event instanceof ActionProviderEvent) {
            Map infoMap = ((ActionProviderEvent)event).getEventInfo();
            HttpServletResponse response = (HttpServletResponse)infoMap.get("response");
            if (response == null) {
                return;
            }
            if (infoMap.containsKey("errorMessage.")) {
                this.errorMessage = infoMap.get("errorMessage.");
            }
            if (infoMap.containsKey("formatTypeChanged")) {
                this.formatTypeSelected = infoMap.get("formatTypeChanged");
            }
            if (infoMap.containsKey("formatSelected")) {
                this.formatSelected = infoMap.get("formatSelected");
            }
        }
    }

    @Override
    public void writeRemoteScriptCommands(PrintWriter out) throws IOException {
        if (this.errorMessage != null) {
            ArrayList<Object> errorList;
            if (this.errorMessage instanceof List) {
                errorList = (ArrayList<Object>)this.errorMessage;
            } else {
                errorList = new ArrayList<Object>();
                errorList.add(this.errorMessage);
            }
            for (Object e : errorList) {
                out.println(JavaScriptIncludeHandler.getStartScript());
                String message = Strings.escapeForJavaScript((String)e.toString());
                message = Strings.replace((String)message, (int)0, (int)-1, (String)"\n", (String)"\\n");
                out.println("alert(\"" + message + "\");");
                out.println(JavaScriptIncludeHandler.getEndScript(null));
            }
        }
        out.println(JavaScriptIncludeHandler.getStartScript());
        if (this.getSelectorModel() instanceof FormatAdapterInterface) {
            if (this.formatTypeSelected != null) {
                out.println(this.getRemoteScriptCommandsForFormatType(this.formatTypeSelected));
                if (this.formatSelected == null) {
                    out.println(this.getRemoteScriptCommandsForFormat(this.formatsList.get(0)));
                }
            }
            if (this.formatSelected != null) {
                out.println(this.getRemoteScriptCommandsForFormat(this.formatSelected));
            }
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        if (this.errorMessage != null) {
            this.errorMessage = null;
        }
        if (this.formatTypeSelected != null) {
            this.formatTypeSelected = null;
        }
        if (this.formatSelected != null) {
            this.formatSelected = null;
        }
    }

    private String getRemoteScriptCommandsForFormatType(Object formatType) {
        StringBuffer sb = new StringBuffer();
        if (this.getSelectorModel() instanceof FormatAdapterInterface) {
            FormatAdapterInterface ftai = (FormatAdapterInterface)this.getSelectorModel();
            String remoteObjectName = "   parent." + this.getId();
            Object category = this.formatTypes.get(formatType);
            List formats = ftai.getFormatByType(category, this.getLocale());
            if (formats != null) {
                this.formatDescriptors.clear();
                this.formatsList.clear();
                sb.append("  var formats = new Array(); \n");
                int i = 0;
                boolean formatListEnabled = true;
                if (category == null) {
                    String defaultFormat = RB.getStringResource(this.RB_KEY, "defaultFormat.txt", this.getLocale());
                    sb.append(" formats[" + i++ + "] = {text:\"" + defaultFormat + "\" , value:\"" + defaultFormat + "\"};\n");
                    formatListEnabled = false;
                    this.formatsList.add(null);
                }
                for (FormatDescription fd : formats) {
                    sb.append(" formats[" + i++ + "] = {text:\"" + fd.getBaseFormatName() + "\" , value:\"" + fd.getBaseFormatName() + "\"};\n");
                    this.formatDescriptors.put(fd.getBaseFormatName(), fd);
                    this.formatsList.add(fd.getBaseFormatName());
                }
                sb.append(remoteObjectName).append(".setFormats(formats);\n");
                if (category == null) {
                    sb.append(remoteObjectName).append(".selectFormatType(\"").append(0).append("\");\n");
                } else {
                    sb.append(remoteObjectName).append(".selectFormatType(\"").append(this.formatTypesList.indexOf(formatType) + 1).append("\");\n");
                }
                sb.append(remoteObjectName).append(".setUsingDefaultFormat(").append(!formatListEnabled).append(");\n");
                if (category == SASFormatCategory.USER_DEFINED_CATEGORY) {
                    sb.append(remoteObjectName).append(".setUsingUserDefinedFormats(").append(true).append(");\n");
                } else {
                    sb.append(remoteObjectName).append(".setUsingUserDefinedFormats(").append(false).append(");\n");
                }
            }
        }
        return sb.toString();
    }

    private String getRemoteScriptCommandsForFormat(Object format) {
        FormatDescription fd = (FormatDescription)this.formatDescriptors.get(format);
        StringBuffer sb = new StringBuffer();
        String remoteObjectName = "   parent." + this.getId();
        this.minWidth = -1;
        this.maxWidth = 0;
        this.minDecimalWidth = -1;
        this.maxDecimalWidth = 0;
        if (fd != null) {
            this.minWidth = fd.getMinWidth();
            this.maxWidth = fd.getMaxWidth();
            this.minDecimalWidth = fd.getMinDecimalWidth();
            this.maxDecimalWidth = fd.getMaxDecimalWidth();
            sb.append(remoteObjectName).append(".selectFormat(\"").append(this.formatsList.indexOf(format)).append("\");\n");
            sb.append(remoteObjectName).append(".setExampleLabelVisible(").append(true).append(");\n");
            sb.append(remoteObjectName).append(".setExample(\"").append(Strings.escapeForJavaScript((String)fd.getExample())).append("\");\n");
            sb.append(remoteObjectName).append(".setDescription(\"").append(Strings.escapeForJavaScript((String)fd.getDescription())).append("\");\n");
            sb.append(remoteObjectName).append(".setWidth(\"").append(fd.getDefaultWidth()).append("\");\n");
            if (fd.isDecimalWidthSupported()) {
                sb.append(remoteObjectName).append(".setDecimalWidth(\"").append(Math.max(fd.getDefaultDecimalWidth(), this.minDecimalWidth)).append("\");\n");
            } else {
                sb.append(remoteObjectName).append(".setDecimalWidth(\"").append(-1).append("\");\n");
            }
            String widthLabel = RB.getStringResource(this.RB_KEY, "widthLabel.fmt.txt", this.getLocale());
            widthLabel = Message.format((String)widthLabel, (Object)new Integer(this.minWidth), (Object)new Integer(this.maxWidth));
            sb.append(remoteObjectName).append(".setWidthLabel(\"").append(Strings.escapeForJavaScript((String)widthLabel)).append("\");\n");
            sb.append(remoteObjectName).append(".setDecimalWidthEnabled(").append(fd.isDecimalWidthSupported()).append(");\n");
        } else {
            sb.append(remoteObjectName).append(".setExampleLabelVisible(").append(false).append(");\n");
            sb.append(remoteObjectName).append(".setExample(\"\");\n");
            sb.append(remoteObjectName).append(".setDescription(\"").append(Strings.escapeForJavaScript((String)RB.getStringResource(this.RB_KEY, "defaultFormatDescription.txt", this.getLocale()))).append("\");\n");
            sb.append(remoteObjectName).append(".setWidthLabel(\"").append(Strings.escapeForJavaScript((String)RB.getStringResource(this.RB_KEY, "widthLabel.txt", this.getLocale()))).append("\");\n");
            sb.append(remoteObjectName).append(".setWidth(\"").append(-1).append("\");\n");
            sb.append(remoteObjectName).append(".setDecimalWidth(\"").append(-1).append("\");\n");
        }
        sb.append(remoteObjectName).append(".minWidth=").append(this.minWidth).append(";\n");
        sb.append(remoteObjectName).append(".maxWidth=").append(this.maxWidth).append(";\n");
        String message = Message.format((String)RB.getStringResource(this.RB_KEY, "minWidth.fmt.txt", this.getLocale()), (Object)new Integer(this.minWidth));
        message = Strings.escapeForJavaScript((String)message);
        sb.append(remoteObjectName).append(".minWidthMessage=\"").append(message).append("\";\n");
        message = Message.format((String)RB.getStringResource(this.RB_KEY, "maxWidth.fmt.txt", this.getLocale()), (Object)new Integer(this.maxWidth));
        message = Strings.escapeForJavaScript((String)message);
        sb.append(remoteObjectName).append(".maxWidthMessage=\"").append(message).append("\";\n");
        message = Message.format((String)RB.getStringResource(this.RB_KEY, "widthRange.fmt.txt", this.getLocale()), (Object)new Integer(this.minWidth), (Object)new Integer(this.maxWidth));
        message = Strings.escapeForJavaScript((String)message);
        sb.append(remoteObjectName).append(".widthRangeMessage=\"").append(message).append("\";\n");
        sb.append(remoteObjectName).append(".minDecimalWidth=").append(this.minDecimalWidth).append(";\n");
        sb.append(remoteObjectName).append(".maxDecimalWidth=").append(this.maxDecimalWidth).append(";\n");
        message = Message.format((String)RB.getStringResource(this.RB_KEY, "minDecimalWidth.fmt.txt", this.getLocale()), (Object)new Integer(this.minDecimalWidth));
        message = Strings.escapeForJavaScript((String)message);
        sb.append(remoteObjectName).append(".minDecimalWidthMessage=\"").append(message).append("\";\n");
        message = RB.getStringResource(this.RB_KEY, "maxDecimalWidth.txt", this.getLocale());
        message = Strings.escapeForJavaScript((String)message);
        sb.append(remoteObjectName).append(".maxDecimalWidthMessage=\"").append(message).append("\";\n");
        message = Message.format((String)RB.getStringResource(this.RB_KEY, "decimalWidthRange1.fmt.txt", this.getLocale()), (Object)new Integer(this.minDecimalWidth));
        message = Strings.escapeForJavaScript((String)message);
        sb.append(remoteObjectName).append(".decimalWidthRangeMessage=\"").append(message).append("\";\n");
        this.writeJsValidationFunctions(sb);
        return sb.toString();
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.createDataItemLabel();
            this.setComponent("FORMATSELECTOR_DATA_ITEM_LABEL", this.dataItemLabel);
            this.createDataItemValueLabel();
            this.setComponent("FORMATSELECTOR_DATA_ITEM_VALUE_LABEL", this.dataItemValueLabel);
            this.createFormatTypeLabel();
            this.setComponent("FORMATSELECTOR_FORMAT_TYPE_LABEL", this.formatTypeLabel);
            this.createFormatTypeChoiceBox();
            this.setComponent("FORMATSELECTOR_FORMAT_TYPE_CHOICE_BOX", this.formatTypeChoice);
            this.createFormatListBox();
            this.setComponent("FORMATSELECTOR_FORMAT_LIST", this.formatList);
            this.createFormatWidthLabel();
            this.setComponent("FORMATSELECTOR_WIDTH_LABEL", this.widthLabel);
            this.createFormatWidthTextEntry();
            this.setComponent("FORMATSELECTOR_WIDTH_ENTRY", this.widthEntry);
            this.createFormatDecimalLabel();
            this.setComponent("FORMATSELECTOR_DECIMAL_LABEL", this.decimalLabel);
            this.createFormatDecimalTextEntry();
            this.setComponent("FORMATSELECTOR_DECIMAL_ENTRY", this.decimalEntry);
            this.createExampleLabel();
            this.setComponent("FORMATSELECTOR_EXAMPLE_LABEL", this.exampleLabel);
            this.createFormatExampleLabel();
            this.setComponent("FORMATSELECTOR_FORMAT_EXAMPLE_LABEL", this.formatExample);
            this.createFormatDescriptionLabel();
            this.setComponent("FORMATSELECTOR_FORMAT_DESCRIPTION_LABEL", this.formatDescription);
        }
    }

    private void setComponentValues() {
        if (this.formatAdapter != null) {
            if (this.formatAdapter instanceof FormatTypeAdapterInterface) {
                this.dataItemValueLabel = (Label)this.getComponent("FORMATSELECTOR_DATA_ITEM_VALUE_LABEL");
                String dataItemLabel = ((FormatTypeAdapterInterface)this.formatAdapter).getDataItemLabel();
                if (this.dataItemValueLabel != null && dataItemLabel != null && dataItemLabel.trim().length() > 0) {
                    this.dataItemValueLabel.setText(dataItemLabel);
                    this.dataItemValueLabel.setRequest(this.getRequest());
                    this.dataItemValueLabel.setResponse(this.getResponse());
                    this.dataItemValueLabel.setLocale(this.getLocale());
                } else {
                    this.removeComponent("FORMATSELECTOR_DATA_ITEM_VALUE_LABEL");
                }
            }
            Map types = null;
            types = this.formatAdapter instanceof FormatTypeAdapterInterface ? this.formatAdapter.getFormatTypes(((FormatTypeAdapterInterface)this.formatAdapter).getType(), this.getLocale()) : this.formatAdapter.getFormatTypes(8, this.getLocale());
            this.formatTypesList.clear();
            this.formatTypes.clear();
            this.formatTypeChoice = (ChoiceBox)this.getComponent("FORMATSELECTOR_FORMAT_TYPE_CHOICE_BOX");
            if (this.formatTypeChoice != null) {
                DefaultComboBoxModel<Item> choiceModel = new DefaultComboBoxModel<Item>();
                choiceModel.addElement(new Item(RB.getStringResource(this.RB_KEY, "defaultFormat.txt", this.getLocale()), null));
                if (types != null) {
                    for (Map.Entry entry : types.entrySet()) {
                        Object key = entry.getKey();
                        if (key == null) continue;
                        choiceModel.addElement(new Item(entry.getValue().toString(), key.toString()));
                        this.formatTypesList.add(key.toString());
                        this.formatTypes.put(key.toString(), key);
                    }
                }
                this.formatTypeChoice.setModel(choiceModel);
                this.formatTypeChoice.setName(this.parameterPrefix + "formatType");
                this.formatTypeChoice.setRequest(this.getRequest());
                this.formatTypeChoice.setResponse(this.getResponse());
                this.formatTypeChoice.setLocale(this.getLocale());
            }
            this.formatList = (ListBox)this.getComponent("FORMATSELECTOR_FORMAT_LIST");
            if (this.formatList != null) {
                this.formatList.setName(this.parameterPrefix + "formatSelected");
                this.formatList.setRequest(this.getRequest());
                this.formatList.setResponse(this.getResponse());
                this.formatList.setLocale(this.getLocale());
            }
            this.widthEntry = (TextEntry)this.getComponent("FORMATSELECTOR_WIDTH_ENTRY");
            if (this.widthEntry != null) {
                this.widthEntry.setName(this.parameterPrefix + "width");
                this.widthEntry.setRequest(this.getRequest());
                this.widthEntry.setResponse(this.getResponse());
                this.widthEntry.setLocale(this.getLocale());
            }
            this.decimalEntry = (TextEntry)this.getComponent("FORMATSELECTOR_DECIMAL_ENTRY");
            if (this.decimalEntry != null) {
                this.decimalEntry.setName(this.parameterPrefix + "decimalWidth");
                this.decimalEntry.setRequest(this.getRequest());
                this.decimalEntry.setResponse(this.getResponse());
                this.decimalEntry.setLocale(this.getLocale());
            }
            this.widthLabel = (Label)this.getComponent("FORMATSELECTOR_WIDTH_LABEL");
            if (this.widthLabel != null) {
                this.widthLabel.setRequest(this.getRequest());
                this.widthLabel.setResponse(this.getResponse());
                this.widthLabel.setLocale(this.getLocale());
            }
            this.decimalLabel = (Label)this.getComponent("FORMATSELECTOR_DECIMAL_LABEL");
            if (this.decimalLabel != null) {
                this.decimalLabel.setRequest(this.getRequest());
                this.decimalLabel.setResponse(this.getResponse());
                this.decimalLabel.setLocale(this.getLocale());
            }
            this.exampleLabel = (Label)this.getComponent("FORMATSELECTOR_EXAMPLE_LABEL");
            if (this.exampleLabel != null) {
                this.exampleLabel.setRequest(this.getRequest());
                this.exampleLabel.setResponse(this.getResponse());
                this.exampleLabel.setLocale(this.getLocale());
            }
            this.formatExample = (Label)this.getComponent("FORMATSELECTOR_FORMAT_EXAMPLE_LABEL");
            if (this.formatExample != null) {
                this.formatExample.setRequest(this.getRequest());
                this.formatExample.setResponse(this.getResponse());
                this.formatExample.setLocale(this.getLocale());
            }
            this.formatDescription = (Label)this.getComponent("FORMATSELECTOR_FORMAT_DESCRIPTION_LABEL");
            if (this.formatDescription != null) {
                this.formatDescription.setRequest(this.getRequest());
                this.formatDescription.setResponse(this.getResponse());
                this.formatDescription.setLocale(this.getLocale());
            }
        }
    }

    protected void createDataItemLabel() {
        this.dataItemLabel = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("dataItemLabel");
        this.dataItemLabel.setId(name.toString());
        this.dataItemLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createDataItemValueLabel() {
        this.dataItemValueLabel = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("dataItemValueLabel");
        this.dataItemValueLabel.setId(name.toString());
        this.dataItemValueLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createFormatTypeLabel() {
        this.formatTypeLabel = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("formatTypeLabel");
        this.formatTypeLabel.setId(name.toString());
        this.formatTypeLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createFormatWidthLabel() {
        this.widthLabel = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("widthLabel");
        this.widthLabel.setId(name.toString());
        this.widthLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createFormatDecimalLabel() {
        this.decimalLabel = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("decimalLabel");
        this.decimalLabel.setId(name.toString());
        this.decimalLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createFormatTypeChoiceBox() {
        this.formatTypeChoice = new ChoiceBox();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("formatTypeChoice");
        this.formatTypeChoice.setId(name.toString());
        this.formatTypeChoice.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_CHOICE"));
    }

    protected void createFormatListBox() {
        this.formatList = new ListBox();
        this.formatList.setMultipleSelections(false);
        this.formatList.setSize(8);
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("formatList");
        this.formatList.setId(name.toString());
        this.formatList.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LIST"));
    }

    protected void createFormatWidthTextEntry() {
        this.widthEntry = new TextEntry();
        this.widthEntry.setSize(8);
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("widthEntry");
        this.widthEntry.setId(name.toString());
        this.widthEntry.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_TEXT_ENTRY"));
    }

    protected void createFormatDecimalTextEntry() {
        this.decimalEntry = new TextEntry();
        this.decimalEntry.setSize(8);
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("decimalEntry");
        this.decimalEntry.setId(name.toString());
        this.decimalEntry.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_TEXT_ENTRY"));
    }

    protected void createExampleLabel() {
        this.exampleLabel = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("exampleLabel");
        this.exampleLabel.setId(name.toString());
        this.exampleLabel.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createFormatExampleLabel() {
        this.formatExample = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("formatExample");
        this.formatExample.setId(name.toString());
        this.formatExample.setStyleInfo((StyleInfo)this.getStyleMap().get("FORMATSELECTOR_LABEL"));
    }

    protected void createFormatDescriptionLabel() {
        this.formatDescription = new Label();
        StringBuffer name = new StringBuffer(this.getId());
        name.append("_");
        name.append("formatDescription");
        this.formatDescription.setId(name.toString());
        StyleInfo descLableStyleInfo = (StyleInfo)this.getStyleMap().get("FORMATSELECTOR_DESCRIPTION_LABEL");
        this.formatDescription.setStyleInfo(descLableStyleInfo);
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("FORMATSELECTOR_FORMAT_DESCRIPTION_CLASS", descLableStyleInfo.getClassid());
    }

    @Override
    public void setActionProvider(HttpActionProvider ap) {
        super.setActionProvider(ap);
        this.parameterPrefix = this.getActionProvider().getParameterPrefix();
    }

    @Override
    public void setSelectorModel(Object selectorModel) {
        super.setSelectorModel(selectorModel);
        if (selectorModel instanceof FormatAdapterInterface) {
            this.formatAdapter = (FormatAdapterInterface)selectorModel;
        }
    }

    private void writeJsValidationFunctions(StringBuffer sb) {
        MinimumValueValidator minimumValueValidator;
        NumericInputValidator numericInputValidator;
        RequiredStringValidator requiredStringValidator;
        String name = "\nparent." + this.getId();
        this.widthEntry = (TextEntry)this.getComponent("FORMATSELECTOR_WIDTH_ENTRY");
        if (this.widthEntry != null) {
            requiredStringValidator = new RequiredStringValidator();
            sb.append(name).append(".checkWidthNonBlank = '").append(Strings.escapeForJavaScript((String)requiredStringValidator.createValidationFunctionCall(this.widthEntry))).append("';");
            numericInputValidator = new NumericInputValidator();
            sb.append(name).append(".checkWidthNumeric = '").append(Strings.escapeForJavaScript((String)numericInputValidator.createValidationFunctionCall(this.widthEntry))).append("';");
            minimumValueValidator = new MinimumValueValidator(this.minWidth);
            sb.append(name).append(".checkWidthMin = '").append(Strings.escapeForJavaScript((String)minimumValueValidator.createValidationFunctionCall(this.widthEntry))).append("';");
            MaximumValueValidator maximumValueValidator = new MaximumValueValidator(this.maxWidth);
            sb.append(name).append(".checkWidthMax = '").append(Strings.escapeForJavaScript((String)maximumValueValidator.createValidationFunctionCall(this.widthEntry))).append("';");
        }
        this.decimalEntry = (TextEntry)this.getComponent("FORMATSELECTOR_DECIMAL_ENTRY");
        if (this.decimalEntry != null) {
            requiredStringValidator = new RequiredStringValidator();
            sb.append(name).append(".checkDecimalWidthNonBlank = '").append(Strings.escapeForJavaScript((String)requiredStringValidator.createValidationFunctionCall(this.decimalEntry))).append("';");
            numericInputValidator = new NumericInputValidator();
            sb.append(name).append(".checkDecimalWidthNumeric = '").append(Strings.escapeForJavaScript((String)numericInputValidator.createValidationFunctionCall(this.decimalEntry))).append("';");
            minimumValueValidator = new MinimumValueValidator(this.minDecimalWidth);
            sb.append(name).append(".checkDecimalWidthMin = '").append(Strings.escapeForJavaScript((String)minimumValueValidator.createValidationFunctionCall(this.decimalEntry))).append("';");
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(FormatSelectorPanel.class, "FORMATSELECTORPANEL");
    }
}

