/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.filterandrank.html;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filterandrank.FilterAndRankModelInterface;
import com.sas.dataselectors.filterandrank.FilterAxisEnum;
import com.sas.dataselectors.filterandrank.FilterOperatorEnum;
import com.sas.dataselectors.filterandrank.FilterTypeEnum;
import com.sas.dataselectors.filterandrank.RankOrderEnum;
import com.sas.dataselectors.filterandrank.RankTypeEnum;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.filterandrank.html.FilterAndRankSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.filterandrank.html.FilterAndRankSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.form.BaseCheckBox;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.BaseListBox;
import com.sas.servlet.tbeans.form.BaseRadio;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.ListBoxView;
import com.sas.servlet.tbeans.form.html.Radio;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.util.validators.NumericInputValidator;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.visuals.dataselectors.filterandrank.RB;
import com.sas.text.Message;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class FilterAndRankSelectorPanel
extends SelectorPanel
implements FilterAndRankSelectorKeysInterface,
FilterAndRankSelectorStyleKeysInterface,
PropertyChangeListener {
    public static final String RB_KEY = "FilterAndRankSelector.";
    public static final String DEFAULT_FILTER_AND_RANK_SELECTOR_NAME = "frSel_panel";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "VDEFilterAndRankSelector.html";
    public static final String DEFAULT_REMOTE_SCRIPT_URL = "SelectorServlet";
    protected Form remoteScriptForm;
    protected String remoteScriptURL;
    protected int browserType;
    protected FilterAndRankModelInterface selectorModel;
    private static final Map formNameMap = new HashMap();

    public FilterAndRankSelectorPanel() {
        this(Util.getName((String)DEFAULT_FILTER_AND_RANK_SELECTOR_NAME));
    }

    public FilterAndRankSelectorPanel(String name) {
        this.setId(name);
        this.initSelector();
    }

    private void initSelector() {
        this.setTemplateKey("VDE_Filter_And_Rank_Selector");
        this.setVisible(true);
        this.remoteScriptURL = null;
        this.browserType = 4;
        this.initRemoteScriptForm();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(this.getDefaultStyleMap());
        this.addComponentMap(this.getDefaultComponentMap());
        this.setLocaleDependentProperties(this.getLocale());
        try {
            this.selectorModel = null;
            ((BaseRadio)this.getComponent("FAR_FILTER_TYPE")).setSelectedIndex(0);
            ((BaseRadio)this.getComponent("FAR_RANK_TYPE")).setSelectedIndex(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initRemoteScriptForm() {
        this.remoteScriptForm = new Form();
        this.remoteScriptForm.setAction(this.getRemoteScriptURL());
    }

    public String getRemoteScriptURL() {
        if (this.remoteScriptURL == null) {
            String contextPath;
            this.remoteScriptURL = DEFAULT_REMOTE_SCRIPT_URL;
            if (this.getRequest() != null && (contextPath = this.getRequest().getContextPath()) != null) {
                this.remoteScriptURL = contextPath + DEFAULT_REMOTE_SCRIPT_URL;
            }
        }
        return this.remoteScriptURL;
    }

    public void setRemoteScriptURL(String value) {
        if (value != this.remoteScriptURL) {
            String oldValue = this.remoteScriptURL;
            this.remoteScriptURL = value;
            this.firePropertyChange("remoteScriptURL", oldValue, value);
        }
    }

    public Map getDefaultComponentMap() {
        HashMap<String, BaseTransformation> map = new HashMap<String, BaseTransformation>();
        map.put("FAR_FILTER_ON_LABEL", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_LABEL")));
        map.put("FAR_FILTER_ON", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_TEXT")));
        map.put("FAR_FILTER_TYPE_LABEL", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_LABEL")));
        Radio radio = new Radio();
        radio.setName("filterType");
        radio.getStyleMap().put("RADIO_BOX", (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_RADIO"));
        radio.getStyleMap().put("RADIO_LABEL", (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_RADIO_LABEL"));
        radio.setContainerDefaults(true);
        radio.setHorizontalAlignment(true);
        radio.setLabelOrientation(4);
        radio.setOnClick(this.getId() + ".selectFilterType(this.value)");
        map.put("FAR_FILTER_TYPE", radio);
        map.put("FAR_BASED_ON_LABEL", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_LABEL")));
        map.put("FAR_BASED_ON", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_TEXT")));
        map.put("FAR_FILTER_CONDITION_LABEL", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_LABEL")));
        ChoiceBox choice = new ChoiceBox();
        choice.setName("filterCondition");
        choice.setStyleInfo((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_FILTER_CONDITION_CHOICE"));
        map.put("FAR_FILTER_CONDITION", choice);
        map.put("FAR_FILTER_VALUE_LABEL", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_LABEL")));
        TextEntry text = new TextEntry();
        text.setName("filterValue");
        text.setStyleInfo((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_FILTER_VALUE_ENTRY"));
        text.setValidator(new NumericInputValidator());
        map.put("FAR_FILTER_VALUE", text);
        Button button = new Button();
        button.setWidthPercentage(100);
        button.setOnClick(this.getId() + ".onEdit()");
        button.setEnabled(false);
        map.put("FAR_FILTER_VALUE_EDIT_BUTTON", button);
        radio = new Radio();
        radio.setName("rankOrder");
        radio.getStyleMap().put("RADIO_BOX", (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_RADIO"));
        radio.getStyleMap().put("RADIO_LABEL", (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_RADIO_LABEL"));
        radio.setContainerDefaults(true);
        radio.setHorizontalAlignment(true);
        radio.setLabelOrientation(4);
        map.put("FAR_RANK_TYPE", radio);
        text = new TextEntry();
        text.setName("rankValue");
        text.setSize(8);
        text.setStyleInfo((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_RANK_VALUE_ENTRY"));
        text.setValidator(new NumericInputValidator());
        map.put("FAR_RANK_VALUE", text);
        choice = new ChoiceBox();
        choice.setName("rankType");
        choice.setStyleInfo((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_RANK_TYPE_CHOICE"));
        choice.setOnChange(this.getId() + ".selectRankType(this.value)");
        map.put("FAR_RANK_OPERATOR", choice);
        CheckBox check = new CheckBox();
        check.setName("rankOption");
        check.getStyleMap().put("CHECKBOX_BOX", (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_CHECKBOX"));
        check.getStyleMap().put("CHECKBOX_LABEL", (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_CHECKBOX_LABEL"));
        map.put("FAR_RANK_OPTION", check);
        map.put("FAR_CURRENT_FILTERS_LABEL", this.newLabel((StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_LABEL")));
        ListBoxView list = new ListBoxView();
        list.setSize(3);
        list.setMultipleSelections(false);
        list.setOnChange(this.getId() + ".onChange(this)");
        StyleInfo style = (StyleInfo)this.getStyleMap().get("FILTERANDRANKSELECTOR_CURRENT_FILTERS");
        StyleInfo oldStyle = (StyleInfo)list.getStyleMap().get("LISTBOXVIEW_OUTER_DIV_XP");
        list.getStyleMap().put("LISTBOXVIEW_OUTER_DIV_XP", new StyleInfo(oldStyle.getClassid() + " " + style.getClassid(), style.getStyle()));
        oldStyle = (StyleInfo)list.getStyleMap().get("LISTBOXVIEW_OUTER_DIV");
        list.getStyleMap().put("LISTBOXVIEW_OUTER_DIV", new StyleInfo(oldStyle.getClassid() + " " + style.getClassid(), style.getStyle()));
        map.put("FAR_CURRENT_FILTERS", list);
        button = new Button();
        button.setWidthPercentage(100);
        button.setOnClick(this.getId() + ".onClear()");
        map.put("FAR_CLEAR_BUTTON", button);
        button = new Button();
        button.setWidthPercentage(100);
        button.setOnClick(this.getId() + ".onClearAll()");
        map.put("FAR_CLEAR_ALL_BUTTON", button);
        return map;
    }

    private Label newLabel(StyleInfo styleInfo) {
        Label l = new Label();
        l.setStyleInfo(styleInfo);
        return l;
    }

    ListModel getFilterTypeModel(Locale locale) {
        DefaultListModel<Item> m = new DefaultListModel<Item>();
        m.addElement(new Item(FilterTypeEnum.FILTER.getLabel(locale), FilterTypeEnum.FILTER.toString()));
        m.addElement(new Item(FilterTypeEnum.RANK.getLabel(locale), FilterTypeEnum.RANK.toString()));
        return m;
    }

    ComboBoxModel getFilterConditionModel(Locale locale) {
        DefaultComboBoxModel<Item> m = new DefaultComboBoxModel<Item>();
        for (FilterOperatorEnum order : FilterOperatorEnum.getTypes()) {
            m.addElement(new Item(order.getLabel(locale), order.getName()));
        }
        return m;
    }

    ListModel getRankOrderModel(Locale locale) {
        DefaultListModel<Item> m = new DefaultListModel<Item>();
        for (RankOrderEnum order : RankOrderEnum.getTypes()) {
            m.addElement(new Item(order.getLabel(locale), order.getName()));
        }
        return m;
    }

    ComboBoxModel getRankTypeModel(Locale locale) {
        DefaultComboBoxModel<Item> m = new DefaultComboBoxModel<Item>();
        for (RankTypeEnum type : RankTypeEnum.getTypes()) {
            m.addElement(new Item(type.getLabel(locale), type.getName()));
        }
        return m;
    }

    Item getRankOptionModel(Locale locale) {
        Item i = new Item();
        i.setValue("Y");
        i.setText(RB.getStringResource((String)RB_KEY, (String)"rankOption.txt", (Locale)locale));
        return i;
    }

    ListModel getCurrentFiltersModel(Locale locale) {
        DefaultListModel<JavaScriptNode> m = new DefaultListModel<JavaScriptNode>();
        Item entry = this.getCurrentFiltersEntry(FilterAxisEnum.COLUMNS, locale);
        JavaScriptNode node = new JavaScriptNode();
        node.setText(entry.getText());
        node.setValue(entry.getValue());
        m.addElement(node);
        entry = this.getCurrentFiltersEntry(FilterAxisEnum.ROWS, locale);
        node = new JavaScriptNode();
        node.setText(entry.getText());
        node.setValue(entry.getValue());
        m.addElement(node);
        return m;
    }

    private Item getCurrentFiltersEntry(FilterAxisEnum role, Locale locale) {
        String text = this.getCurrentFiltersText(role, role, locale);
        Item entry = new Item();
        entry.setText(text);
        entry.setValue(role.getName().toLowerCase());
        return entry;
    }

    private String getCurrentFiltersText(FilterAxisEnum msgRole, FilterAxisEnum stepRole, Locale locale) {
        String filterText = null;
        if (null != this.selectorModel) {
            filterText = this.selectorModel.getStepText(stepRole, locale);
        }
        if (null == filterText) {
            filterText = RB.getStringResource((String)RB_KEY, (String)"none.txt", (Locale)locale);
        }
        String format = FilterAxisEnum.COLUMNS == msgRole ? RB.getStringResource((String)RB_KEY, (String)"currentColumns.txt.fmt", (Locale)locale) : RB.getStringResource((String)RB_KEY, (String)"currentRows.txt.fmt", (Locale)locale);
        String text = Message.format((String)format, (Object)filterText);
        return text;
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this.setLabelText("FAR_FILTER_ON_LABEL", "filterOn.txt", locale);
        this.setLabelText("FAR_FILTER_TYPE_LABEL", "filterType.txt", locale);
        this.setLabelText("FAR_BASED_ON_LABEL", "basedOn.txt", locale);
        this.setLabelText("FAR_FILTER_CONDITION_LABEL", "filterCondition.txt", locale);
        this.setLabelText("FAR_FILTER_VALUE_LABEL", "filterValue.txt", locale);
        this.setLabelText("FAR_CURRENT_FILTERS_LABEL", "currentFilters.txt", locale);
        this.setButtonLabel("FAR_FILTER_VALUE_EDIT_BUTTON", "editButton.txt", locale);
        this.setButtonLabel("FAR_CLEAR_BUTTON", "clearButton.txt", locale);
        this.setButtonLabel("FAR_CLEAR_ALL_BUTTON", "clearAllButton.txt", locale);
        this.setRadioModel("FAR_FILTER_TYPE", this.getFilterTypeModel(locale));
        this.setRadioModel("FAR_RANK_TYPE", this.getRankOrderModel(locale));
        this.setCheckBoxModel("FAR_RANK_OPTION", this.getRankOptionModel(locale));
        this.setChoiceBoxModel("FAR_RANK_OPERATOR", this.getRankTypeModel(locale));
        this.setChoiceBoxModel("FAR_FILTER_CONDITION", this.getFilterConditionModel(locale));
        this.setSelectorModelLocaleDependantProperties(locale);
    }

    private void setSelectorModelLocaleDependantProperties(Locale locale) {
        this.setListBoxModel("FAR_CURRENT_FILTERS", this.getCurrentFiltersModel(locale));
        FilterAxisEnum filterOn = this.getFilterAxis();
        String text = filterOn == null ? RB.getStringResource((String)RB_KEY, (String)"undefined.txt", (Locale)locale) : filterOn.getLabel(locale);
        this.setLabelText("FAR_FILTER_ON", text);
        String basedOn = this.getBasedOn();
        text = basedOn == null ? RB.getStringResource((String)RB_KEY, (String)"undefined.txt", (Locale)locale) : basedOn.toString();
        this.setLabelText("FAR_BASED_ON", text);
    }

    protected FilterAxisEnum getFilterAxis() {
        FilterAxisEnum value;
        if (this.selectorModel == null) {
            value = null;
        } else {
            try {
                value = this.selectorModel.getFilterAxis();
            }
            catch (OLAPException e) {
                value = null;
                LoggerRepository2.getLogger((String)FilterAndRankSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String getBasedOn() {
        String value = this.selectorModel == null ? null : this.selectorModel.getTupleElementLabel();
        return value;
    }

    protected boolean setRadioModel(String componentKey, ListModel model) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseRadio) {
            BaseRadio radio = (BaseRadio)comp;
            radio.setModel(model);
            return true;
        }
        return false;
    }

    protected boolean setChoiceBoxModel(String componentKey, ComboBoxModel model) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseChoiceBox) {
            BaseChoiceBox choiceBox = (BaseChoiceBox)comp;
            choiceBox.setModel(model);
            return true;
        }
        return false;
    }

    protected boolean setListBoxModel(String componentKey, ListModel model) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseListBox) {
            BaseListBox listBox = (BaseListBox)comp;
            listBox.setModel(model);
            return true;
        }
        return false;
    }

    protected boolean setCheckBoxModel(String componentKey, Item model) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseCheckBox) {
            BaseCheckBox check = (BaseCheckBox)comp;
            check.setText(model == null ? null : model.getText());
            check.setValue(model == null ? null : model.getValue());
            return true;
        }
        return false;
    }

    protected boolean setLabelText(String componentKey, String propertyKey, Locale locale) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseLabel) {
            BaseLabel label = (BaseLabel)comp;
            String text = RB.getStringResource((String)RB_KEY, (String)propertyKey, (Locale)locale);
            label.setText(text);
            return true;
        }
        return false;
    }

    protected boolean setLabelText(String componentKey, String text) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseLabel) {
            BaseLabel label = (BaseLabel)comp;
            label.setText(text);
            return true;
        }
        return false;
    }

    protected boolean setButtonLabel(String componentKey, String propertyKey, Locale locale) {
        TransformationInterface comp = this.getComponent(componentKey);
        if (comp instanceof BaseButton) {
            BaseButton button = (BaseButton)comp;
            button.setLabel(RB.getStringResource((String)RB_KEY, (String)propertyKey, (Locale)locale));
            return true;
        }
        return false;
    }

    void addComponentMap(Map components) {
        if (components != null) {
            for (Map.Entry entry : components.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (!(key instanceof String) || !(val instanceof TransformationInterface)) continue;
                this.setComponent((String)key, (TransformationInterface)val);
            }
        }
    }

    public Map getDefaultStyleMap() {
        HashMap<String, StyleInfo> map = new HashMap<String, StyleInfo>();
        map.put("FILTERANDRANKSELECTOR_LABEL", new StyleInfo("selectorLabel"));
        map.put("FILTERANDRANKSELECTOR_TEXT", new StyleInfo("selectorText"));
        map.put("FILTERANDRANKSELECTOR_CHECKBOX", new StyleInfo("selectorCheckBox farSelectorControl"));
        map.put("FILTERANDRANKSELECTOR_CHECKBOX_LABEL", new StyleInfo("selectorCheckBoxLabel farSelectorControl"));
        map.put("FILTERANDRANKSELECTOR_LIST", new StyleInfo("selectorList farSelectorControl"));
        map.put("FILTERANDRANKSELECTOR_RADIO", new StyleInfo("selectorRadio farSelectorControl farSelectorRadio"));
        map.put("FILTERANDRANKSELECTOR_RADIO_LABEL", new StyleInfo("selectorRadioLabel farSelectorControl farSelectorRadioLabel"));
        map.put("FILTERANDRANKSELECTOR_FILTER_CONDITION_CHOICE", new StyleInfo("selectorChoice farSelectorControl farSelectorFilterCondition"));
        map.put("FILTERANDRANKSELECTOR_RANK_TYPE_CHOICE", new StyleInfo("selectorChoice farSelectorControl farSelectorRankType"));
        map.put("FILTERANDRANKSELECTOR_FILTER_VALUE_ENTRY", new StyleInfo("selectorTextEntry farSelectorControl farSelectorFilterValue"));
        map.put("FILTERANDRANKSELECTOR_RANK_VALUE_ENTRY", new StyleInfo("selectorTextEntry farSelectorControl farSelectorRankValue"));
        map.put("FILTERANDRANKSELECTOR_CURRENT_FILTERS", new StyleInfo("selectorList farSelectorControl farSelectorCurrentFilters"));
        return map;
    }

    public FilterTypeEnum getSelectedFilterType() {
        FilterTypeEnum type = null;
        TransformationInterface comp = this.getComponent("FAR_FILTER_TYPE");
        if (comp instanceof BaseRadio) {
            String typeText = ((BaseRadio)comp).getSelectedItem();
            type = FilterTypeEnum.findType((String)typeText);
        }
        return type;
    }

    public RankOrderEnum getSelectedRankOrder() {
        RankOrderEnum order = null;
        TransformationInterface comp = this.getComponent("FAR_RANK_TYPE");
        if (comp instanceof BaseRadio) {
            String text = ((BaseRadio)comp).getSelectedItem();
            order = RankOrderEnum.findType((String)text);
        }
        return order;
    }

    public HashMap getDefaultTemplateDictionary() {
        String name = this.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FAR_SELECTOR_NAME", name);
        map.put("FAR_FILTER_AREA_ID", name + "_filterArea");
        map.put("FAR_RANK_AREA_ID", name + "_rankArea");
        String display = this.getSelectedFilterType() == FilterTypeEnum.FILTER ? "" : "none";
        map.put("FAR_FILTER_AREA", "display: " + display + ";");
        display = this.getSelectedFilterType() == FilterTypeEnum.RANK ? "" : "none";
        map.put("FAR_RANK_AREA", "display: " + display + ";");
        return map;
    }

    protected void setComponentValues() {
        HttpActionProvider ap = this.getActionProvider();
        String name = this.getId();
        String apPrefix = "";
        if (null != ap) {
            apPrefix = ap.getParameterPrefix();
        }
        for (Map.Entry entry : formNameMap.entrySet()) {
            String key = (String)entry.getKey();
            TransformationInterface tbean = this.getComponent(key);
            if (tbean == null) continue;
            String id = (String)entry.getValue();
            if (tbean instanceof BaseFormElement) {
                tbean.setName(apPrefix + id);
            }
            tbean.setId(name + id);
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.setComponentValues();
        HashMap dictionary = this.getDefaultTemplateDictionary();
        HashMap map = this.getTemplateDictionary();
        if (map != null) {
            dictionary.putAll(map);
        }
        this.setTemplateDictionary(dictionary);
        Form selectorForm = this.getFormObject();
        selectorForm.setName(this.getId() + "_FORM");
        selectorForm.setId(this.getId() + "_FORM");
        selectorForm.setAction(this.remoteScriptForm.getAction());
        selectorForm.setTarget(this.getIframeName());
        selectorForm.setValidationEnabled(true);
        TransformationInterface validationComponent = this.getComponent("FAR_FILTER_VALUE");
        if (!selectorForm.getComponents().contains(validationComponent)) {
            selectorForm.addComponent(validationComponent);
        }
        validationComponent = this.getComponent("FAR_RANK_VALUE");
        if (!selectorForm.getComponents().contains(validationComponent)) {
            selectorForm.addComponent(validationComponent);
        }
        this.writeSelectorForm(out, selectorForm);
        String value = this.applyTemplate(this);
        out.println(value);
        selectorForm.writeFooter(out);
        out.println(this.getConstructionJavaScript());
        this.cleanUpResources();
    }

    protected String getConstructionJavaScript() {
        String name = this.getId();
        StringBuffer js = new StringBuffer(JavaScriptIncludeHandler.getStartScript());
        HttpActionProvider ap = this.getActionProvider();
        String apPrefix = ap != null ? ap.getParameterPrefix() : "";
        js.append(name).append(" = new sas_FilterAndRankSelector('").append(name).append("', '").append(apPrefix).append("');\n");
        String text = this.getCurrentFiltersText(FilterAxisEnum.COLUMNS, null, this.getLocale());
        js.append(name).append(".clearColText = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        text = this.getCurrentFiltersText(FilterAxisEnum.ROWS, null, this.getLocale());
        js.append(name).append(".clearRowText = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        text = RB.getStringResource((String)RB_KEY, (String)"invalidFilterValue.txt", (Locale)this.getLocale());
        js.append(name).append(".invalidFilterValue = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        text = RB.getStringResource((String)RB_KEY, (String)"invalidRankValue.txt", (Locale)this.getLocale());
        js.append(name).append(".invalidRankValue = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        text = RB.getStringResource((String)RB_KEY, (String)"rankCountOutOfBounds.txt", (Locale)this.getLocale());
        js.append(name).append(".rankCountOutOfBounds = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        text = RB.getStringResource((String)RB_KEY, (String)"rankPercentOutOfBounds.txt", (Locale)this.getLocale());
        js.append(name).append(".rankPercentOutOfBounds = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        text = RB.getStringResource((String)RB_KEY, (String)"rankSumOutOfBounds.txt", (Locale)this.getLocale());
        js.append(name).append(".rankSumOutOfBounds = \"").append(Strings.escapeForJavaScript((String)text)).append("\";\n");
        if (null != this.selectorModel) {
            boolean needRefresh = false;
            if (this.selectorModel.getStep(FilterAxisEnum.COLUMNS) == null) {
                js.append(name).append(".clearFilters[0] = 'Y';\n");
                needRefresh = true;
            }
            if (this.selectorModel.getStep(FilterAxisEnum.ROWS) == null) {
                js.append(name).append(".clearFilters[1] = 'Y';\n");
                needRefresh = true;
            }
            if (needRefresh) {
                js.append(name).append(".refresh();\n");
            }
        }
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        return js.toString();
    }

    protected void writeSelectorForm(PrintWriter out, Form form) throws IOException {
        String apPrefix = "";
        String cmdID = this.getCommandId();
        if (cmdID == null) {
            cmdID = "";
        }
        form.setRequest(this.getRequest());
        form.setResponse(this.getResponse());
        form.setLocale(this.getRequestLocale());
        form.writeHeader(out);
        HttpActionProvider ap = this.getActionProvider();
        if (ap != null) {
            apPrefix = ap.getParameterPrefix();
            Hidden.writeElement(out, null, "ACTIONPROVIDERNAME", "ACTIONPROVIDERNAME", true);
            Hidden.writeElement(out, null, "APNAME", ap.getName(), true);
        }
        Hidden.writeElement(out, null, "CMDID", cmdID, true);
        Hidden.writeElement(out, null, apPrefix + "mode", "process", true);
        Hidden.writeElement(out, null, "METHOD_PARAMETER", "", true);
        Hidden.writeElement(out, null, "sas_charEncoding", BaseUtil.getOutputCharacterEncoding(this.getRequest()), true);
        Hidden.writeElement(out, null, apPrefix + "clearCol", "", true);
        Hidden.writeElement(out, null, apPrefix + "clearRow", "", true);
    }

    @Override
    public void setSelectorModel(Object selectormodel) {
        if (selectormodel != null && !(selectormodel instanceof FilterAndRankModelInterface)) {
            throw new IllegalArgumentException("Invalid selector model class! " + selectormodel.getClass().getName());
        }
        if (this.selectorModel != selectormodel) {
            if (this.selectorModel != null) {
                this.selectorModel.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.selectorModel = (FilterAndRankModelInterface)selectormodel;
            if (this.selectorModel != null) {
                this.selectorModel.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.setSelectorModelLocaleDependantProperties(this.getLocale());
        }
        super.setSelectorModel(selectormodel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() == this.selectorModel) {
            if ("tupleElement".equals(pce.getPropertyName())) {
                this.setSelectorModelLocaleDependantProperties(this.getLocale());
            }
        } else {
            super.propertyChange(pce);
        }
    }

    static {
        formNameMap.put("FAR_FILTER_TYPE", "filterType");
        formNameMap.put("FAR_FILTER_CONDITION", "filterCondition");
        formNameMap.put("FAR_FILTER_VALUE", "filterValue");
        formNameMap.put("FAR_RANK_TYPE", "rankOrder");
        formNameMap.put("FAR_RANK_VALUE", "rankValue");
        formNameMap.put("FAR_RANK_OPERATOR", "rankType");
        formNameMap.put("FAR_RANK_OPTION", "rankOption");
        formNameMap.put("FAR_CURRENT_FILTERS", "currentFilters");
        formNameMap.put("FAR_CLEAR_BUTTON", "clearButton");
        formNameMap.put("FAR_CLEAR_ALL_BUTTON", "clearAllButton");
    }
}

