/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.calculations.percent.html;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CancelInterface;
import com.sas.dataselectors.calculations.percent.FractionalItemInfo;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorInterface;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.dataselectors.calculations.percent.html.PercentCalculationsSelectorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.calculations.percent.html.PercentCalculationsSelectorListBoxView;
import com.sas.servlet.tbeans.dataselectors.calculations.percent.html.PercentCalculationsSelectorStyleKeysInterface;
import com.sas.servlet.tbeans.dataselectors.calculations.percent.html.PercentItemNode;
import com.sas.servlet.tbeans.dataselectors.calculations.percent.html.RB;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;

@SASScope(value="ALL")
public class PercentCalculationsSelectorPanel
extends SelectorPanel
implements CancelInterface,
PercentCalculationsSelectorKeysInterface,
PercentCalculationsSelectorStyleKeysInterface {
    public static final String RB_KEY = "PercentCalculationsSelectorPanel.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "PercentCalculationsSelectorPanel.html";
    protected static final String JAVASCRIPT_PANEL_CLASS = "jsPanelClass.";
    protected static final String JAVASCRIPT_ADD_FUNCTION = "jsPanelClass.add()";
    protected static final String JAVASCRIPT_REMOVE_FUNCTION = "jsPanelClass.remove()";
    protected static final String JAVASCRIPT_ACTIVATE_ADD_FUNCTION = "jsPanelClass.activateAddButton()";
    protected static final String JAVASCRIPT_IGNORE_ENTER_FUNCTION = "jsPanelClass.ignoreEnter(event)";
    private static final Map defaultStyleMap;

    public PercentCalculationsSelectorPanel() {
        this(Util.getName((String)"pcsSel_panel"));
    }

    public PercentCalculationsSelectorPanel(String name) {
        this.setId(name);
        this.setTemplateKey("Percent_Calculations_Selector_Panel");
        this.addComponents();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.setLocalizedLabelText("PCS_MEASURE_LABEL", "forMeasure.txt", locale);
        this.setLocalizedLabelText("PCS_PERCENT_LABEL", "addPercentOf.txt", locale);
        this.setLocalizedLabelText("PCS_LABEL_LABEL", "label.txt", locale);
        this.setLocalizedLabelText("PCS_PERCENT_CHOICE_LABEL", "columnTotal.txt", locale);
        this.setLocalizedButtonLabel("PCS_ADD_BUTTON", "addButton.txt", locale);
        this.setLocalizedButtonLabel("PCS_REMOVE_BUTTON", "removeButton.txt", locale);
        Object selectorModel = this.getSelectorModel();
        if (selectorModel != null && selectorModel instanceof PercentCalculationsSelectorInterface) {
            ((PercentCalculationsSelectorInterface)selectorModel).setLocale(locale);
        }
    }

    @Override
    public void setSelectorModel(Object selectormodel) {
        super.setSelectorModel(selectormodel);
        if (selectormodel != null && selectormodel instanceof PercentCalculationsSelectorInterface) {
            ((PercentCalculationsSelectorInterface)selectormodel).setLocale(this.getLocale());
        }
    }

    @Override
    public void write(PrintWriter out) {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        try {
            JavaScriptIncludeHandler.writeIncludes(out, "PERCENTCALCULATIONSSELECTORPANEL", this.getRequest());
            JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
            JavaScriptIncludeHandler.writeIncludes(out, "FASTCLICKPROTECTION", this.getRequest());
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)PercentCalculationsSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        Form form = this.getFormObject();
        form.setRequest(this.getRequest());
        form.setResponse(this.getResponse());
        form.setLocale(this.getLocale());
        try {
            this.writeSelectorPanelHeader(out);
            this.writeActionProviderFields(out);
            this.setComponentValues();
            this.setupTemplateDictionary();
            this.writeTemplate(this, null, out);
            this.writeSelectorPanelFooter(out);
        }
        catch (IOException e) {
            LoggerRepository2.getLogger((String)PercentCalculationsSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.print("\tvar jsPanelClass = new sas_PercentCalculationsSelectorPanel('");
        out.print(this.getId());
        out.println("');");
        out.print("\tjsPanelClass.duplicateAddMsg = '");
        String duplicateAddMessage = RB.getStringResource(RB_KEY, "duplicateAddError.txt", this.getLocale());
        out.print(Strings.escapeForJavaScript((String)duplicateAddMessage));
        out.println("';");
        out.print("\tjsPanelClass.invalidCharMessage = '");
        String invalidCharMessage = RB.getStringResource(RB_KEY, "invalidCharMessage.txt", this.getLocale());
        out.print(Strings.escapeForJavaScript((String)invalidCharMessage));
        out.println("';");
        PercentCalculationsSelectorListBoxView listBox = (PercentCalculationsSelectorListBoxView)this.getComponent("PCS_SUMMARY_BOX");
        if (listBox != null) {
            out.print("\tjsPanelClass.measureNodeStyle = '");
            out.print(((StyleInfo)listBox.getStyleMap().get("PCSLISTBOXVIEW_MEASURE_NODE_STYLE")).getClassid());
            out.println("';");
            out.print("\tjsPanelClass.percentNodeStyle = '");
            out.print(((StyleInfo)listBox.getStyleMap().get("PCSLISTBOXVIEW_PERCENT_NODE_STYLE")).getClassid());
            out.println("';");
            out.print("\tjsPanelClass.labelNodeStyle = '");
            out.print(((StyleInfo)listBox.getStyleMap().get("PCSLISTBOXVIEW_LABEL_NODE_STYLE")).getClassid());
            out.println("';");
        }
        if (this.getActionProvider() != null) {
            out.print("\tjsPanelClass.parameterPrefix = '");
            out.print(this.getActionProvider().getParameterPrefix());
            out.println("';");
        }
        if (this.getFormObject() != null) {
            out.print("\tjsPanelClass.formName = '");
            out.print(this.getFormObject().getName());
            out.println("';");
        }
        out.print(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )");
        out.print(" { ");
        out.print(" sas_FastClick_createFastClickManager();");
        out.print(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        this.cleanUpResources();
    }

    protected void writeActionProviderFields(PrintWriter out) {
        HttpActionProvider ap = this.getActionProvider();
        if (ap != null) {
            Hidden.writeElement(out, "APNAME", "APNAME", Strings.escapeForJavaScript((String)ap.getName()), true);
            String cmdId = this.getCommandId();
            Hidden.writeElement(out, "CMDID", "CMDID", cmdId == null ? "" : cmdId, true);
            String id = ap.getParameterPrefix() + "mode";
            Hidden.writeElement(out, id, id, "COMMIT", true);
        }
    }

    protected void setupTemplateDictionary() {
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("PCS_BUTTON_ROW_ID", this.getId() + "_ButtonRow");
        if (((PercentCalculationsSelectorInterface)this.getSelectorModel()).isOLAP()) {
            dictionary.put("PCS_PERCENT_CHOICE_CONDITIONAL", (String)((Object)this.getComponent("PCS_PERCENT_CHOICE")));
        } else {
            dictionary.put("PCS_PERCENT_CHOICE_CONDITIONAL", (String)((Object)this.getComponent("PCS_PERCENT_CHOICE_LABEL")));
        }
    }

    protected void addComponents() {
        this.setComponent("PCS_MEASURE_LABEL", this.newMeasureLabelInstance());
        this.setComponent("PCS_PERCENT_LABEL", this.newPercentLabelInstance());
        this.setComponent("PCS_LABEL_LABEL", this.newLabelLabelInstance());
        this.setComponent("PCS_MEASURE_CHOICE", this.newMeasureComboInstance());
        this.setComponent("PCS_PERCENT_CHOICE", this.newPercentComboInstance());
        this.setComponent("PCS_PERCENT_CHOICE_LABEL", this.newPercentChoiceLabelInstance());
        this.setComponent("PCS_LABEL", this.newLabelTextEntryInstance());
        this.setComponent("PCS_ADD_BUTTON", this.newAddButtonInstance());
        this.setComponent("PCS_REMOVE_BUTTON", this.newRemoveButtonInstance());
        this.setComponent("PCS_SUMMARY_BOX", this.newSummaryBoxInstance());
    }

    private BaseLabel newDefaultLabelInstance(String name, String defaultStyleKey) {
        Label label = new Label();
        label.setId(this.getId() + "_" + name);
        label.setStyleInfo((StyleInfo)defaultStyleMap.get(defaultStyleKey));
        return label;
    }

    protected BaseLabel newMeasureLabelInstance() {
        return this.newDefaultLabelInstance("measureLabel", "PCS_LABEL_STYLE");
    }

    protected BaseLabel newPercentLabelInstance() {
        return this.newDefaultLabelInstance("percentLabel", "PCS_LABEL_STYLE");
    }

    protected BaseLabel newLabelLabelInstance() {
        return this.newDefaultLabelInstance("labelLabel", "PCS_LABEL_STYLE");
    }

    protected BaseLabel newPercentChoiceLabelInstance() {
        return this.newDefaultLabelInstance("percentChoiceLabel", "PCS_CHOICE_LABEL_STYLE");
    }

    protected BaseChoiceBox newMeasureComboInstance() {
        ChoiceBox measureLabel = new ChoiceBox();
        measureLabel.setId(this.getId() + "_" + "measureChoice");
        measureLabel.setStyleInfo((StyleInfo)defaultStyleMap.get("PCS_CHOICE_STYLE"));
        return measureLabel;
    }

    protected BaseChoiceBox newPercentComboInstance() {
        ChoiceBox percentLabel = new ChoiceBox();
        percentLabel.setId(this.getId() + "_" + "percentChoice");
        percentLabel.setStyleInfo((StyleInfo)defaultStyleMap.get("PCS_CHOICE_STYLE"));
        return percentLabel;
    }

    protected TextEntry newLabelTextEntryInstance() {
        TextEntry labelTextEntry = new TextEntry();
        labelTextEntry.setId(this.getId() + "_" + "labelEntry");
        labelTextEntry.setStyleInfo((StyleInfo)defaultStyleMap.get("PCS_LABEL_ENTRY_STYLE"));
        labelTextEntry.setEnabled(true);
        labelTextEntry.setOnKeyUp(JAVASCRIPT_ACTIVATE_ADD_FUNCTION);
        labelTextEntry.setOnKeyDown(JAVASCRIPT_IGNORE_ENTER_FUNCTION);
        return labelTextEntry;
    }

    protected BaseButton newAddButtonInstance() {
        Button addButton = new Button();
        addButton.setId(this.getId() + "_" + "addButton");
        addButton.setOnClick(JAVASCRIPT_ADD_FUNCTION);
        addButton.setEnabled(false);
        return addButton;
    }

    protected BaseButton newRemoveButtonInstance() {
        Button removeButton = new Button();
        removeButton.setId(this.getId() + "_" + "removeButton");
        removeButton.setOnClick(JAVASCRIPT_REMOVE_FUNCTION);
        removeButton.setEnabled(false);
        return removeButton;
    }

    protected PercentCalculationsSelectorListBoxView newSummaryBoxInstance() {
        PercentCalculationsSelectorListBoxView summaryBox = new PercentCalculationsSelectorListBoxView(this.getId() + "_" + "summaryBox");
        return summaryBox;
    }

    protected void setComponentValues() {
        this.populateMeasureChoiceBox();
        this.populatePercentChoiceBox();
        this.populateSummaryListBox();
    }

    public void cancel() {
    }

    protected void populateSummaryListBox() {
        PercentCalculationsSelectorListBoxView listBox = (PercentCalculationsSelectorListBoxView)this.getComponent("PCS_SUMMARY_BOX");
        if (listBox == null) {
            return;
        }
        DefaultListModel listModel = listBox.getModel();
        if (listModel == null) {
            listModel = new DefaultListModel();
        } else {
            listModel.removeAllElements();
        }
        listBox.setModel(this.populateSummaryListBoxModel(listBox, listModel, (PercentCalculationsSelectorInterface)this.getSelectorModel()));
    }

    protected DefaultListModel populateSummaryListBoxModel(PercentCalculationsSelectorListBoxView listBox, DefaultListModel listModel, PercentCalculationsSelectorInterface adapter) {
        if (listModel == null || adapter == null) {
            return listModel;
        }
        List currentFractionalItems = adapter.getFractionalItems();
        if (currentFractionalItems == null) {
            return listModel;
        }
        int size = currentFractionalItems.size();
        for (int i = 0; i < size; ++i) {
            FractionalItemInfo itemInfo = (FractionalItemInfo)currentFractionalItems.get(i);
            PercentItemNode node = new PercentItemNode();
            node.setText(itemInfo.getNumeratorLabel());
            if (itemInfo.getDenominatorType() == 0) {
                node.setPercent(MessageFormat.format(RB.getStringResource(RB_KEY, "subTotal.txt", this.getLocale()), itemInfo.getDenominatorLabel()));
            } else {
                node.setPercent(itemInfo.getDenominatorLabel());
            }
            node.setLabel(BaseUtil.replaceSpecialCharacters(itemInfo.getLabel(), 4));
            Map listBoxStyleMap = listBox.getStyleMap();
            node.setTextStyle(((StyleInfo)listBoxStyleMap.get("PCSLISTBOXVIEW_MEASURE_NODE_STYLE")).getClassid());
            node.setPercentStyle(((StyleInfo)listBoxStyleMap.get("PCSLISTBOXVIEW_PERCENT_NODE_STYLE")).getClassid());
            node.setLabelStyle(((StyleInfo)listBoxStyleMap.get("PCSLISTBOXVIEW_LABEL_NODE_STYLE")).getClassid());
            node.setMeasureId(itemInfo.getNumeratorId());
            String denominatorId = itemInfo.getDenominatorId();
            if (denominatorId != null && denominatorId.length() != 0) {
                node.setPercentId(denominatorId);
            }
            node.setPercentType(Integer.toString(itemInfo.getDenominatorType()));
            listModel.addElement(node);
        }
        return listModel;
    }

    protected void populateMeasureChoiceBox() {
        Object adapter = this.getSelectorModel();
        if (adapter == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "nullAdapter.txt", this.getLocale()));
        }
        if (!(adapter instanceof PercentCalculationsSelectorInterface)) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidAdapterType.txt", this.getLocale()));
        }
        ChoiceBox measureChoiceBox = (ChoiceBox)this.getComponent("PCS_MEASURE_CHOICE");
        if (measureChoiceBox == null) {
            return;
        }
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)measureChoiceBox.getModel();
        if (cbModel == null) {
            cbModel = new DefaultComboBoxModel();
        } else {
            cbModel.removeAllElements();
        }
        measureChoiceBox.setModel(this.populateMeasureComboModel(cbModel, (PercentCalculationsSelectorInterface)adapter));
        if (cbModel.getSize() > 0) {
            try {
                measureChoiceBox.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private DefaultComboBoxModel populateMeasureComboModel(DefaultComboBoxModel cbModel, PercentCalculationsSelectorInterface adapter) {
        Map numerators = adapter.getNumerators();
        if (numerators == null) {
            return cbModel;
        }
        for (String key : numerators.keySet()) {
            JavaScriptNode node = new JavaScriptNode();
            node.setText((String)numerators.get(key));
            node.setValue(key);
            cbModel.addElement(node);
        }
        return cbModel;
    }

    private DefaultComboBoxModel populatePercentComboModel(DefaultComboBoxModel cbModel, PercentCalculationsSelectorInterface adapter) {
        if (cbModel == null) {
            return cbModel;
        }
        Map denominators = adapter.getDenominators();
        if (denominators == null) {
            return cbModel;
        }
        Iterator iterator = denominators.keySet().iterator();
        while (iterator.hasNext()) {
            JavaScriptNode node = new JavaScriptNode();
            Object key = iterator.next();
            if (key instanceof String) {
                node.setValue((String)key);
                node.setText(MessageFormat.format(RB.getStringResource(RB_KEY, "subTotal.txt", this.getLocale()), denominators.get(key)));
                node.setName("");
            } else {
                node.setName(key.toString());
                node.setText((String)denominators.get(key));
            }
            cbModel.addElement(node);
        }
        return cbModel;
    }

    private int getFractionalItemIndex(DefaultComboBoxModel cbModel, PercentCalculationsSelectorInterface adapter, Integer fractionalItemType) {
        if (cbModel == null) {
            return 0;
        }
        Map denominators = adapter.getDenominators();
        if (denominators == null) {
            return 0;
        }
        int numItems = cbModel.getSize();
        for (int i = 0; i < numItems; ++i) {
            JavaScriptNode node = (JavaScriptNode)cbModel.getElementAt(i);
            String nodeValue = node.getValue();
            if (!(nodeValue != null && !nodeValue.equals("") ? node.getValue().equals(fractionalItemType.toString()) : node.getName() != null && node.getName().equals(fractionalItemType.toString()))) continue;
            return i;
        }
        return 0;
    }

    protected void populatePercentChoiceBox() {
        Object adapter = this.getSelectorModel();
        if (adapter == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "nullAdapter.txt", this.getLocale()));
        }
        if (!(adapter instanceof PercentCalculationsSelectorInterface)) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidAdapterType.txt", this.getLocale()));
        }
        ChoiceBox percentChoiceBox = (ChoiceBox)this.getComponent("PCS_PERCENT_CHOICE");
        if (percentChoiceBox == null) {
            return;
        }
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)percentChoiceBox.getModel();
        if (cbModel == null) {
            cbModel = new DefaultComboBoxModel();
        } else {
            cbModel.removeAllElements();
        }
        percentChoiceBox.setModel(this.populatePercentComboModel(cbModel, (PercentCalculationsSelectorInterface)adapter));
        if (cbModel.getSize() > 0) {
            try {
                int indexOfColumnTotalItem = this.getFractionalItemIndex(cbModel, (PercentCalculationsSelectorInterface)adapter, new Integer(3));
                percentChoiceBox.setSelectedIndex(indexOfColumnTotalItem);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cleanUpResources() {
        DefaultComboBoxModel cbModel;
        ChoiceBox percentChoiceBox;
        DefaultComboBoxModel cbModel2;
        super.cleanUpResources();
        ChoiceBox measureChoiceBox = (ChoiceBox)this.getComponent("PCS_MEASURE_CHOICE");
        if (measureChoiceBox != null && (cbModel2 = (DefaultComboBoxModel)measureChoiceBox.getModel()) != null) {
            cbModel2.removeAllElements();
        }
        if ((percentChoiceBox = (ChoiceBox)this.getComponent("PCS_PERCENT_CHOICE")) != null && (cbModel = (DefaultComboBoxModel)percentChoiceBox.getModel()) != null) {
            cbModel.removeAllElements();
        }
    }

    private void setLocalizedLabelText(String componentKey, String resourceKey, Locale locale) {
        BaseLabel label = (BaseLabel)this.getComponent(componentKey);
        if (label != null) {
            label.setText(RB.getStringResource(RB_KEY, resourceKey, locale));
        }
    }

    private void setLocalizedButtonLabel(String componentKey, String resourceKey, Locale locale) {
        BaseButton button = (BaseButton)this.getComponent(componentKey);
        if (button != null) {
            button.setLabel(RB.getStringResource(RB_KEY, resourceKey, locale));
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(PercentCalculationsSelectorPanel.class, "PERCENTCALCULATIONSSELECTORPANEL");
        defaultStyleMap = new HashMap(8, 1.0f);
        defaultStyleMap.put("PCS_LABEL_STYLE", new ImmutableStyleInfo("selectorLabel percentCalculationsSelectorLabel"));
        defaultStyleMap.put("PCS_CHOICE_STYLE", new ImmutableStyleInfo("selectorChoice percentCalculationsSelectorChoiceBox"));
        defaultStyleMap.put("PCS_CHOICE_LABEL_STYLE", new ImmutableStyleInfo("selectorLabel percentCalculationsSelectorChoiceLabel"));
        defaultStyleMap.put("PCS_LABEL_ENTRY_STYLE", new ImmutableStyleInfo("selectorTextEntry percentCalculationsSelectorLabelTextEntry"));
        defaultStyleMap.put("PCS_BUTTON_STYLE", new ImmutableStyleInfo("button percentCalculationsSelectorButton"));
        defaultStyleMap.put("PCS_SUMMARY_STYLE", new ImmutableStyleInfo("selectorList percentCalculationsSelectorSummary"));
    }
}

