/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.dataselectors.calculateditems.html;

import com.sas.codepolicy.SASScope;
import com.sas.expressions.visuals.Operation;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.dataselectors.calculateditems.html.BaseExpressionEditorKeysInterface;
import com.sas.servlet.tbeans.dataselectors.calculateditems.html.BaseExpressionEditorStyleKeysInterface;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.TextArea;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.util.ClientInfo;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.visuals.dataselectors.calculateditems.RB;
import com.sas.util.MapWithDefaults;
import com.sas.util.UncheckedException;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public class BaseExpressionEditor
extends BaseCompositeTransformation
implements BaseExpressionEditorKeysInterface,
BaseExpressionEditorStyleKeysInterface {
    private static final boolean debug = false;
    @SASScope
    public static final String RB_KEY = "BaseExpressionEditor.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "BaseExpressionEditor.html";
    @SASScope
    protected String imageLocation;
    @SASScope
    protected static final String JAVASCRIPT_FUNCTION_ROOT = "sas_BaseExpressionEditor_";
    @SASScope
    protected static final String JAVASCRIPT_PROCESS_BUTTON_FUNCTION = "sas_BaseExpressionEditor_processOperatorButtonSelection";
    @SASScope
    protected static final String JAVASCRIPT_STORE_CARET_FUNCTION = "sas_BaseExpressionEditor_storeCaret(this)";
    @SASScope
    protected static final String JAVASCRIPT_PROCESS_PARENTHESES_BUTTON_FUNCTION = "sas_BaseExpressionEditor_processParenthesesButtonSelection";
    protected static final String JAVASCRIPT_DISABLE_ENTER_KEY_FUNCTION = "sas_BaseExpressionEditor_disableEnterKey(event)";
    protected static final String JAVASCRIPT_ENABLE_EDITOR_BUTTONS_FUNCTION = "sas_BaseExpressionEditor_enableEditorAndButtons(true)";
    @SASScope
    protected static final String STYLE_CLASS_ROOT = "BaseExpressionEditor";
    @SASScope
    protected static final String CONTAINER_SUFFIX = "Container";
    @SASScope
    protected static final String LABEL_SUFFIX = "ExpressionLabel";
    @SASScope
    protected static final String AREA_SUFFIX = "ExpressionArea";
    @SASScope
    protected static final String BUTTON_ROW_SUFFIX = "OperatorButtonRow";
    @SASScope
    protected static final String EXAMPLE_ROW_SUFFIX = "StringDataPatternExampleRow";
    @SASScope
    protected static final String CONTAINER_CLASS = "BaseExpressionEditorContainer";
    @SASScope
    protected static final String LABEL_CLASS = "BaseExpressionEditorExpressionLabel";
    @SASScope
    protected static final String AREA_CLASS = "BaseExpressionEditorExpressionArea";
    @SASScope
    protected static final String BUTTON_ROW_CLASS = "BaseExpressionEditorOperatorButtonRow";
    @SASScope
    protected static final String EXAMPLE_ROW_CLASS = "BaseExpressionEditorStringDataPatternExampleRow";
    @SASScope
    protected static final String EXPRESSION_AREA_NAME_ROOT = "expressionArea";
    @SASScope
    protected String actionProviderPrefix;
    @SASScope
    protected List operatorList;
    private String javaScriptVariables;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap(Map parentStyleMap) {
        if (defaultStyleMap.size() == 0) {
            if (parentStyleMap != null) {
                defaultStyleMap.putAll(parentStyleMap);
            }
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_CONTAINER_CLASS", new StyleInfo(CONTAINER_CLASS));
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_EXPRESSION_LABEL_CLASS", new StyleInfo(((StyleInfo)defaultStyleMap.get("COMMON_SELECTOR_LABEL_CLASS")).getClassid() + " " + LABEL_CLASS));
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_EXPRESSION_AREA_CLASS", new StyleInfo(((StyleInfo)defaultStyleMap.get("COMMON_SELECTOR_TEXT_AREA_CLASS")).getClassid() + " " + AREA_CLASS));
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_OPERATOR_BUTTON_ROW_CLASS", new StyleInfo(BUTTON_ROW_CLASS));
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_STRING_DATA_PATTERN_EXAMPLE_ROW_CLASS", new StyleInfo(((StyleInfo)defaultStyleMap.get("COMMON_SELECTOR_TEXT_CLASS")).getClassid() + " " + EXAMPLE_ROW_CLASS));
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_HELP_TEXT_CLASS", new StyleInfo(((StyleInfo)defaultStyleMap.get("COMMON_SELECTOR_TEXT_CLASS")).getClassid()));
            defaultStyleMap.put("BASEEXPRESSIONEDITOR_NETSCAPE_HELP_TEXT_CLASS", new StyleInfo(((StyleInfo)defaultStyleMap.get("COMMON_SELECTOR_TEXT_CLASS")).getClassid()));
        }
    }

    public BaseExpressionEditor(Map parentStyleMap, List operatorList) {
        this.setId(Util.getName((String)"bee"));
        BaseExpressionEditor.setupDefaultStyleMap(parentStyleMap);
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setTemplateKey("Base_Expression_Editor");
        this.setOperatorList(operatorList);
        this.createComponents();
        this._setLocaleDependentProperties(this.getLocale());
    }

    @SASScope
    public BaseExpressionEditor(Map parentStyleMap, List operatorList, String imageLocation) {
        this.setId(Util.getName((String)"bee"));
        this.setImageLocation(imageLocation);
        BaseExpressionEditor.setupDefaultStyleMap(parentStyleMap);
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setTemplateKey("Base_Expression_Editor");
        this.setOperatorList(operatorList);
        this.createComponents();
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        BaseLabel expressionLabel = (BaseLabel)this.getComponent("BASEEXPRESSIONEDITOR_EXPRESSION_LABEL");
        expressionLabel.setText(RB.getStringResource((String)RB_KEY, (String)"expressionLabel.txt", (Locale)locale));
        BaseButton validateButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_VALIDATE_BUTTON");
        validateButton.setLabel(RB.getStringResource((String)RB_KEY, (String)"validateButton.txt", (Locale)locale));
        validateButton.setAlternateText(RB.getStringResource((String)RB_KEY, (String)"validateButton.toolTip.txt", (Locale)locale));
        BaseLabel stringDataPatternExampleLabel = (BaseLabel)this.getComponent("BASEEXPRESSIONEDITOR_STRING_DATA_PATTERN_EXAMPLE");
        stringDataPatternExampleLabel.setText(RB.getStringResource((String)RB_KEY, (String)"stringDataPatternExampleTbean.txt", (Locale)locale));
        BaseLabel helpTextLabel = (BaseLabel)this.getComponent("BASEEXPRESSIONEDITOR_HELP_TEXT");
        helpTextLabel.setText(RB.getStringResource((String)RB_KEY, (String)"helpTextLabel.txt", (Locale)locale));
        BaseLabel netscapeHelpTextLabel = (BaseLabel)this.getComponent("BASEEXPRESSIONEDITOR_NETSCAPE_HELP_TEXT");
        netscapeHelpTextLabel.setText(RB.getStringResource((String)RB_KEY, (String)"netscapeHelpTextLabel.txt", (Locale)locale));
        this.initializeJavaScriptVariables(locale);
        for (Operation operator : this.operatorList) {
            String operatorName = operator.getName();
            if (operatorName.equals("addButton")) {
                BaseButton addButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_ADD_BUTTON");
                addButton.setAlternateText(operator.getToolTip());
                addButton.setTitle(operator.getToolTip());
                continue;
            }
            if (operatorName.equals("subtractButton")) {
                BaseButton subtractButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_SUBTRACT_BUTTON");
                subtractButton.setAlternateText(operator.getToolTip());
                subtractButton.setTitle(operator.getToolTip());
                continue;
            }
            if (operatorName.equals("multiplyButton")) {
                BaseButton multiplyButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_MULTIPLY_BUTTON");
                multiplyButton.setAlternateText(operator.getToolTip());
                multiplyButton.setTitle(operator.getToolTip());
                continue;
            }
            if (operatorName.equals("divideButton")) {
                BaseButton divideButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_DIVIDE_BUTTON");
                divideButton.setAlternateText(operator.getToolTip());
                divideButton.setTitle(operator.getToolTip());
                continue;
            }
            if (operatorName.equals("parenthesizeButton")) {
                BaseButton parenthesizeButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_PARENTHESIZE_BUTTON");
                parenthesizeButton.setAlternateText(operator.getToolTip());
                parenthesizeButton.setTitle(operator.getToolTip());
                continue;
            }
            if (!operatorName.equals("clearButton")) continue;
            BaseButton clearButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_CLEAR_BUTTON");
            clearButton.setAlternateText(operator.getToolTip());
            clearButton.setTitle(operator.getToolTip());
        }
    }

    @SASScope
    protected void createComponents() {
        this.createLabel();
        this.createValidateButton();
        this.createExpressionArea();
        this.createOperatorButtons();
        this.createStringDataPatternExampleLabel();
        this.createHelpTextLabel();
        this.createNetscapeHelpTextLabel();
    }

    @SASScope
    protected void initializeComponents() {
        this.initializeValidateButton();
        this.initializeExpressionArea();
        this.initializeOperatorButtons();
        this.initializeNetscapeHelpTextLabel();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "BASEEXPRESSIONEDITOR", this.getRequest());
        this.initializeComponents();
        out.println(this.getJavaScriptVariables());
        String formattedSelector = this.applyTemplate(this);
        out.println(formattedSelector);
        this.cleanUpResources();
    }

    public List getOperatorList() {
        return this.operatorList;
    }

    public void setOperatorList(List operators) {
        this.operatorList = operators;
    }

    public String getActionProviderPrefix() {
        return this.actionProviderPrefix;
    }

    public void setActionProviderPrefix(String prefix) {
        this.actionProviderPrefix = prefix;
    }

    @SASScope
    protected String getJavaScriptVariables() {
        return this.javaScriptVariables;
    }

    private void initializeJavaScriptVariables(Locale locale) {
        StringBuffer buffer = new StringBuffer(JavaScriptIncludeHandler.getStartScript());
        buffer.append("var expressionLabelText = \"");
        buffer.append(RB.getStringResource((String)RB_KEY, (String)"expressionLabel.txt", (Locale)locale));
        buffer.append("\";\n");
        buffer.append("var stringDataPatternLabelText = \"");
        buffer.append(RB.getStringResource((String)RB_KEY, (String)"stringDataPatternLabel.txt", (Locale)locale));
        buffer.append("\";\n");
        buffer.append("var operatorButtonList = new Array();\n");
        for (Operation operator : this.operatorList) {
            buffer.append("operatorButtonList[\"");
            buffer.append(this.getButtonType(operator));
            buffer.append("\"] = \"");
            buffer.append(operator.getSymbol());
            buffer.append("\";\n");
        }
        buffer.append(JavaScriptIncludeHandler.getEndScript(null));
        this.javaScriptVariables = buffer.toString();
    }

    @SASScope
    protected void createLabel() {
        Label expressionLabel = new Label();
        expressionLabel.setId(this.getId() + "_expressionLabel");
        expressionLabel.setStyleClass(((StyleInfo)defaultStyleMap.get("BASEEXPRESSIONEDITOR_EXPRESSION_LABEL_CLASS")).getClassid());
        this.setComponent("BASEEXPRESSIONEDITOR_EXPRESSION_LABEL", expressionLabel);
    }

    @SASScope
    protected void createValidateButton() {
        Button validateButton = new Button();
        validateButton.setId(this.getId() + "_validateButton");
        validateButton.setButtonType(3);
        validateButton.setWidthPercentage(100);
        validateButton.setImagePosition(512);
        validateButton.setVisible(false);
        this.setComponent("BASEEXPRESSIONEDITOR_VALIDATE_BUTTON", validateButton);
    }

    @SASScope
    protected void initializeValidateButton() {
        BaseButton validateButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_VALIDATE_BUTTON");
        validateButton.setImage(ComponentPropertyManager.getInstance(this.getRequest()).getImageURI("Spacer"), 15, 13);
    }

    @SASScope
    protected void createExpressionArea() {
        TextArea expressionArea = new TextArea();
        expressionArea.setStyleClass(((StyleInfo)defaultStyleMap.get("BASEEXPRESSIONEDITOR_EXPRESSION_AREA_CLASS")).getClassid());
        this.setComponent("BASEEXPRESSIONEDITOR_EXPRESSION_AREA", expressionArea);
    }

    @SASScope
    protected void initializeExpressionArea() {
        BaseFormElement expressionArea = (BaseFormElement)this.getComponent("BASEEXPRESSIONEDITOR_EXPRESSION_AREA");
        expressionArea.setName(this.getActionProviderPrefix() + EXPRESSION_AREA_NAME_ROOT);
        expressionArea.setId(this.getId() + "_" + EXPRESSION_AREA_NAME_ROOT);
        expressionArea.setOnChange(JAVASCRIPT_STORE_CARET_FUNCTION);
        expressionArea.setOnSelect(JAVASCRIPT_STORE_CARET_FUNCTION);
        expressionArea.setOnMouseUp(JAVASCRIPT_STORE_CARET_FUNCTION);
        expressionArea.setOnKeyUp(JAVASCRIPT_STORE_CARET_FUNCTION);
        expressionArea.setOnKeyPress(JAVASCRIPT_DISABLE_ENTER_KEY_FUNCTION);
        BaseLabel expressionLabel = (BaseLabel)this.getComponent("BASEEXPRESSIONEDITOR_EXPRESSION_LABEL");
        expressionLabel.setFor(expressionArea.getId());
        BaseLabel helpTextLabel = (BaseLabel)this.getComponent("BASEEXPRESSIONEDITOR_HELP_TEXT");
        helpTextLabel.setFor(expressionArea.getId());
    }

    @SASScope
    protected void createOperatorButtons() {
        ArrayList<Button> operatorButtonList = new ArrayList<Button>();
        Button addButton = new Button();
        Button subtractButton = new Button();
        Button multiplyButton = new Button();
        Button divideButton = new Button();
        Button parenthesizeButton = new Button();
        Button clearButton = new Button();
        for (Operation operator : this.operatorList) {
            Button button = new Button();
            button.setId(this.getId() + "_" + operator.getName());
            button.setButtonType(3);
            button.setAlternateText(operator.getToolTip());
            if (operator.getName().equals("addButton")) {
                addButton = button;
            } else if (operator.getName().equals("subtractButton")) {
                subtractButton = button;
            } else if (operator.getName().equals("multiplyButton")) {
                multiplyButton = button;
            } else if (operator.getName().equals("divideButton")) {
                divideButton = button;
            } else if (operator.getName().equals("parenthesizeButton")) {
                parenthesizeButton = button;
            } else if (operator.getName().equals("clearButton")) {
                clearButton = button;
            }
            operatorButtonList.add(button);
        }
        this.setComponent("BASEEXPRESSIONEDITOR_ADD_BUTTON", addButton);
        this.setComponent("BASEEXPRESSIONEDITOR_SUBTRACT_BUTTON", subtractButton);
        this.setComponent("BASEEXPRESSIONEDITOR_MULTIPLY_BUTTON", multiplyButton);
        this.setComponent("BASEEXPRESSIONEDITOR_DIVIDE_BUTTON", divideButton);
        this.setComponent("BASEEXPRESSIONEDITOR_PARENTHESIZE_BUTTON", parenthesizeButton);
        this.setComponent("BASEEXPRESSIONEDITOR_CLEAR_BUTTON", clearButton);
    }

    @SASScope
    protected void initializeOperatorButtons() {
        BaseButton addButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_ADD_BUTTON");
        BaseButton subtractButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_SUBTRACT_BUTTON");
        BaseButton multiplyButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_MULTIPLY_BUTTON");
        BaseButton divideButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_DIVIDE_BUTTON");
        BaseButton parenthesizeButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_PARENTHESIZE_BUTTON");
        BaseButton clearButton = (BaseButton)this.getComponent("BASEEXPRESSIONEDITOR_CLEAR_BUTTON");
        addButton.setOnClick(this.getButtonOnClickFunctionName("BASEEXPRESSIONEDITOR_ADD_BUTTON"));
        subtractButton.setOnClick(this.getButtonOnClickFunctionName("BASEEXPRESSIONEDITOR_SUBTRACT_BUTTON"));
        multiplyButton.setOnClick(this.getButtonOnClickFunctionName("BASEEXPRESSIONEDITOR_MULTIPLY_BUTTON"));
        divideButton.setOnClick(this.getButtonOnClickFunctionName("BASEEXPRESSIONEDITOR_DIVIDE_BUTTON"));
        parenthesizeButton.setOnClick(this.getButtonOnClickFunctionName("BASEEXPRESSIONEDITOR_PARENTHESIZE_BUTTON"));
        clearButton.setOnClick(this.getButtonOnClickFunctionName("BASEEXPRESSIONEDITOR_CLEAR_BUTTON"));
        ClientInfo clientInfo = new ClientInfo(this.getRequest());
        if (clientInfo.isNetscape()) {
            parenthesizeButton.setEnabled(false);
        }
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        for (Operation operator : this.operatorList) {
            String operatorName = operator.getName();
            if (operatorName.equals("addButton")) {
                if (addButton.getImage() == null && addButton.getLabel() == null) {
                    addButton.setImageKey(this.getImageKey(operator, true));
                }
                if (addButton.getDisabledImage() != null || addButton.getLabel() != null) continue;
                addButton.setDisabledImageKey(this.getImageKey(operator, false));
                continue;
            }
            if (operatorName.equals("subtractButton")) {
                if (subtractButton.getImage() == null && subtractButton.getLabel() == null) {
                    subtractButton.setImageKey(this.getImageKey(operator, true));
                }
                if (subtractButton.getDisabledImage() != null || subtractButton.getLabel() != null) continue;
                subtractButton.setDisabledImageKey(this.getImageKey(operator, false));
                continue;
            }
            if (operatorName.equals("multiplyButton")) {
                if (multiplyButton.getImage() == null && multiplyButton.getLabel() == null) {
                    multiplyButton.setImageKey(this.getImageKey(operator, true));
                }
                if (multiplyButton.getDisabledImage() != null || multiplyButton.getLabel() != null) continue;
                multiplyButton.setDisabledImageKey(this.getImageKey(operator, false));
                continue;
            }
            if (operatorName.equals("divideButton")) {
                if (divideButton.getImage() == null && divideButton.getLabel() == null) {
                    divideButton.setImageKey(this.getImageKey(operator, true));
                }
                if (divideButton.getDisabledImage() != null || divideButton.getDisabledImage() != null) continue;
                divideButton.setDisabledImageKey(this.getImageKey(operator, false));
                continue;
            }
            if (operatorName.equals("parenthesizeButton")) {
                if (parenthesizeButton.getImage() == null && parenthesizeButton.getLabel() == null) {
                    parenthesizeButton.setImageKey(this.getImageKey(operator, true));
                }
                if (parenthesizeButton.getDisabledImage() != null || parenthesizeButton.getLabel() != null) continue;
                parenthesizeButton.setDisabledImageKey(this.getImageKey(operator, false));
                continue;
            }
            if (!operatorName.equals("clearButton") || clearButton.getImage() != null || clearButton.getLabel() != null) continue;
            clearButton.setImageKey(this.getImageKey(operator, true));
        }
    }

    private String getImageKey(Operation operator, boolean enableImage) {
        String imageKey = null;
        String operatorName = operator.getName();
        if (operatorName.equals("addButton")) {
            imageKey = enableImage ? "Add_Blue" : "Add_Blue_Disabled";
        } else if (operatorName.equals("subtractButton")) {
            imageKey = enableImage ? "Subtract_Blue" : "Subtract_Blue_Disabled";
        } else if (operatorName.equals("multiplyButton")) {
            imageKey = enableImage ? "Multiply_Blue" : "Multiply_Blue_Disabled";
        } else if (operatorName.equals("divideButton")) {
            imageKey = enableImage ? "Divide_Blue" : "Divide_Blue_Disabled";
        } else if (operatorName.equals("parenthesizeButton")) {
            imageKey = enableImage ? "Parentheses_Blue" : "Parentheses_Blue_Disabled";
        } else if (operatorName.equals("clearButton")) {
            imageKey = "Clear_Selection";
        }
        return imageKey;
    }

    @SASScope
    protected void createStringDataPatternExampleLabel() {
        Label stringDataPatternExampleLabel = new Label();
        stringDataPatternExampleLabel.setStyleClass(((StyleInfo)defaultStyleMap.get("BASEEXPRESSIONEDITOR_STRING_DATA_PATTERN_EXAMPLE_ROW_CLASS")).getClassid());
        this.setComponent("BASEEXPRESSIONEDITOR_STRING_DATA_PATTERN_EXAMPLE", stringDataPatternExampleLabel);
    }

    @SASScope
    protected void createHelpTextLabel() {
        Label helpTextLabel = new Label();
        helpTextLabel.setStyleClass(((StyleInfo)defaultStyleMap.get("BASEEXPRESSIONEDITOR_HELP_TEXT_CLASS")).getClassid());
        this.setComponent("BASEEXPRESSIONEDITOR_HELP_TEXT", helpTextLabel);
    }

    private void createNetscapeHelpTextLabel() {
        Label netscapeHelpTextLabel = new Label();
        netscapeHelpTextLabel.setStyleClass(((StyleInfo)defaultStyleMap.get("BASEEXPRESSIONEDITOR_NETSCAPE_HELP_TEXT_CLASS")).getClassid());
        netscapeHelpTextLabel.setVisible(false);
        this.setComponent("BASEEXPRESSIONEDITOR_NETSCAPE_HELP_TEXT", netscapeHelpTextLabel);
    }

    private void initializeNetscapeHelpTextLabel() {
        if (new ClientInfo(this.getRequest()).isNetscape()) {
            BaseTransformation netscapeHelpTextLabel = null;
            try {
                netscapeHelpTextLabel = (BaseTransformation)this.getComponent("BASEEXPRESSIONEDITOR_NETSCAPE_HELP_TEXT");
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e, null);
            }
            netscapeHelpTextLabel.setVisible(true);
        }
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String location2) {
        this.imageLocation = location2;
    }

    @SASScope
    protected String getButtonOnClickFunctionName(String buttonType) {
        StringBuffer functionName = new StringBuffer();
        if (buttonType.equals("BASEEXPRESSIONEDITOR_PARENTHESIZE_BUTTON")) {
            functionName.append(JAVASCRIPT_PROCESS_PARENTHESES_BUTTON_FUNCTION);
        } else {
            functionName.append(JAVASCRIPT_PROCESS_BUTTON_FUNCTION);
        }
        functionName.append("('");
        functionName.append(buttonType);
        functionName.append("','");
        functionName.append(this.getComponent(buttonType).getId());
        functionName.append("')");
        functionName.append("; return false;");
        return functionName.toString();
    }

    private String getButtonType(Operation operator) {
        if (operator.getName().equals("addButton")) {
            return "BASEEXPRESSIONEDITOR_ADD_BUTTON";
        }
        if (operator.getName().equals("subtractButton")) {
            return "BASEEXPRESSIONEDITOR_SUBTRACT_BUTTON";
        }
        if (operator.getName().equals("multiplyButton")) {
            return "BASEEXPRESSIONEDITOR_MULTIPLY_BUTTON";
        }
        if (operator.getName().equals("divideButton")) {
            return "BASEEXPRESSIONEDITOR_DIVIDE_BUTTON";
        }
        if (operator.getName().equals("parenthesizeButton")) {
            return "BASEEXPRESSIONEDITOR_PARENTHESIZE_BUTTON";
        }
        if (operator.getName().equals("clearButton")) {
            return "BASEEXPRESSIONEDITOR_CLEAR_BUTTON";
        }
        return null;
    }

    static {
        JavaScriptIncludeHandler.addAlias(BaseExpressionEditor.class, "BASEEXPRESSIONEDITOR");
    }
}

