/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.codepolicy.SASScope;
import com.sas.framework.themes.client.Template;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.CompositeComponentInterface;
import com.sas.servlet.tbeans.RB;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateInterface;
import com.sas.servlet.tbeans.TemplateKeyInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.text.Message;
import com.sas.themeresources.cdd.templates.ComponentTemplates;
import com.sas.util.SimpleTemplate2;
import com.sas.util.SimpleTemplateToPrintWriter;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.webapp.servlet.util.ServletUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

@SASScope
public class TemplateSupport {
    static final String RB_KEY = "TemplateSupport.";
    private static final String TEMPLATE_BASE = "temp/templates/";
    private static Map templateCache = Collections.synchronizedMap(new HashMap());
    private static CommonLoggerInterface _log;

    public static String getStringValue(File file) {
        if (file != null) {
            try {
                FileInputStream template = new FileInputStream(file);
                return TemplateSupport.getStringValue(new InputStreamReader(template));
            }
            catch (Exception e) {
                TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringValue(InputStreamReader isr) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(isr);
            br.ready();
            StringBuffer b = new StringBuffer();
            int c = br.read();
            while (c != -1) {
                b.append((char)c);
                c = br.read();
            }
            String string = b.toString();
            return string;
        }
        catch (Exception e) {
            TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String getStringValue(InputStream stream) {
        try {
            StringBuffer b = new StringBuffer();
            int c = stream.read();
            while (c != -1) {
                b.append((char)c);
                c = stream.read();
            }
            return b.toString();
        }
        catch (Exception e) {
            TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String applyTemplate(BaseTransformation tbean, String _template) {
        if (tbean == null || !(tbean instanceof TemplateInterface)) {
            return null;
        }
        String template = TemplateSupport.getTemplate(tbean, _template);
        if (template == null) {
            return null;
        }
        return SimpleTemplate2.format((String)template, (Map)TemplateSupport.getDictionary(tbean, template));
    }

    public static void writeTemplate(BaseTransformation tbean, String _template, PrintWriter printWriter) {
        if (tbean == null || !(tbean instanceof TemplateInterface) || printWriter == null) {
            return;
        }
        String template = TemplateSupport.getTemplate(tbean, _template);
        if (template == null) {
            return;
        }
        PrintWriter bufferedWriter = new PrintWriter(new BufferedWriter(printWriter));
        SimpleTemplateToPrintWriter.write((String)template, (Map)TemplateSupport.getDictionary(tbean, template), (PrintWriter)bufferedWriter);
        bufferedWriter.flush();
    }

    private static Map getDictionary(BaseTransformation tbean, String template) {
        Map componentMap;
        HashMap tempDictionary = new HashMap();
        HashMap templateMap = ((TemplateInterface)((Object)tbean)).getTemplateDictionary();
        if (templateMap != null) {
            tempDictionary.putAll(templateMap);
        }
        HashMap<String, String> newStyleMap = new HashMap<String, String>();
        if (tbean instanceof ComplexStyleInterface) {
            Map styleMap = ((ComplexStyleInterface)((Object)tbean)).getStyleMap();
            Set set = styleMap.keySet();
            for (String key : set) {
                StyleInfo styleinfo = (StyleInfo)styleMap.get(key);
                newStyleMap.put(key, styleinfo.getClassid());
            }
            tempDictionary.putAll(newStyleMap);
        }
        if (tbean instanceof CompositeComponentInterface && (componentMap = ((CompositeComponentInterface)((Object)tbean)).getVisibleComponents()) != null) {
            for (Object key : componentMap.keySet()) {
                Object value = componentMap.get(key);
                tempDictionary.put(key, value);
            }
        }
        return tempDictionary;
    }

    public static void clearTemplateCache() {
        templateCache.clear();
    }

    public static String getTemplate(HttpServletRequest request, String templateFile) {
        return TemplateSupport.getTemplate(request, templateFile, null, null, null);
    }

    public static String getTemplate(HttpServletRequest request, String templateFile, String defaultTemplate) {
        return TemplateSupport.getTemplate(request, templateFile, null, null, defaultTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTemplate(HttpServletRequest request, String templateFile, String templateLocation, String templateKey, String defaultTemplate) {
        String template = null;
        String fullTemplatePath = null;
        if (templateFile != null && request != null) {
            ServletContext sc = request.getSession().getServletContext();
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
            String location2 = cpm.getTemplateURLLocation();
            if (location2 != null) {
                template = TemplateSupport.getTemplateViaURI(location2 + templateFile, cpm);
            } else {
                InputStream templateFileInputStream = null;
                location2 = templateLocation;
                if (location2 == null) {
                    location2 = cpm.getTemplateLocation();
                }
                if (!(location2 = location2.trim()).endsWith("/") && !location2.endsWith("\\")) {
                    location2 = location2 + "/";
                }
                if ((template = (String)templateCache.get(fullTemplatePath = location2 + templateFile)) == null) {
                    templateFileInputStream = sc.getResourceAsStream(location2 + templateFile);
                }
                if (templateFileInputStream != null) {
                    Map map = templateCache;
                    synchronized (map) {
                        InputStreamReader isr = new InputStreamReader(templateFileInputStream);
                        template = TemplateSupport.getStringValue(isr);
                        templateCache.put(fullTemplatePath, template);
                        try {
                            templateFileInputStream.close();
                            if (isr != null) {
                                isr.close();
                            }
                        }
                        catch (IOException e) {
                            TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (template == null) {
                    TemplateSupport.getLog().info(Message.format((String)RB.getStringResource(RB_KEY, "noTemplateFile.fmt.txt"), (Object)fullTemplatePath));
                }
            }
        } else if (templateKey != null && request != null) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
            String templateURI = cpm.getTemplateURI(templateKey);
            if (templateURI != null && (template = (String)templateCache.get(templateURI)) == null && (template = TemplateSupport.getTemplateViaURI(templateURI, cpm)) != null) {
                templateCache.put(templateURI, template);
            }
        } else if (templateFile != null) {
            TemplateSupport.getLog().info(Message.format((String)RB.getStringResource(RB_KEY, "noTemplateFile.fmt.txt"), fullTemplatePath));
        }
        if (template == null) {
            template = defaultTemplate;
            if (fullTemplatePath != null) {
                templateCache.put(fullTemplatePath, template);
            }
        }
        return template;
    }

    @SASScope
    public static final String getTemplateViaURI(String uri, ComponentPropertyManager cpm) {
        String template = null;
        try {
            URL templateFileURL = new URL(uri);
            template = cpm.isTemplateURLLocationFromTheme() ? ServletUtil.getThemeFileAsString(null, (URL)templateFileURL) : ServletUtil.getFileAsString(null, (URL)templateFileURL);
            if (template == null) {
                TemplateSupport.getLog().info(Message.format((String)RB.getStringResource(RB_KEY, "noTemplateFile.fmt.txt"), (Object)uri));
            }
        }
        catch (MalformedURLException e) {
            TemplateSupport.getLog().warn(Message.format((String)RB.getStringResource(RB_KEY, "noTemplateFile.fmt.txt"), (Object)uri), (Throwable)e);
        }
        catch (IOException e) {
            TemplateSupport.getLog().warn(Message.format((String)RB.getStringResource(RB_KEY, "noTemplateFile.fmt.txt"), (Object)uri), (Throwable)e);
        }
        return template;
    }

    private static String getTemplate(BaseTransformation tbean, String _template) {
        if (_template != null) {
            return _template;
        }
        String template = ((TemplateInterface)((Object)tbean)).getTemplate();
        if (template == null) {
            String templateFile = ((TemplateInterface)((Object)tbean)).getTemplateFileName();
            String location2 = ((TemplateInterface)((Object)tbean)).getTemplateLocation();
            String templateKey = null;
            if (tbean instanceof TemplateKeyInterface) {
                templateKey = ((TemplateKeyInterface)((Object)tbean)).getTemplateKey();
            }
            if ((template = TemplateSupport.getTemplate(tbean.getRequest(), templateFile, location2, templateKey, null)) == null) {
                template = ((TemplateInterface)((Object)tbean)).getDefaultTemplate();
            }
        }
        return template;
    }

    public static String applyTemplate(BaseTransformation tbean) {
        return TemplateSupport.applyTemplate(tbean, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultTemplate(TemplateInterface tbean) {
        InputStream in = null;
        try {
            String templateFileName = tbean.getTemplateFileName();
            if (templateFileName == null && tbean instanceof TemplateKeyInterface && ((TemplateKeyInterface)((Object)tbean)).getTemplateKey() != null) {
                templateFileName = ((Template)ComponentTemplates.getInstance().get(((TemplateKeyInterface)((Object)tbean)).getTemplateKey())).getFile();
            }
            if ((in = tbean.getClass().getClassLoader().getResourceAsStream(TEMPLATE_BASE + templateFileName)) != null) {
                String string = TemplateSupport.getStringValue(in);
                return string;
            }
        }
        catch (Exception e) {
            TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                TemplateSupport.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)TemplateSupport.class.getName(), null);
        }
        return _log;
    }
}

