/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.HttpActionProviderInterface;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.CompositeComponentInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope
public class CompositeSupport
extends TemplateSupport {
    protected Map components;
    private String template;
    private String templateFileName;
    private String templateLocation;
    private HashMap templateDictionary;
    private BaseCompositeTransformation composite;
    private String templateKey;

    public CompositeSupport() {
        this(null);
    }

    @SASScope
    public CompositeSupport(BaseCompositeTransformation composite) {
        this.composite = composite;
        this.components = new HashMap();
    }

    public TransformationInterface getComponent(String componentKey) {
        return (TransformationInterface)this.components.get(componentKey);
    }

    public TransformationInterface setComponent(String componentKey, TransformationInterface tbean) {
        if (tbean != null) {
            this.removeComponent(componentKey);
            if (tbean instanceof BaseTransformation) {
                ((BaseTransformation)tbean).setParentComposite(this.composite);
            }
            this.components.put(componentKey, tbean);
            return tbean;
        }
        return null;
    }

    public TransformationInterface removeComponent(String componentKey) {
        TransformationInterface tbean = (TransformationInterface)this.components.remove(componentKey);
        if (tbean instanceof BaseTransformation && !this.components.values().contains(tbean)) {
            ((BaseTransformation)tbean).setParentComposite(null);
        }
        return tbean;
    }

    public StyleInfo getStyleInfo(String componentKey, String styleKey, TransformationInterface tbean) {
        return this.findStyleInfo(this.components, componentKey, styleKey, null, tbean);
    }

    private StyleInfo findStyleInfo(Map compMap, String componentKey, String styleKey, String searchKey, TransformationInterface tbean) throws NullPointerException {
        if (componentKey != null) {
            Iterator iter = compMap.keySet().iterator();
            while (iter.hasNext()) {
                String compareKey = null;
                String key = (String)iter.next();
                compareKey = searchKey != null ? searchKey + "_" + key : key;
                Object o = compMap.get(key);
                if (!compareKey.equals(componentKey)) continue;
                if (o instanceof CompositeComponentInterface && o != tbean) {
                    Map cMap = ((CompositeComponentInterface)o).getComponents();
                    if (o == tbean) continue;
                    return this.findStyleInfo(cMap, componentKey, styleKey, compareKey, tbean);
                }
                if (o instanceof ComplexStyleInterface) {
                    Map sMap = ((ComplexStyleInterface)o).getStyleMap();
                    if (sMap.containsKey(styleKey)) {
                        return (StyleInfo)sMap.get(styleKey);
                    }
                    return null;
                }
                if (!(o instanceof StyleInterface)) continue;
                return ((StyleInterface)o).getStyleInfo();
            }
        }
        return null;
    }

    public void setStyleInfo(String componentKey, String styleKey, StyleInfo styleInfo, TransformationInterface tbean) throws NullPointerException {
        this.modifyStyleInfo(this.components, componentKey, styleKey, styleInfo, null, tbean);
    }

    private void modifyStyleInfo(Map compMap, String componentKey, String styleKey, StyleInfo styleInfo, String searchKey, TransformationInterface tbean) throws NullPointerException {
        if (componentKey != null) {
            Iterator iter = compMap.keySet().iterator();
            while (iter.hasNext()) {
                String compareKey = null;
                String key = (String)iter.next();
                compareKey = searchKey != null ? searchKey + "_" + key : key;
                Object o = compMap.get(key);
                if (!compareKey.equals(componentKey)) continue;
                if (o instanceof CompositeComponentInterface && o != tbean) {
                    Map cMap = ((CompositeComponentInterface)o).getComponents();
                    if (o == tbean) continue;
                    this.modifyStyleInfo(cMap, componentKey, styleKey, styleInfo, compareKey, tbean);
                    continue;
                }
                if (o instanceof ComplexStyleInterface) {
                    Map sMap = ((ComplexStyleInterface)o).getStyleMap();
                    if (!sMap.containsKey(styleKey)) continue;
                    sMap.put(styleKey, styleInfo);
                    continue;
                }
                if (!(o instanceof StyleInterface)) continue;
                ((StyleInterface)o).setStyleInfo(styleInfo);
            }
        }
    }

    public Map getVisibleComponents() {
        Iterator iter = this.components.keySet().iterator();
        HashMap visibleComponents = new HashMap();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object obj = this.components.get(key);
            if (!(obj instanceof TransformationInterface) || !((TransformationInterface)obj).isVisible()) continue;
            visibleComponents.put(key, obj);
        }
        return visibleComponents;
    }

    public void setActionProvider(HttpActionProvider provider, TransformationInterface comp) {
        Collection values = this.components.values();
        for (Object obj : values) {
            if (!(obj instanceof HttpActionProviderInterface) || obj == comp) continue;
            ((HttpActionProviderInterface)obj).setActionProvider(provider);
        }
    }

    public void setCleanUpResourcesOn(boolean b, TransformationInterface comp) {
        Collection values = this.components.values();
        for (Object obj : values) {
            if (!(obj instanceof BaseTransformation) || obj == comp) continue;
            ((BaseTransformation)obj).setCleanUpResourcesOn(b);
        }
    }

    public void setRequest(HttpServletRequest req, TransformationInterface comp) {
        Collection values = this.components.values();
        for (Object obj : values) {
            if (!(obj instanceof TransformationInterface) || obj == comp) continue;
            ((TransformationInterface)obj).setRequest(req);
        }
    }

    public void setResponse(HttpServletResponse resp, TransformationInterface comp) {
        Collection values = this.components.values();
        for (Object obj : values) {
            if (!(obj instanceof TransformationInterface) || obj == comp) continue;
            ((TransformationInterface)obj).setResponse(resp);
        }
    }

    public void setLocale(Locale loc, TransformationInterface comp) {
        Collection values = this.components.values();
        for (Object obj : values) {
            if (!(obj instanceof TransformationInterface) || obj == comp) continue;
            ((TransformationInterface)obj).setLocale(loc);
        }
    }

    public Map getComponents() {
        return this.components;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setTemplateFileName(String file) {
        this.templateFileName = file;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplate(File file) {
        this.setTemplate(TemplateSupport.getStringValue(file));
    }

    public HashMap getTemplateDictionary() {
        return this.templateDictionary;
    }

    public void setTemplateDictionary(HashMap dictionary) {
        this.templateDictionary = dictionary;
    }

    public void setTemplateLocation(String location2) {
        this.templateLocation = location2;
    }

    public String getTemplateLocation(HttpServletRequest request) {
        if (this.templateLocation != null) {
            return this.templateLocation;
        }
        return ComponentPropertyManager.getInstance(request).getTemplateLocation();
    }

    @SASScope
    public String getTemplateKey() {
        return this.templateKey;
    }

    @SASScope
    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }
}

