/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseActionCompositeTransformation2;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.TransformationInterface2;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope
public abstract class BaseTransformation2
extends BaseTransformation
implements TransformationInterface2 {
    private StringBuffer writeBuffer = null;
    protected static final int NOT_WRITING_MODE = -1;
    protected static final int FULL_WRITE_MODE = 0;
    protected static final int REFRESH_WRITE_MODE = 1;
    private static final String COMPONENT_CONTAINER_SUFFIX = "_ComponentContainer";
    private static CommonLoggerInterface _log = null;
    private int writeMode = -1;
    private TransformationInterface2 partialRefreshProxy;

    @Override
    public TransformationInterface2 getPartialRefreshProxy() {
        return this.partialRefreshProxy;
    }

    @Override
    public void setPartialRefreshProxy(TransformationInterface2 partialRefreshProxy) {
        this.partialRefreshProxy = partialRefreshProxy;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        try {
            this.setWriteMode(0);
            if (this.isVisible()) {
                out.println("<div id=\"" + this.getContainerId() + "\" class=\"ComponentContainer\">");
                this.writeContent(out);
                out.println("</div>");
            }
        }
        catch (IOException ioe) {
            BaseTransformation2.getLog().error(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
        finally {
            this.setWriteMode(-1);
            this.cleanUpResources();
        }
    }

    @Override
    public void writePartialRefresh(HttpServletRequest request, HttpServletResponse response, PrintWriter out) throws IOException {
        try {
            this.setWriteMode(1);
            if (this.isVisible()) {
                this.setRequest(request);
                this.setResponse(response);
                this.writeContent(out);
            }
        }
        catch (IOException ioe) {
            BaseTransformation2.getLog().error(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
        finally {
            this.setWriteMode(-1);
            this.cleanUpResources();
        }
    }

    @Override
    public String getContainerId() {
        String id = this.getId();
        if (id == null) {
            return COMPONENT_CONTAINER_SUFFIX;
        }
        return id + COMPONENT_CONTAINER_SUFFIX;
    }

    protected int getWriteMode() {
        return this.writeMode;
    }

    protected void setWriteMode(int writeMode) {
        this.writeMode = writeMode;
    }

    protected abstract void writeContent(PrintWriter var1) throws IOException;

    protected void writeCustomAttributes(PrintWriter out) {
        String styleClass;
        String style;
        String custom = this.getCustomAttributes();
        if (custom != null && custom.length() > 0) {
            this.getWriteBuffer().append(" ").append(custom);
        }
        if ((style = this.getStyle()) != null && style.length() > 0) {
            this.getWriteBuffer().append(" style=\"").append(style).append("\"");
        }
        if ((styleClass = this.getStyleClass()) != null && styleClass.length() > 0) {
            this.getWriteBuffer().append(" class=\"").append(styleClass).append("\"");
        }
        if (this.getWriteBuffer().length() > 0) {
            out.print(this.getWriteBuffer().toString());
        }
        this.writeBuffer = null;
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)BaseActionCompositeTransformation2.class.getPackage().getName(), null);
        }
        return _log;
    }

    private StringBuffer getWriteBuffer() {
        if (this.writeBuffer == null) {
            this.writeBuffer = new StringBuffer();
        }
        return this.writeBuffer;
    }
}

