/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.RB;
import com.sas.actionprovider.URLTemplateViewInterface;
import com.sas.actionprovider.refresh.PartialRefreshActionsInterface;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseActionCompositeTransformation;
import com.sas.servlet.tbeans.CompositeComponentInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.TransformationInterface2;
import com.sas.util.SimpleTemplate;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope
public abstract class BaseActionCompositeTransformation2
extends BaseActionCompositeTransformation
implements TransformationInterface2,
URLTemplateViewInterface,
AJAXControllerURLInterface,
PartialRefreshActionsInterface {
    private SimpleTemplate URLTemplate;
    private boolean partialRefreshActionsEnabled = false;
    private String ajaxControllerURL = null;
    protected static final int NOT_WRITING_MODE = -1;
    protected static final int FULL_WRITE_MODE = 0;
    protected static final int REFRESH_WRITE_MODE = 1;
    private static final String COMPONENT_CONTAINER_SUFFIX = "_ComponentContainer";
    private static CommonLoggerInterface _log = null;
    private int writeMode = -1;
    private TransformationInterface2 partialRefreshProxy;

    @Override
    public TransformationInterface2 getPartialRefreshProxy() {
        return this.partialRefreshProxy;
    }

    @Override
    public void setPartialRefreshProxy(TransformationInterface2 partialRefreshProxy) {
        this.partialRefreshProxy = partialRefreshProxy;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        try {
            this.setWriteMode(0);
            if (this.isVisible()) {
                out.println("<div id=\"" + this.getContainerId() + "\" class=\"ComponentContainer\">");
                this.writeContent(out);
                out.println("</div>");
            }
        }
        catch (IOException ioe) {
            BaseActionCompositeTransformation2.getLog().error(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
        finally {
            this.setWriteMode(-1);
            this.cleanUpResources();
        }
    }

    @Override
    public void writePartialRefresh(HttpServletRequest request, HttpServletResponse response, PrintWriter out) throws IOException {
        try {
            this.setWriteMode(1);
            if (this.isVisible()) {
                this.setRequest(request);
                this.setResponse(response);
                this.writeContent(out);
            }
        }
        catch (IOException ioe) {
            BaseActionCompositeTransformation2.getLog().error(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
        finally {
            this.setWriteMode(-1);
            this.cleanUpResources();
        }
    }

    @Override
    public String getContainerId() {
        String id = this.getId();
        if (id == null) {
            return COMPONENT_CONTAINER_SUFFIX;
        }
        return id + COMPONENT_CONTAINER_SUFFIX;
    }

    protected int getWriteMode() {
        return this.writeMode;
    }

    protected void setWriteMode(int writeMode) {
        this.writeMode = writeMode;
    }

    protected abstract void writeContent(PrintWriter var1) throws IOException;

    protected void flushActionProvider() {
        HttpActionProvider actionProvider = this.getActionProvider();
        if (actionProvider != null && this.isFlushEnabled()) {
            actionProvider.flushViewerCommands(this);
        }
    }

    protected void setPartialRefreshProxy(String componentKey, TransformationInterface2 proxy) {
        TransformationInterface component = this.getComponent(componentKey);
        if (component instanceof TransformationInterface2) {
            ((TransformationInterface2)component).setPartialRefreshProxy(this);
        }
    }

    @Override
    public boolean isPartialRefreshActionsEnabled() {
        return this.partialRefreshActionsEnabled;
    }

    @Override
    public void setPartialRefreshActionsEnabled(boolean partialRefreshActionsEnabled) {
        if (partialRefreshActionsEnabled == this.partialRefreshActionsEnabled) {
            return;
        }
        if (partialRefreshActionsEnabled) {
            if (this.URLTemplate != null) {
                throw new IllegalStateException(RB.getStringResource((String)"BaseTransformation.", (String)"partialRefreshActionsEnabledSetInvalid.txt"));
            }
            this.URLTemplate = new SimpleTemplate("javascript: void(sas.ajax.doAction('%AJAX_CONTROLLER_URL%QUERYSTRING&CLASS_PARAMETER=com.sas.actionprovider.refresh.PartialRefreshActionHandler&refreshViewerId=%REFRESHVIEWERID&_referringURI=%REFERRINGURI'));");
        } else {
            this.setURLTemplate(null);
        }
        this.partialRefreshActionsEnabled = partialRefreshActionsEnabled;
        this.setPartialRefreshActionsEnabledOnComponents(this, partialRefreshActionsEnabled);
    }

    private void setPartialRefreshActionsEnabledOnComponents(CompositeComponentInterface composite, boolean ajaxEnabled) {
        Map children = composite.getComponents();
        if (children == null) {
            return;
        }
        Iterator iterator = children.keySet().iterator();
        while (iterator.hasNext()) {
            Object child = children.get(iterator.next());
            if (child instanceof PartialRefreshActionsInterface) {
                ((PartialRefreshActionsInterface)child).setPartialRefreshActionsEnabled(ajaxEnabled);
                continue;
            }
            if (!(child instanceof CompositeComponentInterface)) continue;
            this.setPartialRefreshActionsEnabledOnComponents((CompositeComponentInterface)child, ajaxEnabled);
        }
    }

    @Override
    public SimpleTemplate getURLTemplate() {
        return this.URLTemplate;
    }

    @Override
    public void setURLTemplate(SimpleTemplate URLTemplate) {
        if (this.isPartialRefreshActionsEnabled()) {
            throw new IllegalStateException(RB.getStringResource((String)"BaseTransformation.", (String)"urlTemplateSetInvalid.txt"));
        }
        this.URLTemplate = URLTemplate;
        this.setURLTemplateOnComponents(this, URLTemplate);
    }

    private void setURLTemplateOnComponents(CompositeComponentInterface composite, SimpleTemplate URLTemplate) {
        Map children = composite.getComponents();
        if (children == null) {
            return;
        }
        Iterator iterator = children.keySet().iterator();
        while (iterator.hasNext()) {
            Object child = children.get(iterator.next());
            if (child instanceof URLTemplateViewInterface) {
                ((URLTemplateViewInterface)child).setURLTemplate(URLTemplate);
                continue;
            }
            if (!(child instanceof CompositeComponentInterface)) continue;
            this.setURLTemplateOnComponents((CompositeComponentInterface)child, URLTemplate);
        }
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)BaseActionCompositeTransformation2.class.getPackage().getName(), null);
        }
        return _log;
    }

    @Override
    public String getAJAXControllerURL() {
        if (this.ajaxControllerURL == null && this.getRequest() != null) {
            return this.getRequest().getContextPath() + "/MethodInvocationServlet";
        }
        return this.ajaxControllerURL;
    }

    @Override
    public void setAJAXControllerURL(String ajaxControllerURL) {
        this.ajaxControllerURL = ajaxControllerURL;
        this.setAJAXControllerURLOnComponents(this, ajaxControllerURL);
    }

    private void setAJAXControllerURLOnComponents(CompositeComponentInterface composite, String ajaxControllerURL) {
        Map children = composite.getComponents();
        if (children == null) {
            return;
        }
        Iterator iterator = children.keySet().iterator();
        while (iterator.hasNext()) {
            Object child = children.get(iterator.next());
            if (child instanceof AJAXControllerURLInterface) {
                ((AJAXControllerURLInterface)child).setAJAXControllerURL(ajaxControllerURL);
                continue;
            }
            if (!(child instanceof CompositeComponentInterface)) continue;
            this.setAJAXControllerURLOnComponents((CompositeComponentInterface)child, ajaxControllerURL);
        }
    }
}

