/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.HttpActionProviderViewInterface;
import com.sas.actionprovider.support.HttpViewerSupport;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.AlternateTextInterface;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.DisabledImageInterface;
import com.sas.servlet.tbeans.DisabledImageKeyInterface;
import com.sas.servlet.tbeans.EnabledInterface;
import com.sas.servlet.tbeans.ImageInterface;
import com.sas.servlet.tbeans.ImageKeyInterface;
import com.sas.servlet.tbeans.ImagePositionInterface;
import com.sas.servlet.tbeans.LabelInterface;
import com.sas.servlet.tbeans.ScriptActivatedInterface;
import com.sas.servlet.tbeans.StyleMapInterface;
import com.sas.servlet.tbeans.TitleInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.URLInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

@SASScope(value="ALL")
public abstract class BaseActionCompositeTransformation
extends BaseCompositeTransformation
implements HttpActionProviderViewInterface {
    protected HttpViewerSupport viewerSupport;
    private Map componentActionTypeMap;

    public Object getUniqueId() {
        return this.getViewerSupport().getUniqueId();
    }

    public void setUniqueId(Object uniqueId) {
        this.getViewerSupport().setUniqueId(uniqueId);
    }

    public void setActionVisible(String actionType, String areaType, boolean visible) {
        this.getViewerSupport().setActionVisible(actionType, areaType, visible);
    }

    public boolean isActionVisible(String actionType, String areaType) {
        return this.getViewerSupport().isActionVisible(actionType, areaType);
    }

    public Collection listAreaTypes() {
        return this.getViewerSupport().listAreaTypes();
    }

    public Collection listActionTypes(String areaType) {
        return this.getViewerSupport().listActionTypes(areaType);
    }

    public void setActionSupportType(String actionSupportType) {
        this.getViewerSupport().setActionSupportType(actionSupportType);
    }

    public String getActionSupportType() {
        return this.getViewerSupport().getActionSupportType();
    }

    public Object getComponentActionType(Object componentKey) {
        return this.getComponentActionTypeMap().get(componentKey);
    }

    public void setComponentActionType(Object componentKey, Object actionTypeKey) {
        this.getComponentActionTypeMap().put(componentKey, actionTypeKey);
    }

    public void setComponent(String componentKey, TransformationInterface tbean, String actionType) {
        this.getComponentActionTypeMap().put(componentKey, actionType);
        super.setComponent(componentKey, tbean);
    }

    protected HttpAction getComponentAction(Object componentKey) {
        if (componentKey == null || this.getActionProvider() == null) {
            return null;
        }
        String actionType = (String)this.getComponentActionTypeMap().get(componentKey);
        if (actionType == null) {
            return null;
        }
        ActionSupportFilter filter = this.getActionFilter(actionType);
        if (filter == null) {
            return null;
        }
        filter.setPoolingOn(true);
        return (HttpAction)this.getActionProvider().getAction(actionType, filter);
    }

    protected ActionSupportFilter getActionFilter(String actionType) {
        return null;
    }

    @Override
    public String applyTemplate(BaseTransformation tbean) {
        return this.applyTemplate(tbean, null);
    }

    @Override
    public String applyTemplate(BaseTransformation tbean, String _template) {
        Map componentActionTypes = this.getComponentActionTypeMap();
        Map componentMap = this.getVisibleComponents();
        if (componentActionTypes.isEmpty() || componentMap == null || componentMap.isEmpty()) {
            return super.applyTemplate(tbean, _template);
        }
        Vector<HttpAction> listOfActions = null;
        for (Object componentKey : componentActionTypes.keySet()) {
            HttpAction action;
            Object component = componentMap.get(componentKey);
            if (component == null || !(component instanceof URLInterface) || (action = this.getComponentAction(componentKey)) == null) continue;
            this.moveActionAttributesToComponent(action, component);
            if (listOfActions == null) {
                listOfActions = new Vector<HttpAction>();
            }
            listOfActions.add(action);
        }
        String returnValue = super.applyTemplate(tbean, _template);
        if (listOfActions == null) {
            return returnValue;
        }
        HttpActionProvider httpActionProvider = this.getActionProvider();
        if (httpActionProvider == null) {
            return returnValue;
        }
        int size = listOfActions.size();
        for (int i = 0; i < size; ++i) {
            httpActionProvider.returnAction((BaseAction)listOfActions.get(i));
        }
        return returnValue;
    }

    @Override
    public void writeTemplate(BaseTransformation tbean, String _template, PrintWriter out) {
        Map componentActionTypes = this.getComponentActionTypeMap();
        Map componentMap = this.getVisibleComponents();
        if (componentActionTypes.isEmpty() || componentMap == null || componentMap.isEmpty()) {
            super.writeTemplate(tbean, _template, out);
            return;
        }
        Vector<HttpAction> listOfActions = null;
        for (Object componentKey : componentActionTypes.keySet()) {
            HttpAction action;
            Object component = componentMap.get(componentKey);
            if (component == null || !(component instanceof URLInterface) || (action = this.getComponentAction(componentKey)) == null) continue;
            this.moveActionAttributesToComponent(action, component);
            if (listOfActions == null) {
                listOfActions = new Vector<HttpAction>();
            }
            listOfActions.add(action);
        }
        super.writeTemplate(tbean, _template, out);
        HttpActionProvider httpActionProvider = this.getActionProvider();
        if (listOfActions != null && httpActionProvider != null) {
            int size = listOfActions.size();
            for (int i = 0; i < size; ++i) {
                httpActionProvider.returnAction((BaseAction)listOfActions.get(i));
            }
        }
    }

    protected void moveActionAttributesToComponent(HttpAction action, Object component) {
        if (component instanceof AlternateTextInterface) {
            this.moveAlternateText((AlternateTextInterface)component, action);
        }
        if (component instanceof LabelInterface) {
            this.moveLabel((LabelInterface)component, action);
        }
        this.moveImage(component, action);
        this.moveDisabledImage(component, action);
        if (component instanceof ImagePositionInterface) {
            this.moveImagePosition((ImagePositionInterface)component, action);
        }
        if (component instanceof EnabledInterface) {
            ((EnabledInterface)component).setEnabled(action.isEnabled());
        }
        if (component instanceof URLInterface) {
            ((URLInterface)component).setURL((String)action.getValue("URL"));
        }
        if (component instanceof StyleMapInterface) {
            ((StyleMapInterface)component).setStyleMap((Map)action.getValue("StyleMap"));
        }
        if (component instanceof TitleInterface) {
            this.moveTitle((TitleInterface)component, action);
        }
        if (component instanceof ScriptActivatedInterface) {
            ((ScriptActivatedInterface)component).setScriptActivated(action.isScriptActivated());
        }
    }

    private void moveTitle(TitleInterface component, HttpAction action) {
        String title = action.isEnabled() ? (String)action.getValue("ShortDescription") : (String)action.getValue("ShortDisabledDescription");
        component.setTitle(title);
    }

    private void moveAlternateText(AlternateTextInterface component, HttpAction action) {
        String alternateText = (String)action.getValue("AlternateText");
        if (alternateText == null) {
            String string = alternateText = action.isEnabled() ? (String)action.getValue("ShortDescription") : (String)action.getValue("ShortDisabledDescription");
            if (alternateText == null) {
                alternateText = "";
            }
        }
        component.setAlternateText(alternateText);
    }

    private void moveLabel(LabelInterface component, HttpAction action) {
        String label = (String)action.getValue("Label");
        if (label == null) {
            label = (String)action.getValue("Name");
        }
        component.setLabel(label);
    }

    private void moveImage(Object component, HttpAction action) {
        String image = (String)action.getValue("SmallIconName");
        if (image != null && component instanceof ImageInterface) {
            ((ImageInterface)component).setImage(image);
        } else {
            String imageKey = (String)action.getValue("ImageKey");
            if (imageKey != null && component instanceof ImageKeyInterface) {
                String overrideImageLocation = this.getActionProvider() != null ? this.getActionProvider().getImageLocation() : null;
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                ((ImageKeyInterface)component).setImageKey(cpm.getImageURI(imageKey, overrideImageLocation));
            }
        }
    }

    private void moveDisabledImage(Object component, HttpAction action) {
        String disabledImage = (String)action.getValue("SmallDisabledIconName");
        if (disabledImage != null && component instanceof ImageInterface) {
            ((DisabledImageInterface)component).setDisabledImage(disabledImage);
        } else {
            String imageKey = (String)action.getValue("ImageKey");
            if (imageKey != null && component instanceof DisabledImageKeyInterface) {
                String overrideImageLocation = this.getActionProvider() != null ? this.getActionProvider().getImageLocation() : null;
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                ((DisabledImageKeyInterface)component).setDisabledImageKey(cpm.getImageURI(imageKey, overrideImageLocation));
            }
        }
    }

    private void moveImagePosition(ImagePositionInterface component, HttpAction action) {
        String alignment = (String)action.getValue("TextAlignment");
        if (alignment != null && (alignment.equals("SwingConstants.LEFT") || alignment.equals("SwingConstants.LEADING"))) {
            component.setImagePosition(4096);
        } else {
            component.setImagePosition(512);
        }
    }

    public void dispose() {
        HttpActionProvider actionProvider = this.getActionProvider();
        if (actionProvider != null) {
            actionProvider.flushViewerCommands(this);
            actionProvider.flushViewerEncodedValues(this);
            actionProvider.flushAdditionalViewerAttributes(this);
            actionProvider.flushViewerReferencesFromSupportClass(this);
        }
    }

    protected HttpViewerSupport getViewerSupport() {
        if (this.viewerSupport == null) {
            this.viewerSupport = new HttpViewerSupport(this);
        }
        return this.viewerSupport;
    }

    private Map getComponentActionTypeMap() {
        if (this.componentActionTypeMap == null) {
            this.componentActionTypeMap = new HashMap();
        }
        return this.componentActionTypeMap;
    }

    @Override
    public void setActionProvider(HttpActionProvider provider) {
        super.setActionProvider(provider);
        this.getViewerSupport().setActionProvider(provider);
    }
}

