/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.commands.olap.export;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.commands.export.Util;
import com.sas.dataselectors.export.HTMLExportCSSInfoInterface;
import com.sas.servlet.commands.olap.export.BaseOLAPExportCommand;
import com.sas.servlet.commands.olap.export.RB;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.util.BaseUtil;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.table.FormattedInterface;
import com.sas.util.UncheckedException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope(value="ALL")
public class OLAPExportToHTMLCommand
extends BaseOLAPExportCommand {
    private boolean isViewerSettingsToBeRestored = false;
    private boolean isViewerFormEnabled;
    private boolean isViewerAllActionsVisible;
    private int viewerStartRow;
    private int viewerEndRow;
    private int viewerRowPageSize;
    private int viewerStartColumn;
    private int viewerEndColumn;
    private int viewerColumnPageSize;
    private HttpServletRequest viewerRequest;
    private HttpServletResponse viewerResponse;
    private Locale viewerLocale;
    private boolean isFormattedDataUsed;
    @SASScope
    protected boolean isFlushEnabled;

    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        this.execute(o, startRow, nRows, isRawData, repeatLabels, null, null);
    }

    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData, boolean repeatLabels, String[] headers, String[] footers) {
        OLAPDataSetInterface model = (OLAPDataSetInterface)this.getAttribute("model");
        if (!(model instanceof OLAPDataSetInterface)) {
            throw new IllegalStateException(RB.getStringResource("BaseOLAPExportCommand.", "invalidModel.txt", this.getLocale()));
        }
        this.response = (HttpServletResponse)this.getAttribute("response");
        String charset = (String)this.getAttribute("charset");
        String contentType = (String)this.getAttribute("content_type");
        String contentDisposition = (String)this.getAttribute("content_disposition");
        if (charset == null) {
            charset = this.response.getCharacterEncoding();
        }
        if (contentType == null) {
            contentType = Util.DEFAULT_EXCEL_HTML_CONTENT_TYPE;
        }
        if (contentDisposition == null) {
            contentDisposition = Util.getDefaultContentDisposition((String)"HTML");
        }
        this.response.setContentType(new StringBuffer(contentType).append("; charset=").append(charset).toString());
        this.response.setHeader("Content-disposition", contentDisposition);
        OLAPTableView htmlTable = this.getViewer(startRow, nRows, isRawData, repeatLabels);
        boolean closeWriterNeeded = false;
        Writer writer = null;
        if (o instanceof Writer) {
            writer = (Writer)o;
            closeWriterNeeded = true;
        } else {
            writer = o instanceof ServletResponse ? BaseUtil.createOutputStreamWriter((ServletResponse)o) : BaseUtil.createOutputStreamWriter((ServletResponse)this.response);
        }
        HTMLExportCSSInfoInterface[] css = (HTMLExportCSSInfoInterface[])this.getAttribute("cssInfo");
        String styles = (String)this.getAttribute("styleDefinitions");
        try {
            String[] nameSpaces = new String[]{"xmlns:x=\"urn:schemas-microsoft-com:office:excel\""};
            writer.write(com.sas.servlet.commands.jdbc.export.Util.getHTMLHeader(css, styles, nameSpaces));
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
        if (headers != null) {
            try {
                for (int i = 0; i < headers.length; ++i) {
                    writer.write(com.sas.servlet.commands.jdbc.export.Util.getHTMLNewLineSpan(headers[i]));
                }
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e, null);
            }
        }
        try {
            htmlTable.write(writer);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (footers != null) {
            try {
                for (int i = 0; i < footers.length; ++i) {
                    writer.write(com.sas.servlet.commands.jdbc.export.Util.getHTMLNewLineSpan(footers[i]));
                }
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e, null);
            }
        }
        try {
            writer.write(com.sas.servlet.commands.jdbc.export.Util.getHTMLFooter());
            writer.flush();
            if (closeWriterNeeded) {
                writer.close();
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
        if (this.isViewerSettingsToBeRestored) {
            this.restoreViewerSettings(htmlTable);
        }
    }

    public OLAPTableView getViewer(int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        Object htmlTable = this.getAttribute("viewComponent");
        if (htmlTable == null) {
            htmlTable = this.createNewViewer(startRow, nRows, isRawData, repeatLabels);
        } else if (!(htmlTable instanceof OLAPTableView)) {
            if (htmlTable instanceof ActionProviderMenuBar) {
                if ((htmlTable = ((ActionProviderMenuBar)htmlTable).getViewer()) instanceof OLAPTableView) {
                    this.backupViewerSettings((OLAPTableView)htmlTable);
                    ((OLAPTableView)htmlTable).setResponse((HttpServletResponse)this.getAttribute("response"));
                    ((OLAPTableView)htmlTable).setRequest((HttpServletRequest)this.getAttribute("request"));
                    ((OLAPTableView)htmlTable).setLocale((Locale)this.getAttribute("locale"));
                    ((OLAPTableView)htmlTable).initialize();
                    htmlTable = this.configureViewerForExport((OLAPTableView)htmlTable, startRow, nRows, isRawData, repeatLabels);
                    ((OLAPTableView)htmlTable).setDeferInitializeToFalse();
                } else {
                    htmlTable = this.createNewViewer(startRow, nRows, isRawData, repeatLabels);
                }
            } else {
                htmlTable = this.createNewViewer(startRow, nRows, isRawData, repeatLabels);
            }
        } else {
            this.backupViewerSettings((OLAPTableView)htmlTable);
            ((OLAPTableView)htmlTable).setResponse((HttpServletResponse)this.getAttribute("response"));
            ((OLAPTableView)htmlTable).setRequest((HttpServletRequest)this.getAttribute("request"));
            ((OLAPTableView)htmlTable).setLocale((Locale)this.getAttribute("locale"));
            ((OLAPTableView)htmlTable).initialize();
            htmlTable = this.configureViewerForExport((OLAPTableView)htmlTable, startRow, nRows, isRawData, repeatLabels);
            ((OLAPTableView)htmlTable).setDeferInitializeToFalse();
        }
        return (OLAPTableView)htmlTable;
    }

    private OLAPTableView createNewViewer(int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        OLAPTableView htmlTable = new OLAPTableView();
        HttpActionProvider actionProvider = new HttpActionProvider();
        htmlTable.setActionProvider(actionProvider);
        htmlTable.setModel((OLAPDataSetInterface)this.getAttribute("model"));
        htmlTable.setRequest((HttpServletRequest)this.getAttribute("request"));
        htmlTable.setResponse(this.response);
        htmlTable.setLocale((Locale)this.getAttribute("locale"));
        htmlTable.initialize();
        htmlTable = this.configureViewerForExport(htmlTable, startRow, nRows, isRawData, repeatLabels);
        htmlTable.setDeferInitializeToFalse();
        return htmlTable;
    }

    private void backupViewerSettings(OLAPTableView htmlTable) {
        this.isViewerFormEnabled = htmlTable.isFormEnabled();
        this.isViewerAllActionsVisible = htmlTable.isAllActionsVisible();
        this.viewerRowPageSize = htmlTable.getRowPageSize();
        this.viewerColumnPageSize = htmlTable.getColumnPageSize();
        this.viewerStartRow = htmlTable.getStartRow();
        this.viewerEndRow = htmlTable.getEndRow();
        this.viewerStartColumn = htmlTable.getStartColumn();
        this.viewerEndColumn = htmlTable.getEndColumn();
        this.isFlushEnabled = htmlTable.isFlushEnabled();
        this.viewerRequest = htmlTable.getRequest();
        this.viewerResponse = htmlTable.getResponse();
        this.viewerLocale = htmlTable.getLocale();
        Object model = this.getAttribute("model");
        if (model instanceof FormattedInterface) {
            this.isFormattedDataUsed = ((FormattedInterface)model).isFormattedDataUsed();
        }
        this.isViewerSettingsToBeRestored = true;
    }

    private void restoreViewerSettings(OLAPTableView htmlTable) {
        htmlTable.setFormEnabled(this.isViewerFormEnabled);
        htmlTable.setAllActionsVisible(this.isViewerAllActionsVisible);
        htmlTable.setExportToExcel(false);
        htmlTable.setRowPageSize(this.viewerRowPageSize);
        htmlTable.setColumnPageSize(this.viewerColumnPageSize);
        htmlTable.setStartRow(this.viewerStartRow);
        htmlTable.setEndRow(this.viewerEndRow);
        htmlTable.setStartColumn(this.viewerStartColumn);
        htmlTable.setEndColumn(this.viewerEndColumn);
        htmlTable.setFlushEnabled(this.isFlushEnabled);
        htmlTable.setRequest(this.viewerRequest);
        htmlTable.setResponse(this.viewerResponse);
        htmlTable.setLocale(this.viewerLocale);
        Object model = this.getAttribute("model");
        if (model instanceof FormattedInterface) {
            ((FormattedInterface)model).setFormattedDataUsed(this.isFormattedDataUsed);
        }
        this.isViewerSettingsToBeRestored = false;
    }

    private OLAPTableView configureViewerForExport(OLAPTableView htmlTable, int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        htmlTable.setFormEnabled(false);
        htmlTable.setAllActionsVisible(false);
        htmlTable.setExportToExcel(true);
        htmlTable.setRowPageSize(-1);
        htmlTable.setColumnPageSize(-1);
        htmlTable.setStartRow(startRow);
        if (nRows == -1) {
            nRows = htmlTable.getRowCount();
        }
        htmlTable.setEndRow(startRow + nRows - 1);
        htmlTable.setFlushEnabled(false);
        FormattedInterface fi = null;
        Object model = this.getAttribute("model");
        if (model instanceof FormattedInterface) {
            fi = (FormattedInterface)model;
            if (isRawData) {
                fi.setFormattedDataUsed(false);
            } else {
                fi.setFormattedDataUsed(true);
            }
        }
        return htmlTable;
    }
}

