/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.commands.olap.export;

import com.sas.codepolicy.SASScope;
import com.sas.commands.export.Util;
import com.sas.servlet.commands.olap.export.BaseOLAPExportCommand;
import com.sas.servlet.util.BaseUtil;
import com.sas.storage.jdbc.export.RelationalExcelXMLExporter;
import com.sas.storage.jdbc.export.RelationalExportInterface;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.export.OLAPExporter;
import com.sas.util.UncheckedException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

@SASScope(value="ALL")
public class OLAPExportToExcelXMLCommand
extends BaseOLAPExportCommand {
    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData, boolean repeatLabels) {
        this.execute(o, startRow, nRows, isRawData, repeatLabels, null, null);
    }

    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData, boolean repeatLabels, String[] headers, String[] footers) {
        String charset = null;
        Locale locale = (Locale)this.getAttribute("locale");
        this.response = (HttpServletResponse)this.getAttribute("response");
        charset = (String)this.getAttribute("charset");
        String contentType = (String)this.getAttribute("content_type");
        String contentDisposition = (String)this.getAttribute("content_disposition");
        if (charset == null) {
            charset = com.sas.servlet.commands.jdbc.export.Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
        }
        if (contentType == null) {
            contentType = Util.DEFAULT_EXCEL_XML_CONTENT_TYPE;
        }
        if (contentDisposition == null) {
            contentDisposition = Util.getDefaultContentDisposition((String)"XML");
        }
        this.response.setContentType(new StringBuffer(contentType).append("; charset=").append(charset).toString());
        this.response.setHeader("Content-disposition", contentDisposition);
        ResultSetInterface model = (ResultSetInterface)this.getAttribute("model");
        boolean closeWriterNeeded = false;
        Writer writer = null;
        if (o instanceof Writer) {
            writer = (Writer)o;
            closeWriterNeeded = true;
        } else {
            writer = o instanceof ServletResponse ? BaseUtil.createOutputStreamWriter((ServletResponse)o) : BaseUtil.createOutputStreamWriter((ServletResponse)this.response);
        }
        int reversedExcelUnicodeBOM = com.sas.servlet.commands.jdbc.export.Util.REVERSED_BOM_FOR_NON_HTML_EXPORT_TO_EXCEL;
        try {
            writer.write(reversedExcelUnicodeBOM);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RelationalExcelXMLExporter xmlExporter = new RelationalExcelXMLExporter();
        xmlExporter.setColumnCount(999999999);
        xmlExporter.setRowCount(999999999);
        OLAPExporter.writeToStream((ResultSetInterface)model, (Writer)writer, (RelationalExportInterface)xmlExporter, (int)startRow, (int)nRows, (boolean)isRawData, (boolean)repeatLabels, (Locale)locale, (String[])headers, (String[])footers);
        try {
            writer.flush();
            if (closeWriterNeeded) {
                writer.close();
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
    }
}

