/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.commands.jdbc.export;

import com.sas.servlet.commands.jdbc.export.BaseRelationalExportCommand;
import com.sas.servlet.commands.jdbc.export.Util;
import com.sas.servlet.util.BaseUtil;
import com.sas.storage.jdbc.export.RelationalExcelXMLExporter;
import com.sas.storage.jdbc.export.RelationalExportInterface;
import com.sas.storage.jdbc.export.RelationalTableModelExporter;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.util.UncheckedException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.swing.table.TableModel;

public class ExportToExcelXMLCommand
extends BaseRelationalExportCommand {
    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData) {
        this.execute(o, startRow, nRows, isRawData, null, null, null);
    }

    @Override
    public void execute(Object o, int startRow, int nRows, boolean isRawData, int[] columns, String[] headers, String[] footers) {
        String charset = null;
        Locale locale = (Locale)this.getAttribute("locale");
        this.response = (HttpServletResponse)this.getAttribute("response");
        charset = (String)this.getAttribute("charset");
        String contentType = (String)this.getAttribute("content_type");
        String contentDisposition = (String)this.getAttribute("content_disposition");
        if (charset == null) {
            charset = Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
        }
        if (contentType == null) {
            contentType = com.sas.commands.export.Util.DEFAULT_EXCEL_XML_CONTENT_TYPE;
        }
        if (contentDisposition == null) {
            contentDisposition = com.sas.commands.export.Util.getDefaultContentDisposition((String)"XML");
        }
        this.response.setContentType(new StringBuffer(contentType).append("; charset=").append(charset).toString());
        this.response.setHeader("Content-disposition", contentDisposition);
        TableModel model = (TableModel)this.getAttribute("model");
        boolean trueRowCalculated = false;
        if (model instanceof TrueRowCountCalculatedInterface && nRows == -1) {
            trueRowCalculated = ((TrueRowCountCalculatedInterface)model).isTrueRowCountCalculated();
            ((TrueRowCountCalculatedInterface)model).setTrueRowCountCalculated(true);
        }
        boolean closeWriterNeeded = false;
        Writer writer = null;
        if (o instanceof Writer) {
            writer = (Writer)o;
            closeWriterNeeded = true;
        } else {
            writer = o instanceof ServletResponse ? BaseUtil.createOutputStreamWriter((ServletResponse)o) : BaseUtil.createOutputStreamWriter((ServletResponse)this.response);
        }
        int reversedExcelUnicodeBOM = Util.REVERSED_BOM_FOR_NON_HTML_EXPORT_TO_EXCEL;
        try {
            writer.write(reversedExcelUnicodeBOM);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RelationalExcelXMLExporter xmlExporter = new RelationalExcelXMLExporter();
        xmlExporter.setColumnCount(model.getColumnCount());
        int headersFootersRowCount = 0;
        if (headers != null) {
            headersFootersRowCount += headers.length;
        }
        if (footers != null) {
            headersFootersRowCount += footers.length;
        }
        xmlExporter.setRowCount(model.getRowCount() + headersFootersRowCount);
        RelationalTableModelExporter.writeToStream((TableModel)model, (Writer)writer, (RelationalExportInterface)xmlExporter, (int)startRow, (int)nRows, (boolean)isRawData, (Locale)locale, (int[])columns, (String[])headers, (String[])footers);
        try {
            writer.flush();
            if (closeWriterNeeded) {
                writer.close();
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, null);
        }
        if (model instanceof TrueRowCountCalculatedInterface && nRows == -1) {
            ((TrueRowCountCalculatedInterface)model).setTrueRowCountCalculated(trueRowCalculated);
        }
    }
}

