/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals.model;

import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.components.webapp.visuals.model.DefaultPromptGroupPanelModel;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptPropertiesPanelModelInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.util.ListFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class DefaultPromptPropertiesPanelModel
implements PromptPropertiesPanelModelInterface {
    private PromptValuesInterface _promptValues;
    private DataProviderInterface _dataProvider;
    private PromptGroupPanelModelInterface _rootGroupModel = null;
    private Locale _locale;
    private DynamicPromptValueContext dynamicPromptValueContext;

    public DefaultPromptPropertiesPanelModel(PromptValuesInterface promptValues, Locale locale) {
        this(promptValues, null, locale);
    }

    public DefaultPromptPropertiesPanelModel(PromptValuesInterface promptValues, DataProviderInterface dataProvider, Locale locale) {
        this._promptValues = promptValues;
        this._dataProvider = dataProvider;
        this._locale = locale;
    }

    @Override
    public PromptGroupPanelModelInterface getRootGroupModel() {
        return this._rootGroupModel;
    }

    protected PromptValuesInterface getPromptValues() {
        return this._promptValues;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    public synchronized void initialize() throws Exception {
        PromptGroup rootGroup = new PromptGroup();
        PromptValuesInterface promptValues = this.getPromptValues();
        if (promptValues == null) {
            return;
        }
        Collection rootPvGroups = DefaultPromptPropertiesPanelModel.extractRootGroups(promptValues);
        if (!DefaultPromptPropertiesPanelModel.isEmptyOrNull(rootPvGroups)) {
            for (PromptGroupInterface rpg : rootPvGroups) {
                rootGroup.addPromptSubgroup(rpg);
            }
        }
        PromptGroupInterface pgi = promptValues.getPromptGroup();
        pgi = PromptUtil.rollupAndPrunePromptGroups((PromptValuesInterface)promptValues, (PromptGroupInterface)pgi, (boolean)false);
        this.dynamicPromptValueContext = new DynamicPromptValueContext(promptValues, pgi, this.getPromptValues() != null ? ((PromptValues)promptValues).getPromptUserContext() : null, this._dataProvider);
        DefaultPromptGroupPanelModel rootGroupModel = new DefaultPromptGroupPanelModel(pgi, promptValues, this.getLocale());
        rootGroupModel.setParentModel(this);
        rootGroupModel.setDynamicPromptValueContext(this.getDynamicPromptValueContext());
        rootGroupModel.initialize();
        this._rootGroupModel = rootGroupModel;
        this.calculatePromptViewDependencies(this._rootGroupModel);
        this.setDynamicPromptValueContext(this._rootGroupModel);
    }

    private void setDynamicPromptValueContext(PromptGroupPanelModelInterface panelModel) {
        List groups = panelModel.getSubGroupModels();
        List components = panelModel.getPromptComponentModels();
        DynamicPromptValueContextInterface context = this.getDynamicPromptValueContext();
        for (PromptComponentModelInterface component : components) {
            Collection depCollections = this.findDependencies(component, panelModel);
            if (!(context instanceof DynamicPromptValueContext)) continue;
            ((DynamicPromptValueContext)context).add((PromptViewInterface)component, depCollections);
        }
        for (PromptGroupPanelModelInterface group : groups) {
            this.setDynamicPromptValueContext(group);
        }
    }

    private Collection findDependencies(PromptComponentModelInterface panelModel, PromptGroupPanelModelInterface groupPanelModel) {
        PromptDefinitionInterface promptDefinition = panelModel.getPromptDefinition();
        ArrayList dependentPromptViews = new ArrayList();
        List l = null;
        if (promptDefinition instanceof ModalGroupDefinition) {
            l = groupPanelModel.getModalGroups(panelModel);
        }
        Collection c = promptDefinition.getDependentPrompts(this.getLocale(), this.getDynamicPromptValueContext());
        this.findDependeciesRecursive(this.getRootGroupModel(), panelModel, c, l, dependentPromptViews);
        return dependentPromptViews;
    }

    private void findDependeciesRecursive(PromptGroupPanelModelInterface groupModel, PromptComponentModelInterface componentModel, Collection dependentDefinitions, List modalGroups, List dependentPromptViews) {
        List components = groupModel.getPromptComponentModels();
        for (PromptComponentModelInterface component : components) {
            if (!dependentDefinitions.contains(component.getPromptDefinition()) || dependentPromptViews.contains(component)) continue;
            dependentPromptViews.add(component);
        }
        List groups = groupModel.getSubGroupModels();
        for (PromptGroupPanelModelInterface group : groups) {
            this.findDependeciesRecursive(group, componentModel, dependentDefinitions, null, dependentPromptViews);
        }
    }

    private void calculatePromptViewDependencies(PromptGroupPanelModelInterface panelModel) {
        List groups = panelModel.getSubGroupModels();
        List components = panelModel.getPromptComponentModels();
        DynamicPromptValueContextInterface context = this.getDynamicPromptValueContext();
        for (PromptComponentModelInterface component : components) {
            Collection depCollections = this.findDependencies(component, panelModel);
            if (!(context instanceof DynamicPromptValueContext)) continue;
            ((DynamicPromptValueContext)context).add((PromptViewInterface)component, depCollections);
        }
        for (PromptGroupPanelModelInterface group : groups) {
            this.calculatePromptViewDependencies(group);
        }
    }

    protected static Collection extractRootGroups(PromptValuesInterface valueStore) {
        PromptGroupInterface localNodeRootGroup;
        List rval = null;
        List valueStoreDelegates = valueStore.getPromptValuesDelegates();
        if (!DefaultPromptPropertiesPanelModel.isEmptyOrNull(valueStoreDelegates)) {
            rval = DefaultPromptPropertiesPanelModel.nonNullList(rval, valueStoreDelegates.size() + 1);
            for (PromptValuesInterface delegate : valueStoreDelegates) {
                if (delegate.getPromptGroup() == null) continue;
                rval.add(delegate.getPromptGroup());
            }
        }
        if ((localNodeRootGroup = valueStore.getPromptGroup()) != null) {
            rval = DefaultPromptPropertiesPanelModel.nonNullList(rval, 1);
            rval.add(0, localNodeRootGroup);
        }
        return DefaultPromptPropertiesPanelModel.nonNullList(rval, 0);
    }

    protected static boolean isEmptyOrNull(Collection c) {
        return c == null || c.isEmpty();
    }

    protected static List nonNullList(List list, int initialCapacity) {
        return list == null ? ListFactory.newList((int)initialCapacity) : list;
    }

    public DynamicPromptValueContextInterface getDynamicPromptValueContext() {
        return this.dynamicPromptValueContext;
    }

    @Override
    public boolean isAllRequiredPromptsValid() {
        if (this.getPromptValues() != null) {
            return this.getPromptValues().isAllRequiredPromptsValid();
        }
        return false;
    }
}

