/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals.model;

import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.components.webapp.visuals.model.DefaultPromptComponentModel;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptPropertiesPanelModelInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroup;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroup;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.util.ListFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DefaultPromptGroupPanelModel
implements PromptGroupPanelModelInterface {
    PromptPropertiesPanelModelInterface _parentModel;
    private PromptGroupInterface _promptGroup;
    private PromptValuesInterface _promptValues;
    private List _subGroupModels = ListFactory.newList();
    private Map _modalGroupModels = new HashMap();
    private List _promptComponentModels = ListFactory.newList();
    private Locale _locale;
    private String _label;
    private DynamicPromptValueContextInterface dynamicPromptValueContext;
    private boolean hiddenGroup;

    public DefaultPromptGroupPanelModel(PromptGroupInterface promptGroup, PromptValuesInterface promptValues, Locale locale) {
        this._promptGroup = promptGroup;
        this._promptValues = promptValues;
        this.hiddenGroup = promptGroup.isPromptGroupHidden();
        this._locale = locale;
    }

    public PromptGroupInterface getGroup() {
        return this._promptGroup;
    }

    public PromptValuesInterface getValues() {
        return this._promptValues;
    }

    @Override
    public PromptPropertiesPanelModelInterface getEmbeddingPropertiesPanelModel() {
        return this._parentModel;
    }

    protected void setParentModel(PromptPropertiesPanelModelInterface parentModel) {
        this._parentModel = parentModel;
    }

    @Override
    public List getPromptComponentModels() {
        return ListFactory.newList((Collection)this._promptComponentModels);
    }

    @Override
    public List getSubGroupModels() {
        return ListFactory.newList((Collection)this._subGroupModels);
    }

    protected PromptValuesInterface getPromptValues() {
        return this._promptValues;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    protected synchronized void initialize() throws Exception {
        PromptGroupInterface promptGroup = this.getGroup();
        if (promptGroup.isPromptGroupHidden()) {
            return;
        }
        List subGroups = promptGroup.getPromptSubgroups(false);
        if (subGroups == null) {
            subGroups = Collections.EMPTY_LIST;
        }
        List promptDefs = promptGroup.getPromptDefinitions(false);
        List promptComponentModels = ListFactory.newList((int)promptDefs.size());
        List allItems = promptGroup.getPromptDefinitionsAndSubgroups();
        List subGroupModels = ListFactory.newList((int)subGroups.size());
        for (Object obj : allItems) {
            PromptGroupInterface subGroup;
            if (obj instanceof PromptDefinitionInterface && !(obj instanceof ModalGroupDefinition)) {
                PromptComponentModelInterface promptComponentModel = this.newPromptComponentModel((PromptDefinitionInterface)obj);
                promptComponentModels.add(promptComponentModel);
                continue;
            }
            if (obj instanceof ModalGroup) {
                ModalGroupDefinition def = (ModalGroupDefinition)((ModalGroup)obj).getChoiceDefinition();
                PromptComponentModelInterface promptComponentModel = null;
                promptComponentModel = this.newPromptComponentModel(((ModalGroup)obj).getChoiceDefinition());
                promptComponentModels.add(promptComponentModel);
                List modalGroupList = ListFactory.newList((int)def.getModalChoiceGroups((ModalGroupInterface)((ModalGroup)obj)).size());
                modalGroupList = def.getModalChoiceGroups((ModalGroupInterface)((ModalGroup)obj));
                List modalGroupPanelModelList = ListFactory.newList((int)def.getModalChoiceGroups((ModalGroupInterface)((ModalGroup)obj)).size());
                for (PromptGroupInterface subGroup2 : modalGroupList) {
                    PromptGroupPanelModelInterface groupModel = this.newSubGroupModel(subGroup2);
                    modalGroupPanelModelList.add(groupModel);
                    subGroupModels.add(groupModel);
                }
                if (promptComponentModel == null) continue;
                this._modalGroupModels.put(promptComponentModel, modalGroupPanelModelList);
                continue;
            }
            if (!(obj instanceof PromptGroupInterface) || obj instanceof ModalChoiceGroupInterface || !((subGroup = (PromptGroupInterface)obj) instanceof TransparentGroupInterface)) continue;
            List allSubGroups = subGroup.getPromptDefinitionsAndSubgroups();
            for (Object obj2 : allSubGroups) {
                if (!(obj2 instanceof PromptDefinitionInterface) || obj2 instanceof ModalGroupDefinition) continue;
                PromptComponentModelInterface promptComponentModel = this.newPromptComponentModel((PromptDefinitionInterface)obj2);
                promptComponentModels.add(promptComponentModel);
            }
        }
        if (promptDefs == null) {
            promptDefs = Collections.EMPTY_LIST;
        }
        for (PromptGroupInterface subGroup : subGroups) {
            if (subGroup instanceof TransparentGroupInterface) continue;
            PromptGroupPanelModelInterface groupModel = this.newSubGroupModel(subGroup);
            subGroupModels.add(groupModel);
        }
        this._subGroupModels.clear();
        this._subGroupModels.addAll(subGroupModels);
        this._promptComponentModels.clear();
        this._promptComponentModels.addAll(promptComponentModels);
        this._label = promptGroup.getPromptGroupLabel(this._locale);
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    protected PromptComponentModelInterface newPromptComponentModel(PromptDefinitionInterface promptDefinition) throws Exception {
        DefaultPromptComponentModel promptComponentModel = new DefaultPromptComponentModel(promptDefinition, this.getPromptValues(), this.getLocale());
        promptComponentModel.setDynamicPromptValuesContext(this.getDynamicPromptValueContext());
        promptComponentModel.initialize();
        return promptComponentModel;
    }

    protected PromptGroupPanelModelInterface newSubGroupModel(PromptGroupInterface subGroup) throws Exception {
        DefaultPromptGroupPanelModel groupModel = new DefaultPromptGroupPanelModel(subGroup, this.getPromptValues(), this.getLocale());
        groupModel.setParentModel(this.getEmbeddingPropertiesPanelModel());
        groupModel.setDynamicPromptValueContext(this.getDynamicPromptValueContext());
        groupModel.initialize();
        return groupModel;
    }

    @Override
    public boolean isModalChoiceGroup() {
        return this._promptGroup instanceof ModalChoiceGroup;
    }

    @Override
    public boolean isTransparentGroup() {
        return this._promptGroup instanceof TransparentGroupInterface;
    }

    @Override
    public boolean isModalGroup() {
        return this._promptGroup instanceof ModalGroup;
    }

    @Override
    public String getModalChoiceGroupValue() {
        if (this._promptGroup instanceof ModalChoiceGroup) {
            return ((ModalChoiceGroup)this._promptGroup).getValue();
        }
        return null;
    }

    @Override
    public List getModalGroups(PromptComponentModelInterface promptComponent) {
        if (this._modalGroupModels.size() > 0) {
            return (List)this._modalGroupModels.get(promptComponent);
        }
        return null;
    }

    @Override
    public boolean isGroupLabelVisible() {
        return !this.isTransparentGroup() && !this.getPromptComponentModels().isEmpty();
    }

    @Override
    public boolean isResetToDefaultsOptionVisible() {
        return !this.isTransparentGroup() && !this.getPromptComponentModels().isEmpty();
    }

    public int getNumberOfRequiredPromptDefinitions() {
        PromptValuesInterface pv = this.getPromptValues();
        if (pv != null) {
            int emptyRequiredCount = 0;
            List definitions = this.getPromptComponentModels();
            for (PromptComponentModelInterface promptComponent : definitions) {
                PromptDefinitionInterface prompt = promptComponent.getPromptDefinition();
                if (!prompt.isRequired() || pv.isPromptValueAvailable(prompt)) continue;
                ++emptyRequiredCount;
            }
            return emptyRequiredCount;
        }
        return 0;
    }

    public PromptGroupInterface findPromptSubgroup(PromptDefinitionInterface definition) {
        if (this._promptGroup == null) {
            return null;
        }
        return this._promptGroup.findPromptSubgroup(definition);
    }

    public DynamicPromptValueContextInterface getDynamicPromptValueContext() {
        return this.dynamicPromptValueContext;
    }

    public void setDynamicPromptValueContext(DynamicPromptValueContextInterface dynamicPromptValueContext) {
        this.dynamicPromptValueContext = dynamicPromptValueContext;
    }

    @Override
    public boolean isHiddenGroup() {
        return this.hiddenGroup;
    }
}

