/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals.model;

import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.valueprovider.olap.MemberValueProvider;
import com.sas.util.ListFactory;
import com.sas.util.ValueItem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeModel;

public class DefaultPromptComponentModel
implements PromptComponentModelInterface {
    private PromptDefinitionInterface _promptDefinition;
    private PromptValuesInterface _persistentValueStore;
    private List _selectionItemsAsList = null;
    private TreeModel _selectionItemsAsTree = null;
    private Collection _promptViewFilterList;
    private Locale _locale;
    private DynamicPromptValueContextInterface _dynamicValueContext;

    public DefaultPromptComponentModel(PromptDefinitionInterface prompt, PromptValuesInterface persistentValueStore, Locale locale) {
        this(prompt, persistentValueStore, null, locale);
    }

    public DefaultPromptComponentModel(PromptDefinitionInterface prompt, PromptValuesInterface persistentValueStore, DynamicPromptValueContextInterface dynamicValueContext, Locale locale) {
        this._promptDefinition = prompt;
        this._persistentValueStore = persistentValueStore;
        this._locale = locale;
        this._dynamicValueContext = dynamicValueContext;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    protected void initialize() throws Exception {
    }

    List getStaticSelectionChoicesAsList() {
        try {
            List choices = null;
            PromptDefinitionInterface prompt = this.getPromptDefinition();
            if (prompt instanceof ValueProviderDefinitionInterface) {
                ValueProviderDefinitionInterface valueProviderPrompt = (ValueProviderDefinitionInterface)this.getPromptDefinition();
                choices = (List)valueProviderPrompt.getValueProvider().getValues(this.getLocale());
            }
            if (choices == null) {
                choices = ListFactory.newList((int)0);
            }
            return choices;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            return ListFactory.newList((int)0);
        }
    }

    protected Object getPersistentValue() {
        try {
            PromptValuesInterface pv = this.getPromptValues();
            if (pv == null) {
                return null;
            }
            if (pv.isPromptValueAvailable(this.getPromptDefinition())) {
                return pv.getPromptValue(this.getPromptDefinition());
            }
            return null;
        }
        catch (PromptValueNotFoundException pe) {
            return null;
        }
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        return this._persistentValueStore;
    }

    public PromptDefinitionInterface getPromptDefinition() {
        return this._promptDefinition;
    }

    @Override
    public void commitValue() throws Exception {
    }

    public Object getPromptValue() {
        try {
            if (this.getPromptValues().isPromptValueAvailable(this.getPromptDefinition())) {
                return this.getPromptValues().getPromptValue(this.getPromptDefinition());
            }
        }
        catch (PromptValueNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        if (this.getPromptDefinition().isDefaultValueSet()) {
            return this.getPromptDefinition().getDefaultValue();
        }
        return null;
    }

    @Override
    public ValueItem[] getSelectionChoices() {
        if (this._selectionItemsAsList != null) {
            return this._selectionItemsAsList.toArray(new ValueItem[this._selectionItemsAsList.size()]);
        }
        return null;
    }

    @Override
    public TreeModel getSelectionChoicesAsTree() {
        return this._selectionItemsAsTree;
    }

    @Override
    public boolean isChoicePrompt() {
        PromptDefinitionInterface promptDef = this.getPromptDefinition();
        if (promptDef instanceof ValueProviderDefinitionInterface) {
            ValueProviderDefinitionInterface sPrompt = (ValueProviderDefinitionInterface)promptDef;
            return sPrompt.getValueProvider() != null;
        }
        return false;
    }

    @Override
    public boolean isDynamicChoicePrompt() {
        PromptDefinitionInterface promptDef = this.getPromptDefinition();
        if (promptDef instanceof ValueProviderDefinitionInterface) {
            ValueProviderDefinitionInterface sPrompt = (ValueProviderDefinitionInterface)promptDef;
            return sPrompt.getValueProvider() instanceof DynamicValueProviderInterface;
        }
        return false;
    }

    @Override
    public synchronized void loadDynamicChoices() throws Exception {
        if (!this.isDynamicChoicePrompt()) {
            return;
        }
        try {
            ValueProviderDefinitionInterface valueProviderPrompt = (ValueProviderDefinitionInterface)this.getPromptDefinition();
            ValueProviderInterface valueProvider = valueProviderPrompt.getValueProvider();
            if (valueProvider instanceof DynamicValueProviderInterface) {
                DynamicValueProviderInterface dvp = (DynamicValueProviderInterface)valueProvider;
                if (this.isDynamicTreeValueProvider(dvp)) {
                    TreeModel selectionTree;
                    this._selectionItemsAsTree = selectionTree = (TreeModel)dvp.getValues(this.getLocale(), ValueType.TREE);
                } else {
                    List choiceList = (List)dvp.getValues(this.getLocale(), ValueType.LIST);
                    if (choiceList == null) {
                        choiceList = ListFactory.newList((int)0);
                    }
                    this._selectionItemsAsList = choiceList;
                }
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw e;
        }
    }

    boolean isDynamicTreeValueProvider(DynamicValueProviderInterface valueProvider) {
        return valueProvider instanceof OLAPDataItemValueProvider || valueProvider instanceof MemberValueProvider;
    }

    @Override
    public void resetToDefaultValues() throws InvalidPromptValueException {
        PromptDefinitionInterface promptDef = this.getPromptDefinition();
        this.getPromptValues().clearPromptValue(promptDef);
    }

    @Override
    public void setPromptValue(Object value) throws InvalidPromptValueException {
        this.getPromptValues().setPromptValue(this.getPromptDefinition(), this.validatePromptValue(value), this.getLocale());
    }

    @Override
    public void validateValue() throws Exception {
        if (!this.getPromptDefinition().isPromptValueValid(this.getPromptValue())) {
            // empty if block
        }
    }

    private Object validatePromptValue(Object value) throws InvalidPromptValueException {
        if (value == "UNSET") {
            return value;
        }
        Object coercedValue = this.getPromptDefinition().getPromptDataType().coerceValue(value, this.getLocale());
        Collection errors = this.getPromptDefinition().getPromptValueValidationErrors(coercedValue, this.getLocale());
        if (errors != null && errors.size() > 0) {
            throw new InvalidPromptValueException(this.getPromptDefinition(), (Object)this.getPromptDefinition().getPromptDataType().getDisplayString(coercedValue, this.getLocale()), this.getLocale(), errors);
        }
        return coercedValue;
    }

    @Override
    public String getPromptValueAsString() {
        if (this.getPromptValues() != null && this.getPromptValues().isPromptValueSet(this.getPromptDefinition())) {
            try {
                return this.getPromptValues().getPromptValueAsString(this.getPromptDefinition(), this.getLocale());
            }
            catch (PromptValueNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public DynamicPromptValueContextInterface getDynamicPromptValuesContext() {
        return this._dynamicValueContext;
    }

    public void setDynamicPromptValuesContext(DynamicPromptValueContextInterface context) {
        this._dynamicValueContext = context;
    }

    @Override
    public List getPromptDefinitionCombinations() {
        if (this.getPromptValues() != null) {
            return this.getPromptValues().getPromptDefinitionCombinations(this.getPromptDefinition());
        }
        return null;
    }

    public Collection getPromptViewFilterExpressions() {
        if (this._promptViewFilterList == null) {
            this._promptViewFilterList = ListFactory.newList((int)0);
        }
        return this._promptViewFilterList;
    }

    public void setPromptViewFilterList(Collection filterList) {
        this._promptViewFilterList = filterList;
    }
}

