/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.actionprovider.ActionList;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.components.webapp.util.RB;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.ValueListEditor;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.CellContentsLabelRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.html.TableViewComposite;
import com.sas.servlet.tbeans.valuepicker.TargetValueListEditor;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.tbeans.valuepicker.ValuePickerTableCellRenderer;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.DoubleTypeToDisplayStringTransform;
import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public class PromptValuePicker
extends ValuePicker {
    private static final long serialVersionUID = 1L;
    public static final String VALUEPICKER_APPLY_BUTTON = "VALUEPICKER_APPLY_BUTTON";
    private Button applyButton;
    private TargetValueListEditor vle;
    public static final String PROMPT_RB_KEY = "PromptDefinitionComponentFactory.";
    private int pageSize;
    private boolean applyButtonVisible;
    protected int minimumDecimalPlaces = -1;

    public PromptValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, Locale locale) {
        super(valueProvider, displayMode, selectionMode, null, false, null, null, null);
    }

    public PromptValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, TransformationInterface editor, boolean editable, SupportedSpecialValues specialValues, DataTypeInterface dataType, int pageSize, DataProviderInterface dataProvider) {
        super(valueProvider, displayMode, selectionMode, editor, editable, specialValues, dataType, dataProvider);
        this.pageSize = pageSize;
        this.setApplyButtonVisible(true);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    protected TargetValueListEditor getDefaultValueListEditor() {
        this.vle = super.getDefaultValueListEditor();
        Button btn = (Button)this.vle.getPredefinedButton(ValueListEditor.BUTTON_DELETE);
        if (btn != null) {
            btn.setButtonType(3);
            btn.getStyleMap().put("BUTTON_STYLE", new StyleInfo("button"));
        }
        if ((btn = (Button)this.vle.getPredefinedButton(ValueListEditor.BUTTON_MOVE_DOWN)) != null) {
            btn.setButtonType(3);
            btn.getStyleMap().put("BUTTON_STYLE", new StyleInfo("button"));
        }
        if ((btn = (Button)this.vle.getPredefinedButton(ValueListEditor.BUTTON_MOVE_UP)) != null) {
            btn.setButtonType(3);
            btn.getStyleMap().put("BUTTON_STYLE", new StyleInfo("button"));
        }
        if (this.getSelectionMode() == 301 || this.getSelectionMode() == 302) {
            this.applyButton = new Button();
            this.applyButton.setId(this.getId() + "_applyButton");
            this.applyButton.setEnabled(true);
            this.vle.setComponent(VALUEPICKER_APPLY_BUTTON, this.applyButton);
        }
        return this.vle;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.applyButton != null) {
            if (!this.isApplyButtonVisible()) {
                this.applyButton.setVisible(false);
            } else {
                this.applyButton.setId(this.getId() + "_applyButton");
                this.applyButton.setOnClick(this.getId() + "_Obj.apply();");
            }
            this.applyButton.setLabel(RB.getStringResource(PROMPT_RB_KEY, "apply.txt", this.getLocale()));
            if (this.vle != null) {
                this.vle.setOnUpdate(this.getId() + "_Obj.valueUpdated();");
            }
        }
        super.write(out);
    }

    public void setMinimumDecimalPlaces(int minDecPlaces) {
        this.minimumDecimalPlaces = minDecPlaces;
    }

    public int getMinimumDecimalPlaces() {
        return this.minimumDecimalPlaces;
    }

    private TableCellRenderer getTableCellRenderer(ValueProviderInterface valueProvider, Locale locale) {
        DefaultTableCellRenderer renderer = null;
        try {
            DataTypeInterface dataType = valueProvider.getDataType();
            CellContentsLabelRenderer contentsRenderer = new CellContentsLabelRenderer();
            Object transform = null;
            transform = this.minimumDecimalPlaces > 0 && dataType instanceof DoubleType ? new DoubleTypeToDisplayStringTransform((DoubleType)dataType, locale, this.minimumDecimalPlaces) : new DataTypeToDisplayStringTransform(dataType, locale);
            contentsRenderer.setInputTransform((TransformInterface)transform);
            if (valueProvider.isValueDisplayed()) {
                renderer = new ValueItemAwareCellRenderer(contentsRenderer);
            } else {
                renderer = new ValuePickerTableCellRenderer(dataType);
                renderer.setTableCellContentsRenderer(contentsRenderer);
            }
        }
        catch (ValueProviderException valueProviderException) {
            // empty catch block
        }
        return renderer;
    }

    @Override
    public void addSourceComponent(ValueProviderInterface valueProvider, Locale locale) {
        super.addSourceComponent(valueProvider, locale);
        if (valueProvider != null) {
            try {
                TransformationInterface comp = this.getSourceComponent();
                if (comp instanceof TableViewComposite) {
                    TargetValueListEditor target;
                    TableCellRenderer renderer = this.getTableCellRenderer(valueProvider, locale);
                    TableView tv = (TableView)((TableViewComposite)comp).getComponent("TABLEVIEW_TABLEDATA");
                    if (tv != null) {
                        tv.setDefaultRenderer(renderer);
                    }
                    if ((target = (TargetValueListEditor)this.getComponent(VALUEPICKER_TARGET_COMPONENT)) != null && (tv = (TableView)target.getComponent("ITEMLISTMANAGER_TABLE")) != null) {
                        tv.setDefaultRenderer(renderer);
                    }
                } else if (comp instanceof ComboBoxView) {
                    ComboBoxView cbv = (ComboBoxView)comp;
                    DataTypeInterface dataType = valueProvider.getDataType();
                    if (this.minimumDecimalPlaces > 0 && dataType instanceof DoubleType) {
                        cbv.setLabelTransform((TransformInterface)new DoubleTypeToDisplayStringTransform((DoubleType)dataType, this.getLocale(), this.minimumDecimalPlaces));
                    }
                } else if (comp instanceof ChoiceBox) {
                    ChoiceBox cbv = (ChoiceBox)comp;
                    DataTypeInterface dataType = valueProvider.getDataType();
                    if (this.minimumDecimalPlaces > 0 && dataType instanceof DoubleType) {
                        cbv.setLabelTransform((TransformInterface)new DoubleTypeToDisplayStringTransform((DoubleType)dataType, this.getLocale(), this.minimumDecimalPlaces));
                    }
                }
            }
            catch (ValueProviderException valueProviderException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isApplyButtonVisible() {
        return this.applyButtonVisible;
    }

    public void setApplyButtonVisible(boolean applyButtonVisible) {
        this.applyButtonVisible = applyButtonVisible;
    }

    private class ValueItemAwareCellRenderer
    extends DefaultTableCellRenderer {
        public ValueItemAwareCellRenderer(TableCellContentsRenderer cRenderer) {
            super(cRenderer);
        }

        @Override
        public void write(PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
            if (this.isValueItemSeparator(value)) {
                this.writeSeparatorHtml(out, tableview);
                return;
            }
            ResizingUtil.writeBeginCell(out, tableview, this);
            TableCellContentsRenderer contentsRenderer = this.getTableCellContentsRenderer();
            contentsRenderer.setRequest(tableview.getRequest());
            contentsRenderer.setResponse(tableview.getResponse());
            contentsRenderer.setLocale(this.getLocale());
            TransformationInterface tbean = value instanceof ValueItem ? new Label(((ValueItem)value).getLabel(this.getLocale())) : contentsRenderer.getCellContentsRendererComponent(tableview, value, actions);
            tbean.write(out);
            this.writeEndCell(out);
        }

        private boolean isValueItemSeparator(Object input) {
            return input != null && input.equals(ValueProviderModelAdapter.SEPARATOR) || input.equals("-SEPARATOR-");
        }

        private void writeSeparatorHtml(PrintWriter out, AbstractBaseTableView table) {
            StyleInfo separatorStyleInfo = (StyleInfo)table.getParentComposite().getParentComposite().getStyleMap().get(ValuePicker.VALUEPICKER_SEPARATOR_STYLE);
            String styleInfoString = separatorStyleInfo == null ? "class='valuePickerSeparator'" : separatorStyleInfo.write(new StringBuffer(), null).toString();
            out.print("<td><div" + styleInfoString + "></div></td>");
        }
    }
}

