/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.visuals;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.components.webapp.util.PromptComponentFactoryInterface;
import com.sas.prompts.components.webapp.util.PromptGroupPanelFactory;
import com.sas.prompts.components.webapp.util.PromptGroupPanelFactoryInterface;
import com.sas.prompts.components.webapp.util.Util;
import com.sas.prompts.components.webapp.visuals.PromptComponent;
import com.sas.prompts.components.webapp.visuals.PromptGroupList;
import com.sas.prompts.components.webapp.visuals.PromptGroupPanel;
import com.sas.prompts.components.webapp.visuals.PromptJavaScriptNode;
import com.sas.prompts.components.webapp.visuals.RB;
import com.sas.prompts.components.webapp.visuals.model.DefaultPromptComponentModel;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptPropertiesPanelModelInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceColumnItemListManager;
import com.sas.servlet.tbeans.datasource.DataSourceColumnPicker;
import com.sas.servlet.tbeans.datasource.DataSourcePicker;
import com.sas.servlet.tbeans.datasource.DataSourceValidationException;
import com.sas.servlet.tbeans.datasource.DataSourceValidationInterface;
import com.sas.servlet.tbeans.form.BasePushButton;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.html.AjaxTreeView;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Image;
import com.sas.servlet.tbeans.html.ValueListEditor;
import com.sas.servlet.tbeans.models.TreeNode;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.servlet.util.MethodInvocationServlet;
import com.sas.text.Message;
import com.sas.util.ListFactory;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.table.TableModel;

public class PromptPropertiesPanel
extends BaseCompositeTransformation
implements AJAXControllerURLInterface {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "PromptPropertiesPanel.";
    public static final String RB_KEY2 = "BasePromptVisualEditor.";
    private static final String PROMPT_PROPERTY_ID = "promptPropertyId";
    private static final String AJAX_ACTION = "ajaxAction";
    private Form formObject;
    private String AJAXControllerURL;
    private TransformationInterface commitButton;
    private String[] protectionIds;
    private String protectPageFunctionName;
    private boolean defaultPageProtectionEnabled;
    private boolean applyOnFocus;
    private PromptGroupPanelModelInterface activeGroupModel;
    private boolean applyButtonVisible;
    private boolean autoSize;
    private int numberOfListValuesDisplayed = 100;
    public static final String PROMPT_VALUE_REQUEST_PARM = "sas_promptValue";
    public static final String PROMPT_NAME_REQUEST_PARM = "sas_promptName";
    public static final String GROUPS_LIST_PANEL = "GROUPS_LIST_PANEL";
    public static final String REQUIRED_CHECKBOX = "REQUIRED_CHECKBOX";
    public static final String GROUP_PANEL = "GROUP_PANEL";
    public static final String GROUP_PANEL_HOLDER = "GROUP_PANEL_HOLDER";
    public static final String MESSAGE_BOX = "MESSAGE_BOX";
    public static final String EXPAND_COLLAPSE_BAR = "EXPAND_COLLAPSE_BAR";
    public static final String PROMPTPROPERTIESPANEL_CONTAINER_STYLE = "PROMPTPROPERTIESPANEL_CONTAINER_STYLE";
    public static final String PROMPTPROPERTIESPANEL_GROUPS_CONTAINER_STYLE = "PROMPTPROPERTIESPANEL_GROUPS_CONTAINER_STYLE";
    public static final String PROMPTPROPERTIESPANEL_GROUP_LIST_CONTAINER_STYLE = "PROMPTPROPERTIESPANEL_GROUP_LIST_CONTAINER_STYLE";
    public static final String PROMPTPROPERTIESPANEL_EXPAND_BAR_STYLE = "PROMPTPROPERTIESPANEL_EXPAND_BAR_STYLE";
    public static final String PROMPTPROPERTIESPANEL_REQUIRED_GROUP_STYLE = "PROMPTPROPERTIESPANEL_REQUIRED_GROUP_STYLE";
    public static final String PROMPTPROPERTIESPANEL_NUMBER_OF_REQUIRED_GROUP_STYLE = "PROMPTPROPERTIESPANEL_NUMBER_OF_REQUIRED_GROUP_STYLE";
    private static final String GROUP_PANEL_ID_KEY = "GROUP_PANEL_ID";
    private static final String DEFAULT_AJAX_CONTROLLER_URL = "/MethodInvocationServlet";
    private static final String BASE_AJAX_URL = "BASE_AJAX_URL";
    private static final String AJAX_URL_SUFFIX = "AJAX_URL_SUFFIX";
    private static final String EXPAND_COLLAPSE_COLUMN = "EXPAND_COLLAPSE_COLUMN";
    public static final String DEFAULT_AJAX_URL_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + PromptPropertiesPanel.class.getName() + "&" + "METHOD" + "=processRequest&" + "promptPropertyId" + "=%" + "promptPropertyId";
    private PromptGroupPanel groupPanel;
    private CheckBox requiredPromptCheckBox;
    private Image expandCollapseBar;
    private PromptGroupList groupList;
    private Map promptGroupPanels;
    private PromptPropertiesPanelModelInterface _panelModel;
    private String imageLocation;
    private Map groupsList;
    private List allGroupsList;
    private boolean showRootGroup;
    private boolean showInvalidDependentPrompts;
    private boolean honor24HourLocale;
    private String defaultGroupName;
    private PromptComponentFactoryInterface promptComponentFactory;
    private PromptGroupPanelFactoryInterface promptGroupPanelFactory;
    private SimpleTemplate ajaxURLTemplate;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(PROMPTPROPERTIESPANEL_CONTAINER_STYLE, new ImmutableStyleInfo("promptPropertiesPanelContainer"));
            defaultStyleMap.put(PROMPTPROPERTIESPANEL_GROUPS_CONTAINER_STYLE, new ImmutableStyleInfo("promptGroupsContainer"));
            defaultStyleMap.put(PROMPTPROPERTIESPANEL_GROUP_LIST_CONTAINER_STYLE, new ImmutableStyleInfo("promptGroupListContainer"));
            defaultStyleMap.put(PROMPTPROPERTIESPANEL_EXPAND_BAR_STYLE, new ImmutableStyleInfo("promptGroupListExpandBar"));
            defaultStyleMap.put(PROMPTPROPERTIESPANEL_REQUIRED_GROUP_STYLE, new ImmutableStyleInfo("promptRequiredGroupNodeText"));
            defaultStyleMap.put(PROMPTPROPERTIESPANEL_NUMBER_OF_REQUIRED_GROUP_STYLE, new ImmutableStyleInfo("promptRequiredGroupRequiredNumberText"));
        }
    }

    public PromptPropertiesPanel(PromptPropertiesPanelModelInterface panelModel) {
        this.setId(com.sas.util.Util.getName((String)"promptProperties"));
        this.setTemplateDictionary(new HashMap());
        this.setTemplateKey("Prompt_Properties_Panel");
        this._panelModel = panelModel;
        this.promptGroupPanels = new HashMap();
        this.groupsList = new HashMap();
        this.allGroupsList = new ArrayList();
        this.autoSize = false;
        this.setShowInvalidDependentPrompts(true);
        this.setDefaultPageProtectionEnabled(true);
        this.setApplyOnFocus(false);
        this.setApplyButtonVisible(true);
        this.setShowRootGroup(false);
        this.setHonor24HourLocale(true);
        if (this.isGroupListVisible(panelModel)) {
            this.groupList = new PromptGroupList(panelModel.getRootGroupModel(), this);
            this.groupList.setId(this.getId() + "_groupList");
            this.setComponent(GROUPS_LIST_PANEL, this.groupList);
        }
        this.expandCollapseBar = new Image();
        this.expandCollapseBar.setId(this.getId() + "_expandCollapseImage");
        this.setComponent(EXPAND_COLLAPSE_BAR, this.expandCollapseBar);
        if (Util.isRequiredPromptPresent(panelModel)) {
            this.requiredPromptCheckBox = new CheckBox();
            this.requiredPromptCheckBox.setRequest(this.getRequest());
            this.requiredPromptCheckBox.setId(this.getId() + "_requiredCheckBox");
            this.setComponent(REQUIRED_CHECKBOX, this.requiredPromptCheckBox);
        }
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(DEFAULT_AJAX_URL_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
        this.setLocale(panelModel.getLocale());
        PromptPropertiesPanel.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.defaultGroupName = Util.getValidGroupName(panelModel.getRootGroupModel());
    }

    private boolean isGroupListVisible(PromptPropertiesPanelModelInterface panelModel) {
        if (panelModel.getRootGroupModel() == null) {
            return false;
        }
        if (panelModel.getRootGroupModel().getSubGroupModels().isEmpty()) {
            return false;
        }
        if (panelModel.getRootGroupModel().getSubGroupModels() != null) {
            List groups = panelModel.getRootGroupModel().getSubGroupModels();
            boolean transparentGroup = false;
            for (PromptGroupPanelModelInterface group : groups) {
                if (group.isTransparentGroup()) {
                    transparentGroup = true;
                    continue;
                }
                return true;
            }
            return !transparentGroup;
        }
        return true;
    }

    public PromptPropertiesPanelModelInterface getPanelModel() {
        return this._panelModel;
    }

    public Map getPromptGroupPanels() {
        return this.promptGroupPanels;
    }

    public PromptGroupPanelModelInterface getPromptGroupModel(String groupId) {
        Map panels = this.getPromptGroupPanels();
        Iterator itr = panels.keySet().iterator();
        while (itr.hasNext()) {
            PromptGroupPanel panel = (PromptGroupPanel)panels.get(itr.next());
            if (!panel.getId().equals(groupId)) continue;
            return panel.getPanelModel();
        }
        return null;
    }

    private PromptGroupPanel addPromptGroupPanelForGroup(PromptGroupPanelModelInterface groupModel, boolean modal) {
        PromptGroupPanel promptGroupPanel;
        if (this.promptGroupPanels.containsKey(groupModel)) {
            promptGroupPanel = (PromptGroupPanel)this.promptGroupPanels.get(groupModel);
            promptGroupPanel.resetContent();
        } else {
            promptGroupPanel = this.getPromptGroupPanelFactory().createGroupPanel(groupModel, this);
            this.promptGroupPanels.put(groupModel, promptGroupPanel);
        }
        promptGroupPanel.setModal(modal);
        return promptGroupPanel;
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        if (this.requiredPromptCheckBox != null) {
            this.requiredPromptCheckBox.setText(RB.getStringResource(RB_KEY, "showRequired.txt", currentLocale));
        }
    }

    private boolean isTransparent(PromptGroupPanelModelInterface groupModel) {
        if (groupModel != null) {
            List groups = groupModel.getSubGroupModels();
            if (groups.isEmpty()) {
                return groupModel.isTransparentGroup();
            }
            boolean allTransparent = true;
            for (PromptGroupPanelModelInterface group : groups) {
                if (group.isTransparentGroup()) continue;
                allTransparent = false;
            }
            return allTransparent;
        }
        return true;
    }

    protected void addComponents() {
        if (this.groupList != null) {
            this.groupList.setRequest(this.getRequest());
        }
        PromptGroupPanelModelInterface groupModel = this.getPanelModel().getRootGroupModel();
        this.activeGroupModel = this.getPanelModel().getRootGroupModel();
        if (!this.isShowRootGroup() && this.activeGroupModel != null && !this.isTransparent(this.activeGroupModel) && this.activeGroupModel.getPromptComponentModels().isEmpty() && !this.activeGroupModel.getSubGroupModels().isEmpty()) {
            this.activeGroupModel = (PromptGroupPanelModelInterface)this.activeGroupModel.getSubGroupModels().get(0);
        }
        this.groupPanel = (PromptGroupPanel)this.getComponent(GROUP_PANEL);
        if (this.activeGroupModel != null && this.groupPanel == null && this.promptGroupPanels.get(this.groupPanel) == null) {
            this.groupPanel = this.getPromptGroupPanelFactory().createGroupPanel(this.activeGroupModel, this);
            this.promptGroupPanels.put(this.activeGroupModel, this.groupPanel);
        }
        if (this.requiredPromptCheckBox != null) {
            this.requiredPromptCheckBox.setOnClick(this.getId() + "_Obj.showRequired(this)");
        }
        List groupsWritten = ListFactory.newList();
        List activeGroups = this.activeGroupModel.getSubGroupModels();
        for (PromptGroupPanelModelInterface group : activeGroups) {
            if (group.isModalChoiceGroup() || group.isModalGroup()) continue;
            groupsWritten.add(group);
        }
        if (this.allGroupsList.size() == 0) {
            this.allGroups(groupModel.getSubGroupModels(), groupsWritten);
        }
        StringBuffer groupContainers = new StringBuffer();
        if (this.allGroupsList.size() > 1) {
            for (int i = 1; i < this.allGroupsList.size(); ++i) {
                PromptGroupPanelModelInterface item = (PromptGroupPanelModelInterface)this.allGroupsList.get(i);
                if (item == groupModel || item.isModalChoiceGroup() || item.isModalGroup()) continue;
                groupContainers.append("<div id=\"").append(this.getId()).append("_").append(Util.getValidGroupName(item)).append("_container\" style=\"display:none;\"> " + item.getLabel() + "</div>\n");
            }
        }
        HashMap dict = this.getTemplateDictionary();
        dict.put(GROUP_PANEL_HOLDER, groupContainers.toString());
        this.setTemplateDictionary(dict);
    }

    private void allGroups(List groups, List ignoreGroups) {
        if (groups != null) {
            for (PromptGroupPanelModelInterface group : groups) {
                if (this.allGroupsList.contains(group) || ignoreGroups.contains(group)) continue;
                this.allGroupsList.add(group);
                if (group.equals(this.activeGroupModel)) continue;
                this.allGroups(group.getSubGroupModels(), ignoreGroups);
            }
        }
    }

    private void updateImages() {
        if (this.expandCollapseBar != null) {
            this.expandCollapseBar.setImageKey("Collapse_Left");
            this.expandCollapseBar.setImageLocation(this.imageLocation);
            this.expandCollapseBar.setOnClick(this.getId() + "_Obj.navToggle();");
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        try {
            TransformationInterface button;
            if (this.getPanelModel().getRootGroupModel() == null) {
                return;
            }
            if (this.promptGroupPanels.isEmpty()) {
                this.addComponents();
            }
            if ((button = this.getCommitButton()) != null && !this.getPanelModel().isAllRequiredPromptsValid()) {
                if (button instanceof Button) {
                    ((Button)button).setEnabled(false);
                } else {
                    ((BasePushButton)button).setEnabled(false);
                }
            }
            HttpServletRequest request = this.getRequest();
            JavaScriptIncludeHandler.writeIncludes(out, "PROMPTPROPERTIESPANEL", request);
            this.groupPanel.setRequest(request);
            this.groupPanel.setResponse(this.getResponse());
            this.setComponent(GROUP_PANEL, this.groupPanel);
            this.updateImages();
            if (this.isDefaultPageProtectionEnabled()) {
                this.writeFastClickProtection(out);
            }
            PromptGroupPanel promptGroupPanel = (PromptGroupPanel)this.getComponent(GROUP_PANEL);
            CheckBox cb = (CheckBox)this.getComponent(REQUIRED_CHECKBOX);
            if (cb != null) {
                if (promptGroupPanel.isShowOnlyRequired()) {
                    cb.setSelected(true);
                } else {
                    cb.setSelected(false);
                }
            }
            this.groupList = (PromptGroupList)this.getComponent(GROUPS_LIST_PANEL);
            if (this.groupList != null) {
                this.groupList.setShowRootGroup(this.isShowRootGroup());
            }
            this.getTemplateDictionary().put(GROUP_PANEL_ID_KEY, this.getId() + "_group_panel");
            this.getTemplateDictionary().put(EXPAND_COLLAPSE_COLUMN, this.getId() + "_navcolumn");
            this.getTemplateDictionary().put("PANEL_CONTAINER", this.getId() + "_container");
            TemplateSupport.writeTemplate(this, null, out);
            this.writeJavaScript(out);
            this.cleanUpResources();
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeJavaScript(PrintWriter out) {
        StringBuffer sb = new StringBuffer();
        sb.append(JavaScriptIncludeHandler.getStartScript());
        String scriptId = this.getId() + "_Obj";
        this.getAjaxURLTemplate().getValueDictionary().put(BASE_AJAX_URL, this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            this.getAjaxURLTemplate().getValueDictionary().put(AJAX_URL_SUFFIX, "?");
        } else {
            this.getAjaxURLTemplate().getValueDictionary().put(AJAX_URL_SUFFIX, "&");
        }
        this.getAjaxURLTemplate().getValueDictionary().put(PROMPT_PROPERTY_ID, this.getId());
        StringBuffer parm = new StringBuffer().append("[");
        StringBuffer s = null;
        if (this.showRootGroup || !this.getPanelModel().getRootGroupModel().getPromptComponentModels().isEmpty()) {
            s = this.getGroupId(this.getPanelModel().getRootGroupModel(), parm);
        } else {
            List subgroupList = this.getPanelModel().getRootGroupModel().getSubGroupModels();
            if (!subgroupList.isEmpty()) {
                s = this.getGroupId((PromptGroupPanelModelInterface)subgroupList.get(0), parm);
            }
        }
        if (s != null) {
            s.append("]");
        }
        sb.append(scriptId).append("= new sas_PromptPropertiesPanel(\"").append(this.getId()).append("\"");
        if (this.getCommitButton() != null) {
            sb.append(", \"").append(this.getCommitButton().getId() + "\"");
        } else {
            sb.append(", null");
        }
        if (this.getProtectionIds() != null) {
            sb.append(", [");
            for (int i = 0; i < this.getProtectionIds().length; ++i) {
                sb.append("\"").append(this.getProtectionIds()[i]).append("\"");
                if (this.getProtectionIds().length - 1 <= i) continue;
                sb.append(",");
            }
            sb.append("]");
        } else {
            sb.append(", null");
        }
        if (s != null) {
            sb.append(",").append(s.toString());
        }
        sb.append(",").append(this.isAutoSize());
        sb.append(");\n");
        sb.append(scriptId).append(".url = \"").append(this.getAjaxURLTemplate().format()).append("\";\n");
        if (this.defaultGroupName != null) {
            sb.append(scriptId).append(".defaultGroupName = \"").append(this.defaultGroupName).append("\";\n");
        }
        if (this.getProtectPageFunctionName() != null) {
            sb.append(scriptId).append(".protectPageFunctionName = function(arg) {").append(this.getProtectPageFunctionName()).append("};");
        }
        sb.append(scriptId).append(".fastClickProtectionEnabled = ").append(this.isDefaultPageProtectionEnabled()).append(";\n");
        sb.append(scriptId).append(".collapseLeftImage = \"").append(ComponentPropertyManager.getInstance(this.getRequest()).getImageURI("Collapse_Left")).append("\";\n");
        sb.append(scriptId).append(".collapseRightImage = \"").append(ComponentPropertyManager.getInstance(this.getRequest()).getImageURI("Collapse_Right")).append("\";\n");
        sb.append(scriptId).append(".setEnableRequiredCheckBox(").append(Util.isRequiredPromptPresent(this.groupPanel.getPanelModel())).append(");\n");
        sb.append(scriptId).append(".setApplyOnFocus(").append(this.isApplyOnFocus()).append(");\n");
        sb.append(scriptId).append(".applyButtonVisible = ").append(this.isApplyButtonVisible()).append(";\n");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    private StringBuffer getGroupId(PromptGroupPanelModelInterface model, StringBuffer sb) {
        sb.append("\"").append(this.getId()).append("_").append(Util.getValidGroupName(model)).append("\"");
        List subgroups = model.getSubGroupModels();
        for (PromptGroupPanelModelInterface subgroup : subgroups) {
            this.getGroupId(subgroup, sb.append(","));
        }
        return sb;
    }

    private void writeFastClickProtection(PrintWriter out) throws IOException {
        out.println(JavaScriptIncludeHandler.getStartScript());
        String processText = "Processing";
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' ) ");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager(null,\"" + processText + "\");");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    public String getImageLocation() {
        if (this.imageLocation != null) {
            return this.imageLocation;
        }
        return ComponentPropertyManager.getInstance(this.getRequest()).getImageLocation();
    }

    public void setImageLocation(String imageLocation) {
        if (imageLocation != null && imageLocation.lastIndexOf(47) == -1) {
            StringBuffer sb = new StringBuffer(imageLocation);
            sb.append('/');
            this.imageLocation = sb.toString();
        } else {
            this.imageLocation = imageLocation;
        }
    }

    private PromptComponent getPromptComponent(String componentId, String groupName) {
        Map m = (Map)this.getGroupsList().get(groupName);
        if (m == null) {
            LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).warn("PromptGroup " + groupName + " is not found.");
            return null;
        }
        Iterator itr = m.keySet().iterator();
        while (itr.hasNext()) {
            PromptComponent pc = (PromptComponent)m.get(itr.next());
            if (!componentId.equals(pc.getId())) continue;
            return pc;
        }
        return null;
    }

    private int getRequiredPromptCount(PromptGroupPanelModelInterface group) {
        int numRequired = 0;
        List promptComponentModels = group.getPromptComponentModels();
        if (promptComponentModels != null && promptComponentModels.size() > 0) {
            for (PromptComponentModelInterface pcModel : promptComponentModels) {
                if (pcModel.getPromptDefinition() == null || !pcModel.getPromptDefinition().isRequired() || pcModel.getPromptValue() != null) continue;
                ++numRequired;
            }
        }
        return numRequired;
    }

    private void updateGroupLabel(PrintWriter out, PromptComponent promptComponent) {
        PromptDefinitionInterface def = promptComponent.getPromptDefinition();
        if (def.isRequired()) {
            out.print("<span");
            out.print(">");
            out.print("&#160;");
            out.println("</span>");
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.print(this.getId() + "_Obj.updateGroupLabel(");
            out.println(this.getRequiredPromptCount(promptComponent.getGroupPanel().getPanelModel()) + ", \"" + Util.getValidGroupName(promptComponent.getGroupPanel().getPanelModel()) + "\");");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
    }

    private void updateComponent(HttpServletRequest request, HttpServletResponse response, PromptComponent promptComponent, Object value) throws PromptValueNotFoundException, InvalidPromptValueException {
        promptComponent.setRequest(request);
        promptComponent.setResponse(response);
        promptComponent.updatePromptValue(request, value);
    }

    private List converTableModelToList(TableModel model) {
        int rowCount = model.getRowCount();
        int colCount = model.getColumnCount();
        if (rowCount == 0) {
            return null;
        }
        List items = ListFactory.newList();
        for (int i = 0; i < rowCount; ++i) {
            if (model.getValueAt(i, 0) instanceof ValueItem || colCount == 1) {
                items.add(model.getValueAt(i, 0));
                continue;
            }
            if (colCount <= 1) continue;
            items.add(model.getValueAt(i, 1));
        }
        return items;
    }

    private void revertValue(PrintWriter out, PromptComponent promptComponent) throws IOException {
        out.print("<span");
        out.print(">");
        out.print("&#160;");
        out.println("</span>");
        out.println(JavaScriptIncludeHandler.getStartScript());
        String message = Message.format((String)com.sas.prompts.visuals.swing.RB.getStringResource((String)RB_KEY2, (String)"revertingValue.fmt.txt", (Locale)promptComponent.getLocale()), (Object)promptComponent.getPromptComponentModel().getPromptDefinition().getPromptLabel(promptComponent.getLocale()));
        out.println(this.getId() + "_Obj.validationFailed = true; ");
        out.println("alert(\"" + Strings.escapeForJavaScript((String)message) + "\");");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        promptComponent.write(out);
    }

    public void setPromptValuesObject(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String componentId = request.getParameter(PROMPT_NAME_REQUEST_PARM);
        if (componentId != null) {
            this.setRequest(request);
            this.setResponse(response);
            PromptComponent promptComponent = this.getPromptComponent(componentId, request.getParameter("sas_groupName"));
            if (promptComponent == null) {
                return;
            }
            PrintWriter out = response.getWriter();
            TransformationInterface valueComponent = promptComponent.getComponent("PROMPT_COMPONENT");
            TableModel model = null;
            Object value = null;
            if (valueComponent instanceof DataSourcePicker) {
                DataSourcePicker dsp = (DataSourcePicker)valueComponent;
                if (valueComponent instanceof DataSourceValidationInterface) {
                    try {
                        ((DataSourceValidationInterface)((Object)valueComponent)).validate(request.getParameter(PROMPT_VALUE_REQUEST_PARM), promptComponent.getLocale());
                        out.print("<span");
                        out.print(">");
                        out.print("&#160;");
                        out.println("</span>");
                        String parmValue = request.getParameter(PROMPT_VALUE_REQUEST_PARM);
                        if (parmValue != null && !parmValue.trim().equals("")) {
                            value = dsp.getDataSource(parmValue);
                        }
                        out.println(JavaScriptIncludeHandler.getStartScript());
                        if (value != null) {
                            out.println(valueComponent.getId() + "_Obj.setValue(\"" + value.toString() + "\");");
                        }
                        out.println(JavaScriptIncludeHandler.getEndScript(null));
                    }
                    catch (Exception e) {
                        this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
                        return;
                    }
                }
            } else if (valueComponent instanceof DataSourceColumnPicker) {
                DataSourceColumnPicker dscp = (DataSourceColumnPicker)valueComponent;
                if (dscp.getSelectionType() == 300) {
                    TransformationInterface dataSourceComponent = dscp.getComponent("DATASOURCECOLUMN_CHOICEBOX");
                    if (dataSourceComponent instanceof ValuePicker) {
                        PromptDefinitionInterface pdi = promptComponent.getPromptDefinition();
                        if (pdi instanceof MutableSelectableDefinitionInterface) {
                            MutableSelectableDefinitionInterface msdi = (MutableSelectableDefinitionInterface)pdi;
                            ((ValuePicker)dataSourceComponent).setMaximumValueCount(msdi.getMaximumValueCount());
                            ((ValuePicker)dataSourceComponent).setMinimumValueCount(msdi.getMinimumValueCount());
                        }
                        ChoiceBox cb = (ChoiceBox)((ValuePicker)dataSourceComponent).getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
                        String index = request.getParameter("sas_selectedIndex");
                        int selectedIndex = index != null ? Integer.parseInt(index) : cb.getSelectedIndex();
                        value = cb.getModel().getElementAt(selectedIndex);
                    } else if (dataSourceComponent instanceof ChoiceBox) {
                        String index = request.getParameter("sas_selectedIndex");
                        int selectedIndex = 0;
                        selectedIndex = index != null ? Integer.parseInt(index) : ((ChoiceBox)dataSourceComponent).getSelectedIndex();
                        value = ((ChoiceBox)dataSourceComponent).getModel().getElementAt(selectedIndex);
                        if (value instanceof ValueItem && (((ValueItem)value).getValue() == null || ((ValueItem)value).getValue().equals(""))) {
                            value = null;
                        }
                    }
                } else {
                    DataSourceColumnItemListManager ilm = (DataSourceColumnItemListManager)dscp.getComponent("DATASOURCECOLUMN_ITEMLISTMANAGER");
                    value = this.converTableModelToList((TableModel)ilm.getModel());
                }
            } else if (valueComponent instanceof ValuePicker) {
                ValuePicker valuePicker = (ValuePicker)valueComponent;
                if (valuePicker.getSelectionMode() == 300) {
                    TransformationInterface src = valuePicker.getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT);
                    if (src instanceof AjaxTreeView) {
                        TreeNode node = (TreeNode)((AjaxTreeView)src).findNode(request.getParameter(PROMPT_VALUE_REQUEST_PARM));
                        value = node == null ? null : node.getUserObject();
                    }
                } else {
                    ValueListEditor vle = (ValueListEditor)((ValuePicker)valueComponent).getComponent(ValuePicker.VALUEPICKER_TARGET_COMPONENT);
                    value = this.converTableModelToList((TableModel)vle.getModel());
                }
            } else if (valueComponent instanceof ValueListEditor) {
                model = (TableModel)((ValueListEditor)valueComponent).getModel();
                value = this.converTableModelToList(model);
            }
            try {
                this.updateComponent(request, response, promptComponent, value);
                if (promptComponent.isRequired() && promptComponent.getPromptComponentModel().getPromptDefinition().isDefaultValueSet() && value == null && promptComponent.getPromptComponentModel().getPromptValue() != null) {
                    this.revertValue(out, promptComponent);
                }
            }
            catch (PromptValueNotFoundException e) {
                this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
            }
            catch (InvalidPromptValueException e) {
                this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
            }
            catch (Exception e) {
                if (e.getLocalizedMessage() != null) {
                    this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
                }
                LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                this.writeMessage(out, RB.getStringResource(RB_KEY, "error.txt", request.getLocale()), promptComponent);
            }
            if (promptComponent != null) {
                if (this.getCommitButton() != null) {
                    out.print("<span");
                    out.print(">");
                    out.print("&#160;");
                    out.println("</span>");
                    out.println(JavaScriptIncludeHandler.getStartScript());
                    out.println(this.getId() + "_Obj.setCommitButtonEnable(" + this.getPanelModel().isAllRequiredPromptsValid() + ");");
                    out.println(JavaScriptIncludeHandler.getEndScript(null));
                }
                this.updateGroupLabel(out, promptComponent);
            }
            this.clearDependentPrompts(this.getPanelModel().getRootGroupModel(), promptComponent.getPromptComponentModel());
            this.handlePromptValueChanges(this.getPanelModel().getRootGroupModel(), promptComponent.getPromptComponentModel(), out, false);
        }
    }

    private PromptGroupPanel findPromptGroupPanel(PromptGroupPanelModelInterface groupPanelModel) {
        Map panels = this.getPromptGroupPanels();
        return (PromptGroupPanel)panels.get(groupPanelModel);
    }

    private PromptComponent findPromptComponent(PromptDefinitionInterface promptDefinition, PromptGroupPanelModelInterface panelModel) {
        PromptGroupPanel panel = this.findPromptGroupPanel(panelModel);
        if (panel != null) {
            Map components = panel.getPromptComponents();
            Iterator itr = components.keySet().iterator();
            while (itr.hasNext()) {
                PromptComponent pc = (PromptComponent)components.get(itr.next());
                if (pc.getPromptComponentModel().getPromptDefinition() != promptDefinition) continue;
                return pc;
            }
        }
        return null;
    }

    private PromptComponent findPromptComponent(PromptComponentModelInterface promptComponentModel) {
        Map groups = this.getPromptGroupPanels();
        Iterator itr = groups.keySet().iterator();
        while (itr.hasNext()) {
            PromptGroupPanel groupPanel = (PromptGroupPanel)groups.get(itr.next());
            Map components = groupPanel.getPromptComponents();
            Iterator cItr = components.keySet().iterator();
            while (cItr.hasNext()) {
                PromptComponent pc = (PromptComponent)components.get(cItr.next());
                if (pc.getPromptComponentModel() != promptComponentModel) continue;
                return pc;
            }
        }
        return null;
    }

    private void clearDependentPrompts(PromptGroupPanelModelInterface panelModel, PromptComponentModelInterface changedPromptDefinitionModel) {
        List promptComponentModels = panelModel.getPromptComponentModels();
        int csize = promptComponentModels.size();
        int n = csize;
        for (int i = 0; i < n; ++i) {
            PromptComponent pc;
            PromptComponentModelInterface _promptComponentModel = (PromptComponentModelInterface)promptComponentModels.get(i);
            Collection coll = _promptComponentModel.getDynamicPromptValuesContext().getDependentPromptViews((PromptViewInterface)_promptComponentModel);
            if (coll == null || !coll.contains(changedPromptDefinitionModel) || (pc = this.findPromptComponent(_promptComponentModel)) == null) continue;
            try {
                _promptComponentModel.setPromptValue(null);
                this.clearDependentPrompts(panelModel, _promptComponentModel);
                continue;
            }
            catch (InvalidPromptValueException invalidPromptValueException) {
                // empty catch block
            }
        }
        Iterator itr = panelModel.getSubGroupModels().iterator();
        while (itr.hasNext()) {
            this.clearDependentPrompts((PromptGroupPanelModelInterface)itr.next(), changedPromptDefinitionModel);
        }
    }

    private void handlePromptValueChanges(PromptGroupPanelModelInterface panelModel, PromptComponentModelInterface changedPromptDefinitionModel, PrintWriter out, boolean resetToDefault) {
        HttpServletResponse response = this.getResponse();
        HttpServletRequest request = this.getRequest();
        List promptComponentModels = panelModel.getPromptComponentModels();
        int csize = promptComponentModels.size();
        int n = csize;
        for (int i = 0; i < n; ++i) {
            List combinations;
            PromptComponent pc;
            Collection coll;
            List list;
            PromptComponentModelInterface _promptComponentModel = (PromptComponentModelInterface)promptComponentModels.get(i);
            if (changedPromptDefinitionModel.equals(_promptComponentModel) && (list = panelModel.getModalGroups(_promptComponentModel)) != null) {
                for (Object modalGroupObj : list) {
                    PromptGroupPanelModelInterface obj;
                    if (!(modalGroupObj instanceof PromptGroupPanelModelInterface) || !(obj = (PromptGroupPanelModelInterface)modalGroupObj).isModalChoiceGroup()) continue;
                    if (obj.getModalChoiceGroupValue() != null && obj.getModalChoiceGroupValue().equals(_promptComponentModel.getPromptValue())) {
                        Map groupPanels = this.getPromptGroupPanels();
                        PromptGroupPanel panel = (PromptGroupPanel)groupPanels.get(obj);
                        if (panel == null) {
                            panel = this.getPromptGroupPanelFactory().createGroupPanel(obj, this);
                            groupPanels.put(obj, panel);
                        } else {
                            Map promptComponents = panel.getPromptComponents();
                            if (promptComponents != null && promptComponents.size() > 0) {
                                Set keySet = promptComponents.keySet();
                                Iterator iter = keySet.iterator();
                                while (iter.hasNext()) {
                                    PromptComponent component = (PromptComponent)promptComponents.get(iter.next());
                                    component.reset();
                                }
                            }
                        }
                        panel.setRequest(request);
                        panel.setResponse(response);
                        try {
                            panel.write(out);
                        }
                        catch (IOException e) {
                            LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    Integer hc = new Integer(obj.hashCode());
                    String hcVal = hc.toString();
                    if (hc < 0) {
                        hcVal = hcVal.replace('-', '_');
                    }
                    if (obj.isModalChoiceGroup()) {
                        out.println("<div id=\"" + this.getId() + "_PG" + hcVal + "_PMG_container\" style=\"display:none;\"></div>");
                        continue;
                    }
                    out.println("<div id=\"" + this.getId() + "_PG" + hcVal + "_container\" style=\"display:none;\"></div>");
                }
            }
            if ((coll = _promptComponentModel.getDynamicPromptValuesContext().getDependentPromptViews((PromptViewInterface)_promptComponentModel)) != null && coll.contains(changedPromptDefinitionModel) && (pc = this.findPromptComponent(_promptComponentModel)) != null) {
                if (_promptComponentModel.getDynamicPromptValuesContext().isValueSetForAllDependentPromptViews((PromptViewInterface)_promptComponentModel)) {
                    try {
                        pc.handleDependentPromptValueChange(_promptComponentModel, this.getLocale());
                    }
                    catch (PromptValueNotFoundException e1) {
                        LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e1.getMessage(), (Throwable)e1);
                    }
                }
                try {
                    if (!resetToDefault && pc.getPromptComponentModel() instanceof DefaultPromptComponentModel) {
                        pc.getPromptComponentModel().setPromptValue("UNSET");
                        BaseTransformation tbean = (BaseTransformation)pc.getComponent("PROMPT_COMPONENT");
                        if (tbean != null) {
                            tbean.setObjectData(null);
                        }
                    } else {
                        pc.setComponentValue(this.getLocale());
                    }
                }
                catch (PromptValueNotFoundException e) {
                    LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                }
                catch (InvalidPromptValueException e) {
                    e.printStackTrace();
                }
                try {
                    if (!resetToDefault) {
                        if (pc.isVisible()) {
                            pc.write(request, response);
                            PrintWriter o = response.getWriter();
                            out.println(JavaScriptIncludeHandler.getStartScript());
                            out.println(pc.getId() + "_Obj.setEnabled(true);");
                            out.println(JavaScriptIncludeHandler.getEndScript());
                        } else {
                            out.println("<span>&nbsp;</span>");
                            out.println(JavaScriptIncludeHandler.getStartScript());
                            out.println(pc.getId() + "_Obj.setEnabled(false);");
                            out.println(JavaScriptIncludeHandler.getEndScript());
                        }
                    }
                    this.handlePromptValueChanges(panelModel, _promptComponentModel, out, resetToDefault);
                }
                catch (ServletException e) {
                    LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
            PromptDefinitionInterface changedPromptDefinition = changedPromptDefinitionModel.getPromptDefinition();
            PromptDefinitionInterface promptDefinition = _promptComponentModel.getPromptDefinition();
            if (changedPromptDefinitionModel == null || !promptDefinition.equals(changedPromptDefinition) || (combinations = changedPromptDefinitionModel.getPromptDefinitionCombinations()) == null) continue;
            for (PromptDefinitionInterface pdi : combinations) {
                if (changedPromptDefinitionModel.getPromptDefinition().equals(pdi)) continue;
                try {
                    BaseTransformation valueComponent;
                    PromptComponent promptComponent = this.findPromptComponent(pdi, panelModel);
                    if (promptComponent == null || promptComponent.getPromptComponentModel().getPromptValue() == null || (valueComponent = (BaseTransformation)promptComponent.getComponent("PROMPT_COMPONENT")) == null) continue;
                    promptComponent.setRequest(request);
                    promptComponent.setResponse(response);
                    valueComponent.setObjectData(promptComponent.getPromptComponentModel().getPromptValue());
                    promptComponent.write(request, response);
                }
                catch (IOException ex) {
                    LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(ex.getMessage(), (Throwable)ex);
                }
                catch (ServletException ex) {
                    LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        List subgroups = panelModel.getSubGroupModels();
        for (Object obj : subgroups) {
            this.handlePromptValueChanges((PromptGroupPanelModelInterface)obj, changedPromptDefinitionModel, out, resetToDefault);
        }
    }

    public void getRequiredPromptsWithoutValues(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List l = Util.getRequiredPromptsWithoutValues(this.getPanelModel());
        PrintWriter out = response.getWriter();
        StringBuffer sb = new StringBuffer();
        sb.append("var requiredPromptNames =  new Array();\n");
        for (PromptComponentModelInterface pcm : l) {
            sb.append("requiredPromptNames.push(\"").append(pcm.getPromptDefinition().getPromptLabel(this.getLocale())).append("\");\n");
        }
        out.println(sb.toString());
    }

    public void setPromptValues(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String componentId = request.getParameter(PROMPT_NAME_REQUEST_PARM);
        if (componentId != null) {
            this.setRequest(request);
            this.setResponse(response);
            PromptComponent promptComponent = this.getPromptComponent(componentId, request.getParameter("sas_groupName"));
            PrintWriter out = response.getWriter();
            try {
                if (promptComponent != null) {
                    promptComponent.setRequest(request);
                    promptComponent.setResponse(response);
                    TransformationInterface componentValue = promptComponent.getComponent("PROMPT_COMPONENT");
                    if (componentValue instanceof DataSourceValidationInterface) {
                        ((DataSourceValidationInterface)((Object)componentValue)).validate(request.getParameter(PROMPT_VALUE_REQUEST_PARM), promptComponent.getLocale());
                    }
                    promptComponent.updatePromptValue(request);
                    this.updateGroupLabel(out, promptComponent);
                    out.println(JavaScriptIncludeHandler.getStartScript());
                    PromptComponentModelInterface promptComponentModel = promptComponent.getPromptComponentModel();
                    out.println(promptComponent.getId() + "_Obj.updateValue(" + PromptComponent.getJSValue(promptComponentModel.getPromptValue(), this.getLocale()) + ");");
                    out.println(JavaScriptIncludeHandler.getEndScript(null));
                    this.setRequest(request);
                    this.setResponse(response);
                    if (this.getCommitButton() != null) {
                        out.println("<span>&#160;</span>");
                        out.println(JavaScriptIncludeHandler.getStartScript());
                        out.println(this.getId() + "_Obj.setCommitButtonEnable(" + this.getPanelModel().isAllRequiredPromptsValid() + ");");
                        out.println(JavaScriptIncludeHandler.getEndScript(null));
                    }
                    this.clearDependentPrompts(this.getPanelModel().getRootGroupModel(), promptComponentModel);
                    this.handlePromptValueChanges(this.getPanelModel().getRootGroupModel(), promptComponentModel, out, false);
                    if (promptComponent.isRequired() && promptComponentModel.getPromptDefinition().isDefaultValueSet()) {
                        Object value = request.getParameterValues(PROMPT_VALUE_REQUEST_PARM);
                        if (value != null && ((String[])value).length == 1) {
                            value = value[0];
                        }
                        if ((value == null || value == "") && promptComponentModel.getPromptValue() != null) {
                            this.revertValue(out, promptComponent);
                        }
                    }
                }
            }
            catch (InvalidPromptValueException e) {
                this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
            }
            catch (NumberFormatException e) {
                this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
            }
            catch (DataSourceValidationException e) {
                this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
            }
            catch (Exception e) {
                if (e.getLocalizedMessage() != null) {
                    this.writeMessage(out, e.getLocalizedMessage(), promptComponent);
                }
                LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                this.writeMessage(out, RB.getStringResource(RB_KEY, "error.txt", request.getLocale()), promptComponent);
            }
        }
    }

    private void writeMessage(PrintWriter out, String message, PromptComponent promptComponent) {
        PromptDefinitionInterface definition = promptComponent.getPromptComponentModel().getPromptDefinition();
        String value = promptComponent.getPromptDefinition().getPromptDataType().getDisplayString(promptComponent.getPromptComponentModel().getPromptValue(), this.getLocale());
        if (message != null) {
            out.print("<span");
            out.print(">");
            out.print("&#160;");
            out.println("</span>");
            try {
                TransformationInterface componentValue = promptComponent.getComponent("PROMPT_COMPONENT");
                if (componentValue instanceof ValuePicker) {
                    ((ValuePicker)componentValue).setObjectData(promptComponent.getPromptComponentModel().getPromptValue());
                } else if (componentValue instanceof ValueListEditor) {
                    ((ValueListEditor)componentValue).setObjectData(promptComponent.getPromptComponentModel().getPromptValue());
                } else if (componentValue instanceof DataSourceColumnPicker) {
                    ((DataSourceColumnPicker)componentValue).setObjectData(promptComponent.getPromptComponentModel().getPromptValue());
                }
                promptComponent.setRequest(this.getRequest());
                promptComponent.setResponse(this.getResponse());
                promptComponent.write(out);
            }
            catch (IOException e) {
                LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            out.println(JavaScriptIncludeHandler.getStartScript());
            char[] specialChars = new char[]{'\"', '\'', '\\', '\b', '\n', '\t', '\f', '\r'};
            String[] replacementChars = new String[]{"\\\"", "\\'", "\\\\", "\\b", "\\n", "\\t", "\\f", "\\r"};
            message = Strings.replace((String)message, (char[])specialChars, (String[])replacementChars);
            if (value != null) {
                value = Strings.replace((String)value, (char[])specialChars, (String[])replacementChars);
            }
            out.println(this.getId() + "_Obj.displayErrorDialog(\"" + message + "\",\"" + definition.getPromptName() + "\", \"" + Strings.escapeForJavaScript((String)value) + "\",\"" + promptComponent.getId() + "\");");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
    }

    public void switchGroupPanel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requiredChecked;
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        PromptGroupPanelModelInterface groupModel = this.getPromptGroupModel(request);
        PromptGroupPanel promptGroupPanel = (PromptGroupPanel)this.getPromptGroupPanels().get(groupModel);
        if (promptGroupPanel == null) {
            promptGroupPanel = this.addPromptGroupPanelForGroup(groupModel, false);
        }
        if ((requiredChecked = request.getParameter("requiredChecked")) != null && requiredChecked.equalsIgnoreCase("true")) {
            promptGroupPanel.setShowOnlyRequired(true);
        } else {
            promptGroupPanel.setShowOnlyRequired(false);
        }
        this.updatePromptProperty(request, response, null);
    }

    public void resetToDefault(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        Map panels = this.getPromptGroupPanels();
        PromptGroupPanel groupPanel = (PromptGroupPanel)panels.get(this.getPromptGroupModel(request));
        if (groupPanel != null) {
            this.resetComponents(groupPanel, request, response);
        }
    }

    private void resetComponents(PromptGroupPanel groupPanel, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map panels = this.getPromptGroupPanels();
        PromptGroupPanelModelInterface groupModel = groupPanel.getPanelModel();
        this.restAllComponents(groupPanel.getPromptComponents(), groupModel, request, response);
        List subgroups = groupModel.getSubGroupModels();
        Iterator itr = subgroups.iterator();
        while (itr.hasNext()) {
            PromptGroupPanel panel = (PromptGroupPanel)panels.get(itr.next());
            if (panel == null) continue;
            this.resetComponents(panel, request, response);
        }
    }

    private void restAllComponents(Map promptComponents, PromptGroupPanelModelInterface groupModel, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PromptComponent component;
        Set keySet = promptComponents.keySet();
        PrintWriter out = response.getWriter();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            component = (PromptComponent)promptComponents.get(iter.next());
            component.reset();
        }
        iter = keySet.iterator();
        while (iter.hasNext()) {
            component = (PromptComponent)promptComponents.get(iter.next());
            PromptComponentModelInterface pcModel = component.getPromptComponentModel();
            if (!pcModel.getDynamicPromptValuesContext().hasDependent((PromptViewInterface)pcModel)) continue;
            this.handlePromptValueChanges(this.getPanelModel().getRootGroupModel(), component.getPromptComponentModel(), out, true);
        }
        iter = keySet.iterator();
        while (iter.hasNext()) {
            component = (PromptComponent)promptComponents.get(iter.next());
            if (groupModel.isModalChoiceGroup()) continue;
            component.setRequest(request);
            component.setResponse(response);
            component.write(out);
            if (!component.isEnabled() || !component.isVisible()) continue;
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println(component.getId() + "_Obj.setEnabled(true);");
            out.println(JavaScriptIncludeHandler.getEndScript());
        }
    }

    private PromptGroupPanelModelInterface getPromptGroupModel(HttpServletRequest request) {
        String selectedPromptGroupName = request.getParameter("sas_selectedGroupName");
        if (selectedPromptGroupName != null) {
            return this.getPromptGroupModel(selectedPromptGroupName);
        }
        String selectedPromptIndex = request.getParameter("sas_selectedGroupIndex");
        int index = -1;
        PromptGroupPanelModelInterface pgroup = null;
        if (selectedPromptIndex != null) {
            index = Integer.parseInt(selectedPromptIndex);
            if (this.getComponent(GROUPS_LIST_PANEL) != null) {
                PromptGroupList groupList = (PromptGroupList)this.getComponent(GROUPS_LIST_PANEL);
                try {
                    groupList.getListBoxView().setSelectedIndex(index);
                }
                catch (IOException e) {
                    LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
                }
                pgroup = ((PromptJavaScriptNode)groupList.getListModel().getElementAt(index)).getPromptGroupModel();
            } else {
                pgroup = this.getPanelModel().getRootGroupModel();
            }
        }
        return pgroup;
    }

    public static void processRequest(HttpServletRequest request, HttpServletResponse response, PromptPropertiesPanel panel) throws IOException {
        if (panel == null) {
            panel = PromptPropertiesPanel.getPromptPropertiesPanel(request);
        }
        if (panel != null) {
            panel.setRequest(request);
            panel.setResponse(response);
            panel.processRequestAction(request, response);
        }
    }

    public static void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PromptPropertiesPanel.processRequest(request, response, null);
    }

    public void processAllActions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpActionProvider actionProvider;
        String cmdId = request.getParameter("CMDID");
        String classParameter = request.getParameter("CLASS_PARAMETER");
        if (cmdId != null && cmdId.length() > 0 && (actionProvider = this.getActionProvider()) != null) {
            actionProvider.executeCommand(request, response, null);
        }
        if (classParameter != null) {
            try {
                MethodInvocationServlet.invoke(request, response);
            }
            catch (ServletException e) {
                LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processRequestAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = request.getParameter(AJAX_ACTION);
        if (action == null) {
            LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).debug("**No AJAX Action Found**");
            return;
        }
        if (action.equals("switchGroupPanel")) {
            this.switchGroupPanel(request, response);
        } else if (action.equals("setPromptValues")) {
            String serverUpdate = request.getParameter("serverUpdate");
            if (serverUpdate != null && serverUpdate.equalsIgnoreCase("true")) {
                this.setPromptValuesObject(request, response);
            } else {
                this.setPromptValues(request, response);
            }
        } else if (action.equals("resetToDefault")) {
            this.resetToDefault(request, response);
        } else if (action.equals("getRequiredPromptsWithoutValues")) {
            this.getRequiredPromptsWithoutValues(request, response);
        }
    }

    private static PromptPropertiesPanel getPromptPropertiesPanel(HttpServletRequest request) {
        PromptPropertiesPanel panel;
        String id = request.getParameter(PROMPT_PROPERTY_ID);
        if (id != null && (panel = (PromptPropertiesPanel)ComponentSessionManager.getSessionManager(request).get(id)) != null) {
            return panel;
        }
        return null;
    }

    private void updatePromptProperty(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        this.setRequest(request);
        PrintWriter out = response.getWriter();
        PromptGroupPanel promptGroupPanel = (PromptGroupPanel)this.getPromptGroupPanels().get(this.getPromptGroupModel(request));
        promptGroupPanel.setRequest(request);
        promptGroupPanel.setResponse(response);
        String componentId = request.getParameter(PROMPT_NAME_REQUEST_PARM);
        promptGroupPanel.write(out);
        if (promptGroupPanel.isContentEmpty()) {
            out.print("<span");
            out.print(">");
            out.print("&#160;");
            out.println("</span>");
        }
        if (message != null) {
            try {
                message = Strings.replace((String)message, (int)0, (int)(message.length() - 1), (String)"\n", (String)"<br>");
            }
            catch (Exception ex) {
                LoggerRepository2.getLogger((String)PromptPropertiesPanel.class.getName(), null).error(ex.getMessage(), (Throwable)ex);
            }
            message = Strings.escapeForJavaScript((String)message);
            message = Strings.replace((String)message, (int)0, (int)-1, (String)"<br>", (String)"\\n");
            out.println(this.getId() + ".displayErrorDialog(\"" + message + "\",\"" + componentId + "\");");
        }
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    public Map getGroupsList() {
        return this.groupsList;
    }

    public boolean isShowRootGroup() {
        return this.showRootGroup;
    }

    public void setShowRootGroup(boolean showRootGroup) {
        this.showRootGroup = showRootGroup;
    }

    public void setHonor24HourLocale(boolean honor24HourLocale) {
        this.honor24HourLocale = honor24HourLocale;
    }

    public boolean isHonor24HourLocale() {
        return this.honor24HourLocale;
    }

    public boolean isShowInvalidDependentPrompts() {
        return this.showInvalidDependentPrompts;
    }

    public void setShowInvalidDependentPrompts(boolean showInvalidDependentPrompts) {
        this.showInvalidDependentPrompts = showInvalidDependentPrompts;
    }

    public void cleanUp() {
    }

    public PromptComponentFactoryInterface getPromptComponentFactory() {
        return this.promptComponentFactory;
    }

    public void setPromptComponentFactory(PromptComponentFactoryInterface promptComponentFactory) {
        this.promptComponentFactory = promptComponentFactory;
    }

    public PromptGroupPanelFactoryInterface getPromptGroupPanelFactory() {
        if (this.promptGroupPanelFactory == null) {
            this.promptGroupPanelFactory = new PromptGroupPanelFactory();
        }
        return this.promptGroupPanelFactory;
    }

    public void setPromptGroupPanelFactory(PromptGroupPanelFactoryInterface promptGroupPanelFactory) {
        this.promptGroupPanelFactory = promptGroupPanelFactory;
    }

    public void setFormObject(Form form) {
        this.formObject = form;
    }

    public Form getFormObject() {
        return this.formObject;
    }

    private SimpleTemplate getAjaxURLTemplate() {
        if (this.ajaxURLTemplate.getValueDictionary() == null) {
            this.ajaxURLTemplate.setValueDictionary(new HashMap());
        }
        return this.ajaxURLTemplate;
    }

    public TransformationInterface getCommitButton() {
        return this.commitButton;
    }

    public void setCommitButton(BaseButton commitButton) {
        this.commitButton = commitButton;
    }

    public void setCommitButton(BasePushButton commitButton) {
        this.commitButton = commitButton;
    }

    @Override
    public String getAJAXControllerURL() {
        if (this.AJAXControllerURL == null) {
            return this.getRequest().getContextPath() + DEFAULT_AJAX_CONTROLLER_URL;
        }
        return this.AJAXControllerURL;
    }

    @Override
    public void setAJAXControllerURL(String controllerURL) {
        this.AJAXControllerURL = controllerURL;
    }

    public String[] getProtectionIds() {
        return this.protectionIds;
    }

    public void setProtectionIds(String[] protectionIds) {
        this.protectionIds = protectionIds;
    }

    public String getProtectPageFunctionName() {
        return this.protectPageFunctionName;
    }

    public void setProtectPageFunctionName(String protectPageFunctionName) {
        this.protectPageFunctionName = protectPageFunctionName;
    }

    public boolean isDefaultPageProtectionEnabled() {
        return this.defaultPageProtectionEnabled;
    }

    public void setDefaultPageProtectionEnabled(boolean defaultPageProtectionEnabled) {
        this.defaultPageProtectionEnabled = defaultPageProtectionEnabled;
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        this.cleanup(request.getSession());
    }

    @Override
    public void cleanup(HttpSession session) {
        super.cleanup(session);
        this.cleanUp();
        Map panels = this.getPromptGroupPanels();
        Iterator itr = panels.keySet().iterator();
        while (itr.hasNext()) {
            PromptGroupPanel panel = (PromptGroupPanel)panels.get(itr.next());
            panel.cleanup(session);
        }
        panels.clear();
    }

    public boolean isApplyOnFocus() {
        return this.applyOnFocus;
    }

    public void setApplyOnFocus(boolean applyOnFocus) {
        this.applyOnFocus = applyOnFocus;
    }

    public void setApplyButtonVisible(boolean visible) {
        this.applyButtonVisible = visible;
    }

    public boolean isApplyButtonVisible() {
        return this.applyButtonVisible;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean auto) {
        this.autoSize = auto;
    }

    public void setNumberOfListValuesDisplayed(int value) {
        this.numberOfListValuesDisplayed = value;
    }

    public int getNumberOfListValuesDisplayed() {
        String psize = System.getProperty("com.sas.prompts.pagesize");
        if (psize == null) {
            return this.numberOfListValuesDisplayed;
        }
        try {
            return Integer.valueOf(psize);
        }
        catch (NumberFormatException numberFormatException) {
            return this.numberOfListValuesDisplayed;
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(PromptPropertiesPanel.class, "PROMPTPROPERTIESPANEL");
    }
}

