/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.util;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptPropertiesPanelModelInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Util {
    public static String getValidGroupName(PromptGroupPanelModelInterface group) {
        Integer hc = new Integer(group.hashCode());
        String hcVal = hc.toString();
        if (hc < 0) {
            hcVal = hcVal.replace('-', '_');
        }
        return group == null ? "PG" : "PG" + hcVal;
    }

    public static final boolean isRequiredPromptPresent(PromptPropertiesPanelModelInterface model) {
        if (model != null) {
            return Util.isRequiredPromptPresent(model.getRootGroupModel());
        }
        return false;
    }

    public static List getOrderToSetPromptValues(PromptGroupPanelModelInterface promptGroupPanel) {
        return Util.getOrderToSetPromptValues(promptGroupPanel, true);
    }

    public static List getOrderToSetPromptValues(PromptGroupPanelModelInterface promptGroupPanel, boolean includeSubGroups) {
        ArrayList orderedPrompts = new ArrayList();
        List allPrompts = Util.getOrderOfDefs(promptGroupPanel, includeSubGroups);
        Util.addPromptDefinitionsOrderedByDependencies(allPrompts, orderedPrompts, promptGroupPanel);
        return orderedPrompts;
    }

    public static List getRequiredPromptsWithoutValues(PromptPropertiesPanelModelInterface model) {
        ArrayList<PromptComponentModelInterface> defsToReturn = new ArrayList<PromptComponentModelInterface>();
        if (model != null) {
            List promptDefinitions = Util.getVisualOrderOfDefinitions(model, false);
            for (PromptComponentModelInterface pcmi : promptDefinitions) {
                List properOrderOfPrompts = PromptUtil.getVisualOrderOfDefinitions((PromptValuesInterface)pcmi.getPromptValues(), (boolean)false);
                if (!pcmi.getPromptDefinition().isRequired() || pcmi.getPromptValue() != null) continue;
                if (properOrderOfPrompts != null) {
                    if (!properOrderOfPrompts.contains(pcmi.getPromptDefinition())) continue;
                    defsToReturn.add(pcmi);
                    continue;
                }
                defsToReturn.add(pcmi);
            }
        }
        return defsToReturn;
    }

    public static List getVisualOrderOfDefinitions(PromptPropertiesPanelModelInterface model, boolean includeOnlyPromptsWithValuesAvailable) {
        PromptGroupPanelModelInterface promptGroup = model.getRootGroupModel();
        return Util.getVisualOrderOfDefinitions(model, promptGroup, includeOnlyPromptsWithValuesAvailable);
    }

    public static List getVisualOrderOfDefinitions(PromptPropertiesPanelModelInterface model, PromptGroupPanelModelInterface promptGroup, boolean includeOnlyPromptsWithValuesAvailable) {
        ArrayList returnList = new ArrayList();
        if (promptGroup != null) {
            List components = promptGroup.getPromptComponentModels();
            for (Object item : components) {
                if (!(item instanceof PromptComponentModelInterface)) continue;
                if (!includeOnlyPromptsWithValuesAvailable) {
                    returnList.add(item);
                    continue;
                }
                if (((PromptComponentModelInterface)item).getPromptValue() == null) continue;
                returnList.add(item);
            }
            List groupList = promptGroup.getSubGroupModels();
            for (Object o : groupList) {
                if (!(o instanceof PromptGroupPanelModelInterface)) continue;
                PromptGroupPanelModelInterface pgm = (PromptGroupPanelModelInterface)o;
                returnList.addAll(Util.getVisualOrderOfDefinitions(model, pgm, includeOnlyPromptsWithValuesAvailable));
            }
        }
        return returnList;
    }

    private static void addPromptDefinitionsOrderedByDependencies(List allPrompts, List orderedPrompts, PromptGroupPanelModelInterface promptGroupPanel) {
        boolean change = true;
        while (!allPrompts.isEmpty() && change) {
            change = false;
            Iterator allPromptsIterator = allPrompts.iterator();
            while (allPromptsIterator.hasNext()) {
                PromptComponentModelInterface promptComp = (PromptComponentModelInterface)allPromptsIterator.next();
                Collection dependencies = Util.getAllDependentPrompts(promptComp);
                if (dependencies != null && !dependencies.isEmpty() && !Util.isAllDependenciesInList(dependencies, orderedPrompts)) continue;
                orderedPrompts.add(promptComp);
                allPromptsIterator.remove();
                change = true;
            }
        }
        if (!allPrompts.isEmpty()) {
            orderedPrompts.addAll(allPrompts);
        }
    }

    public static Collection getAllDependentPrompts(PromptComponentModelInterface promptComponent) {
        Collection directDependencies = promptComponent.getDynamicPromptValuesContext().getDependentPromptViews((PromptViewInterface)promptComponent);
        ArrayList dependencies = new ArrayList();
        if (directDependencies != null) {
            dependencies.addAll(directDependencies);
        }
        return dependencies;
    }

    private static void addPromptDefinitionsOrderedByDependencies(List allPrompts, List orderedPrompts, PromptGroupInterface promptGroup) {
        boolean change = true;
        while (!allPrompts.isEmpty() && change) {
            change = false;
            Iterator allPromptsIterator = allPrompts.iterator();
            while (allPromptsIterator.hasNext()) {
                PromptDefinitionInterface prompt = (PromptDefinitionInterface)allPromptsIterator.next();
                Collection dependencies = Util.getAllDependentPrompts(prompt);
                if (dependencies != null && !dependencies.isEmpty() && !Util.isAllDependenciesInList(dependencies, orderedPrompts)) continue;
                change = true;
                orderedPrompts.add(prompt);
                allPromptsIterator.remove();
            }
        }
        if (!allPrompts.isEmpty()) {
            orderedPrompts.addAll(allPrompts);
        }
    }

    private static boolean isAllDependenciesInList(Collection dependencies, List orderedPrompts) {
        for (Object dependency : dependencies) {
            if (orderedPrompts.contains(dependency)) continue;
            return false;
        }
        return true;
    }

    public static Collection getAllDependentPrompts(PromptDefinitionInterface prompt) {
        Collection directDependencies = prompt.getDependentPrompts(Locale.US, null);
        Collection additionalDependencies = prompt.getAdditionalCascadeDependencies();
        ArrayList dependencies = new ArrayList();
        if (directDependencies != null) {
            dependencies.addAll(directDependencies);
        }
        if (additionalDependencies != null) {
            dependencies.addAll(additionalDependencies);
        }
        return dependencies;
    }

    private static List getOrderOfDefs(PromptGroupPanelModelInterface promptGroupPanel) {
        return Util.getOrderOfDefs(promptGroupPanel, true);
    }

    private static List getOrderOfDefs(PromptGroupPanelModelInterface promptGroupPanel, boolean includeSubGroups) {
        ArrayList returnList = new ArrayList();
        List promptsAndSubgroups = null;
        List prompts = null;
        prompts = promptGroupPanel.getPromptComponentModels();
        int size = prompts.size();
        for (int i = 0; i < size; ++i) {
            Object item = prompts.get(i);
            if (!(item instanceof PromptComponentModelInterface)) continue;
            returnList.add(item);
        }
        promptsAndSubgroups = promptGroupPanel.getSubGroupModels();
        ArrayList groupList = new ArrayList();
        int size2 = promptsAndSubgroups.size();
        for (int i = 0; i < size2; ++i) {
            Object item = promptsAndSubgroups.get(i);
            if (!(item instanceof PromptGroupPanelModelInterface)) continue;
            PromptGroupPanelModelInterface pgp = (PromptGroupPanelModelInterface)item;
            if (pgp.isModalGroup()) {
                List choiceGroups;
                List comps = pgp.getPromptComponentModels();
                returnList.addAll(comps);
                if (comps == null || comps.size() != 1 || (choiceGroups = pgp.getModalGroups((PromptComponentModelInterface)comps.get(0))) == null) continue;
                Iterator iter = choiceGroups.iterator();
                while (iter.hasNext()) {
                    returnList.addAll(Util.getOrderOfDefs((PromptGroupPanelModelInterface)iter.next()));
                }
                continue;
            }
            if (pgp.isTransparentGroup()) {
                returnList.addAll(Util.getOrderOfDefs(pgp));
                continue;
            }
            groupList.add(item);
        }
        Iterator iter = groupList.iterator();
        while (iter.hasNext()) {
            returnList.addAll(Util.getOrderOfDefs((PromptGroupPanelModelInterface)iter.next()));
        }
        return returnList;
    }

    public static final boolean isRequiredPromptPresent(PromptGroupPanelModelInterface group) {
        if (group != null) {
            List views = group.getPromptComponentModels();
            for (Object o : views) {
                PromptGroupPanelModelInterface subgroup;
                PromptComponentModelInterface view;
                if (!(o instanceof PromptComponentModelInterface ? (view = (PromptComponentModelInterface)o).getPromptDefinition().isRequired() : Util.isRequiredPromptPresent(subgroup = (PromptGroupPanelModelInterface)o))) continue;
                return true;
            }
        }
        boolean requiredPresent = false;
        if (group != null) {
            List subgroups = group.getSubGroupModels();
            for (Object o : subgroups) {
                if (!(o instanceof PromptGroupPanelModelInterface) || !(requiredPresent = Util.isRequiredPromptPresent((PromptGroupPanelModelInterface)o))) continue;
                return true;
            }
        }
        return requiredPresent;
    }

    public static boolean isGroupVisible(PromptGroupPanelModelInterface group) {
        if (group.isHiddenGroup()) {
            return false;
        }
        List objs = group.getPromptComponentModels();
        if (objs.isEmpty() || !group.getSubGroupModels().isEmpty()) {
            return true;
        }
        for (Object element : objs) {
            if (!(element instanceof PromptComponentModelInterface ? !((PromptComponentModelInterface)element).getPromptDefinition().isHidden() : element instanceof PromptGroupPanelModelInterface && Util.isGroupVisible((PromptGroupPanelModelInterface)element))) continue;
            return true;
        }
        return false;
    }
}

