/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.components.webapp.util;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DoubleType;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptDynamicValueProviderWrapper;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.components.webapp.util.PromptDefinitionComponentFactory;
import com.sas.prompts.components.webapp.visuals.PromptValueListEditor;
import com.sas.prompts.components.webapp.visuals.PromptValuePicker;
import com.sas.prompts.components.webapp.visuals.model.PromptComponentModelInterface;
import com.sas.prompts.components.webapp.visuals.model.PromptGroupPanelModelInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.DataSourceColumnPicker;
import com.sas.servlet.tbeans.form.html.TextArea;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.itemlistmanager.AbstractItemListManager;
import com.sas.servlet.tbeans.tableview.html.CellContentsLabelRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.TargetValueListEditor;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.tbeans.valuepicker.ValuePickerTableCellRenderer;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.DoubleTypeToDisplayStringTransform;
import com.sas.util.transforms.TransformInterface;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PromptValueComponentFactory {
    public TransformationInterface createComponent(PromptComponentModelInterface promptComponentModel, String componentId, DynamicPromptValueContextInterface dynamicPromptValueContext, boolean applyVisible, Locale locale) {
        return this.createComponent(promptComponentModel, null, componentId, dynamicPromptValueContext, applyVisible, locale);
    }

    public TransformationInterface createComponent(PromptComponentModelInterface promptComponentModel, PromptGroupPanelModelInterface groupModel, String componentId, DynamicPromptValueContextInterface dynamicPromptValueContext, boolean applyVisible, Locale locale) {
        TransformationInterface valueComponent = null;
        PromptDefinitionInterface promptDefinition = promptComponentModel.getPromptDefinition();
        DataProvider dataProvider = null;
        if (dynamicPromptValueContext != null) {
            dataProvider = (DataProvider)dynamicPromptValueContext.getDataProvider();
        }
        if (promptDefinition.isFixed()) {
            SelectableDefinitionInterface selDef;
            if (promptDefinition instanceof SelectableDefinitionInterface && ((selDef = (SelectableDefinitionInterface)promptDefinition).getSelectionType() == 301 || selDef.getSelectionType() == 302 || selDef instanceof TextDefinitionInterface && ((TextDefinitionInterface)selDef).isAllowMultipleLines())) {
                valueComponent = new TextArea();
                ((TextArea)valueComponent).setColumns(50);
                ((TextArea)valueComponent).setReadOnly(true);
            }
            if (valueComponent == null) {
                valueComponent = new Label();
            }
            if (promptDefinition.isDefaultValueSet()) {
                Object defObject = promptDefinition.getDefaultValue();
                if (defObject instanceof Color) {
                    Color color = (Color)defObject;
                    String red = Integer.toHexString(color.getRed());
                    String green = Integer.toHexString(color.getGreen());
                    String blue = Integer.toHexString(color.getBlue());
                    if (red.length() == 1) {
                        red = "0" + red;
                    }
                    if (green.length() == 1) {
                        green = "0" + green;
                    }
                    if (blue.length() == 1) {
                        blue = "0" + blue;
                    }
                    String colorString = new StringBuffer().append("#").append(red).append(green).append(blue).toString();
                    ((BaseLabel)valueComponent).setText("<div style=\"width:100px; background-color:" + colorString + "\">" + "&#160;" + "</div>");
                    ((BaseLabel)valueComponent).setEncodeText(false);
                    return valueComponent;
                }
                ((BaseTransformation)valueComponent).setObjectData(promptDefinition.getPromptDataType().getDisplayString(defObject, locale));
            } else {
                LoggerRepository2.getLogger((String)PromptDefinitionComponentFactory.class.getName(), null).error("Fixed prompt requires a default value. " + promptDefinition.getPromptName());
            }
            return valueComponent;
        }
        if (promptDefinition instanceof ValueProviderDefinitionInterface) {
            ValueProviderDefinitionInterface valueProviderDefinition = (ValueProviderDefinitionInterface)promptDefinition;
            boolean allowUserValues = valueProviderDefinition.isAllowUserValues();
            ValueProviderInterface valueProvider = valueProviderDefinition.getValueProvider();
            int selType = 300;
            if (promptDefinition instanceof SelectableDefinitionInterface) {
                selType = ((SelectableDefinitionInterface)promptDefinition).getSelectionType();
            }
            if (valueProvider == null) {
                if (promptDefinition instanceof ModalGroupDefinition && groupModel != null) {
                    List modalChoices = groupModel.getModalGroups(promptComponentModel);
                    StaticValueProvider svp = new StaticValueProvider();
                    ArrayList<ValueItem> values = new ArrayList<ValueItem>();
                    for (PromptGroupPanelModelInterface choiceGroup : modalChoices) {
                        if (choiceGroup.isHiddenGroup()) continue;
                        String label = choiceGroup.getLabel();
                        ValueItem item = new ValueItem((Object)label, (Object)choiceGroup.getModalChoiceGroupValue());
                        values.add(item);
                    }
                    svp.setValues(values, locale);
                    int selection = selType == 300 ? 300 : (selType == 302 ? 302 : 301);
                    valueComponent = new PromptValuePicker((ValueProviderInterface)svp, 402, selection, null, allowUserValues, null, promptDefinition.getPromptDataType(), valueProviderDefinition.getPageSize(), (DataProviderInterface)dataProvider);
                } else if (selType == 300) {
                    valueComponent = PromptDefinitionComponentFactory.createComponent(promptComponentModel, componentId, dataProvider, applyVisible, locale);
                } else if (selType == 301 || selType == 302) {
                    TransformationInterface editor = PromptDefinitionComponentFactory.createComponent(promptComponentModel, componentId, dataProvider, applyVisible, locale);
                    if (editor instanceof BaseTransformation) {
                        ((BaseTransformation)editor).setObjectData(null);
                    }
                    DataTypeInterface dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)promptDefinition.getPromptDataType());
                    valueComponent = new PromptValueListEditor(editor, dataType, locale);
                    if (!applyVisible && promptComponentModel.getDynamicPromptValuesContext() != null) {
                        ((PromptValueListEditor)valueComponent).setApplyButtonVisible(promptComponentModel.getDynamicPromptValuesContext().hasDependent((PromptViewInterface)promptComponentModel));
                    }
                    ValuePickerTableCellRenderer renderer = new ValuePickerTableCellRenderer(dataType);
                    CellContentsLabelRenderer contentsRenderer = new CellContentsLabelRenderer();
                    if (promptDefinition instanceof DoubleDefinitionInterface && dataType instanceof DoubleType) {
                        int minDecPlaces = ((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces();
                        DoubleTypeToDisplayStringTransform inTransform = new DoubleTypeToDisplayStringTransform((DoubleType)dataType, locale, minDecPlaces);
                        contentsRenderer.setInputTransform((TransformInterface)inTransform);
                    } else {
                        contentsRenderer.setInputTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, locale));
                    }
                    renderer.setTableCellContentsRenderer(contentsRenderer);
                    TableView tv = (TableView)((PromptValueListEditor)valueComponent).getComponent("ITEMLISTMANAGER_TABLE");
                    if (tv != null) {
                        tv.setDefaultRenderer(renderer);
                    }
                    if (selType == 301) {
                        ((PromptValueListEditor)valueComponent).setReorderingAllowed(false);
                    }
                }
            } else {
                if (valueProvider instanceof DynamicValueProviderInterface || this.getNumberOfListValuesDisplayed() == -1) {
                    valueProvider = new PromptDynamicValueProviderWrapper(valueProvider, dynamicPromptValueContext, (PromptViewInterface)promptComponentModel);
                }
                int selection = selType == 300 ? 300 : (selType == 302 ? 302 : 301);
                TransformationInterface editor = null;
                if (allowUserValues) {
                    editor = PromptDefinitionComponentFactory.createComponent(promptComponentModel, componentId, dataProvider, applyVisible, locale);
                }
                SupportedSpecialValues specialValues = ((SupportedSpecialValuesInterface)promptDefinition).getSupportedSpecialValues();
                boolean cleanse = true;
                ValueProviderInterface vp = valueProviderDefinition.getValueProvider();
                if (vp == null || vp instanceof StaticValueProvider || vp instanceof AllowUserValuesInterface && ((AllowUserValuesInterface)vp).isAllowUserValues() || valueProviderDefinition instanceof AllowUserValuesInterface && valueProviderDefinition.isAllowUserValues()) {
                    cleanse = false;
                }
                if (cleanse) {
                    specialValues = this.cleanseSupportedSpecialValues(specialValues);
                }
                valueComponent = new PromptValuePicker(valueProvider, 402, selection, editor, allowUserValues, specialValues, promptDefinition.getPromptDataType(), valueProviderDefinition.getPageSize(), (DataProviderInterface)dataProvider);
                if (!applyVisible && promptComponentModel.getDynamicPromptValuesContext() != null) {
                    ((PromptValuePicker)valueComponent).setApplyButtonVisible(promptComponentModel.getDynamicPromptValuesContext().hasDependent((PromptViewInterface)promptComponentModel));
                }
                ((ValuePicker)valueComponent).setAddNullValueForSingleComboSelection(allowUserValues ? false : !promptDefinition.isRequired());
                if (promptDefinition instanceof OLAPMemberNameDefinitionInterface) {
                    ((ValuePicker)valueComponent).setDataSource(((OLAPMemberNameDefinitionInterface)promptDefinition).getDataSource());
                } else if (!(selection != 301 && selection != 302 || valueProvider.isValueDisplayed())) {
                    DataTypeInterface dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)promptDefinition.getPromptDataType());
                    DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                    CellContentsLabelRenderer contentsRenderer = new CellContentsLabelRenderer();
                    contentsRenderer.setInputTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, locale));
                    renderer.setTableCellContentsRenderer(contentsRenderer);
                    TargetValueListEditor target = (TargetValueListEditor)((PromptValuePicker)valueComponent).getComponent(PromptValuePicker.VALUEPICKER_TARGET_COMPONENT);
                    TableView tv = (TableView)target.getComponent("ITEMLISTMANAGER_TABLE");
                    if (tv != null) {
                        tv.setDefaultRenderer(renderer);
                    }
                    if (promptDefinition instanceof DoubleDefinitionInterface && dataType instanceof DoubleType) {
                        int minDecPlaces = ((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces();
                        ((PromptValuePicker)valueComponent).setMinimumDecimalPlaces(minDecPlaces);
                    }
                } else {
                    DataTypeInterface dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)promptDefinition.getPromptDataType());
                    if (promptDefinition instanceof DoubleDefinitionInterface && dataType instanceof DoubleType) {
                        int minDecPlaces = ((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces();
                        ((PromptValuePicker)valueComponent).setMinimumDecimalPlaces(minDecPlaces);
                    }
                }
            }
        } else {
            valueComponent = PromptDefinitionComponentFactory.createComponent(promptComponentModel, componentId, dataProvider, applyVisible, locale);
        }
        if (promptDefinition instanceof SelectableDefinitionInterface) {
            if (valueComponent instanceof ValuePicker) {
                ((ValuePicker)valueComponent).setMaximumValueCount(((SelectableDefinitionInterface)promptDefinition).getMaximumValueCount());
                ((ValuePicker)valueComponent).setMinimumValueCount(((SelectableDefinitionInterface)promptDefinition).getMinimumValueCount());
            } else if (valueComponent instanceof AbstractItemListManager) {
                ((AbstractItemListManager)valueComponent).setMaximumValueCount(((SelectableDefinitionInterface)promptDefinition).getMaximumValueCount());
                ((AbstractItemListManager)valueComponent).setMinimumValueCount(((SelectableDefinitionInterface)promptDefinition).getMinimumValueCount());
            } else if (valueComponent instanceof DataSourceColumnPicker) {
                ((DataSourceColumnPicker)valueComponent).setMaximumValueCount(((SelectableDefinitionInterface)promptDefinition).getMaximumValueCount());
            }
        }
        if (valueComponent == null) {
            LoggerRepository2.getLogger((String)PromptDefinitionComponentFactory.class.getName(), null).error("Unable to make prompt value component for definition. Creating a default TextEntry - " + promptDefinition.getPromptName());
            valueComponent = PromptDefinitionComponentFactory.createTextEntry();
        }
        if (valueComponent != null) {
            ((BaseTransformation)valueComponent).setObjectData(promptComponentModel.getPromptValue());
        }
        return valueComponent;
    }

    private int getNumberOfListValuesDisplayed() {
        String psize = System.getProperty("com.sas.prompts.pagesize");
        if (psize == null) {
            return 100;
        }
        try {
            return Integer.valueOf(psize);
        }
        catch (NumberFormatException numberFormatException) {
            return 100;
        }
    }

    private SupportedSpecialValues cleanseSupportedSpecialValues(SupportedSpecialValues ssv) {
        if (ssv != null && ssv.isMissingValuesSupported()) {
            SupportedSpecialValues s = new SupportedSpecialValues();
            s.setAllSupported(ssv.isAllSupported());
            s.setOtherSupported(ssv.isOtherSupported());
            s.setNoneSupported(ssv.isNoneSupported());
            ssv = s;
        }
        return ssv;
    }
}

