/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals.servlet;

import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.EntityUtil;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.models.EntityToTableModelAdapter;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.entities.edit.visuals.EntityEditors;
import com.sas.entities.edit.visuals.servlet.ComboValueEditor;
import com.sas.entities.edit.visuals.servlet.RB;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.form.html.PushButton;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.tableview.TableCellContentsEditor;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.html.CellContentsTextEntryEditor;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellEditor;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.util.validators.DateStringValidator;
import com.sas.servlet.tbeans.util.validators.HexColorStringValidator;
import com.sas.servlet.tbeans.util.validators.IntegerInputValidator;
import com.sas.servlet.tbeans.util.validators.NumericInputValidator;
import com.sas.servlet.tbeans.util.validators.RequiredStringValidator;
import com.sas.text.Message;
import com.sas.util.Classes;
import com.sas.util.Util;
import com.sas.util.validators.CompositeValidator;
import com.sas.util.validators.GenericValidatorInterface;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class EntityPropertySheet
extends BaseActionTransformation {
    public static final String RB_KEY = "EntityPropertySheet.";
    public static String SHOW_EXPERT = "ShowExpert";
    public static final String HIDE_EXPERT = "HideExpert";
    protected static final String DEFAULT_EDITOR = EntityEditors.getEditorClassName((String)EntityEditors.STRING_EDITOR, (String)"Servlet");
    protected static final String LABEL_EDITOR = EntityEditors.getEditorClassName((String)EntityEditors.STATIC_STRING_EDITOR, (String)"Servlet");
    private static final String NAME_PREFIX = "epp";
    protected RemoteEntityInterface model;
    protected TableView tableView;
    protected EntityToTableModelAdapter tableModel;
    protected AttributeGroup attributeGroup;
    protected String URLName;
    private String noDefaultValueSetString;
    private ChoiceBox groupCombo;
    private Label noAttributesDisplayedArea;
    protected HashMap nameMappings;
    protected boolean noDefaultValueSetSpecified;
    private boolean displaySubgroups;
    private boolean displayExpertGroups;
    private boolean comboPopulated;
    protected boolean expertButtonHasBeenClicked;
    protected Map editorMappings;
    protected PushButton expertButton;
    protected NumericInputValidator numericValidator;
    protected HexColorStringValidator colorValidator;
    protected DateStringValidator dateValidator;
    protected Hidden hiddenElementForExpertButton;

    public EntityPropertySheet() {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.initialize();
    }

    public EntityPropertySheet(String URLName) {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.URLName = URLName;
        this.initialize();
    }

    public EntityPropertySheet(Locale locale) {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.setLocale(locale);
        this.initialize();
    }

    public EntityPropertySheet(String URLName, Locale locale) {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.URLName = URLName;
        this.setLocale(locale);
        this.initialize();
    }

    public EntityPropertySheet(boolean displaySubgroups) {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.displaySubgroups = displaySubgroups;
        this.initialize();
    }

    public EntityPropertySheet(boolean displaySubgroups, boolean displayExpertGroups) {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.displaySubgroups = displaySubgroups;
        this.displayExpertGroups = displayExpertGroups;
        this.initialize();
    }

    protected void initialize() {
        this.tableView = new TableView();
        if (this.URLName != null) {
            Form form = this.tableView.getFormObject();
            form.setAction(this.URLName);
        }
        this.tableView.setId(this.getId() + "_tv");
        this.tableView.setBorderWidth(1);
        this.tableView.getEditController().setEditEnabled(true);
        this.tableView.getFormObject().setValidationEnabled(true);
        this.editorMappings = new HashMap();
        this.hiddenElementForExpertButton = new Hidden();
        this.hiddenElementForExpertButton.setName("expertButtonInformation");
        this.hiddenElementForExpertButton.setId(this.getId() + "_expertButtonInformation");
    }

    public void configureDialogMode() {
        if (this.tableView != null) {
            this.tableView.setColumnHeaderVisible(false);
            this.tableView.setCellPadding(2);
            this.tableView.setCellSpacing(2);
            this.tableView.setBorderWidth(0);
            this.tableView.getEditController().setSingleRowEditingEnabled(false);
        }
    }

    public RemoteEntityInterface getModel() {
        return this.model;
    }

    public void showExpertButton() {
        this.expertButton = new PushButton();
        this.expertButton.setName("expertButton");
        this.expertButton.setId(this.getId() + "_expertButton");
        this.expertButton.setType("submit");
        if (this.displayExpertGroups) {
            this.expertButton.setLabel(RB.getStringResource(RB_KEY, "hideExpert.txt", this.getLocale()));
            this.hiddenElementForExpertButton.setText(HIDE_EXPERT);
        } else {
            this.expertButton.setLabel(RB.getStringResource(RB_KEY, "showExpert.txt", this.getLocale()));
            this.hiddenElementForExpertButton.setText(SHOW_EXPERT);
        }
    }

    public void setModel(RemoteEntityInterface entityModel, AttributeGroupInterface ag) {
        if (this.getActionProvider() == null) {
            this.setActionProvider(new HttpActionProvider());
        }
        this.attributeGroup = (AttributeGroup)ag;
        if (entityModel != null) {
            this.model = entityModel;
            if (this.attributeGroup == null) {
                try {
                    this.attributeGroup = (AttributeGroup)this.model.getAttributeGroup();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.tableModel = new EntityToTableModelAdapter(this.model, (AttributeGroupInterface)this.attributeGroup, this.displaySubgroups, this.displayExpertGroups);
            this.tableModel.setContext("Servlet");
            this.createAttributeEditors();
            this.tableModel.setEditorMappings(this.editorMappings);
            if (this.noDefaultValueSetSpecified) {
                this.tableModel.setNoDefaultValueSetString(this.noDefaultValueSetString);
            }
            this.tableModel.setLocale(this.getLocale());
            this.tableView.setModel((TableModel)this.tableModel);
            TableColumn tc = this.tableView.getEditColumn();
            this.tableView.addColumn(tc);
        }
        if (this.displaySubgroups && !this.comboPopulated) {
            this.populateComboBox();
        }
    }

    protected void populateComboBox() {
        this.groupCombo = new ChoiceBox();
        this.groupCombo.setName("groupChoiceBox");
        this.groupCombo.setId(this.getId() + "_groupChoiceBox");
        this.groupCombo.setOnChange(this.getId() + "_f1.submit()");
        this.noAttributesDisplayedArea = new Label();
        this.noAttributesDisplayedArea.setId(this.getId() + "_label");
        this.nameMappings = new HashMap();
        DefaultComboBoxModel<String> groupModel = new DefaultComboBoxModel<String>();
        DefaultTreeModel groups = null;
        groups = this.displayExpertGroups ? EntityUtil.getAttributeGroupsTreeModel((AttributeGroupInterface)this.attributeGroup, (boolean)true) : (this.expertButton == null ? EntityUtil.getAttributeGroupsTreeModel((AttributeGroupInterface)this.attributeGroup, (boolean)false) : EntityUtil.getAttributeGroupsTreeModel((AttributeGroupInterface)this.attributeGroup, (boolean)true));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)groups.getRoot();
        Enumeration<TreeNode> nodes = root.preorderEnumeration();
        String groupName = null;
        int attributeCount = 0;
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)nodes.nextElement();
            if (!(node.getUserObject() instanceof AttributeGroupInterface) || (attributeCount = ((AttributeGroupInterface)node.getUserObject()).count(false)) <= 0 && node.isLeaf()) continue;
            groupName = ((AttributeGroupInterface)node.getUserObject()).getName();
            if (groupName == null) {
                groupName = Message.format((String)RB.getStringResource(RB_KEY, "unidentifiedGroup.pd.txt", this.getLocale()), (Object)new Integer(((AttributeGroupInterface)node.getUserObject()).hashCode()));
            }
            this.nameMappings.put(groupName, (AttributeGroupInterface)node.getUserObject());
            groupModel.addElement(groupName);
        }
        this.comboPopulated = true;
        this.groupCombo.setModel(groupModel);
    }

    public void setModel(RemoteEntityInterface entityModel) {
        if (entityModel != null) {
            this.model = entityModel;
            try {
                this.attributeGroup = (AttributeGroup)entityModel.getAttributeGroup();
                this.setModel(entityModel, (AttributeGroupInterface)this.attributeGroup);
            }
            catch (RemoteException remoteException) {}
        } else {
            this.setModel(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAttributeEditors() {
        ArrayList al = (ArrayList)this.tableModel.getAttributeNames();
        int listSize = al.size();
        AttributeValueEditorInterface editor = null;
        Class editorClass = null;
        String editorName = null;
        for (int i = 0; i < listSize; ++i) {
            AttributeDescriptorInterface adi = this.attributeGroup.getAttributeDescriptor((String)al.get(i), true);
            AttributeTypeInterface ati = adi.getType();
            editorName = adi == null ? null : adi.getEditor("Servlet");
            try {
                if (editorName == null) {
                    String configXML = adi.getConfigurationXML();
                    if (configXML == null) {
                        editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
                        editor = this.createDefaultEditor(adi);
                        continue;
                    }
                    ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject((String)configXML);
                    if (parsedObject.getEnumerationItems() != null) {
                        String editorClassName = EntityEditors.getEditorClassName((String)EntityEditors.COMBO_EDITOR, (String)"Servlet");
                        editorClass = Classes.loadClass((String)editorClassName, null, (Object)this);
                        editor = (AttributeValueEditorInterface)editorClass.newInstance();
                        continue;
                    }
                    editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
                    editor = this.createDefaultEditor(adi);
                    continue;
                }
                editorClass = Classes.loadClass((String)editorName, null, (Object)this);
                editor = (AttributeValueEditorInterface)editorClass.newInstance();
                if (!(editor instanceof ComboValueEditor)) continue;
                this.noDefaultValueSetSpecified = true;
                this.noDefaultValueSetString = ((ComboValueEditor)editor).getNoDefaultValueSetString();
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                String className = EntityEditors.getEditorClassName((String)editorName, (String)"Servlet");
                if (className != null) {
                    try {
                        editorClass = Classes.loadClass((String)className, null, (Object)this);
                        editor = (AttributeValueEditorInterface)editorClass.newInstance();
                        if (!(editor instanceof ComboValueEditor)) continue;
                        this.noDefaultValueSetSpecified = true;
                        this.noDefaultValueSetString = ((ComboValueEditor)editor).getNoDefaultValueSetString();
                    }
                    catch (Exception e) {
                        editor = this.createDefaultEditor(adi);
                    }
                    continue;
                }
                editor = this.createDefaultEditor(adi);
                continue;
            }
            catch (InstantiationException ie) {
                editor = this.createDefaultEditor(adi);
                continue;
            }
            catch (IllegalAccessException ie) {
                editor = this.createDefaultEditor(adi);
                continue;
            }
            finally {
                ArrayList validators;
                if (editor instanceof CellContentsTextEntryEditor && ati != null && (validators = (ArrayList)adi.getValidators("Servlet")) != null && validators.size() == 0) {
                    RequiredStringValidator requiredStringValidator;
                    CompositeValidator compositeValidator;
                    String msgCode = null;
                    Message msgObject = null;
                    if (ati.getSQLType() == 12 && adi.isRequired()) {
                        RequiredStringValidator requiredStringValidator2 = new RequiredStringValidator();
                        msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("RequiredStringValidator.", "required.txt");
                        msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                        requiredStringValidator2.setValidationMessage(msgObject);
                        ((CellContentsTextEntryEditor)editor).setValidator(requiredStringValidator2);
                    } else if (ati.getSQLType() == 6) {
                        NumericInputValidator numericValidator = new NumericInputValidator();
                        msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("NumericInputValidator.", "numeric.txt");
                        msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                        numericValidator.setValidationMessage(msgObject);
                        if (adi.isRequired()) {
                            compositeValidator = new CompositeValidator();
                            requiredStringValidator = new RequiredStringValidator();
                            msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("RequiredStringValidator.", "required.txt");
                            msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                            requiredStringValidator.setValidationMessage(msgObject);
                            compositeValidator.addValidator((ValidationInterface)requiredStringValidator);
                            compositeValidator.addValidator((ValidationInterface)numericValidator);
                            ((CellContentsTextEntryEditor)editor).setValidator((ValidationInterface)compositeValidator);
                        } else {
                            ((CellContentsTextEntryEditor)editor).setValidator(numericValidator);
                        }
                    } else if (ati.getSQLType() == 4) {
                        IntegerInputValidator integerValidator = new IntegerInputValidator();
                        msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("IntegerInputValidator.", "invalidInteger.txt");
                        msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                        integerValidator.setValidationMessage(msgObject);
                        if (adi.isRequired()) {
                            compositeValidator = new CompositeValidator();
                            requiredStringValidator = new RequiredStringValidator();
                            msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("RequiredStringValidator.", "required.txt");
                            msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                            requiredStringValidator.setValidationMessage(msgObject);
                            compositeValidator.addValidator((ValidationInterface)requiredStringValidator);
                            compositeValidator.addValidator((ValidationInterface)integerValidator);
                            ((CellContentsTextEntryEditor)editor).setValidator((ValidationInterface)compositeValidator);
                        } else {
                            ((CellContentsTextEntryEditor)editor).setValidator(integerValidator);
                        }
                    } else if (ati.getSQLType() == 91) {
                        DateStringValidator sasDateValidator = new DateStringValidator(new SimpleDateFormat("ddMMMyyyy", Locale.US));
                        msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("DateValidator.", "invalidDate.txt");
                        msgObject = new Message(msgCode + " " + adi.getLabel(this.getLocale()));
                        sasDateValidator.setValidationMessage(msgObject);
                        if (adi.isRequired()) {
                            compositeValidator = new CompositeValidator();
                            requiredStringValidator = new RequiredStringValidator();
                            msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("RequiredStringValidator.", "required.txt");
                            msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                            requiredStringValidator.setValidationMessage(msgObject);
                            compositeValidator.addValidator((ValidationInterface)requiredStringValidator);
                            compositeValidator.addValidator((ValidationInterface)sasDateValidator);
                            ((CellContentsTextEntryEditor)editor).setValidator((ValidationInterface)compositeValidator);
                        } else {
                            ((CellContentsTextEntryEditor)editor).setValidator(sasDateValidator);
                        }
                    } else if (ati.getName() != null && ati.getName().equals(AttributeTypeUtility.COLOR_NAME) && ati.getSQLType() == 12) {
                        HexColorStringValidator colorValidator = new HexColorStringValidator(true);
                        msgCode = com.sas.servlet.tbeans.util.validators.RB.getStringResource("HexColorStringValidator.", "notValidColor.txt");
                        msgObject = new Message(adi.getLabel(this.getLocale()) + " " + msgCode);
                        colorValidator.setValidationMessage(msgObject);
                        if (adi.isRequired()) {
                            compositeValidator = new CompositeValidator();
                            requiredStringValidator = new RequiredStringValidator();
                            compositeValidator.addValidator((ValidationInterface)requiredStringValidator);
                            compositeValidator.addValidator((ValidationInterface)colorValidator);
                            ((CellContentsTextEntryEditor)editor).setValidator((ValidationInterface)compositeValidator);
                        } else {
                            ((CellContentsTextEntryEditor)editor).setValidator(colorValidator);
                        }
                    }
                }
                if (editor instanceof TransformationInterface) {
                    ((TransformationInterface)editor).setRequest(this.getRequest());
                    ((TransformationInterface)editor).setResponse(this.getResponse());
                    ((TransformationInterface)editor).setLocale(this.getLocale());
                }
                editor.setEditInfo(this.model, (String)al.get(i));
                this.editorMappings.put(adi, editor);
                DefaultTableCellEditor myEditor = new DefaultTableCellEditor();
                myEditor.setTableCellContentsEditor((TableCellContentsEditor)editor.getEditGUI());
                this.tableView.setCellEditor(i + 1, 2, myEditor);
                this.tableView.setCellRenderer(i + 1, 1, (TableCellRenderer)editor.getRendererGUI());
            }
        }
        if (this.editorMappings != null) {
            for (AttributeDescriptorInterface ad : this.editorMappings.keySet()) {
                AttributeValueEditorInterface editControl = (AttributeValueEditorInterface)this.editorMappings.get(ad);
                if (!(editControl instanceof GenericValidatorInterface)) continue;
                this.tableView.getFormObject().addComponent((TransformationInterface)editControl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributeValueEditorInterface createDefaultEditor(AttributeDescriptorInterface adi) {
        AttributeValueEditorInterface editor = null;
        try {
            if (!adi.isModifiable()) {
                Class editorClass = Classes.loadClass((String)LABEL_EDITOR, null, (Object)this);
                editor = (AttributeValueEditorInterface)editorClass.newInstance();
            }
            Class editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
            editor = (AttributeValueEditorInterface)editorClass.newInstance();
            return editor;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (InstantiationException instantiationException) {}
        catch (IllegalAccessException illegalAccessException) {}
        finally {
            return editor;
        }
    }

    public TableView getTableView() {
        return this.tableView;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.tableModel != null) {
            this.tableModel.setLocale(locale);
        }
    }

    public String getURL() {
        return this.URLName;
    }

    public void setURL(String URLName) {
        if (URLName != null && this.tableView != null) {
            this.URLName = URLName;
            Form form = this.tableView.getFormObject();
            form.setAction(URLName);
        }
    }

    public String getColumnName(int columnIndex) {
        if (this.tableModel != null) {
            return this.tableModel.getColumnName(columnIndex);
        }
        return null;
    }

    public void setColumnName(String columnName, int columnIndex) {
        if (this.tableModel != null) {
            this.tableModel.setColumnName(columnName, columnIndex);
        }
    }

    public boolean isDisplayExpertGroups() {
        return this.displayExpertGroups;
    }

    public void setDisplayExpertGroups(boolean displayExpertGroups) {
        this.displayExpertGroups = displayExpertGroups;
    }

    public void setDisplaySubgroups(boolean displaySubgroups) {
        this.displaySubgroups = displaySubgroups;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String val;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        AttributeGroupInterface newGroup = null;
        HttpActionProvider actionProvider = this.getActionProvider();
        if (actionProvider != null) {
            if (actionProvider.getLocale() == null) {
                actionProvider.setLocale(this.getLocale());
            }
            this.tableView.setActionProvider(actionProvider);
            Collection actions = actionProvider.listDefaultActions("TABLEVIEW_SUPPORT", "COLUMN_HEADER_AREA");
            for (BaseAction action : actions) {
                if (action.getActionType() == null) continue;
                this.tableView.setActionVisible(action.getActionType(), "COLUMN_HEADER_AREA", false);
            }
        }
        if (this.groupCombo != null && (val = this.getRequest().getParameter("groupChoiceBox")) != null) {
            newGroup = (AttributeGroupInterface)this.nameMappings.get(val);
            this.setModel(this.model, newGroup);
            this.groupCombo.setSelectedItem(val);
        }
        Locale locale = this.getLocale();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        this.tableView.setResponse(response);
        this.tableView.setRequest(request);
        this.tableView.setLocale(locale);
        if (this.groupCombo != null) {
            this.groupCombo.setResponse(response);
            this.groupCombo.setRequest(request);
            this.groupCombo.setLocale(locale);
        }
        if (this.noAttributesDisplayedArea != null) {
            this.noAttributesDisplayedArea.setResponse(response);
            this.noAttributesDisplayedArea.setRequest(request);
            this.noAttributesDisplayedArea.setLocale(locale);
        }
        if (this.expertButton != null) {
            this.expertButton.setResponse(response);
            this.expertButton.setRequest(request);
            this.expertButton.setLocale(locale);
        }
        if (this.hiddenElementForExpertButton != null) {
            this.hiddenElementForExpertButton.setResponse(response);
            this.hiddenElementForExpertButton.setRequest(request);
            this.hiddenElementForExpertButton.setLocale(locale);
        }
        out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        out.println("<tr><td>");
        if (this.groupCombo != null) {
            out.print("<form name = '");
            out.print(this.getId());
            out.print("_f1' id='");
            out.print(this.getId());
            out.println("_f1'>");
            this.groupCombo.write(out);
            out.println("</form>");
        }
        out.println("</td></tr>");
        out.println("<tr><td>&#160;</td></tr>");
        out.println("<tr><td>");
        if (this.displaySubgroups && newGroup != null && newGroup.count(false) == 0) {
            this.noAttributesDisplayedArea.setText(RB.getStringResource("noAttributesToDisplay.txt", this.getLocale()));
            this.noAttributesDisplayedArea.write(out);
        } else {
            if (this.expertButton != null) {
                if (this.expertButtonHasBeenClicked) {
                    String valButton = this.getRequest().getParameter("expertButtonInformation");
                    if (valButton != null) {
                        if (valButton.equals(SHOW_EXPERT)) {
                            this.tableModel.setDisplayExpertGroups(true);
                            this.tableModel.refresh();
                            this.expertButton.setLabel(RB.getStringResource(RB_KEY, "hideExpert.txt", this.getLocale()));
                            this.hiddenElementForExpertButton.setText(HIDE_EXPERT);
                        } else {
                            this.displayExpertGroups = false;
                            this.tableModel.setDisplayExpertGroups(false);
                            this.tableModel.refresh();
                            this.expertButton.setLabel(RB.getStringResource(RB_KEY, "showExpert.txt", this.getLocale()));
                            this.hiddenElementForExpertButton.setText(SHOW_EXPERT);
                        }
                    }
                } else {
                    this.expertButtonHasBeenClicked = true;
                }
            }
            this.tableView.write(out);
            if (this.expertButton != null) {
                out.print("<form name = '");
                out.print(this.getId());
                out.print("_f2' id='");
                out.print(this.getId());
                out.println("_f2'>");
                this.hiddenElementForExpertButton.write(out);
                this.expertButton.write(out);
                out.println("</form>");
            }
            out.println("</td></tr>");
            out.println("</table>");
        }
        this.cleanUpResources();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this.tableView != null) {
            this.tableView.setId(id + "_tv");
        }
        if (this.groupCombo != null) {
            this.groupCombo.setId(id + "_groupChoiceBox");
        }
        if (this.noAttributesDisplayedArea != null) {
            this.noAttributesDisplayedArea.setId(id + "_label");
        }
        if (this.hiddenElementForExpertButton != null) {
            this.hiddenElementForExpertButton.setId(id + "_expertButtonInformation");
        }
        if (this.expertButton != null) {
            this.expertButton.setId(id + "_expertButton");
        }
    }
}

